<?php

namespace Qoxag\Core\Elementor\Traits;

defined('ABSPATH') || exit;

trait Grid_Controls
{

    /*
        Advanced Ordering Controls
    */
    protected function advance_ordering_controls()
    {

        $this->start_controls_section(
            'advance_section',
            [
                'label' => esc_html__('Advance Ordering', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_ordering',
            [
                'label' => esc_html__('Enable Ordering', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'qoxag'),
                'label_off' => esc_html__('No', 'qoxag'),
                'default' => '',
                'return_value' => 'yes',
                'description' => esc_html__('Lowest value will be on top and highest value will be on the bottom.', 'qoxag'),
            ]
        );

        $this->add_control(
            'order_category',
            [
                'label' => esc_html__('Category', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'enable_ordering' => 'yes',
                    'layout_category_position!' => 'onimage'
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .category-wrapper' => 'order: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'order_title',
            [
                'label' => esc_html__('Title', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => ['enable_ordering' => 'yes'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-heading' => 'order: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'order_meta',
            [
                'label' => esc_html__('Meta', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'enable_ordering' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-meta' => 'order: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'order_content',
            [
                'label' => esc_html__('Description', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'terms' => [
                                ['name' => 'enable_ordering', 'operator' => '===', 'value' => 'yes'],
                                ['name' => 'layout_show_content', 'operator' => '===', 'value' => 'yes']
                            ]
                        ],
                        [
                            'terms' => [
                                ['name' => 'enable_ordering', 'operator' => '===', 'value' => 'yes'],
                                ['name' => 'featured_show_content', 'operator' => '===', 'value' => 'yes']
                            ]
                        ],
                    ]
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-excerpt' => 'order: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
        Title Style Controls
    */
    protected function title_style_controls()
    {
        $this->start_controls_section(
            'section_title_style', [
                'label' => esc_html__('Title', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_title_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#041a57',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-heading a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .qoxag-grid-single .post-heading a:hover' => 'background-image: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 98%);',
                    '{{WRAPPER}} .qoxag-grid-single .post-heading' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => esc_html__('Typography', 'qoxag'),
                'scheme' => \Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .qoxag-grid-single .post-heading',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '600',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '18',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '25',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'isLinked' => false,
                ],
                'default' => [
                    'bottom' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
        Image Style Controls
    */
    protected function image_style_controls( $params = [] ){
        $default = !empty( $params) && !empty( $params['defaults']) ? $params['defaults'] : [];
        $exclude = !empty( $params) && !empty( $params['exclude']) ? $params['exclude'] : [];

        $this->start_controls_section(
            'section_image_style', [
                'label' => esc_html__('Post Thumbnail', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        ['name' => 'layout_show_thumbnail', 'operator' => '==', 'value' => 'yes'],
                        ['name' => 'featured_show_thumbnail', 'operator' => '==', 'value' => 'yes'],
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'layout_thumbnail_image_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'condition' => ['layout_show_thumbnail' => ['yes']],
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 0.01,
                        'max' => 3.0,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => (isset( $default['layout_thumbnail_image_aspect_ratio']['default']) ? esc_attr($default['layout_thumbnail_image_aspect_ratio']['default']) : 0.5)
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => (isset( $default['layout_thumbnail_image_aspect_ratio']['tablet_default']) ? esc_attr($default['layout_thumbnail_image_aspect_ratio']['tablet_default']) : 0.3)
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => (isset( $default['layout_thumbnail_image_aspect_ratio']['mobile_default']) ? esc_attr($default['layout_thumbnail_image_aspect_ratio']['mobile_default']) : 0.5)
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-thumbnail' => 'padding-bottom: calc( {{size}} * 100% );',
                ],
                'description' => esc_html__("Not applicable for Featured Layouts.", "qoxag"),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'layout_thumbnail_img_size',
                'condition' => ['layout_show_thumbnail' => ['yes']],
                'exclude' => [ 'custom' ],
                'include' => [],
                'default' => 'large',
            ]
        );

        $this->add_control(
            'layout_thumbnail_notes',
            [
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'raw' => esc_html__('Not applicable for Featured Layouts.', 'qoxag'),
                'content_classes' => 'elementor-descriptor',
                'condition' => ['layout_show_thumbnail' => ['yes']],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'image_background',
                'label' => __('Background', 'qoxag'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'condition' => ['layout_layout_style' => ['thumb-bg']],
                'selector' => '{{WRAPPER}} .qoxag-grid-single.thumb-bg .post-thumbnail a:after',
                'fields_options' => [
                    'background' => [
                        'default' => 'gradient'
                    ],
                    'color' => [
                        'default' => '#cecece57'
                    ],
                    'color_stop' => [
                        'default' => [
                            'size' => '0',
                            'unit' => '%'
                        ]
                    ],
                    'color_b' => [
                        'default' => '#161b2aad'
                    ],
                    'color_b_stop' => [
                        'default' => [
                            'size' => '65',
                            'unit' => '%'
                        ]
                    ],
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .qoxag-grid-single.thumb-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
        Meta Style Controls
    */
    protected function meta_style_controls()
    {

        /*
            Category Styles
        */
        $this->start_controls_section(
            'section_category_style', [
                'label' => esc_html__('Category', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('category_tab_style');

        $this->start_controls_tab(
            'category_tab_style_normal',
            [
                'label' => esc_html__('Normal', 'qoxag'),
            ]
        );

        $this->add_control(
            'post_category_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-cat' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .qoxag-grid-single .post-cat.left-background .cat-background-span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_category_bg_color',
            [
                'label' => esc_html__('Background Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#041a57',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-cat' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'layout_category_style' => ['default'],
                ],
            ]
        );

        $this->add_control(
            'category_notes',
            [
                'type' => \Elementor\Controls_Manager::RAW_HTML,
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                'raw' => esc_html__('Individual category style can also set from Posts => Categories', 'qoxag'),
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'category_tab_style_hover',
            [
                'label' => esc_html__('Hover', 'qoxag'),
            ]
        );

        $this->add_control(
            'category_color_hover',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#404040',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-cat:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .qoxag-grid-single .post-cat.left-background:hover .cat-background-span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#041a57',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-cat:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'layout_category_style' => ['default'],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'category_divider',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_typography',
                'label' => esc_html__('Category Typography', 'qoxag'),
                'selector' => '{{WRAPPER}}  .qoxag-grid-single .post-cat span',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '11',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'text_transform' => [
                        'default' => 'uppercase',
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'category_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '2',
                    'right' => '10',
                    'bottom' => '2',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-cat' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'category_border_radius',
            [
                'label' => esc_html__('Border Radius', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '4',
                    'right' => '4',
                    'bottom' => '4',
                    'left' => '4',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-cat' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'category_position_vertical',
            [
                'label' => esc_html__('Category Vertical Position', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'separator' => 'before',
                'size_units' => ['px', '%'],
                'condition' => [
                    'layout_layout_style' => ['thumb-top', 'thumb-bg', 'featured-slider thumb-top'],
                    'layout_category_position' => ['onimage'],
                ],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .position-onimage' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'category_position_horizontal',
            [
                'label' => esc_html__('Category Horizontal Position', 'qoxag'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => [
                    'layout_layout_style' => ['thumb-top', 'thumb-bg', 'featured-slider thumb-top'],
                    'layout_category_position' => ['onimage'],
                ],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .position-onimage' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
            Meta  Styles
        */
        $this->start_controls_section(
            'section_meta_style', [
                'label' => esc_html__('Meta', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('meta_tab_style');

        $this->start_controls_tab(
            'meta_tab_style_normal',
            [
                'label' => esc_html__('Normal', 'qoxag'),
            ]
        );

        $this->add_control(
            'post_meta_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#404040',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-meta span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'post_meta_after_color',
            [
                'label' => esc_html__('Separator Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-meta .post-author:after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'meta_tab_style_hover',
            [
                'label' => esc_html__('Hover', 'qoxag'),
            ]
        );

        $this->add_control(
            'meta_color_hover',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#404040',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-meta > span:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .qoxag-grid-single .post-meta > span a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'meta_divider',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => esc_html__('Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-grid-single .post-meta span',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '14',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'right' => '10',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-meta span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
        Description Style Controls
    */
    protected function description_style_controls()
    {

        $this->start_controls_section(
            'section_content_style', [
                'label' => esc_html__('Description', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        ['name' => 'layout_show_content', 'operator' => '==', 'value' => 'yes'],
                        //['name' => 'featured_show_content', 'operator' => '==', 'value' => 'yes'],
                    ],
                ],
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#404040',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-excerpt' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => esc_html__('Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-grid-single .post-excerpt',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '400',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '16',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '22',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-grid-single .post-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'bottom' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*
        Advanced Style Controls
    */
    protected function advanced_style_controls($params = [])
    {
        $default = !empty( $params) && !empty( $params['defaults']) ? $params['defaults'] : [];
        $exclude = !empty( $params) && !empty( $params['exclude']) ? $params['exclude'] : [];

        if(empty($exclude) || !in_array('inner_content_background', $exclude)) {
            $this->add_group_control(
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'inner_content_background',
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .qoxag-grid-single .post-content',
                    'description' => esc_html__('Background for the inner contents', 'qoxag'),
                    'fields_options' => [
                        'background'     => [
                            'label'   => esc_html__('Content Background', 'qoxag'),
                        ],
                    ],
                ]
            );
        }

        if(empty($exclude) || !in_array('inner_content_padding', $exclude)) {
            $this->add_responsive_control(
                'inner_content_padding',
                [
                    'label' => esc_html__('Content Padding', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'description' => esc_html__('Padding for the inner contents', 'qoxag'),
                    'default' => [
                        'top' => '25',
                        'right' => '15',
                        'bottom' => '20',
                        'left' => '25',
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .qoxag-grid-single .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
                ]
            );
        }
        if(empty($exclude) || !in_array('wrapper_margin', $exclude)) {
            $this->add_responsive_control(
                'wrapper_margin',
                [
                    'label' => esc_html__('Wrapper Margin', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'description' => esc_html__('Margin for the single item', 'qoxag'),
                    'default' => [
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .qoxag-grid-single' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        }

        if(empty($exclude) || !in_array('wrapper_padding', $exclude)) {
            $this->add_responsive_control(
                'wrapper_padding',
                [
                    'label' => esc_html__('Wrapper Padding', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'description' => esc_html__('Padding for the single item', 'qoxag'),
                    'default' => [
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .qoxag-grid-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        }

        if(empty($exclude) || !in_array('wrapper_border', $exclude)) {
            $this->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'wrapper_border',
                    'label' => esc_html__('Border', 'qoxag'),
                    'selector' => '{{WRAPPER}} .qoxag-grid-single ',
                    'fields_options' => [
                        'width' => [
                            'default' => [
                                'isLinked' => false,
                            ],
                        ],
                    ]
                ]
            );
        }
    }

    /*
        Tab Style Controls
    */
    protected function tab_nav_style_controls()
    {

        $this->start_controls_section(
            'tab_nav_styles', [
                'label' => esc_html__('Nav Style', 'qoxag'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'tab_nav_align',
            [
                'label' => esc_html__('Align', 'qoxag'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'qoxag'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'qoxag'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'qoxag'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-tab .nav-tabs' => 'justify-content: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name' => 'tab_nav_typography',
                'label' => esc_html__('Typography', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-post-tab .tab-head',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                    'font_size' => [
                        'default' => [
                            'size' => '17',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                    'text_transform' => [
                        'default' => 'uppercase',
                    ],
                    'line_height' => [
                        'default' => [
                            'size' => '17',
                            'unit' => 'px'
                        ],
                        'size_units' => ['px']
                    ],
                ],
            )
        );

        $this->start_controls_tabs('nav_tab_tabs');

        $this->start_controls_tab('nav_tab_style_normal',
            [
                'label' => esc_html__('Normal', 'qoxag'),
            ]
        );

        $this->add_control(
            'nav_tab_text_color',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222222',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-tab .qoxag-tab-a .tab-head' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('nav_tab_style_active',
            [
                'label' => esc_html__('Active', 'qoxag'),
            ]
        );

        $this->add_control(
            'nav_tab_text_active',
            [
                'label' => esc_html__('Color', 'qoxag'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fc4a00',
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-tab .qoxag-tab-a.active .tab-head' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .qoxag-post-tab .qoxag-tab-a.active::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'nav_tab_border',
                'label' => esc_html__('Border', 'qoxag'),
                'selector' => '{{WRAPPER}} .qoxag-post-tab .nav-item'

            ]
        );

        $this->add_control(
            'nav_tab_border_radius',
            [
                'label' => esc_html__('Border Radius', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-tab .nav-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_tab_item_padding',
            [
                'label' => esc_html__('Padding', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '7',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-tab .nav-link .tab-head' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_tab_item_margin',
            [
                'label' => esc_html__('Margin', 'qoxag'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'default' => [
                    'top' => '0',
                    'right' => '7',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .qoxag-post-tab .nav-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();
    }

}