<?php
$block_style = $settings['block_style'];
$posts_per_page = $settings['query_posts_per_page'];
$show_thumbnail = $settings['layout_show_thumbnail'];
$show_category = $settings['layout_show_category'];
$number_of_categories = $settings['layout_number_of_categories'];
$show_date = $settings['layout_show_date'];
$orderby = $settings['query_orderby'];
$order = $settings['query_order'];
$post_title_crop = isset($settings['layout_post_title_crop']) ? $settings['layout_post_title_crop']['size'] : '35';
$show_author = $settings['layout_show_author'];
$show_content = $settings['layout_show_content'];
$post_content_crop = isset($settings['layout_post_content_crop']) ? $settings['layout_post_content_crop']['size'] : '20';
$post_format = $settings['query_post_format'];
$category_position = $settings['layout_category_position'];

$desktop_column_number = ( isset($settings['layout_column_number']) ) ? $settings['layout_column_number']: 3;
$tablet_column_number = ( isset($settings['layout_column_number_tablet']) ) ? $settings['layout_column_number_tablet']: 2; 
$mobile_column_number = ( isset($settings['layout_column_number_mobile']) ) ? $settings['layout_column_number_mobile']: 1;

$column_desktop = round(12 / (int)$desktop_column_number);
$column_tablet = round(12 / (int)$tablet_column_number);
$column_mobile = round(12 / (int)$mobile_column_number);

$tabs = $settings['query_post_tabs'];
$post_count = count($tabs);

$category_style = $settings['layout_category_style'];
?>

<div class="qoxag-wrapper qoxag-post-tab">

    <ul class="nav nav-tabs">
        <?php
        foreach ($tabs as $tab_key => $value) {
            ?>
            <li class="nav-item">
                <div class='qoxag-tab-a <?php echo esc_attr(($tab_key == 0) ? ' active ' : ''); ?>' data-id='tab<?php echo esc_attr($this->get_id()) . $value['_id']; ?>'>
                    <h3 class="tab-head">
                        <?php echo esc_html($value['tab_title']); ?>
                    </h3>
                </div>
            </li>
            <?php
        }
        ?>
    </ul>

    <div class="tab-content">

        <?php foreach ($tabs as $content_key => $value) { ?>

            <div class="tab-pane fade <?php echo esc_attr(($content_key == 0) ? ' active ' : ''); ?>"
                 data-id="tab<?php echo esc_attr($this->get_id()) . $value['_id']; ?>">
                <?php
                $arg = array(
                    'post_type' => 'post',
                    'post_status' => 'publish',
                    'posts_per_page' => $posts_per_page,
                    'order' => $order,
                    'category__in' => $value['post_cats'],
                    'suppress_filters' => false,
                );

                $arg['orderby'] = $orderby;

                if (in_array('video', $post_format) && !in_array('standard', $post_format)) {
                    $arg['tax_query'] = array(
                        array(
                            'taxonomy' => 'post_format',
                            'field' => 'slug',
                            'terms' => array('post-format-video'),
                            'operator' => 'IN'
                        )
                    );
                }

                if ($settings['query_enable_offset'] == 'yes') {
                    $arg['offset'] = $settings['query_offset_item_num'];
                }

                $query = get_posts($arg); ?>

                <div class="block-tab-item">
                    <div class="row">
                        <?php foreach ($query as $key => $post): ?>
                            <?php
                            $postid = $post->ID;
                            include QOXAG_CORE . "/elementor/content-parts/content-${block_style}.php";
                            ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

        <?php } ?>

    </div>
</div>
