<?php
$args = [
     'number' => $settings['query_posts_per_page'],
     'orderby' => $settings['query_orderby'],
     'order' => $settings['query_order'],

];
$authors = get_users($args);
if ($authors): ?>
    <div class="qoxag-wrapper qoxag-authors">
    <?php foreach ($authors as $author): ?>
        <div class="row single-author">
            <div class="col-4 author-img">
                <?php echo get_avatar( $author->ID, 100 ); ?>
            </div>
            <div class="col-8 author-desc">
                <h3 class="author-name">
                    <?php echo esc_html($author->display_name);?>
                </h3>
                <p class="post-count">
                    <?php printf( _nx( 'Post', '%1$s Posts', count_user_posts($author->ID), 'post count', 'qoxag' ), number_format_i18n( count_user_posts($author->ID) ) );?>
                </p>
                <a href="<?php echo esc_url(get_author_posts_url($author->ID)); ?>" class="posts-link">
                    <?php esc_html_e('View All Posts', 'qoxag');?>
                </a>
            </div>
        </div>
    <?php endforeach;?>
    </div>
<?php endif; ?>
