<?php
$posts_per_page = $settings['query_posts_per_page'];
$post_categories = $settings['query_post_categories'];
$post_tags = $settings['query_post_tags'];
$show_thumbnail = $settings['layout_show_thumbnail'];
$show_category = $settings['layout_show_category'];
$number_of_categories = $settings['layout_number_of_categories'];
$show_date = $settings['layout_show_date'];
$orderby = $settings['query_orderby'];
$order = $settings['query_order'];
$post_title_crop = isset($settings['layout_post_title_crop']) ? $settings['layout_post_title_crop']['size'] : '35';
$show_author = $settings['layout_show_author'];
$show_view_count = $settings['layout_show_view_count'];
$show_read_time = $settings['layout_show_read_time'];
$show_readmore = $settings['layout_show_read_more_link'];
$readmore_text = $settings['layout_read_more_text'];
$read_more_icon = $settings['layout_read_more_icon'];
$show_content = $settings['layout_show_content'];
$post_content_crop = isset($settings['layout_post_content_crop']) ? $settings['layout_post_content_crop']['size'] : '20';
$category_position = $settings['layout_category_position'];
$layout_thumbnail_img_size = $settings['layout_thumbnail_img_size_size'];
$thumbnail_image_aspect_ratio = $settings['layout_thumbnail_image_aspect_ratio']['size'];
$video_icon = 'no';
$category_style = $settings['layout_category_style'];

$show_review_rating = $settings['layout_show_review_rating'];
$show_review_rating_style2 = 'no';
$show_review_rating_style1 = 'no';
if($show_review_rating == 'yes') {
    $review_style = $settings['layout_review_style'];
    if($review_style == 'style2') {
        $show_review_rating_style2 = 'yes';
    } else {
        $show_review_rating_style1 = 'yes';
    }
}

$args = array(
    'posts_per_page' => $posts_per_page,
    'orderby' => $orderby,
    'order' => $order
);

if (!empty($post_categories)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'terms' => $post_categories,
            'field' => 'id'
        ),
    );
}

if (!empty($post_tags)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_tag',
            'terms' => $post_tags,
            'field' => 'id'
        ),
    );
}

$args['tax_query'] = array(
    array(
        'taxonomy' => 'post_format',
        'field' => 'slug',
        'terms' => array('post-format-audio'),
        'operator' => 'IN'
    )
);

if ($settings['query_enable_offset'] == 'yes') {
    $args['offset'] = $settings['query_offset_item_num'];
}

$query = get_posts($args);

$style_class = 'thumb-left';

$slides_per_group = [
    'desktop'   => 1,
    'tablet'   => 1,
    'mobile'   => 1
];

$this->add_render_attribute(
    'wrapper',
    [
        'class' => [
            'qoxag-wrapper',
            'audio-slider',
            'qoxag-post-slider'
        ],
    ]
);


$slider_control = [
    'slides_to_show' => [
        'desktop'   => $settings['query_slides_to_show'],
        'tablet'   => $settings['query_slides_to_show_tablet'],
        'mobile'   => $settings['query_slides_to_show_mobile'],
    ],
    'slide_loop' => ("yes" == $settings['slide_loop']) ? true : false,
    'slide_autoplay' => ("yes" == $settings['slide_autoplay']) ? true : false,
    'slide_autoplay_delay' => $settings['slide_autoplay_delay'],
    'slider_space_between' => $settings['slider_column_gap']['size'],
    'slides_per_group'  => $slides_per_group,
    'widget_id' => $this->get_id()
];
//passing slider controls to the template file
$slider_controls = \json_encode($slider_control);

?>
<?php if ($query) { ?>
    <div <?php echo qoxag_kses($this->get_render_attribute_string( 'wrapper' )); ?>
            data-controls="<?php echo esc_attr($slider_controls); ?>">
        <div class="swiper-container">
            <div class="swiper-wrapper">
                <?php
                foreach ($query as $key => $post) {
                    ?>
                    <div class="swiper-slide">
                        <?php
                        $postid = $post->ID;
                        include QOXAG_CORE . "/elementor/content-parts/content-audio.php";
                        ?>
                    </div>
                    <?php
                }
                ?>
            </div>
            <!-- content will be here -->
            <?php if ("yes" == $settings['slide_dots']): ?>
                <div class="swiper-pagination"></div>
            <?php endif; ?>
        </div>

        <?php if ("yes" == $settings['slide_arrows']): ?>
            <div class="swiper-button-prev swiper-prev-<?php echo esc_attr($this->get_id()); ?>">
                <?php \Elementor\Icons_Manager::render_icon($settings['slide_arrow_icon_left']); ?>
            </div>
            <div class="swiper-button-next swiper-next-<?php echo esc_attr($this->get_id()); ?>">
                <?php \Elementor\Icons_Manager::render_icon($settings['slide_arrow_icon_right']); ?>
            </div>
        <?php endif; ?>
    </div>
<?php } ?>