<?php
if ( ! defined( 'ABSPATH' ) ) exit;

use \Qoxag\Core\Elementor\Controls\Qoxag_Post_Query;
use \Qoxag\Core\Elementor\Controls\Qoxag_Layout;

class Qoxag_Shortcode{

	/**
     * Holds the class object.
     *
     * @since 1.0
     *
     */
    public static $_instance;


    /**
     * Localize data array
     *
     * @var array
     */
    public $localize_data = array();

	/**
     * Load Construct
     *
     * @since 1.0
     */

	public function __construct(){
        $this->init();
    }


	public function init(){
        add_action('elementor/init', array( $this, 'qoxag_traits' ));
        add_action('elementor/init', array($this, 'qoxag_elementor_init'));
        add_action('elementor/controls/controls_registered', array( $this, 'qoxag_icon_pack' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'qoxag_elementor_init' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'qoxag_custom_group_controls' ), 12 );
        add_action('elementor/widgets/widgets_registered', array($this, 'qoxag_shortcode_elements'),13);
        

        

        
        if (defined( 'ELEMENTOR_VERSION' )) {            
            add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );            
        } else {
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        }

        // elemntor icon load
        $this -> Qoxag_elementor_icon_pack();
	}


    /**
     * Enqueue Scripts
     *
     * @return void
     */

   
    
    public function enqueue_scripts() {
        if (defined( 'ELEMENTOR_VERSION' )) {
            wp_enqueue_script( 'qoxag-main-scripts', QOXAG_JS  . '/public/scripts.js',  ['jquery', 'elementor-frontend'], QOXAG_VERSION, true );
        }else{
            wp_enqueue_script( 'qoxag-main-scripts', QOXAG_JS  . '/public/scripts.js',  ['jquery'], QOXAG_VERSION );
        }

        $blog_sticky_sidebar  = qoxag_option('blog_sticky_sidebar'); 

        /*if( is_singular( 'post' ) ){
            if(get_the_id()==605){
                $blog_sticky_sidebar = 'yes';
            }
        }*/

        wp_localize_script( 'qoxag-main-scripts', 'qoxag_ajax', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'blog_sticky_sidebar' => $blog_sticky_sidebar)
        );

        if(defined('DEVM')) {
            $global_body_font = json_decode(qoxag_option( 'body_font' ), true);
            $heading_font_one = json_decode(qoxag_option( 'heading_font_one' ), true);   
            $heading_font_two = json_decode(qoxag_option( 'heading_font_two' ), true);
            $heading_font_three = json_decode(qoxag_option( 'heading_font_three' ), true) ;
            $heading_font_four = json_decode(qoxag_option( 'heading_font_four' ), true) ;
            $heading_font_five = json_decode(qoxag_option( 'heading_font_five' ), true) ;
            $heading_font_six = json_decode(qoxag_option( 'heading_font_six' ), true) ;

            $font_list = [
                $global_body_font['family'],
                $heading_font_one['family'],
                $heading_font_two['family'],
                $heading_font_three['family'],
                $heading_font_four['family'],
                $heading_font_five['family'],
                $heading_font_six['family'],
            ];
            wp_add_inline_script( 'qoxag-main-scripts', 'var fontList = ' . wp_json_encode( $font_list ), 'before' );
        }
        
        
    }

	/**
     * Elementor Initialization
     *
     * @since 1.0
     *
     */

    public function qoxag_elementor_init(){
        \Elementor\Plugin::$instance->elements_manager->add_category(
            'qoxag-elements',
            [
                'title' =>esc_html__( 'Qoxag', 'qoxag' ),
                'icon' => 'fas fa-plug',
            ],
            1
        );
    }

    public function get_input_widgets() {

		$widgets = [
            
            'site-logo',
            'news-ticker',
			'back-to-top',
            'post-grid',
            'post-block',
            'post-slider',
            'main-slider',
            'post-tab',
            'post-videotab',
            'post-loadmore',
            'date-time',
            'author',
            'title',
            'post-masonary',
            'audio-slider',
            'products-tab',
            'products-slider',
            'dark-light',
            'post-category'
		];

		return $widgets;
	}

    public static function make_classname($dirname) {
		$dirname    = pathinfo($dirname, PATHINFO_FILENAME);
		$class_name = explode('-', $dirname);
		$class_name = array_map('ucfirst', $class_name);
		$class_name = implode('_', $class_name);

		return $class_name;
	}

    public function qoxag_shortcode_elements($widgets_manager){
        foreach($this->get_input_widgets() as $v) {

			$files = QOXAG_CORE . '/elementor/widgets/' . $v . '/' . $v . '.php';
          
			if(file_exists($files)) {
                require_once $files;
                
				$class_name = '\Elementor\Qoxag_' . self::make_classname($v);

                if(class_exists($class_name)){
                    $widgets_manager->register_widget_type(new $class_name());
                }
			}
		}
    }

	public static function qoxag_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new Qoxag_Shortcode();
        }
        return self::$_instance;
    }

    //Qoxag custom group controls
    public function qoxag_custom_group_controls( $controls_manager ){

        //post query controls
        include_once QOXAG_CORE . '/elementor/controls/qoxag-post-query.php';
        $controls_manager->add_group_control( Qoxag_Post_Query::get_type(), new Qoxag_Post_Query() );

        //post layout controls
        include_once QOXAG_CORE . '/elementor/controls/qoxag-layout.php';
        $controls_manager->add_group_control( Qoxag_Layout::get_type(), new Qoxag_Layout() );
    }

    // registering traits
    public function qoxag_traits( ) {
        require_once QOXAG_CORE. '/elementor/traits/grid-controls.php';
        require_once QOXAG_CORE. '/elementor/traits/slider-controls.php';
    }

    /**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */ 

    public function QOXAG_icon_pack( $controls_manager ) {

        require_once QOXAG_CORE . '/elementor/controls/icon.php';

        $controls = array(
            $controls_manager::ICON => 'Qoxag_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }

    
    // elementor icon fonts loaded
    public function Qoxag_elementor_icon_pack(  ) {

		$this->__generate_font();
		
        add_filter( 'elementor/icons_manager/additional_tabs', [ $this, '__add_font']);
		
    }
    
    public function __add_font( $font){
        $font_new['icon-electionify'] = [
            'name' => 'icon-qoxag',
            'label' => esc_html__( 'Qoxag Icons', 'qoxag' ),
            'url' => QOXAG_CSS . '/public/icon.css',
            'enqueue' => [ QOXAG_CSS . '/public/icon.css' ],
            'prefix' => 'xts-',
            'displayPrefix' => 'xts-icon',
            'labelIcon' => 'xts-icon xts-play_icon',
            'ver' => '5.9.0',
            'fetchJson' => QOXAG_JS . '/public/icon.js',
            'native' => true,
        ];
        return  array_merge($font, $font_new);
    }


    public function __generate_font(){
        global $wp_filesystem;

        require_once ( ABSPATH . '/wp-admin/includes/file.php' );
        WP_Filesystem();
        $css_file =  QOXAG_CSS_DIR . '/public/icon.css';
    
        if ( $wp_filesystem->exists( $css_file ) ) {
            $css_source = $wp_filesystem->get_contents( $css_file );
        } // End If Statement
        
        preg_match_all( "/\.(xts-.*?):\w*?\s*?{/", $css_source, $matches, PREG_SET_ORDER, 0 );
        $iconList = []; 
        
        foreach ( $matches as $match ) {
            $new_icons[$match[1] ] = str_replace('xts-', '', $match[1]);
            $iconList[] = str_replace('xts-', '', $match[1]);
        }

        $icons = new \stdClass();
        $icons->icons = $iconList;
        $icon_data = json_encode($icons);
        
        $file = QOXAG_THEME_DIR . '/assets/js/public/icon.js';
        
            global $wp_filesystem;
            require_once ( ABSPATH . '/wp-admin/includes/file.php' );
            WP_Filesystem();
            if ( $wp_filesystem->exists( $file ) ) {
                $content =  $wp_filesystem->put_contents( $file, $icon_data) ;
            } 
        
    }
}
Qoxag_Shortcode::qoxag_get_instance();