
<?php
/**
 * the template for displaying 404 pages (Not Found)
 */

get_header();

if ( defined( 'DEVM' ) ) {
   $blog_show_banner = qoxag_option('blog_show_banner');
   $show_breadcrumb  = qoxag_option('blog_show_breadcrumb');
} else {
   $blog_show_banner = 'yes';
   $show_breadcrumb  = 'yes';
}

?>
<section id="main-container" class="blog main-container">
      <div class="container">
         <?php 
            if( $show_breadcrumb == 'yes' && $blog_show_banner != 'yes'){
         ?>
            <div class="nobanner-breadcrumb">
               <?php qoxag_get_breadcrumbs(); ?>
            </div>
         <?php } ?>

            <div class="row">
               <div class="col-lg-6 mx-auto">
                  <div class="error-page text-center">
                     <div class="error-code">
                        <strong><?php esc_html_e('404', 'qoxag'); ?></strong>
                     </div>
                     <div class="error-message">
                        <h3><?php esc_html_e('Oops... Page Not Found!', 'qoxag'); ?></h3>
                     </div>
                     <div class="error-body">
                        <?php esc_html_e('Try using the button below to go to main page of the site', 'qoxag'); ?> <br>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn btn-primary solid blank"><i class="xts-icon xts-chevron-left"> </i> <?php esc_html_e('Back to Home Page', 'qoxag'); ?></a>
                     </div>
                  </div>
               </div>
            </div><!-- Content row -->
         </div><!-- Container end -->
      </section><!-- Main container end -->

<?php get_footer(); ?>