<?php

$fields[]              = array(
	'name'          => __( 'Facebook Comments Instructions', 'better-studio' ),
	'id'            => 'facebook-help',
	'type'          => 'info',
	'std'           => __( '<ol>
            <li>Read <a href="https://goo.gl/0WBQTi">official documentation to create new app</a>.</li>
            <li>Paste created "APP ID" it in the below "App ID" input box.</li>
          </ol>
                    ', 'better-studio' ),
	'state'         => 'open',
	'info-type'     => 'help',
	'section_class' => 'widefat',
);
$fields['app_id']      = array(
	'name' => __( 'App ID', 'better-studio' ),
	'id'   => 'app_id',
	'desc' => __( 'Enter in your Facebook App ID.', 'better-studio' ),
	'type' => 'text',
);
$fields['numposts']    = array(
	'name' => __( 'Number Posts', 'better-studio' ),
	'id'   => 'numposts',
	'desc' => __( 'Select the amount of posts per page to display.', 'better-studio' ),
	'type' => 'text',
);
$fields['order_by']    = array(
	'name'    => __( 'Posts Order', 'better-studio' ),
	'id'      => 'order_by',
	'desc'    => __( 'Choose the order for your posts. Selecting "Social" will bring what Facebook deems the highest quality comments to the surface.', 'better-studio' ),
	'type'    => 'select',
	'options' => array(
		'social'       => __( 'Social', 'better-studio' ),
		'time'         => __( 'Time', 'better-studio' ),
		'reverse_time' => __( 'Reverse Time', 'better-studio' ),
	)
);
$fields['colorscheme'] = array(
	'name'    => __( 'Color Scheme', 'better-studio' ),
	'id'      => 'colorscheme',
	'desc'    => __( 'Choose which color scheme you would like for your comments.', 'better-studio' ),
	'type'    => 'select',
	'options' => array(
		'light' => __( 'Light', 'better-studio' ),
		'dark'  => __( 'Dark', 'better-studio' ),
	)
);
$fields['locale']      = array(
	'name'    => __( 'Adjust Language', 'better-studio' ),
	'id'      => 'locale',
	'desc'    => __( 'You can adjust the language of the Comments by changing this option.', 'better-studio' ),
	'type'    => 'select',
	'options' => array()
);

// Add locales only in admin to reduce memory usage in front end!
if ( is_admin() ) {
	$fields['locale']['options'] = array(
		'en_US' => '-- English (US) -- ',
		'af_ZA' => 'Afrikaans',
		'ak_GH' => 'Akan',
		'am_ET' => 'Amharic',
		'ar_AR' => 'Arabic',
		'as_IN' => 'Assamese',
		'ay_BO' => 'Aymara',
		'az_AZ' => 'Azerbaijani',
		'be_BY' => 'Belarusian',
		'bg_BG' => 'Bulgarian',
		'bn_IN' => 'Bengali',
		'br_FR' => 'Breton',
		'bs_BA' => 'Bosnian',
		'ca_ES' => 'Catalan',
		'cb_IQ' => 'Sorani Kurdish',
		'ck_US' => 'Cherokee',
		'co_FR' => 'Corsican',
		'cs_CZ' => 'Czech',
		'cx_PH' => 'Cebuano',
		'cy_GB' => 'Welsh',
		'da_DK' => 'Danish',
		'de_DE' => 'German',
		'el_GR' => 'Greek',
		'en_GB' => 'English (UK)',
		'en_IN' => 'English (India)',
		'en_PI' => 'English (Pirate)',
		'en_UD' => 'English (Upside Down)',
		'eo_EO' => 'Esperanto',
		'es_CO' => 'Spanish (Colombia)',
		'es_ES' => 'Spanish (Spain)',
		'es_LA' => 'Spanish',
		'et_EE' => 'Estonian',
		'eu_ES' => 'Basque',
		'fa_IR' => 'Persian',
		'fb_LT' => 'Leet Speak',
		'ff_NG' => 'Fulah',
		'fi_FI' => 'Finnish',
		'fo_FO' => 'Faroese',
		'fr_CA' => 'French (Canada)',
		'fr_FR' => 'French (France)',
		'fy_NL' => 'Frisian',
		'ga_IE' => 'Irish',
		'gl_ES' => 'Galician',
		'gn_PY' => 'Guarani',
		'gu_IN' => 'Gujarati',
		'gx_GR' => 'Classical Greek',
		'ha_NG' => 'Hausa',
		'he_IL' => 'Hebrew',
		'hi_IN' => 'Hindi',
		'hr_HR' => 'Croatian',
		'hu_HU' => 'Hungarian',
		'hy_AM' => 'Armenian',
		'id_ID' => 'Indonesian',
		'ig_NG' => 'Igbo',
		'is_IS' => 'Icelandic',
		'it_IT' => 'Italian',
		'ja_JP' => 'Japanese',
		'ja_KS' => 'Japanese (Kansai)',
		'jv_ID' => 'Javanese',
		'ka_GE' => 'Georgian',
		'kk_KZ' => 'Kazakh',
		'km_KH' => 'Khmer',
		'kn_IN' => 'Kannada',
		'ko_KR' => 'Korean',
		'ku_TR' => 'Kurdish (Kurmanji)',
		'la_VA' => 'Latin',
		'lg_UG' => 'Ganda',
		'li_NL' => 'Limburgish',
		'ln_CD' => 'Lingala',
		'lo_LA' => 'Lao',
		'lt_LT' => 'Lithuanian',
		'lv_LV' => 'Latvian',
		'mg_MG' => 'Malagasy',
		'mk_MK' => 'Macedonian',
		'ml_IN' => 'Malayalam',
		'mn_MN' => 'Mongolian',
		'mr_IN' => 'Marathi',
		'ms_MY' => 'Malay',
		'mt_MT' => 'Maltese',
		'my_MM' => 'Burmese',
		'nb_NO' => 'Norwegian (bokmal)',
		'nd_ZW' => 'Ndebele',
		'ne_NP' => 'Nepali',
		'nl_BE' => 'Dutch (België)',
		'nl_NL' => 'Dutch',
		'nn_NO' => 'Norwegian (nynorsk)',
		'ny_MW' => 'Chewa',
		'or_IN' => 'Oriya',
		'pa_IN' => 'Punjabi',
		'pl_PL' => 'Polish',
		'ps_AF' => 'Pashto',
		'pt_BR' => 'Portuguese (Brazil)',
		'pt_PT' => 'Portuguese (Portugal)',
		'qu_PE' => 'Quechua',
		'rm_CH' => 'Romansh',
		'ro_RO' => 'Romanian',
		'ru_RU' => 'Russian',
		'rw_RW' => 'Kinyarwanda',
		'sa_IN' => 'Sanskrit',
		'sc_IT' => 'Sardinian',
		'se_NO' => 'Northern Sámi',
		'si_LK' => 'Sinhala',
		'sk_SK' => 'Slovak',
		'sl_SI' => 'Slovenian',
		'sn_ZW' => 'Shona',
		'so_SO' => 'Somali',
		'sq_AL' => 'Albanian',
		'sr_RS' => 'Serbian',
		'sv_SE' => 'Swedish',
		'sw_KE' => 'Swahili',
		'sy_SY' => 'Syriac',
		'sz_PL' => 'Silesian',
		'ta_IN' => 'Tamil',
		'te_IN' => 'Telugu',
		'tg_TJ' => 'Tajik',
		'th_TH' => 'Thai',
		'tk_TM' => 'Turkmen',
		'tl_PH' => 'Filipino',
		'tl_ST' => 'Klingon',
		'tr_TR' => 'Turkish',
		'tt_RU' => 'Tatar',
		'tz_MA' => 'Tamazight',
		'uk_UA' => 'Ukrainian',
		'ur_PK' => 'Urdu',
		'uz_UZ' => 'Uzbek',
		'vi_VN' => 'Vietnamese',
		'wo_SN' => 'Wolof',
		'xh_ZA' => 'Xhosa',
		'yi_DE' => 'Yiddish',
		'yo_NG' => 'Yoruba',
		'zh_CN' => 'Simplified Chinese (China)',
		'zh_HK' => 'Traditional Chinese (Hong Kong)',
		'zh_TW' => 'Traditional Chinese (Taiwan)',
		'zu_ZA' => 'Zulu',
		'zz_TR' => 'Zazaki',
	);
}
$fields[]                   = array(
	'name'  => __( 'Comment Texts', 'better-studio' ),
	'type'  => 'group',
	'state' => 'close',
);
$fields['text_no_comment']  = array(
	'name' => __( 'No Comment Text', 'better-studio' ),
	'id'   => 'text_no_comment',
	'type' => 'text',
);
$fields['text_one_comment'] = array(
	'name' => __( 'One Comment Text', 'better-studio' ),
	'id'   => 'text_one_comment',
	'type' => 'text',
);
$fields['text_two_comment'] = array(
	'name' => __( 'Two Comment Text', 'better-studio' ),
	'id'   => 'text_two_comment',
	'type' => 'text',
);
$fields['text_comments']    = array(
	'name' => __( 'Comments Text', 'better-studio' ),
	'id'   => 'text_comments',
	'type' => 'text',
);
$fields['text_loading']     = array(
	'name' => __( 'Comments Loading', 'better-studio' ),
	'id'   => 'text_loading',
	'type' => 'text',
);
