<?php
/**
 * @param $options
 * dialog
 */
function blogar_confirmation_dialog_options($options)
{
    return array_merge($options, array(
        'width' => 500,
        'dialogClass' => 'wp-dialog',
        'resizable' => false,
        'height' => 'auto',
        'modal' => true,
    ));
}

add_filter('pt-ocdi/confirmation_dialog_options', 'blogar_confirmation_dialog_options', 10, 1);

/**
 * blogar_import_files
 * @return array
 */
function blogar_import_files()
{
    $demo_location = BLOGAR_DEMO_CONTENT_URL;
    $preview_image_location = BLOGAR_DEMO_PREVIEW_IMAGE_URL;
    $preview_url = 'http://axilthemes.com/themes/blogar';
    $import_notice = esc_html__('Importing may take 5-10 minutes.', 'blogar');
    return array(
        array(
            'import_file_name' => 'Home Default',
            'import_file_url' => $demo_location . 'content.xml',
            'import_widget_file_url' => $demo_location . 'widget.wie',
            'import_customizer_file_url' => $demo_location . 'customizer.dat',
            'import_redux' => array(
                array(
                    'file_url' => $demo_location . 'redux_options.json',
                    'option_name' => 'axil_options',
                )
            ),
            'import_preview_image_url' => $preview_image_location . 'home-default.jpg',
            'preview_url' => $preview_url,
            'import_notice' => $import_notice,
        ),
        array(
            'import_file_name' => 'Home Creative Blog',
            'import_file_url' => $demo_location . 'content.xml',
            'import_widget_file_url' => $demo_location . 'widget.wie',
            'import_customizer_file_url' => $demo_location . 'customizer.dat',
            'import_redux' => array(
                array(
                    'file_url' => $demo_location . 'redux_options.json',
                    'option_name' => 'axil_options',
                )
            ),
            'import_preview_image_url' => $preview_image_location . 'home-creative-blog.jpg',
            'preview_url' => $preview_url . '/home-creative-blog/',
            'import_notice' => $import_notice,
        ),
        array(
            'import_file_name' => 'Home SEO Blog',
            'import_file_url' => $demo_location . 'content.xml',
            'import_widget_file_url' => $demo_location . 'widget.wie',
            'import_customizer_file_url' => $demo_location . 'customizer.dat',
            'import_redux' => array(
                array(
                    'file_url' => $demo_location . 'redux_options.json',
                    'option_name' => 'axil_options',
                )
            ),
            'import_preview_image_url' => $preview_image_location . 'home-seo-blog.jpg',
            'preview_url' => $preview_url . '/home-seo-blog/',
            'import_notice' => $import_notice,
        ),
        array(
            'import_file_name' => 'Home Tech Blog',
            'import_file_url' => $demo_location . 'content.xml',
            'import_widget_file_url' => $demo_location . 'widget.wie',
            'import_customizer_file_url' => $demo_location . 'customizer.dat',
            'import_redux' => array(
                array(
                    'file_url' => $demo_location . 'redux_options.json',
                    'option_name' => 'axil_options',
                )
            ),
            'import_preview_image_url' => $preview_image_location . 'home-tech-blog.jpg',
            'preview_url' => $preview_url . '/home-tech-blog/',
            'import_notice' => $import_notice,
        ),
        array(
            'import_file_name' => 'Home Lifestyle Blog',
            'import_file_url' => $demo_location . 'content.xml',
            'import_widget_file_url' => $demo_location . 'widget.wie',
            'import_customizer_file_url' => $demo_location . 'customizer.dat',
            'import_redux' => array(
                array(
                    'file_url' => $demo_location . 'redux_options.json',
                    'option_name' => 'axil_options',
                )
            ),
            'import_preview_image_url' => $preview_image_location . 'home-lifestyle-blog.jpg',
            'preview_url' => $preview_url . '/home-lifestyle-blog/',
            'import_notice' => $import_notice,
        )
    );
}

add_filter('pt-ocdi/import_files', 'blogar_import_files');

/**
 * blogar_before_widgets_import
 * @param $selected_import
 */
function blogar_before_widgets_import($selected_import)
{

    // Remove 'Hello World!' post
    wp_delete_post(1, true);
    // Remove 'Sample page' page
    wp_delete_post(2, true);

    $sidebars_widgets = get_option('sidebars_widgets');
    $sidebars_widgets['sidebar'] = array();
    update_option('sidebars_widgets', $sidebars_widgets);

}

add_action('pt-ocdi/before_widgets_import', 'blogar_before_widgets_import');

/*
 * Automatically assign
 * "Front page",
 * "Posts page" and menu
 * locations after the importer is done
 */
function blogar_after_import_setup($selected_import)
{

    $demo_imported = get_option('blogar_demo_imported');

    $cpt_support = get_option('elementor_cpt_support');
    $elementor_disable_color_schemes = get_option('elementor_disable_color_schemes');
    $elementor_disable_typography_schemes = get_option('elementor_disable_typography_schemes');
    $elementor_container_width = get_option('elementor_container_width');


    //check if option DOESN'T exist in db
    if (!$cpt_support) {
        $cpt_support = ['page', 'post', 'megamenu', 'elementor_disable_color_schemes']; //create array of our default supported post types
        update_option('elementor_cpt_support', $cpt_support); //write it to the database
    }
    if (empty($elementor_disable_color_schemes)) {
        update_option('elementor_disable_color_schemes', 'yes'); //update database
    }
    if (empty($elementor_disable_typography_schemes)) {
        update_option('elementor_disable_typography_schemes', 'yes'); //update database
    }
    if (empty($elementor_container_width)) {
        update_option('elementor_container_width', '1260'); //update database
    }

    $elementor_general_settings = array(
        'container_width' => (!empty($elementor_container_width)) ? $elementor_container_width : '1260',
    );
    update_option('_elementor_general_settings', $elementor_general_settings); //update database

    // Update Global Css Options For Elementor
    $currentTime = strtotime("now");
    $elementor_global_css = array(
        'time' => $currentTime,
        'fonts' => array()
    );
    update_option('_elementor_global_css', $elementor_global_css); //update database
    update_option('trydo_elementor_custom_setting_imported', 'elementor_custom_setting_imported');
    update_option('mc4wp_default_form_id', '703'); //update database

    if (empty($demo_imported)) {

        // Home page selected
        if ('Home Default' === $selected_import['import_file_name']) {
            $front_page_id = get_page_by_title('Home Default');
            update_option('blogar_theme_active_demo', $selected_import['import_file_name']);
        } elseif ('Home Creative Blog' === $selected_import['import_file_name']) {
            $front_page_id = get_page_by_title('Home Creative Blog');
            update_option('blogar_theme_active_demo', $selected_import['import_file_name']);
        } elseif ('Home SEO Blog' === $selected_import['import_file_name']) {
            $front_page_id = get_page_by_title('Home SEO Blog');
            update_option('blogar_theme_active_demo', $selected_import['import_file_name']);
        } elseif ('Home Tech Blog' === $selected_import['import_file_name']) {
            $front_page_id = get_page_by_title('Home Tech Blog');
            update_option('blogar_theme_active_demo', $selected_import['import_file_name']);
        } elseif ('Home Lifestyle Blog' === $selected_import['import_file_name']) {
            $front_page_id = get_page_by_title('Home Lifestyle Blog');
            update_option('blogar_theme_active_demo', $selected_import['import_file_name']);
        }

        $blog_page_id = get_page_by_title('Posts');
        update_option('show_on_front', 'page');
        update_option('page_on_front', $front_page_id->ID);
        update_option('page_for_posts', $blog_page_id->ID);

        update_option('blogar_demo_imported', 'imported');
    }

    // Set Menu As Primary && Off Canvus Menu
    $main_menu = get_term_by('name', 'Primary Menu', 'nav_menu');
    $footerbottom = get_term_by('name', 'Footer Bottom Menu', 'nav_menu');
    $headertop = get_term_by('name', 'Header Top Menu', 'nav_menu');
    set_theme_mod('nav_menu_locations', array(
        'primary' => $main_menu->term_id,
        'headertop' => $headertop->term_id,
        'footerbottom' => $footerbottom->term_id
    ));

}

add_action('pt-ocdi/after_import', 'blogar_after_import_setup');

/**
 * time_for_one_ajax_call
 * @return int
 */
function blogar_change_time_of_single_ajax_call()
{
    return 20;
}

add_action('pt-ocdi/time_for_one_ajax_call', 'blogar_change_time_of_single_ajax_call');


// To make demo imported items selected
add_action('admin_footer', 'blogar_pt_ocdi_add_scripts');
function blogar_pt_ocdi_add_scripts()
{
    $demo_imported = get_option('blogar_theme_active_demo');
    if (!empty($demo_imported)) {
        ?>
        <script>
            jQuery(document).ready(function ($) {
                $('.ocdi__gl-item.js-ocdi-gl-item').each(function () {
                    var ocdi_theme_title = $(this).data('name');
                    var current_ocdi_theme_title = '<?php echo strtolower($demo_imported); ?>';
                    if (ocdi_theme_title == current_ocdi_theme_title) {
                        $(this).addClass('active_demo');
                        return false;
                    }
                });
            });
        </script>
        <?php
    }
}

/**
 * Remove ads
 */
add_filter('pt-ocdi/disable_pt_branding', '__return_true');



