<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'nexio_child_locale_css' ) ) {
	function nexio_child_locale_css( $uri ) {
		if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) ) {
			$uri = get_template_directory_uri() . '/rtl.css';
		}
		
		return $uri;
	}
};
add_filter( 'locale_stylesheet_uri', 'nexio_child_locale_css' );

if ( ! function_exists( 'nexio_child_enqueue_scripts' ) ) {
	function nexio_child_enqueue_scripts() {
		wp_enqueue_style( 'nexio_child_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array(
			'boostrap',
			'flat-icons',
			'fullpage',
			'scrollbar',
			'nexio-main-style',
			'nexio-main-style',
			'nexio_custom_css'
		) );
	}
};
add_action( 'wp_enqueue_scripts', 'nexio_child_enqueue_scripts', 999 );

