<?php
add_shortcode('cs-next-event', 'cs_shortcode_next_event_render');
function cs_shortcode_next_event_render($params, $content = null) {
	global $wpdb;
    extract(shortcode_atts(array(
        'title' => '',
        'image' => '',
        'description'=>'',
        'class' => ''
    ), $params));
    
    $date_sever = date_i18n('Y-m-d G:i:s');
    
    $gmt_offset = get_option( 'gmt_offset' );
    
    //date_default_timezone_set("America/Los_Angeles");
    wp_enqueue_script('jquery-plugin', get_template_directory_uri() . "/framework/shortcodes/eventcountdown/js/jquery.plugin.min.js");
    wp_enqueue_script('jquery-countdown', get_template_directory_uri() . "/framework/shortcodes/eventcountdown/js/jquery.countdown.min.js");
    wp_enqueue_script('custom-countdown', get_template_directory_uri() . "/framework/shortcodes/eventcountdown/js/custom.countdown.js");
    
    
    /* Query */
    $pageposts = null;
    $querystr  = "SELECT e.*, p.*
                  FROM {$wpdb->prefix}em_events as e,{$wpdb->prefix}posts as p
                  WHERE e.event_status = '1'
                  AND e.post_id = p.ID
                  AND TIMESTAMP(CONCAT(e.event_start_date,' ',e.event_start_time)) >= TIMESTAMP('{$date_sever}')
                  ORDER BY e.event_start_date ASC LIMIT 0, 1";

    $pageposts = $wpdb->get_results($querystr, OBJECT);
    
    ob_start();
    
    if(isset($pageposts[0])):
    
    $pageposts = $pageposts[0];
    
    $utc_date = !empty($pageposts) ? date('Y,m,d,H,i,s', strtotime($pageposts->event_start_date." ".$pageposts->event_start_time)) : null;
    
	?>
	<div class="cs-eventCount">
		<div class="cs-eventCount-header widget-block-header">
			<?php if($title): ?>
				<h1 class="cs-title"><?php echo esc_attr($title); ?></h1>
			<?php endif; ?>
			<?php if($description): ?>
				<p class="cs-desc"><?php echo esc_attr($description); ?></p>
			<?php endif; ?>
		</div>
		<div class="cs-eventCount-content">
			<div class='cs-eventCount-introImg col-xs-12 col-sm-12 col-md-6 col-lg-6'>
			<?php if($image): ?>
				<?php $image = wp_get_attachment_image_src($image, 'full'); ?>
				<img alt="<?php echo esc_html($pageposts->event_name); ?>" src="<?php echo esc_url($image[0]); ?>"/>
			<?php elseif (has_post_thumbnail($pageposts->post_id)) : ?>
				<?php the_post_thumbnail( 'full' ); ?>
			<?php endif; ?>
			</div>
			<div class="cs-eventCount-contentWrap col-xs-12 col-sm-12 col-md-6 col-lg-6">
				<h3 class="cs-eventCount-title"><a href="<?php get_the_permalink($pageposts->post_id); ?>"><?php echo esc_html($pageposts->event_name); ?></a></h3>
				<div class="cs-eventCount-content-main"><?php echo cshero_string_limit_words(strip_tags($pageposts->post_content), 20); ?>...</div>
				<span id="event_countdown" class="" data-count="<?php echo esc_attr($utc_date);?>" data-timezone="<?php echo esc_attr($gmt_offset); ?>" data-label="<?php echo esc_html__('DAYS', 'wp_nuvo').','.esc_html__('HOURS', 'wp_nuvo').','.esc_html__('MINUTES', 'wp_nuvo').','.esc_html__('SECONDS', 'wp_nuvo'); ?>"></span>
			</div>
		</div>
	</div>
	<?php
	
	else :
	
	?>
	<div class="cs-eventCount">
		<span><?php esc_html_e('No Event', 'wp_nuvo'); ?></span>
	</div>
	<?php
	
	endif;
	
	return ob_get_clean();
}