<?php

/**
 * Theme options / General / Posts
 *
 * @package vamtam/morz
 */

return array(

	array(
		'label'       => esc_html__( 'Pagination Type', 'morz' ),
		'description' => esc_html__( 'Also used for portfolio', 'morz' ),
		'id'          => 'pagination-type',
		'type'        => 'select',
		'choices'     => array(
			'paged'              => esc_html__( 'Paged', 'morz' ),
			'load-more'          => esc_html__( 'Load more button', 'morz' ),
			'infinite-scrolling' => esc_html__( 'Infinite scrolling', 'morz' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show "Related Posts" in Single Post View', 'morz' ),
		'description' => esc_html__( 'Enabling this option will show more posts from the same category when viewing a single post.', 'morz' ),
		'id'          => 'show-related-posts',
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'     => esc_html__( '"Related Posts" title', 'morz' ),
		'id'        => 'related-posts-title',
		'type'      => 'text',
		'transport' => 'postMessage',
	),

	array(
		'label'     => esc_html__( 'Meta Information', 'morz' ),
		'id'        => 'post-meta',
		'type'      => 'multicheck',
		'transport' => 'postMessage',
		'choices'   => array(
			'author'   => esc_html__( 'Post Author', 'morz' ),
			'tax'      => esc_html__( 'Categories and Tags', 'morz' ),
			'date'     => esc_html__( 'Timestamp', 'morz' ),
			'comments' => esc_html__( 'Comment Count', 'morz' ),
		),
	),

	array(
		'label'       => esc_html__( 'Show Featured Image on Single Posts', 'morz' ),
		'id'          => 'show-single-post-image',
		'description' => esc_html__( 'Please note, that this option works only for Blog Post Format Image.', 'morz' ),
		'type'        => 'switch',
		'transport'   => 'postMessage',
	),

	array(
		'label'       => esc_html__( 'Post Archive Layout', 'morz' ),
		'description' => '',
		'id'          => 'archive-layout',
		'type'        => 'radio',
		'choices'     => array(
			'normal' => esc_html__( 'Large', 'morz' ),
			'mosaic' => esc_html__( 'Small', 'morz' ),
		),
	),

);

