<?php


/*-----------------------------------------------------------------------------------

	CUSTOM POST TYPES 

-----------------------------------------------------------------------------------*/
global $prefix;


/*-----------------------------------------------------------------------------------*/
/*	Register new Post-type
/*-----------------------------------------------------------------------------------*/

add_action('init', 'sr_portfolio_post_type');

function sr_portfolio_post_type(){
	
	register_post_type('portfolio', array(
		'labels' => array(
				'name' => __("Portfolio", 'sr_mila_theme'),
				'singular_name' => __("Project", 'sr_mila_theme')
			),
		'public' => true,
		'show_ui' => true,
		'supports' => array('title', 'editor', 'thumbnail', 'comments'),
		'menu_icon' => get_stylesheet_directory_uri() . '/theme-admin/functions/images/portfolio.png',
		'rewrite' => array(
			'slug' => 'portfolio',
			'with_front' => false
			),
		'has_archive' => 'portfolio',
		'query_var' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'exclude_from_search' => true,
		'publicly_queryable' => true
	) );
	
	register_post_type('gallery', array(
		'labels' => array(
				'name' => __("Gallery", 'sr_mila_theme'),
				'singular_name' => __("Gallery", 'sr_mila_theme')
			),
		'public' => true,
		'show_ui' => true,
		'supports' => array('title', 'thumbnail', 'comments'),
		'menu_icon' => get_stylesheet_directory_uri() . '/theme-admin/functions/images/gallery.png',
		'rewrite' => array(
			'slug' => 'gallery',
			'with_front' => false
			),
		'has_archive' => 'gallery',
		'query_var' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'exclude_from_search' => true,
		'publicly_queryable' => true
	) );
	
	/*register_post_type('slider', array(
		'labels' => array(
				'name' => __("Slider", 'sr_mila_theme'),
				'singular_name' => __("Slider", 'sr_mila_theme')
			),
		'public' => false,
		'show_ui' => true,
		'supports' => array('title'),
		'menu_icon' => get_stylesheet_directory_uri() . '/theme-admin/functions/images/slider.png',
		'rewrite' => array(
			'slug' => 'slider',
			'with_front' => false
			),
		'has_archive' => 'slider',
		'query_var' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'exclude_from_search' => true,
		'publicly_queryable' => false
	) );*/
	
}




/*-----------------------------------------------------------------------------------*/
/*	Add taxonomies
/*-----------------------------------------------------------------------------------*/

add_action('init', 'sr_portfolio_taxonomies', 0);

function sr_portfolio_taxonomies(){
	
	// Categories Portfolio
	register_taxonomy(
		'portfolio_category',
		'portfolio',
		array(
			'hierarchical' => true,
			'label' => __("Portfolio categories", 'sr_mila_theme'),
			'query_var' => true,
			'rewrite' => true
		)
	);
	
	// Categories Gallery
	/*register_taxonomy(
		'gallery_category',
		'gallery',
		array(
			'hierarchical' => true,
			'label' => __("Gallery categories", 'sr_mila_theme'),
			'query_var' => true,
			'rewrite' => true
		)
	);*/
	
	
	// Tags Portfolio
	/*register_taxonomy(
		'portfolio_tags',
		'portfolio',
		array(
			'hierarchical' => false,
			'label' => __("Portfolio tags", 'sr_mila_theme'),
			'query_var' => true,
			'rewrite' => true
		)
	);*/
	
}




/*-----------------------------------------------------------------------------------*/
/*	Columns
/*-----------------------------------------------------------------------------------*/

add_filter("manage_edit-portfolio_columns", "sr_portfolio_edit_columns");
function sr_portfolio_edit_columns($columns){
	$columns = array(
		"cb" => "<input type='checkbox' />",
		"title" => __("Title", 'sr_mila_theme'),
		"portfolio_category" => __("Category", 'sr_mila_theme'),
		"date" => __("Date", 'sr_mila_theme')
	);
	return $columns;
}


/*add_filter("manage_edit-gallery_columns", "sr_gallery_edit_columns");
function sr_gallery_edit_columns($columns){
	$columns = array(
		"cb" => "<input type='checkbox' />",
		"title" => __("Title", 'sr_mila_theme'),
		"gallery_category" => __("Category", 'sr_mila_theme'),
		"date" => __("Date", 'sr_mila_theme')
	);
	return $columns;
}*/


add_action("manage_posts_custom_column",  "sr_portfolio_custom_columns");
function sr_portfolio_custom_columns($column){
	global $post;
	global $prefix;
	switch ($column){
		case "intro":
			$custom = get_post_custom();
			if ( isset($custom[$prefix."_intro"][0]) && $custom[$prefix."_intro"][0] !== '' ) { echo  $custom[$prefix."_intro"][0]; }
		break;
		case "portfolio_category":
			if (get_the_term_list($post->ID, 'portfolio_category', '', ', ','') !== '') { $val = wp_get_object_terms($post->ID, 'portfolio_category'); foreach($val as $v){ echo $v->name . ', ';	}  }
			
		break;
		/*case "portfolio_tags":
			if (get_the_term_list($post->ID, 'portfolio_tags', '', ', ','') !== '') { $val = wp_get_object_terms($post->ID, 'portfolio_tags'); foreach($val as $v){ echo $v->name . ', ';	}  }
		break;
		case "gallery_category":
			if (get_the_term_list($post->ID, 'gallery_category', '', ', ','') !== '') { $val = wp_get_object_terms($post->ID, 'gallery_category'); foreach($val as $v){ echo $v->name . ', ';	}  }
			
		break;*/
	}
}




