<?php 

global $prefix;

?>
<!doctype html>
<!--[if lt IE 7]> <html class="no-js ie6 oldie" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js ie7 oldie" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js ie8 oldie" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->
<head>
<meta charset="utf-8">

<!-- scaling not possible (for smartphones, ipad, etc.) -->
<meta name="viewport" content="width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;" />

<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />


<?php  
$titles = sr_getTitle();
if ($titles['tax']) {
	$title =  $titles['tax'].' | '.$titles['title'];
} else {
	$title =  $titles['title'];
}
?>
<title><?php echo $title; ?> | <?php bloginfo('name'); ?> | <?php bloginfo('description'); ?></title>

<?php sr_get_social_metas(); ?>

<?php get_template_part( 'includes/custom-fonts' ); ?>

<?php wp_head(); ?>

</head>


<body <?php body_class(); ?>>

<div id="page-content">

<div id="loading"><span>loading</span></div>

<header>        
		
        <div class="header-inner wrapper clearfix">
            <?php if (get_option($prefix.'_logo')) { ?>
                <a id="logo" class="left_float" href="<?php echo home_url(); ?>"><img src="<?php echo get_option($prefix.'_logo'); ?>" alt="Logotype"></a>
            <?php } ?> 
            
			<div class="header-right right_float clearfix">
				<a href="" id="dropdown-menu" title="Drop/Down Menu"><?php _e("Menu", 'sr_mila_theme'); ?></a>
				<?php  
                    if(has_nav_menu('primary-menu')) {  
                        wp_nav_menu(  
                            array(  
                                'theme_location'  => 'primary-menu', 
                                'container'       => 'nav',  			        
                                'container_id'    => 'main-nav',  
                                'container_class' => 'right_float',  
                                'menu_class'      => '', 
                                'menu_id'         => 'primary' 
                            )
                        );  
                   }
                ?>
                
                
				<?php
					if ((is_page_template( 'template-portfolio.php' ) || (is_single() && get_post_type() == 'portfolio')) && !get_option($prefix.'_portfoliodisablefilter') && has_nav_menu('category-menu-portfolio')) {
				?>	
				<div class="filter left_float">
                	<a class="openfilter" href=""><?php _e("Filter", 'sr_mila_theme'); ?></a>
				<?php wp_nav_menu(  
						array(  
							'theme_location'  => 'category-menu-portfolio', 
							'container'       => '',  			        
							'container_id'    => 'portfolio-filter',  
							'container_class' => '',  
							'menu_class'      => 'masonryfilter clearfix', 
							'menu_id'         => '' ,
							'walker' => new sr_filter_output()
						)
					);
					 
				?>
				</div>
                <span class="filter-seperator"></span>
                <?php	 
                     }
				?>
                
                <?php
					if ( (is_home() || (is_single() && get_post_type() == 'post')) && !get_option($prefix.'_blogdisablefilter') && has_nav_menu('category-menu-blog')) {
				?>	
				<div class="filter left_float">
                	<a class="openfilter" href=""><?php _e("Filter", 'sr_mila_theme'); ?></a>
				<?php wp_nav_menu(  
						array(  
							'theme_location'  => 'category-menu-blog', 
							'container'       => '',  			        
							'container_id'    => 'blog-filter',  
							'container_class' => '',  
							'menu_class'      => 'masonryfilter clearfix', 
							'menu_id'         => '' ,
							'walker' => new sr_filter_output()
						)
					);
					 
				?>
                </div>
                <span class="filter-seperator"></span>
                <?php	 
                     }
				?>
                
            </div>
        </div>    
        
</header> <!-- END header -->

<section id="main">
	
	<div id="main-inner" class="clearfix">
