<!DOCTYPE html>
<!--[if lt IE 7 ]><html class="ie ie6" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7 ]><html class="ie ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8 ]><html class="ie ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 9 ]><html class="ie ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->
<html <?php language_attributes(); ?>><!--<![endif]-->
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
	<meta charset="<?php esc_attr(bloginfo( 'charset' )); ?>" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<meta name="viewport" content="width=device-width, initial-scale=1"/>

	<link rel="alternate" type="application/rss+xml" title="<?php esc_attr(bloginfo( 'name' )); ?>" href="<?php esc_attr(bloginfo( 'rss2_url' )); ?>" />
	<link rel="alternate" type="application/atom+xml" title="<?php esc_attr(bloginfo( 'name' )); ?>" href="<?php esc_attr(bloginfo( 'atom_url' )); ?>" />

    <script type="text/javascript">var $OZY_WP_AJAX_URL = "<?php echo esc_url(admin_url('admin-ajax.php')) ?>", $OZY_WP_IS_HOME = <?php echo (is_home() || is_front_page() ? 'true' : 'false') ?>, $OZY_WP_HOME_URL = "<?php echo esc_url(home_url()) ?>";</script>
    <?php global $ozyHelper, $ozy_global_params, $ozy_data; ?>
	<?php wp_head(); /* this is used by many Wordpress features and for plugins to work proporly */ ?>
</head>

<body <?php body_class(); ?>>
	<?php 
	if($ozy_data->is_animsition_active) echo '<div class="animsition">';

	include( locate_template( 'include/primary-menu.php', false, false ) ); 
	include( locate_template( 'include/google-maps_bg.php', false, false ) ); /* google maps background */ 
    ?>        
    <div class="none">
        <p><a href="#content"><?php _e('Skip to Content', 'logistic'); ?></a></p><?php /* used for accessibility, particularly for screen reader applications */ ?>
    </div><!--.none-->
    <?php
        $ozy_data->header_slider = ozy_check_header_slider();
        $ozy_data->footer_slider = ozy_check_footer_slider();
    ?>
    
    <div id="main" class="<?php ozy_o_html($ozy_data->header_slider[0] !='' ? ' header-slider-active' : ''); ozy_o_html($ozy_data->footer_slider[0] !='' ? ' footer-slider-active' : ''); ?>">
        <?php
		include( locate_template( 'include/header.php', false, false ) ); 
        ?>
        <div class="container <?php echo esc_attr($content_css); ?>">
        
            