<?php

require_once('classes/tgm-plugin-activation.php');

/**
* TGM Plugin activator
*/
function logistic_register_required_plugins() {
	$ext_plugin_path = logistic_settings(); if($ext_plugin_path == false) return;
	$plugins = array(
		array(
			'name'     	=> 'WPBakery Page Builder',
			'slug'     	=> 'js_composer',
			'source'   	=> $ext_plugin_path . 'js_composer.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '6.7.0'
		),array(
			'name'     	=> 'Logistic Essentials',
			'slug'     	=> 'ozy-logistic-essentials',
			'source'   	=> $ext_plugin_path . 'ozy-logistic-essentials.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '3.8'
		),array(
			'name'     	=> 'Classic Editor',
			'slug'     	=> 'classic-editor',
			'required' 	=> true,
			'force_deactivation' => false,
			'version'	=> '1.6.2'
		),array(
			'name'     	=> 'Master Slider',
			'slug'     	=> 'masterslider',
			'source'   	=> $ext_plugin_path . 'masterslider.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '3.5.5'
		),array(
			'name'     	=> 'Revolution Slider',
			'slug'     	=> 'revslider',
			'source'   	=> $ext_plugin_path . 'revslider.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '6.5.7'
		),array(
			'name'     	=> 'Freevision Tracker',
			'slug'     	=> 'freevision-tracker',
			'source'   	=> $ext_plugin_path . 'freevision-tracker.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '1.4'
		),array(
			'name'     	=> 'Envato Market',
			'slug'     	=> 'envato-market',
			'source'   	=> $ext_plugin_path . 'envato-market.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '2.0.6'
		),array(
			'name'     	=> 'Contact Form 7',
			'slug'     	=> 'contact-form-7',
			'required' 	=> false,
			'version'	=> '5.4.2'
		),array(
			'name'     	=> 'Mailchimp Widget',
			'slug'     	=> 'mailchimp-widget',
			'source'   	=> $ext_plugin_path . 'mailchimp-widget.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '2.0.9'
		)
	);

	$config = array(
		'id'           => 'logistic',         	   // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'install-required-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}

add_action('tgmpa_register', 'logistic_register_required_plugins');

?>
