<?php
/**
* Constants
*/
define( 'OZY_BASE_DIR', get_template_directory() . '/' );
define( 'OZY_BASE_URL', get_template_directory_uri() . '/' );
define( 'OZY_CSS_DIRECTORY_URL', get_stylesheet_directory_uri() . '/');
define( 'OZY_MAX_INFO_BAR_ENTRY', 5 );
define( 'OZY_DATE_FORMAT', get_option('date_format'));

/**
* Globals
*/
$ozy_data = new stdClass();

locate_template('functions/classes/helper.php', true, true);

global $ozyHelper,
	$ozy_temporary_post_title,
	$ozy_temporary_post_format,
	$ozy_global_params;

$ozyHelper = new Ozy_myHelper;

/**
* WPML Plugin Check
*/
if(class_exists('SitePress') && function_exists("icl_get_languages") && defined("ICL_LANGUAGE_CODE") && defined('ICL_LANGUAGE_NAME') && function_exists('icl_object_id')){
	global $sitepress;
	define( 'OZY_WPLANG', $sitepress->get_default_language());
	define( 'OZY_HOME_URL', esc_url(apply_filters( 'wpml_home_url', get_option( 'home' ) ) . '/') );
}else if(function_exists('pll_default_language') && function_exists('pll_home_url')){
	define( 'OZY_WPLANG', pll_default_language());
	define( 'OZY_HOME_URL', esc_url( pll_home_url() . '/' ) );
}else{
	define( 'OZY_WPLANG', substr(get_locale(), 0, 2));
	define( 'OZY_HOME_URL', esc_url(home_url('/') . '/') );
}

$ozy_data->wpml_current_language_	= '';

if(defined("ICL_LANGUAGE_CODE") && ICL_LANGUAGE_CODE != OZY_WPLANG) {
	$ozy_data->wpml_current_language_ = '_' . ICL_LANGUAGE_CODE;
}

/**
* Sets up theme defaults and registers support for various WordPress features.
*/
add_action('after_setup_theme', 'ozy_theme_setup');
function ozy_theme_setup() {
	// Load Languages
	load_theme_textdomain('logistic', get_template_directory() . '/lang/');

	// Adds Post Format support
	// learn more: http://codex.wordpress.org/Post_Formats
	add_theme_support( 'post-formats', array(
		'aside',
		'gallery',
		'link',
		'image',
		'quote',
		'status',
		'video',
		'audio',
		'chat' )
	);

	// Declare Automatic Feed Links support
	add_theme_support( 'automatic-feed-links' );

	// Declare WooCommerce support
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

	// Post thumbnail support
	add_theme_support( 'post-thumbnails' );

	// Custom menu support
	if ( function_exists( 'register_nav_menus' ) ) {
		register_nav_menus(
			array(
			  'header-menu' => 'Primary Menu',
			  'logged-in-menu' => 'Logged In Primary Menu'
			)
		);
	}

	// Add custom thumbnail sizes
	if ( function_exists( 'add_image_size' ) ) {
		add_image_size( 'boxyboxy', 480, 480, true );
		add_image_size( 'showbiz', 720, 720, true ); /*466x466 older version*/
		add_image_size( 'blog', 1144, 9999, false );
	}

	// Enable shortcodes in the widgets
	add_filter('widget_text', 'shortcode_unautop');
	add_filter('widget_text', 'do_shortcode');

	// WordPress 4.1+ title tag support
	add_theme_support("title-tag");

	// Removes detailed login error information for security
	add_filter('login_errors',function($a){return null;});

	// Default media sizes
	if (!isset($content_width)) $content_width = 1140;
	
	// Opting out of the block-based widgets editor WP 5.8+
	remove_theme_support( 'widgets-block-editor' );
}

/**
* TGM & Plugins
*/
require_once 'functions/extender.php';

/**
* Include Vafpress Framework
*/
require_once 'framework/bootstrap.php';

/**
* Include Custom Data Sources
*/
require_once 'admin/data_sources.php';

/**
* Mobile Check Class
*/
require_once 'functions/classes/mobile-check.php';

/**
* Theme options initializing here
*/
$ozy_tmpl_opt = OZY_BASE_DIR . 'admin/option/option.php';

/**
* Main functions / actions / hooks
*/
include_once('functions/functions.php');

/**
* Include Dynamic Sidebars
*/
require_once 'functions/sidebars.php';

/**
* Create instance of Theme Options
*/
$theme_options = new VP_Option(array(
	'is_dev_mode' 			=> false,
	'option_key' 			=> 'vpt_ozy_logistic_option',
	'page_slug' 			=> 'vpt_option',
	'template' 				=> $ozy_tmpl_opt,
	'menu_page' 			=> 'themes.php',
	'use_auto_group_naming' => true,
	'use_exim_menu' 		=> true,
	'minimum_role' 			=> 'edit_theme_options',
	'layout' 				=> 'fixed',
	'page_title' 			=> __( 'Theme Options', 'logistic' ),
	'menu_label' 			=> __( 'Theme Options', 'logistic' ),
));

/**
* Load option based css
*/
locate_template('functions/option-based-css.php', true, true);

/**
* Custom Menu Items
*/
if(defined('OZY_LOGISTIC_ESSENTIALS_ACTIVATED')) {
	require_once 'functions/menu-item-custom-fields/menu-item-custom-fields.php';
	require_once 'functions/menu-item-custom-fields/menu-item-custom-fields-megamenu.php';
}

/**
* Visual Composer Add-On visual shortcodes
*/
global $ozy_data;
$ozy_data->vc_active = false;

function ozy_init_vc_shortcodes() {
	if(function_exists('vc_map') &&
		function_exists('vc_set_as_theme')) {
		/* Make visual composer part of the theme */
		vc_set_as_theme();

		//Remove frontend editor
		if(function_exists('vc_disable_frontend')){vc_disable_frontend();}

		global $ozy_data;
		include_once('functions/vc_extend.php');
		//include_once('functions/shortcodes.php');
		$ozy_data->vc_active = true;
	}
}
add_action( 'init', 'ozy_init_vc_shortcodes', 99 );

/**
* Output and checks for wp_head
*/
function ozy_wp_head() {
	// Compatiblity check for old style favicon
	if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
		echo '<link rel="icon" href="'. esc_url(ozy_get_option('favicon')) . '" type="image/x-icon" />
		<link rel="apple-touch-icon" href="' . esc_url(ozy_get_option('favicon_apple_small')) . '">
		<link rel="apple-touch-icon" sizes="76x76" href="' . esc_url(ozy_get_option('favicon_apple_medium')) . '">
		<link rel="apple-touch-icon" sizes="120x120" href="' . esc_url(ozy_get_option('favicon_apple_large')) . '">
		<link rel="apple-touch-icon" sizes="152x152" href="' . esc_url(ozy_get_option('favicon_apple_xlarge')) . '">';
	}

	/*if YOAST plugin activated, let it do its work*/
    if (!defined('WPSEO_VERSION')) {
		echo '<meta name="description" content="';
		echo esc_attr(bloginfo( 'description' ));
		echo '" />';
    }
}
add_action('wp_head','ozy_wp_head');

function ozy_filter_title( $title ) {
	$filtered_title = get_bloginfo( 'name' );
	if ( is_category() ) {
		$filtered_title = 'Category Archive for &quot;' . single_cat_title('', false) . '&quot; | ' . get_bloginfo( 'name' );
	} elseif ( is_tag() ) {
		$filtered_title = 'Tag Archive for &quot;' . single_tag_title('', false) . '&quot; | ' . get_bloginfo( 'name' );
	} elseif ( is_archive() ) {
		$filtered_title = $title . ' Archive | ' . get_bloginfo( 'name' );
	} elseif ( is_search()) {
		$filtered_title = 'Search for &quot;'. esc_html(get_search_query()) .'&quot; | ' . get_bloginfo( 'name' );
	} elseif ( is_home() ) {
		$filtered_title = get_bloginfo( 'name' ) .  ' | ' . get_bloginfo( 'description' );
	}  elseif ( is_404() ) {
		$filtered_title = 'Error 404 Not Found | ' . get_bloginfo( 'name' );
	} elseif ( is_single() ) {
		$filtered_title = $title;
	} else {
		$filtered_title = get_bloginfo( 'name' );
		if($title) {
			$filtered_title .= $title;
		}
	}
    return $filtered_title;
}
add_filter( 'wp_title', 'ozy_filter_title' );

/**
* Add a pingback url auto-discovery header for single posts, pages, or attachments.
*/
function ozy_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="'. esc_url( get_bloginfo( 'pingback_url' ) ) .'">';
	}
}
add_action( 'wp_head', 'ozy_pingback_header' );

/**
* Disabling the auto-update feature Master Slider
*/
add_filter( 'masterslider_disable_auto_update', '__return_true' );

/**
* Customize Tag Cloud widget
*/
function ozy_tag_cloud_fix($tag_string){
   return preg_replace("/style='font-size:.+pt;'/", '', $tag_string);
}
add_filter('wp_generate_tag_cloud', 'ozy_tag_cloud_fix',10,3);

/**
* ozy_o
*
* @input - String
* @type - String - Default: attr
*
*/
function ozy_o($input, $type = 'attr') {
	switch ($type) {
		case 'attr';
			echo esc_attr($input);
			break;
		case 'url';
			echo esc_url($input);
			break;
		case 'css';
			echo strip_tags($input);
			break;
		case 'post';
			echo html_entity_decode($input);
			break;
		case 'html';
			return $input;
			break;
		default:
			echo esc_attr($input);
			break;
	}
}
function ozy_o_html($input) {
	echo ozy_o($input, 'html');
}
function ozy_o_css($input) {
	ozy_o($input, 'css');
}

function ozy_get_default_language_code() {
	$lang_code = get_bloginfo("language");
	if(strpos($lang_code, '-')) {
		$lang_code = explode('-', $lang_code);
		return $lang_code[0];
	}
	return $lang_code;
}

function ozy_is_wpml_active() {
	if(function_exists("icl_get_languages") && defined("ICL_LANGUAGE_CODE") && defined("ICL_LANGUAGE_NAME")) {
		return true;
	}
	return false;
}

function ozy_is_date_between($dt_start, $dt_check, $dt_end) {
    if(strtotime($dt_check) >= strtotime($dt_start) && strtotime($dt_check) <= strtotime($dt_end)) {
        return true;
	}
    return false;
}

function ozy_htmlentitiesOutsideHTMLTags ($htmlText) {
    $matches = Array();
    $sep = '###HTMLTAG###';
    preg_match_all("@<[^>]*>@", $htmlText, $matches);
    $tmp = preg_replace("@(<[^>]*>)@", $sep, $htmlText);
    $tmp = explode($sep, $tmp);

    for ($i=0; $i<count($tmp); $i++)
        $tmp[$i] = htmlentities($tmp[$i]);

    $tmp = join($sep, $tmp);

    for ($i=0; $i<count($matches[0]); $i++)
        $tmp = preg_replace("@"."$sep@", $matches[0][$i], $tmp, 1);

    return $tmp;
}

//add_filter( 'wp_lazy_loading_enabled',  '__return_false', 10, 3 );

/*function dequeue_jquery_migrate( $scripts ) {
    if ( ! is_admin() && ! empty( $scripts->registered['jquery'] ) ) {
        $scripts->registered['jquery']->deps = array_diff(
            $scripts->registered['jquery']->deps,
            [ 'jquery-migrate' ]
        );
    }
}
add_action( 'wp_default_scripts', 'dequeue_jquery_migrate' );*/

?>
