<?php
/**
 * Description tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

$heading = esc_html( apply_filters( 'woocommerce_product_description_heading', esc_html__( 'Description', 'jannal' ) ) );

?>

<?php if ( $heading ) : ?>
  <h2><?php echo jannal_html_output($heading); ?></h2>
<?php endif; ?>

<?php

/* Customized script */

$product_template = jannal_woo_product_single_template_option();
if( $product_template == 'custom-template' ) {

	global $product;
	$product_id = $product->get_id();

	$settings = get_post_meta( $product_id, '_custom_settings', true );

	if(isset($settings['description']) && $settings['description'] != '') {
		echo do_shortcode($settings['description']);
	}

} else {
	the_content();
}