<?php
$config = jannal_kirki_config();

# Breadcrumb Settings
JANNAL_Kirki::add_section( 'dt_site_breadcrumb_section', array(
	'title' => esc_html__( 'Breadcrumb', 'jannal' ),
	'panel' => 'dt_site_typography_panel',
	'priority' => 5
) );

	# customize-breadcrumb-title-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'customize-breadcrumb-title-typo',
		'label'    => esc_html__( 'Customize Title ?', 'jannal' ),
		'section'  => 'dt_site_breadcrumb_section',
		'default'  => jannal_defaults('customize-breadcrumb-title-typo'),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)			
	));
	
	# breadcrumb-title-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'typography',
		'settings' => 'breadcrumb-title-typo',
		'label'    => esc_html__( 'Title Typography', 'jannal' ),
		'section'  => 'dt_site_breadcrumb_section',
		'output' => array(
			array( 'element' => '.main-title-section h1, h1.simple-title' )
		),
		'default' => jannal_defaults( 'breadcrumb-title-typo' ),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),		
		'active_callback' => array(
			array( 'setting' => 'customize-breadcrumb-title-typo', 'operator' => '==', 'value' => '1' )
		)		
	));		
	
	# customize-breadcrumb-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'customize-breadcrumb-typo',
		'label'    => esc_html__( 'Customize Link ?', 'jannal' ),
		'section'  => 'dt_site_breadcrumb_section',
		'default'  => jannal_defaults('customize-breadcrumb-typo'),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)			
	));
	
	# breadcrumb-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'typography',
		'settings' => 'breadcrumb-typo',
		'label'    => esc_html__( 'Link Typography', 'jannal' ),
		'section'  => 'dt_site_breadcrumb_section',
		'output' => array(
			array( 'element' => 'div.breadcrumb a' )
		),
		'default' => jannal_defaults( 'breadcrumb-typo' ),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),
		'active_callback' => array(
			array( 'setting' => 'customize-breadcrumb-typo', 'operator' => '==', 'value' => '1' )
		)		
	));
# Breadcrumb Settings

# Body Content
JANNAL_Kirki::add_section( 'dt_body_content_typo_section', array(
	'title' => esc_html__( 'Body', 'jannal' ),
	'panel' => 'dt_site_typography_panel',
	'priority' => 15
) );

	# customize-body-content-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'customize-body-content-typo',
		'label'    => esc_html__( 'Customize Content Typo', 'jannal' ),
		'section'  => 'dt_body_content_typo_section',
		'default'  => jannal_defaults( 'customize-body-content-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# body-content-typo
	JANNAL_Kirki::add_field( $config ,array(
		'type' => 'typography',
		'settings' => 'body-content-typo',
		'label'    => esc_html__('Settings', 'jannal'),
		'section'  => 'dt_body_content_typo_section',
		'output' => array( 
			array( 'element' => 'body' ),
			array( 
				'element' => '.editor-styles-wrapper > *',
				'context' => array ('editor')
			)
		),
		'default' => jannal_defaults('body-content-typo'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),
		'active_callback' => array(
			array( 'setting' => 'customize-body-content-typo', 'operator' => '==', 'value' => '1' )
		)
	));	

# Heading
JANNAL_Kirki::add_section( 'dt_headings_typo_section', array(
	'title' => esc_html__( 'Headings', 'jannal' ),
	'panel' => 'dt_site_typography_panel',
	'priority' => 20
) );

	# H1
	# customize-body-h1-typo
	JANNAL_Kirki::add_field( 'jannal_kirki_config', array(
		'type'     => 'switch',
		'settings' => 'customize-body-h1-typo',
		'label'    => esc_html__( 'Customize H1 Tag', 'jannal' ),
		'section'  => 'dt_headings_typo_section',
		'default'  => jannal_defaults( 'customize-body-h1-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# h1 tag typography	
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type' => 'typography',
		'settings' => 'h1',
		'label'    =>esc_html__('H1 Tag Settings', 'jannal'),
		'section'  => 'dt_headings_typo_section',
		'output' => array( 
			array( 'element' => 'h1' ),
			array( 
				'element' => '.editor-post-title__block .editor-post-title__input, .editor-styles-wrapper .wp-block h1, body#tinymce.wp-editor.content h1',
				'context' => array ('editor')
			),
		),
		'default' => jannal_defaults('h1'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),					
		'active_callback' => array(
			array( 'setting' => 'customize-body-h1-typo', 'operator' => '==', 'value' => '1' )
		)
	));

	# H1 Divider
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type'=> 'custom',
		'settings' => 'customize-body-h1-typo-divider',
		'section'  => 'dt_headings_typo_section',
		'default'  => '<div class="customize-control-divider"></div>'
	));

	# H2
	# customize-body-h2-typo
	JANNAL_Kirki::add_field( 'jannal_kirki_config', array(
		'type'     => 'switch',
		'settings' => 'customize-body-h2-typo',
		'label'    => esc_html__( 'Customize H2 Tag', 'jannal' ),
		'section'  => 'dt_headings_typo_section',
		'default'  => jannal_defaults( 'customize-body-h2-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# h2 tag typography	
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type' => 'typography',
		'settings' => 'h2',
		'label'    =>esc_html__('H2 Tag Settings', 'jannal'),
		'section'  => 'dt_headings_typo_section',
		'output' => array( 
			array( 'element' => 'h2' ),
			array( 
				'element' => '.editor-styles-wrapper .wp-block h2',
				'context' => array ('editor')
			),
		),
		'default' => jannal_defaults('h2'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),									
		'active_callback' => array(
			array( 'setting' => 'customize-body-h2-typo', 'operator' => '==', 'value' => '1' )
		)
	));

	# H2 Divider
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type'=> 'custom',
		'settings' => 'customize-body-h2-typo-divider',
		'section'  => 'dt_headings_typo_section',
		'default'  => '<div class="customize-control-divider"></div>'
	));

	# H3
	# customize-body-h3-typo
	JANNAL_Kirki::add_field( 'jannal_kirki_config', array(
		'type'     => 'switch',
		'settings' => 'customize-body-h3-typo',
		'label'    => esc_html__( 'Customize H3 Tag', 'jannal' ),
		'section'  => 'dt_headings_typo_section',
		'default'  => jannal_defaults( 'customize-body-h3-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# h3 tag typography	
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type' => 'typography',
		'settings' => 'h3',
		'label'    =>esc_html__('H3 Tag Settings', 'jannal'),
		'section'  => 'dt_headings_typo_section',
		'output' => array( 
			array( 'element' => 'h3' ),
			array( 
				'element' => '.editor-styles-wrapper .wp-block h3',
				'context' => array ('editor')
			),
		),
		'default' => jannal_defaults('h3'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),									
		'active_callback' => array(
			array( 'setting' => 'customize-body-h3-typo', 'operator' => '==', 'value' => '1' )
		)
	));

	# H3 Divider
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type'=> 'custom',
		'settings' => 'customize-body-h3-typo-divider',
		'section'  => 'dt_headings_typo_section',
		'default'  => '<div class="customize-control-divider"></div>'
	));

	# H4
	# customize-body-h4-typo
	JANNAL_Kirki::add_field( 'jannal_kirki_config', array(
		'type'     => 'switch',
		'settings' => 'customize-body-h4-typo',
		'label'    => esc_html__( 'Customize H4 Tag', 'jannal' ),
		'section'  => 'dt_headings_typo_section',
		'default'  => jannal_defaults( 'customize-body-h4-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# h4 tag typography	
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type' => 'typography',
		'settings' => 'h4',
		'label'    =>esc_html__('H4 Tag Settings', 'jannal'),
		'section'  => 'dt_headings_typo_section',
		'output' => array( 
			array( 'element' => 'h4' ),
			array( 
				'element' => '.editor-styles-wrapper .wp-block h4',
				'context' => array ('editor')
			),
		),
		'default' => jannal_defaults('h4'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),									
		'active_callback' => array(
			array( 'setting' => 'customize-body-h4-typo', 'operator' => '==', 'value' => '1' )
		)
	));

	# H4 Divider
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type'=> 'custom',
		'settings' => 'customize-body-h4-typo-divider',
		'section'  => 'dt_headings_typo_section',
		'default'  => '<div class="customize-control-divider"></div>'
	));

	# H5
	# customize-body-h5-typo
	JANNAL_Kirki::add_field( 'jannal_kirki_config', array(
		'type'     => 'switch',
		'settings' => 'customize-body-h5-typo',
		'label'    => esc_html__( 'Customize H5 Tag', 'jannal' ),
		'section'  => 'dt_headings_typo_section',
		'default'  => jannal_defaults( 'customize-body-h5-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# h5 tag typography	
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type' => 'typography',
		'settings' => 'h5',
		'label'    =>esc_html__('H5 Tag Settings', 'jannal'),
		'section'  => 'dt_headings_typo_section',
		'output' => array( 
			array( 'element' => 'h5' ),
			array( 
				'element' => '.editor-styles-wrapper .wp-block h5',
				'context' => array ('editor')
			),
		),
		'default' => jannal_defaults('h5'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),									
		'active_callback' => array(
			array( 'setting' => 'customize-body-h5-typo', 'operator' => '==', 'value' => '1' )
		)
	));

	# H5 Divider
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type'=> 'custom',
		'settings' => 'customize-body-h5-typo-divider',
		'section'  => 'dt_headings_typo_section',
		'default'  => '<div class="customize-control-divider"></div>'
	));

	# H6
	# customize-body-h6-typo
	JANNAL_Kirki::add_field( 'jannal_kirki_config', array(
		'type'     => 'switch',
		'settings' => 'customize-body-h6-typo',
		'label'    => esc_html__( 'Customize H6 Tag', 'jannal' ),
		'section'  => 'dt_headings_typo_section',
		'default'  => jannal_defaults( 'customize-body-h6-typo' ),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)
	));

	# h6 tag typography	
	JANNAL_Kirki::add_field( 'jannal_kirki_config' ,array(
		'type' => 'typography',
		'settings' => 'h6',
		'label'    =>esc_html__('H6 Tag Settings', 'jannal'),
		'section'  => 'dt_headings_typo_section',
		'output' => array( 
			array( 'element' => 'h6' ),
			array( 
				'element' => '.editor-styles-wrapper .wp-block h6',
				'context' => array ('editor')
			),
		),
		'default' => jannal_defaults('h6'),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),									
		'active_callback' => array(
			array( 'setting' => 'customize-body-h6-typo', 'operator' => '==', 'value' => '1' )
		)
	));
	

# Custom Content Settings
JANNAL_Kirki::add_section( 'dt_site_custom_content_section', array(
	'title' => esc_html__( 'Custom Content', 'jannal' ),
	'panel' => 'dt_site_typography_panel',
	'priority' => 25
) );

	# customize-custom-content-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'customize-custom-content-typo',
		'label'    => esc_html__( 'Customize Custom Content ?', 'jannal' ),
		'section'  => 'dt_site_custom_content_section',
		'default'  => jannal_defaults('customize-custom-content-typo'),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)			
	));
	
	# custom-content-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'typography',
		'settings' => 'custom-content-typo',
		'label'    => esc_html__( 'Custom Content Typography', 'jannal' ),
		'section'  => 'dt_site_custom_content_section',
		'output' => array(
			array( 'element' => 'body, input[type="text"], input[type="password"], input[type="email"], input[type="url"], input[type="tel"], input[type="number"], input[type="range"], input[type="date"], textarea, input.text, input[type="search"], select, textarea' )
		),
		'default' => jannal_defaults( 'custom-content-typo' ),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),		
		'active_callback' => array(
			array( 'setting' => 'customize-custom-content-typo', 'operator' => '==', 'value' => '1' )
		)		
	));		

	# customize-custom-heading-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'customize-custom-heading-typo',
		'label'    => esc_html__( 'Customize Custom Heading ?', 'jannal' ),
		'section'  => 'dt_site_custom_content_section',
		'default'  => jannal_defaults('customize-custom-heading-typo'),
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		)			
	));
	
	# custom-heading-typo
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'typography',
		'settings' => 'custom-heading-typo',
		'label'    => esc_html__( 'Custom Heading Typography', 'jannal' ),
		'section'  => 'dt_site_custom_content_section',
		'output' => array(
			array( 'element' => '.steps-section .dt-sc-icon-box.type3.shadow-ico-box h4, .sec-font, .dtportfolio-sorting a, .comment-metadata' )
		),
		'default' => jannal_defaults( 'custom-heading-typo' ),
		'choices'  => array(
			'variant' => array(
				'100',
				'100italic',
				'200',
				'200italic',
				'300',
				'300italic',
				'regular',
				'italic',
				'500',
				'500italic',
				'600',
				'600italic',
				'700',
				'700italic',
				'800',
				'800italic',
				'900',
				'900italic'
			),
		),		
		'active_callback' => array(
			array( 'setting' => 'customize-custom-heading-typo', 'operator' => '==', 'value' => '1' )
		)		
	));	

# Custom Content Settings


# Footer Typography
	JANNAL_Kirki::add_section( 'dt_footer_typo', array(
		'title'	=> esc_html__( 'Footer', 'jannal' ),
		'panel' => 'dt_site_typography_panel',
		'priority' => 100,
	) );

		# customize-footer-title-typo
		JANNAL_Kirki::add_field( $config, array(
			'type'     => 'switch',
			'settings' => 'customize-footer-title-typo',
			'label'    => esc_html__( 'Customize Title ?', 'jannal' ),
			'section'  => 'dt_footer_typo',
			'default'  => jannal_defaults('customize-footer-title-typo'),
			'choices'  => array(
				'on'  => esc_html__( 'Yes', 'jannal' ),
				'off' => esc_html__( 'No', 'jannal' )
			),
		));

		# footer-title-typo
		JANNAL_Kirki::add_field( $config, array(
			'type'     => 'typography',
			'settings' => 'footer-title-typo',
			'label'    => esc_html__( 'Title Typography', 'jannal' ),
			'section'  => 'dt_footer_typo',
			'output' => array(
				array( 'element' => 'div.footer-widgets h3.widgettitle, #footer h3.widgettitle' )
			),
			'default' => jannal_defaults( 'footer-title-typo' ),
			'active_callback' => array(
				array( 'setting' => 'customize-footer-title-typo', 'operator' => '==', 'value' => '1' )
			)		
		));

		# Divider
		JANNAL_Kirki::add_field( $config ,array(
			'type'=> 'custom',
			'settings' => 'footer-title-typo-divider',
			'section'  => 'dt_footer_typo',
			'default'  => '<div class="customize-control-divider"></div>',
			'active_callback' => array(
				array( 'setting' => 'customize-footer-title-typo', 'operator' => '==', 'value' => '1' )
			)			
		));

		# customize-footer-content-typo
		JANNAL_Kirki::add_field( $config, array(
			'type'     => 'switch',
			'settings' => 'customize-footer-content-typo',
			'label'    => esc_html__( 'Customize Content ?', 'jannal' ),
			'section'  => 'dt_footer_typo',
			'default'  => jannal_defaults('customize-footer-content-typo'),
			'choices'  => array(
				'on'  => esc_html__( 'Yes', 'jannal' ),
				'off' => esc_html__( 'No', 'jannal' )
			),
		));

		# footer-content-typo
		JANNAL_Kirki::add_field( $config, array(
			'type'     => 'typography',
			'settings' => 'footer-content-typo',
			'label'    => esc_html__( 'Content Typography', 'jannal' ),
			'section'  => 'dt_footer_typo',
			'output' => array(
				array( 'element' => '#footer, .footer-copyright, div.footer-widgets .widget' )
			),
			'default' => jannal_defaults( 'footer-content-typo' ),
			'active_callback' => array(
				array( 'setting' => 'customize-footer-content-typo', 'operator' => '==', 'value' => '1' )
			)		
		));

		# footer-content-a-color		
		JANNAL_Kirki::add_field( $config, array(
			'type'     => 'color',
			'settings' => 'footer-content-a-color',
			'label'    => esc_html__( 'Anchor Color', 'jannal' ),
			'section'  => 'dt_footer_typo',
			'choices' => array( 'alpha' => true ),
			'output' => array(
				array( 'element' => '.footer-widgets a, #footer a' )
			),
			'default' => jannal_defaults( 'footer-content-a-color' ),
			'active_callback' => array(
				array( 'setting' => 'customize-footer-content-typo', 'operator' => '==', 'value' => '1' )
			)		
		));

		# footer-content-a-hover-color
		JANNAL_Kirki::add_field( $config, array(
			'type'     => 'color',
			'settings' => 'footer-content-a-hover-color',
			'label'    => esc_html__( 'Anchor Hover Color', 'jannal' ),
			'section'  => 'dt_footer_typo',
			'choices' => array( 'alpha' => true ),			
			'output' => array(
				array( 'element' => '.footer-widgets a:hover, #footer a:hover' )
			),
			'default' => jannal_defaults( 'footer-content-a-hover-color' ),
			'active_callback' => array(
				array( 'setting' => 'customize-footer-content-typo', 'operator' => '==', 'value' => '1' )
			)		
		));