<?php
$config = jannal_kirki_config();

JANNAL_Kirki::add_section( 'dt_site_layout_section', array(
	'title' => esc_html__( 'Site Layout', 'jannal' ),
	'priority' => 20
) );

	# site-layout
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'site-layout',
		'label'    => esc_html__( 'Site Layout', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'default'  => jannal_defaults('site-layout'),
		'choices' => array(
			'boxed' =>  JANNAL_THEME_URI.'/kirki/assets/images/site-layout/boxed.png',
			'wide' => JANNAL_THEME_URI.'/kirki/assets/images/site-layout/wide.png',
		)
	));

	# site-boxed-layout
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'site-boxed-layout',
		'label'    => esc_html__( 'Customize Boxed Layout?', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'default'  => '1',
		'choices'  => array(
			'on'  => esc_html__( 'Yes', 'jannal' ),
			'off' => esc_html__( 'No', 'jannal' )
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
		)			
	));

	# body-bg-type
	JANNAL_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-type',
		'label'    => esc_html__( 'Background Type', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'multiple' => 1,
		'default'  => 'none',
		'choices'  => array(
			'pattern' => esc_html__( 'Predefined Patterns', 'jannal' ),
			'upload' => esc_html__( 'Set Pattern', 'jannal' ),
			'none' => esc_html__( 'None', 'jannal' ),
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-pattern
	JANNAL_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'body-bg-pattern',
		'label'    => esc_html__( 'Predefined Patterns', 'jannal' ),
		'description'    => esc_html__( 'Add Background for body', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'choices' => array(
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg',
			JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg'=> JANNAL_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg',
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'pattern' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)						
	));

	# body-bg-image
	JANNAL_Kirki::add_field( $config, array(
		'type' => 'image',
		'settings' => 'body-bg-image',
		'label'    => esc_html__( 'Background Image', 'jannal' ),
		'description'    => esc_html__( 'Add Background Image for body', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'upload' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-position
	JANNAL_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-position',
		'label'    => esc_html__( 'Background Position', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-position' )
		),
		'default' => 'center',
		'multiple' => 1,
		'choices' => jannal_image_positions(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload') ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-repeat
	JANNAL_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-repeat',
		'label'    => esc_html__( 'Background Repeat', 'jannal' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-repeat' )
		),
		'default' => 'repeat',
		'multiple' => 1,
		'choices' => jannal_image_repeats(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload' ) ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));	