<?php
function jannal_kirki_config() {
	return 'jannal_kirki_config';
}

function jannal_defaults( $key = '' ) {
	$defaults = array();

	# site identify
	$defaults['use-custom-logo'] = '1';
	$defaults['custom-logo'] = JANNAL_THEME_URI.'/images/logo.png';
	$defaults['custom-light-logo'] = JANNAL_THEME_URI.'/images/light-logo.png';
	$defaults['site_icon'] = JANNAL_THEME_URI.'/images/favicon.ico';

	# site layout
	$defaults['site-layout'] = 'wide';

	# site skin
	$defaults['primary-color']      = '#ff0047';
	$defaults['secondary-color']    = '#b90134';
	$defaults['tertiary-color']     = '#ffcddb';
	$defaults['body-bg-color']      = '#ffffff';
	$defaults['body-content-color'] = '#484848';
	$defaults['body-a-color']       = '#ff0047';
	$defaults['body-a-hover-color'] = '#484848';

	# site breadcrumb
	$defaults['customize-breadcrumb-title-typo'] = '1';
	$defaults['breadcrumb-title-typo'] = array( 'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '',
		'line-height' => '',
		'letter-spacing' => '0.01em',
		'color' => '#ffffff',
		'text-align' => 'unset',
		'text-transform' => 'none' );

	$defaults['customize-breadcrumb-typo'] = '0';
	$defaults['breadcrumb-typo'] = array( 'font-family' => 'Roboto, sans-serif',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '17px',
		'line-height' => '',
		'letter-spacing' => '0.01em',
		'color' => '#ffffff',
		'text-align' => 'unset',
		'text-transform' => 'none' );

	# custom content
	$defaults['customize-custom-content-typo'] = '0';
	$defaults['custom-content-typo'] = array( 'font-family' => 'Roboto, sans-serif' );
	$defaults['customize-custom-heading-typo'] = '1';
	$defaults['custom-heading-typo'] = array( 'font-family' => 'FuturaStd Medium, sans-serif' );

	# site footer
	$defaults['customize-footer-title-typo'] = '1';
	$defaults['footer-title-typo'] = array( 'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '30px',
		'line-height' => '36px',
		'letter-spacing' => '0.01em',
		'color' => '#000000',
		'text-align' => 'left',
		'text-transform' => 'none' );

	$defaults['customize-footer-content-typo'] = '1';
	$defaults['footer-content-typo'] = array( 'font-family' => 'Roboto, sans-serif',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '17px',
		'line-height' => '30px',
		'letter-spacing' => '0.01em',
		'color' => '#484848',
		'text-align' => 'left',
		'text-transform' => 'none' );

	# site typography
	$defaults['customize-body-h1-typo'] = '1';
	$defaults['h1'] = array(
		'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'font-size' => '46px',
		'line-height' => '',
		'letter-spacing' => '0.025em',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['customize-body-h2-typo'] = '1';
	$defaults['h2'] = array(
		'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'font-size' => '44px',
		'line-height' => '',
		'letter-spacing' => '0.025em',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['customize-body-h3-typo'] = '1';
	$defaults['h3'] = array(
		'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'font-size' => '36px',
		'line-height' => '',
		'letter-spacing' => '0.025em',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['customize-body-h4-typo'] = '1';
	$defaults['h4'] = array(
		'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'font-size' => '30px',
		'line-height' => '',
		'letter-spacing' => '0.025em',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['customize-body-h5-typo'] = '1';
	$defaults['h5'] = array(
		'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'font-size' => '24px',
		'line-height' => '',
		'letter-spacing' => '0.025em',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['customize-body-h6-typo'] = '1';
	$defaults['h6'] = array(
		'font-family' => 'FuturaStd Heavy, sans-serif',
		'variant' => 'regular',
		'font-size' => '20px',
		'line-height' => '',
		'letter-spacing' => '0.025em',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['customize-body-content-typo'] = '1';
	$defaults['body-content-typo'] = array(
		'font-family' => 'Roboto, sans-serif',
		'variant' => 'regular',
		'font-size' => '17px',
		'line-height' => '30px',
		'letter-spacing' => '0.01em',
		'color' => '#484848',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	if( !empty( $key ) && array_key_exists( $key, $defaults) ) {
		return $defaults[$key];
	}

	return '';
}

function jannal_image_positions() {
	$positions = array( "top left" => esc_html__('Top Left','jannal'),
		"top center"    => esc_html__('Top Center','jannal'),
		"top right"     => esc_html__('Top Right','jannal'),
		"center left"   => esc_html__('Center Left','jannal'),
		"center center" => esc_html__('Center Center','jannal'),
		"center right"  => esc_html__('Center Right','jannal'),
		"bottom left"   => esc_html__('Bottom Left','jannal'),
		"bottom center" => esc_html__('Bottom Center','jannal'),
		"bottom right"  => esc_html__('Bottom Right','jannal'),
	);

	return $positions;
}


function jannal_image_repeats() {
	$image_repeats = array( "repeat" => esc_html__('Repeat','jannal'),
		"repeat-x"  => esc_html__('Repeat in X-axis','jannal'),
		"repeat-y"  => esc_html__('Repeat in Y-axis','jannal'),
		"no-repeat" => esc_html__('No Repeat','jannal')
	);

	return $image_repeats;
}

function jannal_border_styles() {
	$image_repeats = array(
		"none"	 => esc_html__('None','jannal'),
		"dotted" => esc_html__('Dotted','jannal'),
		"dashed" => esc_html__('Dashed','jannal'),
		"solid"	 => esc_html__('Solid','jannal'),
		"double" => esc_html__('Double','jannal'),
		"groove" => esc_html__('Groove','jannal'),
		"ridge"	 => esc_html__('Ridge','jannal'),
	);

	return $image_repeats;
}

function jannal_animations() {
	$animations = array(
		''                   => esc_html__('Default','jannal'),	
		"bigEntrance"        =>  esc_html__("bigEntrance",'jannal'),
		"bounce"             =>  esc_html__("bounce",'jannal'),
		"bounceIn"           =>  esc_html__("bounceIn",'jannal'),
		"bounceInDown"       =>  esc_html__("bounceInDown",'jannal'),
		"bounceInLeft"       =>  esc_html__("bounceInLeft",'jannal'),
		"bounceInRight"      =>  esc_html__("bounceInRight",'jannal'),
		"bounceInUp"         =>  esc_html__("bounceInUp",'jannal'),
		"bounceOut"          =>  esc_html__("bounceOut",'jannal'),
		"bounceOutDown"      =>  esc_html__("bounceOutDown",'jannal'),
		"bounceOutLeft"      =>  esc_html__("bounceOutLeft",'jannal'),
		"bounceOutRight"     =>  esc_html__("bounceOutRight",'jannal'),
		"bounceOutUp"        =>  esc_html__("bounceOutUp",'jannal'),
		"expandOpen"         =>  esc_html__("expandOpen",'jannal'),
		"expandUp"           =>  esc_html__("expandUp",'jannal'),
		"fadeIn"             =>  esc_html__("fadeIn",'jannal'),
		"fadeInDown"         =>  esc_html__("fadeInDown",'jannal'),
		"fadeInDownBig"      =>  esc_html__("fadeInDownBig",'jannal'),
		"fadeInLeft"         =>  esc_html__("fadeInLeft",'jannal'),
		"fadeInLeftBig"      =>  esc_html__("fadeInLeftBig",'jannal'),
		"fadeInRight"        =>  esc_html__("fadeInRight",'jannal'),
		"fadeInRightBig"     =>  esc_html__("fadeInRightBig",'jannal'),
		"fadeInUp"           =>  esc_html__("fadeInUp",'jannal'),
		"fadeInUpBig"        =>  esc_html__("fadeInUpBig",'jannal'),
		"fadeOut"            =>  esc_html__("fadeOut",'jannal'),
		"fadeOutDownBig"     =>  esc_html__("fadeOutDownBig",'jannal'),
		"fadeOutLeft"        =>  esc_html__("fadeOutLeft",'jannal'),
		"fadeOutLeftBig"     =>  esc_html__("fadeOutLeftBig",'jannal'),
		"fadeOutRight"       =>  esc_html__("fadeOutRight",'jannal'),
		"fadeOutUp"          =>  esc_html__("fadeOutUp",'jannal'),
		"fadeOutUpBig"       =>  esc_html__("fadeOutUpBig",'jannal'),
		"flash"              =>  esc_html__("flash",'jannal'),
		"flip"               =>  esc_html__("flip",'jannal'),
		"flipInX"            =>  esc_html__("flipInX",'jannal'),
		"flipInY"            =>  esc_html__("flipInY",'jannal'),
		"flipOutX"           =>  esc_html__("flipOutX",'jannal'),
		"flipOutY"           =>  esc_html__("flipOutY",'jannal'),
		"floating"           =>  esc_html__("floating",'jannal'),
		"hatch"              =>  esc_html__("hatch",'jannal'),
		"hinge"              =>  esc_html__("hinge",'jannal'),
		"lightSpeedIn"       =>  esc_html__("lightSpeedIn",'jannal'),
		"lightSpeedOut"      =>  esc_html__("lightSpeedOut",'jannal'),
		"pullDown"           =>  esc_html__("pullDown",'jannal'),
		"pullUp"             =>  esc_html__("pullUp",'jannal'),
		"pulse"              =>  esc_html__("pulse",'jannal'),
		"rollIn"             =>  esc_html__("rollIn",'jannal'),
		"rollOut"            =>  esc_html__("rollOut",'jannal'),
		"rotateIn"           =>  esc_html__("rotateIn",'jannal'),
		"rotateInDownLeft"   =>  esc_html__("rotateInDownLeft",'jannal'),
		"rotateInDownRight"  =>  esc_html__("rotateInDownRight",'jannal'),
		"rotateInUpLeft"     =>  esc_html__("rotateInUpLeft",'jannal'),
		"rotateInUpRight"    =>  esc_html__("rotateInUpRight",'jannal'),
		"rotateOut"          =>  esc_html__("rotateOut",'jannal'),
		"rotateOutDownRight" =>  esc_html__("rotateOutDownRight",'jannal'),
		"rotateOutUpLeft"    =>  esc_html__("rotateOutUpLeft",'jannal'),
		"rotateOutUpRight"   =>  esc_html__("rotateOutUpRight",'jannal'),
		"shake"              =>  esc_html__("shake",'jannal'),
		"slideDown"          =>  esc_html__("slideDown",'jannal'),
		"slideExpandUp"      =>  esc_html__("slideExpandUp",'jannal'),
		"slideLeft"          =>  esc_html__("slideLeft",'jannal'),
		"slideRight"         =>  esc_html__("slideRight",'jannal'),
		"slideUp"            =>  esc_html__("slideUp",'jannal'),
		"stretchLeft"        =>  esc_html__("stretchLeft",'jannal'),
		"stretchRight"       =>  esc_html__("stretchRight",'jannal'),
		"swing"              =>  esc_html__("swing",'jannal'),
		"tada"               =>  esc_html__("tada",'jannal'),
		"tossing"            =>  esc_html__("tossing",'jannal'),
		"wobble"             =>  esc_html__("wobble",'jannal'),
		"fadeOutDown"        =>  esc_html__("fadeOutDown",'jannal'),
		"fadeOutRightBig"    =>  esc_html__("fadeOutRightBig",'jannal'),
		"rotateOutDownLeft"  =>  esc_html__("rotateOutDownLeft",'jannal')
    );

	return $animations;
}

function jannal_custom_fonts( $standard_fonts ){
	$custom_fonts = array();
	$fonts = cs_get_option('custom_font_fields',array());

	if( count( $fonts ) > 0 ):
		foreach( $fonts as $font ):
			$custom_fonts[$font['custom_font_name']] = array(
				'label' => $font['custom_font_name'],
				'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
				'stack' => $font['custom_font_name'] . ', sans-serif'
			);
		endforeach;
	endif;

	return array_merge_recursive( $custom_fonts, $standard_fonts );
}

add_filter( 'kirki/fonts/standard_fonts', 'jannal_custom_fonts', 20 );