<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// -----------------------------------------
// Layer Sliders
// -----------------------------------------
function jannal_layersliders() {
  $layerslider = array(  esc_html__('Select a slider','jannal') );

  if( class_exists( 'LS_Sliders' ) ) {

    $sliders = LS_Sliders::find(array('limit' => 50));

    if(!empty($sliders)) {
      foreach($sliders as $key => $item){
        $layerslider[ $item['id'] ] = $item['name'];
      }
    }
  }

  return $layerslider;
}

// -----------------------------------------
// Revolution Sliders
// -----------------------------------------
function jannal_revolutionsliders() {
  $revolutionslider = array( '' => esc_html__('Select a slider','jannal') );

  if(class_exists( 'RevSlider' )) {
    $sld = new RevSlider();
    $sliders = $sld->getArrSliders();
    if(!empty($sliders)){
      foreach($sliders as $key => $item) {
        $revolutionslider[$item->getAlias()] = $item->getTitle();
      }
    }    
  }

  return $revolutionslider;  
}

// -----------------------------------------
// Meta Layout Section
// -----------------------------------------
$meta_layout_section =array(
  'name'  => 'layout_section',
  'title' => esc_html__('Layout', 'jannal'),
  'icon'  => 'fa fa-columns',
  'fields' =>  array(
    array(
      'id'  => 'layout',
      'type' => 'image_select',
      'title' => esc_html__('Page Layout', 'jannal' ),
      'options'      => array(
          'global-site-layout' 	 => JANNAL_THEME_URI . '/cs-framework-override/images/admin-option.png',
          'content-full-width'   => JANNAL_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
          'with-left-sidebar'    => JANNAL_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
          'with-right-sidebar'   => JANNAL_THEME_URI . '/cs-framework-override/images/right-sidebar.png'
      ),
      'default'      => 'global-site-layout',
      'attributes'   => array( 'data-depend-id' => 'page-layout' )
    ),
    array(
      'id'        => 'show-standard-sidebar-left',
      'type'      => 'switcher',
      'title'     => esc_html__('Show Standard Left Sidebar', 'jannal' ),
      'dependency'  => array( 'page-layout', 'any', 'with-left-sidebar' ),
      'default'	  => true,
    ),
    array(
      'id'        => 'widget-area-left',
      'type'      => 'select',
      'title'     => esc_html__('Choose Left Widget Areas', 'jannal' ),
      'class'     => 'chosen',
      'options'   => jannal_custom_widgets(),
      'attributes'  => array( 
        'multiple'  => 'multiple',
        'data-placeholder' => esc_attr__('Select Left Widget Areas','jannal'),
        'style' => 'width: 400px;'
      ),
      'dependency'  => array( 'page-layout', 'any', 'with-left-sidebar' ),
    ),
    array(
      'id'          => 'show-standard-sidebar-right',
      'type'        => 'switcher',
      'title'       => esc_html__('Show Standard Right Sidebar', 'jannal' ),
      'dependency'  => array( 'page-layout', 'any', 'with-right-sidebar' ),
      'default'	  => true,
    ),
    array(
      'id'        => 'widget-area-right',
      'type'      => 'select',
      'title'     => esc_html__('Choose Right Widget Areas', 'jannal' ),
      'class'     => 'chosen',
      'options'   => jannal_custom_widgets(),
      'attributes'    => array( 
        'multiple' => 'multiple',
        'data-placeholder' => esc_attr__('Select Right Widget Areas','jannal'),
        'style' => 'width: 400px;'
      ),
      'dependency'  => array( 'page-layout', 'any', 'with-right-sidebar' ),
    )
  )
);

// -----------------------------------------
// Meta Breadcrumb Section
// -----------------------------------------
$meta_breadcrumb_section = array(
  'name'  => 'breadcrumb_section',
  'title' => esc_html__('Breadcrumb', 'jannal'),
  'icon'  => 'fa fa-sitemap',
  'fields' =>  array(
    array(
      'id'      => 'enable-sub-title',
      'type'    => 'switcher',
      'title'   => esc_html__('Show Breadcrumb', 'jannal' ),
      'default' => true
    ),
    array(
    	'id'                 => 'breadcrumb_position',
	'type'               => 'select',
      'title'              => esc_html__('Position', 'jannal' ),
      'options'            => array(
        'header-top-absolute'    => esc_html__('Behind the Header','jannal'),
        'header-top-relative' 	   => esc_html__('Default','jannal'),
		),
		'default'            => 'header-top-relative',	
      'dependency'         => array( 'enable-sub-title', '==', 'true' ),
    ),    
    array(
      'id'    => 'breadcrumb_background',
      'type'  => 'background',
      'title' => esc_html__('Background', 'jannal' ),
      'dependency'   => array( 'enable-sub-title', '==', 'true' ),
    ),
  )
);

// -----------------------------------------
// Meta Slider Section
// -----------------------------------------
$meta_slider_section = array(
  'name'  => 'slider_section',
  'title' => esc_html__('Slider', 'jannal'),
  'icon'  => 'fab fa-slideshare',
  'fields' =>  array(
    array(
      'id'           => 'slider-notice',
      'type'         => 'notice',
      'class'        => 'danger',
      'content'      => esc_html__('Slider tab works only if breadcrumb disabled.','jannal'),
      'class'        => 'margin-30 cs-danger',
      'dependency'   => array( 'enable-sub-title', '==', 'true' ),
    ),

    array(
      'id'           => 'show_slider',
      'type'         => 'switcher',
      'title'        => esc_html__('Show Slider', 'jannal' ),
      'dependency'   => array( 'enable-sub-title', '==', 'false' ),
    ),
    array(
    	'id'                 => 'slider_position',
	'type'               => 'select',
	'title'              => esc_html__('Position', 'jannal' ),
	'options'            => array(
		'header-top-relative'     => esc_html__('Top Header Relative','jannal'),
		'header-top-absolute'    => esc_html__('Top Header Absolute','jannal'),
		'bottom-header' 	   => esc_html__('Bottom Header','jannal'),
	),
	'default'            => 'bottom-header',
	'dependency'         => array( 'enable-sub-title|show_slider', '==|==', 'false|true' ),
   ),
   array(
      'id'                 => 'slider_type',
      'type'               => 'select',
      'title'              => esc_html__('Slider', 'jannal' ),
      'options'            => array(
        ''                 => esc_html__('Select a slider','jannal'),
        'layerslider'      => esc_html__('Layer slider','jannal'),
        'revolutionslider' => esc_html__('Revolution slider','jannal'),
        'customslider'     => esc_html__('Custom Slider Shortcode','jannal'),
      ),
      'validate' => 'required',
      'dependency'         => array( 'enable-sub-title|show_slider', '==|==', 'false|true' ),
    ),

    array(
      'id'          => 'layerslider_id',
      'type'        => 'select',
      'title'       => esc_html__('Layer Slider', 'jannal' ),
      'options'     => jannal_layersliders(),
      'validate'    => 'required',
      'dependency'  => array( 'enable-sub-title|show_slider|slider_type', '==|==|==', 'false|true|layerslider' )
    ),

    array(
      'id'          => 'revolutionslider_id',
      'type'        => 'select',
      'title'       => esc_html__('Revolution Slider', 'jannal' ),
      'options'     => jannal_revolutionsliders(),
      'validate'    => 'required',
      'dependency'  => array( 'enable-sub-title|show_slider|slider_type', '==|==|==', 'false|true|revolutionslider' )
    ),

    array(
      'id'          => 'customslider_sc',
      'type'        => 'textarea',
      'title'       => esc_html__('Custom Slider Code', 'jannal' ),
      'validate'    => 'required',
      'dependency'  => array( 'enable-sub-title|show_slider|slider_type', '==|==|==', 'false|true|customslider' )
    ),
  )  
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options = array();

// -----------------------------------------
// Page Metabox Options                    -
// -----------------------------------------
array_push( $meta_layout_section['fields'], array(
  'id'        => 'enable-sticky-sidebar',
  'type'      => 'switcher',
  'title'     => esc_html__('Enable Sticky Sidebar', 'jannal' ),
  'dependency'  => array( 'page-layout', 'any', 'with-left-sidebar,with-right-sidebar' )
) );

$page_settings = array(
  $meta_layout_section,
  $meta_breadcrumb_section,
  $meta_slider_section,
  array(
    'name'   => 'sidenav_template_section',
    'title'  => esc_html__('Side Navigation Template', 'jannal'),
    'icon'   => 'fa fa-th-list',
    'fields' =>  array(
      array(
        'id'      => 'sidenav-tpl-notice',
        'type'    => 'notice',
        'class'   => 'success',
        'content' => esc_html__('Side Navigation Tab Works only if page template set to Side Navigation Template in Page Attributes','jannal'),
        'class'   => 'margin-30 cs-success',      
      ),
      array(
        'id'      => 'sidenav-style',
        'type'    => 'select',
        'title'   => esc_html__('Side Navigation Style', 'jannal' ),
        'options' => array(
          'type1'  => esc_html__('Type1','jannal'),
          'type2'  => esc_html__('Type2','jannal'),
          'type3'  => esc_html__('Type3','jannal'),
          'type4'  => esc_html__('Type4','jannal'),
          'type5'  => esc_html__('Type5','jannal')
        ),
      ),
      array(
        'id'    => 'sidenav-align',
        'type'  => 'switcher',
        'title' => esc_html__('Align Right', 'jannal' ),
        'info'  => esc_html__('YES! to align right of side navigation.','jannal')
      ),
      array(
        'id'    => 'sidenav-sticky',
        'type'  => 'switcher',
        'title' => esc_html__('Sticky Side Navigation', 'jannal' ),
        'info'  => esc_html__('YES! to sticky side navigation content.','jannal')
      ),
      array(
        'id'    => 'enable-sidenav-content',
        'type'  => 'switcher',
        'title' => esc_html__('Show Content', 'jannal' ),
        'info'  => esc_html__('YES! to show content in below side navigation.','jannal')
      ),
      array(
        'id'         => 'sidenav-content',
        'type'       => 'textarea',
        'title'      => esc_html__('Side Navigation Content', 'jannal' ),
        'info'       => esc_html__('Paste any shortcode content here','jannal'),
        'attributes' => array( 'rows' => 6 ),
      ),
    )
  ),  
);

$shop_page_id = get_option('woocommerce_shop_page_id');

if( isset( $_GET['post'] ) && ( $_GET['post'] != $shop_page_id ) || !isset( $_GET['post'] )  ) {	
  $options[] = array(
    'id'        => '_tpl_default_settings',
    'title'     => esc_html__('Page Settings','jannal'),
    'post_type' => 'page',
    'context'   => 'normal',
    'priority'  => 'high',
    'sections'  => $page_settings
  );

}

// -----------------------------------------
// Post Metabox Options                    -
// -----------------------------------------
$post_meta_layout_section = $meta_layout_section;
$fields = $post_meta_layout_section['fields'];

	$fields[0]['title'] =  esc_html__('Post Layout', 'jannal' );
	#unset( $fields[0]['options']['with-both-sidebar'] );
	#unset( $fields[0]['info'] );
	#unset( $fields[0]['options']['fullwidth'] );
	unset( $fields[5] );
	unset( $post_meta_layout_section['fields'] );
	$post_meta_layout_section['fields']  = $fields;  

	$post_format_section = array(
		'name'  => 'post_format_data_section',
		'title' => esc_html__('Post Format', 'jannal'),
		'icon'  => 'fa fa-cog',
		'fields' =>  array(

			array(
				'id'           => 'single-post-style',
				'type'         => 'select',
				'title'        => esc_html__('Post Style', 'jannal'),
				'options'      => array(
				  'breadcrumb-fixed'    => esc_html__('Breadcrumb Fixed', 'jannal'),
				  'breadcrumb-parallax' => esc_html__('Breadcrumb Parallax', 'jannal'),
				  'overlay'				         => esc_html__('Overlay', 'jannal'),
				  'overlap' 		          => esc_html__('Overlap', 'jannal'),
				  'custom' 		    	      => esc_html__('Custom', 'jannal')
				),
				'class'        => 'chosen',
				'default'      => 'overlap',
				'info'         => esc_html__('Choose post style to display single post. If post style is "Custom", display based on Editor content.', 'jannal')
			),

			array(
				'id'           => 'single-custom-style',
				'type'         => 'select',
				'title'        => esc_html__('Custom Style', 'jannal'),
				'options'      => array(
				  'minimal'     => esc_html__('Minimal', 'jannal'),
				  'classic' 	=> esc_html__('Classic', 'jannal'),
				  'modern'		=> esc_html__('Modern', 'jannal'),
				),
				'class'        => 'chosen',
				'default'      => 'minimal',
				'info'         => esc_html__('Select type of custom style.', 'jannal'),
				'dependency'   => array( 'single-post-style', '==', 'custom' ),
			),

			array(
			    'id'           => 'view_count',
			    'type'         => 'number',
			    'title'        => esc_html__('Views', 'jannal' ),
				'info'         => esc_html__('No.of views of this post.', 'jannal'),
	          	'attributes' => array(
		           'style'    => 'width: 15%;'
        	    ),
			),

			array(
			    'id'           => 'like_count',
			    'type'         => 'number',
			    'title'        => esc_html__('Likes', 'jannal' ),
				'info'         => esc_html__('No.of likes of this post.', 'jannal'),
	          	'attributes' => array(
		           'style'    => 'width: 15%;'
        	    ),
			),

			array(
				'id' => 'post-format-type',
				'title'   => esc_html__('Type', 'jannal' ),
				'type' => 'select',
				'default' => 'standard',
				'options' => array(
					'standard'  => esc_html__('Standard', 'jannal'),
					'status'	=> esc_html__('Status','jannal'),
					'quote'		=> esc_html__('Quote','jannal'),
					'gallery'	=> esc_html__('Gallery','jannal'),
					'image'		=> esc_html__('Image','jannal'),
					'video'		=> esc_html__('Video','jannal'),
					'audio'		=> esc_html__('Audio','jannal'),
					'link'		=> esc_html__('Link','jannal'),
					'aside'		=> esc_html__('Aside','jannal'),
					'chat'		=> esc_html__('Chat','jannal')
				),
				'info'         => esc_html__('Post Format & Type should be Same. Check the Post Format from the "Format" Tab, which comes in the Right Side Section', 'jannal'),
			),

			array(
				'id' 	  => 'post-gallery-items',
				'type'	  => 'gallery',
				'title'   => esc_html__('Add Images', 'jannal' ),
				'add_title'   => esc_html__('Add Images', 'jannal' ),
				'edit_title'  => esc_html__('Edit Images', 'jannal' ),
				'clear_title' => esc_html__('Remove Images', 'jannal' ),
				'dependency' => array( 'post-format-type', '==', 'gallery' ),
			),

			array(
				'id' 	  => 'media-type',
				'type'	  => 'select',
				'title'   => esc_html__('Select Type', 'jannal' ),
				'dependency' => array( 'post-format-type', 'any', 'video,audio' ),
		      	'options'	=> array(
					'oembed' => esc_html__('Oembed','jannal'),
					'self' => esc_html__('Self Hosted','jannal'),
				)
			),

			array(
				'id' 	  => 'media-url',
				'type'	  => 'textarea',
				'title'   => esc_html__('Media URL', 'jannal' ),
				'dependency' => array( 'post-format-type', 'any', 'video,audio' ),
			),
		)
	);

	$options[] = array(
		'id'        => '_dt_post_settings',
		'title'     => esc_html__('Post Settings','jannal'),
		'post_type' => 'post',
		'context'   => 'normal',
		'priority'  => 'high',
		'sections'  => array(
			$post_meta_layout_section,
			$meta_breadcrumb_section,
			$post_format_section			
		)
	);

// -----------------------------------------
// Tribe Events Post Metabox Options
// -----------------------------------------
  array_push( $post_meta_layout_section['fields'], array(
    'id' => 'event-post-style',
    'title'   => esc_html__('Post Style', 'jannal' ),
    'type' => 'select',
    'default' => 'type1',
    'options' => array(
      'type1'  => esc_html__('Classic', 'jannal'),
      'type2'  => esc_html__('Full Width','jannal'),
      'type3'  => esc_html__('Minimal Tab','jannal'),
      'type4'  => esc_html__('Clean','jannal'),
      'type5'  => esc_html__('Modern','jannal'),
    ),
	'class'    => 'chosen',
	'info'     => esc_html__('Your event post page show at most selected style.', 'jannal')
  ) );

  $options[] = array(
    'id'        => '_custom_settings',
    'title'     => esc_html__('Settings','jannal'),
    'post_type' => 'tribe_events',
    'context'   => 'normal',
    'priority'  => 'high',
    'sections'  => array(
      $post_meta_layout_section,
      $meta_breadcrumb_section
    )
  );

  if( function_exists( 'is_woocommerce' ) ) {

    $woo_size_guides = cs_get_option( 'dt-woo-size-guides' );
    $woo_size_guides = (is_array($woo_size_guides) && !empty($woo_size_guides)) ? $woo_size_guides : false;
  
    $size_guides[] = esc_html__('None', 'jannal');
    if($woo_size_guides) {
      foreach($woo_size_guides as $woo_size_guide_key => $woo_size_guide) {
        $size_guides[$woo_size_guide_key] = $woo_size_guide['title'];
      }
    }
    
    $product_meta_layout_section = array(
      'name'   => 'general_section',
      'title'  => esc_html__('General', 'jannal'),
      'icon'   => 'fa fa-angle-double-right',
      'fields' =>  array(
          array(
              'id'         => 'page-layout',
              'type'       => 'image_select',
              'title'      => esc_html__('Page Layout', 'jannal'),
              'options'    => array(
                  'admin-option'       => JANNAL_THEME_URI . '/cs-framework-override/images/admin-option.png',
                  'content-full-width' => JANNAL_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
                  'with-left-sidebar'  => JANNAL_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
                  'with-right-sidebar' => JANNAL_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
              ),
              'default'    => 'admin-option',
              'attributes' => array( 'data-depend-id' => 'page-layout' )
          ),
          array(
              'id'         => 'show-standard-sidebar',
              'type'       => 'switcher',
              'title'      => esc_html__('Show Product Standard Sidebar', 'jannal'),
              'dependency' => array( 'page-layout', 'any', 'with-left-sidebar,with-right-sidebar' )
          ),
          array(
              'id'         => 'product-widgetareas',
              'type'       => 'select',
              'title'      => esc_html__('Choose Custom Widget Area', 'jannal'),
              'class'      => 'chosen',
              'options'    => jannal_custom_widgets(),
              'dependency' => array( 'page-layout', 'any', 'with-left-sidebar,with-right-sidebar' ),
              'attributes' => array(
                  'multiple'         => 'multiple',
                  'data-placeholder' => esc_attr__('Select Widget Areas', 'jannal'),
                  'style'            => 'width: 400px;'
              ),
          ),
  
          # Product Template
          array(
              'id'      => 'product-template',
              'type'    => 'select',
              'title'   => esc_html__('Product Template', 'jannal'),
              'class'   => 'chosen',
              'options' => array(
                  'admin-option'    => esc_html__( 'Admin Option', 'jannal' ),
                  'woo-default'     => esc_html__( 'WooCommerce Default', 'jannal' ),
                  'custom-template' => esc_html__( 'Custom Template', 'jannal' )
              ),
              'default'    => 'admin-option',
              'info'       => esc_html__('Don\'t use product shortcodes in content area when "WooCommerce Default" template is chosen.', 'jannal')
          ),
                 
          array(
              'id'         => 'show-upsell',
              'type'       => 'select',
              'title'      => esc_html__('Show Upsell Products', 'jannal'),
              'class'      => 'chosen',
              'default'    => 'admin-option',
              'attributes' => array( 'data-depend-id' => 'show-upsell' ),
              'options'    => array(
                  'admin-option' => esc_html__( 'Admin Option', 'jannal' ),
                  'true'         => esc_html__( 'Show', 'jannal'),
                  null           => esc_html__( 'Hide', 'jannal'),
              ),
              'dependency' => array( 'product-template', '!=', 'custom-template')
          ),
          array(
              'id'         => 'upsell-column',
              'type'       => 'select',
              'title'      => esc_html__('Choose Upsell Column', 'jannal'),
              'class'      => 'chosen',
              'default'    => 4,
              'options'    => array(
                  'admin-option' => esc_html__( 'Admin Option', 'jannal' ),
                  1              => esc_html__( 'One Column', 'jannal' ),
                  2              => esc_html__( 'Two Columns', 'jannal' ),
                  3              => esc_html__( 'Three Columns', 'jannal' ),
                  4              => esc_html__( 'Four Columns', 'jannal' ),
              ),
              'dependency' => array( 'product-template|show-upsell', '!=|==', 'custom-template|true')
          ),
          array(
              'id'         => 'upsell-limit',
              'type'       => 'select',
              'title'      => esc_html__('Choose Upsell Limit', 'jannal'),
              'class'      => 'chosen',
              'default'    => 4,
              'options'    => array(
                  'admin-option' => esc_html__( 'Admin Option', 'jannal' ),
                  1              => esc_html__( 'One', 'jannal' ),
                  2              => esc_html__( 'Two', 'jannal' ),
                  3              => esc_html__( 'Three', 'jannal' ),
                  4              => esc_html__( 'Four', 'jannal' ),
                  5              => esc_html__( 'Five', 'jannal' ),
                  6              => esc_html__( 'Six', 'jannal' ),
                  7              => esc_html__( 'Seven', 'jannal' ),
                  8              => esc_html__( 'Eight', 'jannal' ),
                  9              => esc_html__( 'Nine', 'jannal' ),
                  10              => esc_html__( 'Ten', 'jannal' ),                                                
              ),
              'dependency' => array( 'product-template|show-upsell', '!=|==', 'custom-template|true')
          ),        
          array(
              'id'         => 'show-related',
              'type'       => 'select',
              'title'      => esc_html__('Show Related Products', 'jannal'),
              'class'      => 'chosen',
              'default'    => 'admin-option',
              'attributes' => array( 'data-depend-id' => 'show-related' ),
              'options'    => array(
                  'admin-option' => esc_html__( 'Admin Option', 'jannal' ),
                  'true'         => esc_html__( 'Show', 'jannal'),
                  null           => esc_html__( 'Hide', 'jannal'),
              ),
              'dependency' => array( 'product-template', '!=', 'custom-template')
          ),
          array(
              'id'         => 'related-column',
              'type'       => 'select',
              'title'      => esc_html__('Choose Related Column', 'jannal'),
              'class'      => 'chosen',
              'default'    => 4,
              'options'    => array(
                  'admin-option' => esc_html__( 'Admin Option', 'jannal' ),
                  2              => esc_html__( 'Two Columns', 'jannal' ),
                  3              => esc_html__( 'Three Columns', 'jannal' ),
                  4              => esc_html__( 'Four Columns', 'jannal' ),
              ),
              'dependency' => array( 'product-template|show-related', '!=|==', 'custom-template|true')
          ),
          array(
              'id'         => 'related-limit',
              'type'       => 'select',
              'title'      => esc_html__('Choose Related Limit', 'jannal'),
              'class'      => 'chosen',
              'default'    => 4,
              'options'    => array(
                  'admin-option' => esc_html__( 'Admin Option', 'jannal' ),
                  1              => esc_html__( 'One', 'jannal' ),
                  2              => esc_html__( 'Two', 'jannal' ),
                  3              => esc_html__( 'Three', 'jannal' ),
                  4              => esc_html__( 'Four', 'jannal' ),
                  5              => esc_html__( 'Five', 'jannal' ),
                  6              => esc_html__( 'Six', 'jannal' ),
                  7              => esc_html__( 'Seven', 'jannal' ),
                  8              => esc_html__( 'Eight', 'jannal' ),
                  9              => esc_html__( 'Nine', 'jannal' ),
                  10              => esc_html__( 'Ten', 'jannal' ),                                                
              ),
              'dependency' => array( 'product-template|show-related', '!=|==', 'custom-template|true')
          ),
  
          # Product Additional Tabs
          array(
            'id'              => 'product-additional-tabs',
            'type'            => 'group',
            'title'           => esc_html__('Additional Tabs', 'jannal'),
            'info'            => esc_html__('Click button to add title and description.', 'jannal'),
            'button_title'    => esc_html__('Add New Tab', 'jannal'),
            'accordion_title' => esc_html__('Adding New Tab Field', 'jannal'),
            'fields'          => array(
              array(
              'id'          => 'tab_title',
              'type'        => 'text',
              'title'       => esc_html__('Title', 'jannal'),
              ),
  
              array(
              'id'          => 'tab_description',
              'type'        => 'textarea',
              'title'       => esc_html__('Description', 'jannal')
              ),
            )
          ),
  
          # Product New Label
           array(
              'id'         => 'product-new-label',
              'type'       => 'switcher',
              'title'      => esc_html__('Add "New" label', 'jannal'),
          ), 
  
          array(
            'id'         => 'dt-single-product-size-guides',
            'type'       => 'select',
            'title'      => esc_html__('Product Size Guides', 'jannal'),
            'options'    => $size_guides,
            //'info'       => esc_html__('Choose product size guide that defined in admin section.', 'jannal')
          ),              
  
          array(
            'id'          => 'description',
            'type'        => 'textarea',
            'title'       => esc_html__('Description', 'jannal'),
            'info'       => esc_html__('This content will be used in description tab, when "Custom Template" is chosen.', 'jannal')
            ),
  
      )
    );
  
    $options[] = array(
      'id'        => '_custom_settings',
      'title'     => esc_html__('Product Settings','jannal'),
      'post_type' => 'product',
      'context'   => 'normal',
      'priority'  => 'high',
      'sections'  => array(
        $product_meta_layout_section
      )
    );
  
    $options[] = array(
      'id'        => '_360viewer_gallery',
      'title'     => esc_html__('Product 360 View Gallery','jannal'),
      'post_type' => 'product',
      'context'   => 'side',
      'priority'  => 'low',
      'sections'  => array(
                      array(
                      'name'   => '360view_section',
                      'fields' =>  array(
                                      array (
                                        'id'          => 'product-360view-gallery',
                                        'type'        => 'gallery',
                                        'title'       => esc_html__('Gallery Images', 'jannal'),
                                        'desc'        => esc_html__('Simply add images to gallery items.', 'jannal'),
                                        'add_title'   => esc_html__('Add Images', 'jannal'),
                                        'edit_title'  => esc_html__('Edit Images', 'jannal'),
                                        'clear_title' => esc_html__('Remove Images', 'jannal'),
                                      )
                                  )
                      )
                    )
      );
  
  
  }
  
// -----------------------------------------
// Header And Footer Options Metabox
// -----------------------------------------
$post_types = apply_filters( 'jannal_header_footer_default_cpt' , array ( 'post', 'page', 'product' )  );
$options[] = array(
	'id'	=> '_dt_custom_settings',
	'title'	=> esc_html__('Header & Footer','jannal'),
	'post_type' => $post_types,
	'priority'  => 'high',
	'context'   => 'side', 
	'sections'  => array(
	
		# Header Settings
		array(
			'name'  => 'header_section',
			'title' => esc_html__('Header', 'jannal'),
			'icon'  => 'fa fa-angle-double-right',
			'fields' =>  array(
			
				# Header Show / Hide
				array(
					'id'		=> 'show-header',
					'type'		=> 'switcher',
					'title'		=> esc_html__('Show Header', 'jannal'),
					'default'	=>  true,
				),
				
				# Header
				array(
					'id'  		 => 'header',
					'type'  	 => 'select',
					'title' 	 => esc_html__('Choose Header', 'jannal'),
					'class'		 => 'chosen',
					'options'	 => 'posts',
					'query_args' => array(
						'post_type'	 => 'dt_headers',
						'orderby'	 => 'ID',
						'order'		 => 'ASC',
						'posts_per_page' => -1,
					),
					'default_option' => esc_attr__('Select Header', 'jannal'),
					'attributes' => array( 'style'	=> 'width:50%' ),
					'info'		 => esc_html__('Select custom header for this page.','jannal'),
					'dependency'	=> array( 'show-header', '==', 'true' )
				),							
			)			
		),
		# Header Settings

		# Footer Settings
		array(
			'name'  => 'footer_settings',
			'title' => esc_html__('Footer', 'jannal'),
			'icon'  => 'fa fa-angle-double-right',
			'fields' =>  array(
			
				# Footer Show / Hide
				array(
					'id'		=> 'show-footer',
					'type'		=> 'switcher',
					'title'		=> esc_html__('Show Footer', 'jannal'),
					'default'	=>  true,
				),
				
				# Footer
		        array(
					'id'         => 'footer',
					'type'       => 'select',
					'title'      => esc_html__('Choose Footer', 'jannal'),
					'class'      => 'chosen',
					'options'    => 'posts',
					'query_args' => array(
						'post_type'  => 'dt_footers',
						'orderby'    => 'ID',
						'order'      => 'ASC',
						'posts_per_page' => -1,
					),
					'default_option' => esc_attr__('Select Footer', 'jannal'),
					'attributes' => array( 'style'  => 'width:50%' ),
					'info'       => esc_html__('Select custom footer for this page.','jannal'),
					'dependency'    => array( 'show-footer', '==', 'true' )
				),			
			)			
		),
		# Footer Settings
		
	)	
);
	
CSFramework_Metabox::instance( $options );