<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => constant('JANNAL_THEME_NAME').' '.esc_html__('Options', 'jannal'),
  'menu_type'       => 'theme', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'cs-framework',
  'ajax_save'       => true,
  'show_reset_all'  => false,
	'framework_title' => sprintf(esc_html__('Designthemes Framework %1$s', 'jannal'), '<small>'.esc_html__('by Designthemes', 'jannal').'</small>'),
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();

$options[]      = array(
  'name'        => 'general',
  'title'       => esc_html__('General', 'jannal'),
  'icon'        => 'fa fa-gears',

  'fields'      => array(

	array(
	  'type'    => 'subheading',
	  'content' => esc_html__( 'General Options', 'jannal' ),
	),
	
	array(
		'id'	=> 'header',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Header', 'jannal'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_headers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Header', 'jannal'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select default header.','jannal'),
	),
	
	array(
		'id'	=> 'footer',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Footer', 'jannal'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_footers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Footer', 'jannal'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select defaultfooter.','jannal'),
	),

	array(
	  'id'  	 => 'use-site-loader',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Site Loader', 'jannal'),
	  'info'	 => esc_html__('YES! to use site loader.', 'jannal')
	),	

	array(
	  'id'  	 => 'show-pagecomments',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Globally Show Page Comments', 'jannal'),
	  'info'	 => esc_html__('YES! to show comments on all the pages. This will globally override your "Allow comments" option under your page "Discussion" settings.', 'jannal'),
	  'default'  => true,
	),

	array(
	  'id'  	 => 'showall-pagination',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Show all pages in Pagination', 'jannal'),
	  'info'	 => esc_html__('YES! to show all the pages instead of dots near the current page.', 'jannal')
	),



	array(
	  'id'      => 'google-map-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Google Map API Key', 'jannal'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid google account api key here', 'jannal').'</p>',
	),

	array(
	  'id'      => 'mailchimp-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Mailchimp API Key', 'jannal'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid mailchimp account api key here', 'jannal').'</p>',
	),

	array(
	  'id'  	 => 'enable-totop',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Enable To Top', 'jannal'),
	  'info'	 => esc_html__('YES! to enable to top for your site.', 'jannal'),
	  'default'  => true,
	),


  ),
);

$options[]      = array(
  'name'        => 'layout_options',
  'title'       => esc_html__('Layout Options', 'jannal'),
  'icon'        => 'dashicons dashicons-exerpt-view',
  'sections' => array(

	// -----------------------------------------
	// Header Options
	// -----------------------------------------
	array(
	  'name'      => 'breadcrumb_options',
	  'title'     => esc_html__('Breadcrumb Options', 'jannal'),
	  'icon'      => 'fa fa-sitemap',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Breadcrumb Options", 'jannal' ),
		  ),

		  array(
			'id'  		 => 'show-breadcrumb',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Breadcrumb', 'jannal'),
			'info'		 => esc_html__('YES! to display breadcrumb for all pages.', 'jannal'),
			'default' 	 => true,
		  ),

		  array(
			'id'           => 'breadcrumb-delimiter',
			'type'         => 'icon',
			'title'        => esc_html__('Breadcrumb Delimiter', 'jannal'),
			'info'         => esc_html__('Choose delimiter style to display on breadcrumb section.', 'jannal'),
		  ),

		  array(
			'id'           => 'breadcrumb-style',
			'type'         => 'select',
			'title'        => esc_html__('Breadcrumb Style', 'jannal'),
			'options'      => array(
			  'default' 							=> esc_html__('Default', 'jannal'),
			  'aligncenter'    						=> esc_html__('Align Center', 'jannal'),
			  'alignright'  						=> esc_html__('Align Right', 'jannal'),
			  'breadcrumb-left'    					=> esc_html__('Left Side Breadcrumb', 'jannal'),
			  'breadcrumb-right'     				=> esc_html__('Right Side Breadcrumb', 'jannal'),
			  'breadcrumb-top-right-title-center'  	=> esc_html__('Top Right Title Center', 'jannal'),
			  'breadcrumb-top-left-title-center'  	=> esc_html__('Top Left Title Center', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'alignright',
			'info'         => esc_html__('Choose alignment style to display on breadcrumb section.', 'jannal'),
		  ),

		  array(
			  'id'                 => 'breadcrumb-position',
			  'type'               => 'select',
			  'title'              => esc_html__('Position', 'jannal' ),
			  'options'            => array(
				  'header-top-absolute'    => esc_html__('Behind the Header','jannal'),
				  'header-top-relative'    => esc_html__('Default','jannal'),
			  ),
			  'class'        => 'chosen',
			  'default'      => 'header-top-relative',
			  'info'         => esc_html__('Choose position of breadcrumb section.', 'jannal'),
		  ),

		  array(
			'id'    => 'breadcrumb_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'jannal'),
			'desc'  => esc_html__('Choose background options for breadcrumb title section.', 'jannal')
		  ),

		),
	),

  ),
);

$options[]      = array(
  'name'        => 'allpage_options',
  'title'       => esc_html__('All Page Options', 'jannal'),
  'icon'        => 'fa fa-files-o',
  'sections' => array(

	// -----------------------------------------
	// Global Sidebar Options
	// -----------------------------------------
	array(
	  'name'      => 'global_sidebar_options',
	  'title'     => esc_html__('Global Sidebar Options', 'jannal'),
	  'icon'      => 'dashicons dashicons-format-aside',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Global Sidebar Options", 'jannal' ),
		  ),

		  array(
			'id'      	 => 'site-global-sidebar-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Global Sidebar Layout', 'jannal'),
			'options'    => array(
			  'content-full-width'   => JANNAL_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => JANNAL_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => JANNAL_THEME_URI . '/cs-framework-override/images/right-sidebar.png'
			),
			'default'      => 'with-left-sidebar',
			'attributes'   => array(
			  'data-depend-id' => 'site-global-sidebar-layout',
			),
			'desc'  => esc_html__('Choose sidebar layout for site wide.', 'jannal')
		  ),
		),
	),

	// -----------------------------------------
	// Blog Archive Options
	// -----------------------------------------
	array(
	  'name'      => 'blog_archive_options',
	  'title'     => esc_html__('Blog Archive Options', 'jannal'),
	  'icon'      => 'fa fa-file-archive-o',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Blog Archives Page Layout", 'jannal' ),
		  ),

		  array(
			'id'      	 => 'blog-archives-page-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Page Layout', 'jannal'),
			'options'    => array(
			  'content-full-width'   => JANNAL_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => JANNAL_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => JANNAL_THEME_URI . '/cs-framework-override/images/right-sidebar.png'
			),
			'default'      => 'with-left-sidebar',
			'attributes'   => array(
			  'data-depend-id' => 'blog-archives-page-layout',
			),
		  ),

		  array(
			'id'  		 => 'show-standard-left-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Left Sidebar', 'jannal'),
			'dependency' => array( 'blog-archives-page-layout', 'any', 'with-left-sidebar' ),
			'default' => true
		  ),

		  array(
			'id'  		 => 'show-standard-right-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Right Sidebar', 'jannal'),
			'dependency' => array( 'blog-archives-page-layout', 'any', 'with-right-sidebar' ),
			'default' => true
		  ),

		  array(
			'id'      	   => 'blog-post-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Post Layout', 'jannal'),
			'options'      => array(
			  'entry-grid'  => JANNAL_THEME_URI . '/cs-framework-override/images/entry-grid.png',
			  'entry-list'  => JANNAL_THEME_URI . '/cs-framework-override/images/entry-list.png',			  
			  'entry-cover' => JANNAL_THEME_URI . '/cs-framework-override/images/entry-cover.png',
			),
			'default'      => 'entry-grid',
			'attributes'   => array(
			  'data-depend-id' => 'blog-post-layout',
			),
		  ),

		  array(
			'id'           => 'blog-post-grid-list-style',
			'type'         => 'select',
			'title'        => esc_html__('Post Style', 'jannal'),
			'options'      => array(
			  'dt-sc-boxed' 			=> esc_html__('Boxed', 'jannal'),
			  'dt-sc-simple'      		=> esc_html__('Simple', 'jannal'),
			  'dt-sc-overlap'      		=> esc_html__('Overlap', 'jannal'),
			  'dt-sc-content-overlay' 	=> esc_html__('Content Overlay', 'jannal'),
			  'dt-sc-simple-withbg'		=> esc_html__('Simple with Background', 'jannal'),
			  'dt-sc-overlay'   	    => esc_html__('Overlay', 'jannal'),
			  'dt-sc-overlay-ii'      	=> esc_html__('Overlay II', 'jannal'),			  
			  'dt-sc-overlay-iii'      	=> esc_html__('Overlay III', 'jannal'),			  
			  'dt-sc-alternate'	 		=> esc_html__('Alternate', 'jannal'),
			  'dt-sc-minimal'       	=> esc_html__('Minimal', 'jannal'),
			  'dt-sc-modern' 	      	=> esc_html__('Modern', 'jannal'),
			  'dt-sc-classic'	 		=> esc_html__('Classic', 'jannal'),
			  'dt-sc-classic-ii'	 	=> esc_html__('Classic II', 'jannal'),
			  'dt-sc-classic-overlay' 	=> esc_html__('Classic Overlay', 'jannal'),
			  'dt-sc-grungy-boxed' 		=> esc_html__('Grungy Boxed', 'jannal'),
			  'dt-sc-title-overlap'	 	=> esc_html__('Title Overlap', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'dt-sc-classic-overlay',
			'info'         => esc_html__('Choose post style to display blog archives pages.', 'jannal'),
			'dependency'   => array( 'blog-post-layout', 'any', 'entry-grid,entry-list' ),
		  ),

		  array(
			'id'           => 'blog-post-cover-style',
			'type'         => 'select',
			'title'        => esc_html__('Post Style', 'jannal'),
			'options'      => array(
			  'dt-sc-boxed' 			=> esc_html__('Boxed', 'jannal'),
			  'dt-sc-canvas'      		=> esc_html__('Canvas', 'jannal'),
			  'dt-sc-content-overlay' 	=> esc_html__('Content Overlay', 'jannal'),
			  'dt-sc-overlay'   	    => esc_html__('Overlay', 'jannal'),
			  'dt-sc-overlay-ii'      	=> esc_html__('Overlay II', 'jannal'),
			  'dt-sc-overlay-iii'      	=> esc_html__('Overlay III', 'jannal'),
			  'dt-sc-trendy' 			=> esc_html__('Trendy', 'jannal'),
			  'dt-sc-mobilephone' 		=> esc_html__('Mobile Phone', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'dt-sc-boxed',
			'info'         => esc_html__('Choose post style to display blog archives pages.', 'jannal'),
			'dependency'   => array( 'blog-post-layout', '==', 'entry-cover' ),
		  ),

		  array(
			'id'      	   => 'blog-post-columns',
			'type'         => 'image_select',
			'title'        => esc_html__('Columns', 'jannal'),
			'options'      => array(
			  'one-column' 		  => JANNAL_THEME_URI . '/cs-framework-override/images/one-column.png',
			  'one-half-column'   => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
			  'one-third-column'  => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
			  //'one-fourth-column' => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
			),
			'default'      => 'one-half-column',
			'attributes'   => array(
			  'data-depend-id' => 'blog-post-columns',
			),
			'dependency' => array( 'blog-post-layout', 'any', 'entry-grid,entry-cover' ),
		  ),

		  array(
			'id'      	   => 'blog-list-thumb',
			'type'         => 'image_select',
			'title'        => esc_html__('List Type', 'jannal'),
			'options'      => array(
			  'entry-left-thumb'  => JANNAL_THEME_URI . '/cs-framework-override/images/entry-left-thumb.png',
			  'entry-right-thumb' => JANNAL_THEME_URI . '/cs-framework-override/images/entry-right-thumb.png',
			),
			'default'      => 'entry-left-thumb',
			'attributes'   => array(
			  'data-depend-id' => 'blog-list-thumb',
			),
			'dependency' => array( 'blog-post-layout', '==', 'entry-list' ),
		  ),

		  array(
			'id'           => 'blog-alignment',
			'type'         => 'select',
			'title'        => esc_html__('Elements Alignment', 'jannal'),
			'options'      => array(
			  'alignnone'	=> esc_html__('None', 'jannal'),
			  'alignleft' 	=> esc_html__('Align Left', 'jannal'),
			  'aligncenter' => esc_html__('Align Center', 'jannal'),
			  'alignright'  => esc_html__('Align Right', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'alignnone',
			'info'         => esc_html__('Choose alignment to display archives pages.', 'jannal'),
			'dependency'   => array( 'blog-post-layout', 'any', 'entry-grid,entry-cover' ),
		  ),

		  array(
			'id'  		 => 'enable-equal-height',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Enable Equal Height', 'jannal'),
			'info'		 => esc_html__('YES! to items display as equal height', 'jannal'),
			'dependency' => array( 'blog-post-layout', 'any', 'entry-grid,entry-cover' ),
		  ),

		  array(
			'id'  		 => 'enable-no-space',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Enable No Space', 'jannal'),
			'info'		 => esc_html__('YES! to items display as no space', 'jannal'),
			'dependency' => array( 'blog-post-layout', 'any', 'entry-grid,entry-cover' ),
		  ),

		  array(
			'id'  		 => 'enable-gallery-slider',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Display Gallery Slider', 'jannal'),
			'info'		 => esc_html__('YES! to display gallery slider', 'jannal'),
			'dependency' => array( 'blog-post-layout', 'any', 'entry-grid,entry-list' ),
		  ),

		  array(
			'id'             => 'blog-elements-position',
			'type'           => 'sorter',
			'title'          => esc_html__('Elements Positioning', 'jannal'),
			'default'        => array(
			  'enabled'      => array(
					'feature_image'	=> esc_html__('Feature Image', 'jannal'),
					'comments' 		=> esc_html__('Comments', 'jannal'),
					'date'     		=> esc_html__('Date', 'jannal'),
					'author'		=> esc_html__('Author', 'jannal'),
					'title'      	=> esc_html__('Title', 'jannal'),
					'content'    	=> esc_html__('Content', 'jannal'),
					'read_more'  	=> esc_html__('Read More', 'jannal'),				
			  ),
			  'disabled'     => array(
					'likes_views'   => esc_html__('Likes & Views', 'jannal'),
					'meta_group' 	=> esc_html__('Meta Group', 'jannal'),
					'categories'    => esc_html__('Categories', 'jannal'),
					'tags'  		=> esc_html__('Tags', 'jannal'),
					'social_share'  => esc_html__('Social Share', 'jannal'),				
			  ),
			),
			'enabled_title'  	=> esc_html__('Active Elements', 'jannal'),
			'disabled_title' 	=> esc_html__('Deactive Elements', 'jannal'),
		  ),

		  array(
			'id'             => 'blog-meta-position',
			'type'           => 'sorter',
			'title'          => esc_html__('Meta Group Positioning', 'jannal'),
			'default'        => array(
			  'enabled'      => array(
					'date'     		=> esc_html__('Date', 'jannal'),
			  ),
			  'disabled'     => array(
					'author'		=> esc_html__('Author', 'jannal'),
					'comments' 		=> esc_html__('Comments', 'jannal'),
					'categories'    => esc_html__('Categories', 'jannal'),					
					'tags'  		=> esc_html__('Tags', 'jannal'),
					'social_share'  => esc_html__('Social Share', 'jannal'),
					'likes_views'   => esc_html__('Likes & Views', 'jannal'),
			  ),
			),
			'enabled_title'  => esc_html__('Active Items', 'jannal'),
			'disabled_title' => esc_html__('Deactive Items', 'jannal'),
			'desc'  		 => esc_html__('Note: Use max 3 items for better results.', 'jannal')
		  ),

		  array(
			'id'  		 => 'enable-post-format',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Enable Post Format', 'jannal'),
			'info'		 => esc_html__('YES! to display post format icon', 'jannal'),
		  ),

		  array(
			'id'  		 => 'enable-excerpt-text',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Enable Excerpt Text', 'jannal'),
			'info'		 => esc_html__('YES! to display excerpt content', 'jannal'),
			'default'	=> true
		  ),

		  array(
			'id'  		 => 'blog-excerpt-length',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Excerpt Length', 'jannal'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Put Excerpt Length', 'jannal').'</span>',
			'default' 	 => 25,
			'dependency' => array( 'enable-excerpt-text', '==', 'true' ),
		  ),

		  array(
			'id'  		 => 'enable-video-audio',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Display Video & Audio for Posts', 'jannal'),
			'info'		 => esc_html__('YES! to display video & audio, instead of feature image for posts', 'jannal'),
			'dependency' => array( 'blog-post-layout', 'any', 'entry-grid,entry-list' ),
		  ),

		  array(
			'id'  		 => 'blog-readmore-text',
			'type'  	 => 'text',
			'title' 	 => esc_html__('Read More Text', 'jannal'),
			'info'		 => esc_html__('Put the read more text here', 'jannal'),
			'default'	 => esc_html__('Read More', 'jannal')
		  ),

		  array(
			'id'           => 'blog-image-hover-style',
			'type'         => 'select',
			'title'        => esc_html__('Image Hover Style', 'jannal'),
			'options'      => array(
			  'dt-sc-default' 			=> esc_html__('Default', 'jannal'),
			  'dt-sc-blur'      		=> esc_html__('Blur', 'jannal'),
			  'dt-sc-bw'   		   		=> esc_html__('Black and White', 'jannal'),
			  'dt-sc-brightness'	 	=> esc_html__('Brightness', 'jannal'),
			  'dt-sc-fadeinleft'   	    => esc_html__('Fade InLeft', 'jannal'),
			  'dt-sc-fadeinright'  	    => esc_html__('Fade InRight', 'jannal'),
			  'dt-sc-hue-rotate'   	    => esc_html__('Hue-Rotate', 'jannal'),
			  'dt-sc-invert'	   	    => esc_html__('Invert', 'jannal'),
			  'dt-sc-opacity'   	    => esc_html__('Opacity', 'jannal'),
			  'dt-sc-rotate'	   	    => esc_html__('Rotate', 'jannal'),
			  'dt-sc-rotate-alt'   	    => esc_html__('Rotate Alt', 'jannal'),
			  'dt-sc-scalein'   	    => esc_html__('Scale In', 'jannal'),
			  'dt-sc-scaleout' 	    	=> esc_html__('Scale Out', 'jannal'),
			  'dt-sc-sepia'	   	    	=> esc_html__('Sepia', 'jannal'),
			  'dt-sc-tint'		   	    => esc_html__('Tint', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'dt-sc-default',
			'info'         => esc_html__('Choose image hover style to display archives pages.', 'jannal'),
		  ),

		  array(
			'id'           => 'blog-image-overlay-style',
			'type'         => 'select',
			'title'        => esc_html__('Image Overlay Style', 'jannal'),
			'options'      => array(
			  'dt-sc-default' 			=> esc_html__('None', 'jannal'),
			  'dt-sc-fixed' 			=> esc_html__('Fixed', 'jannal'),
			  'dt-sc-tb' 				=> esc_html__('Top to Bottom', 'jannal'),
			  'dt-sc-bt'   				=> esc_html__('Bottom to Top', 'jannal'),
			  'dt-sc-rl'   				=> esc_html__('Right to Left', 'jannal'),
			  'dt-sc-lr'				=> esc_html__('Left to Right', 'jannal'),
			  'dt-sc-middle'			=> esc_html__('Middle', 'jannal'),
			  'dt-sc-middle-radial'		=> esc_html__('Middle Radial', 'jannal'),
			  'dt-sc-tb-gradient' 		=> esc_html__('Gradient - Top to Bottom', 'jannal'),
			  'dt-sc-bt-gradient'   	=> esc_html__('Gradient - Bottom to Top', 'jannal'),
			  'dt-sc-rl-gradient'   	=> esc_html__('Gradient - Right to Left', 'jannal'),
			  'dt-sc-lr-gradient'		=> esc_html__('Gradient - Left to Right', 'jannal'),
			  'dt-sc-radial-gradient'	=> esc_html__('Gradient - Radial', 'jannal'),
			  'dt-sc-flash' 			=> esc_html__('Flash', 'jannal'),
			  'dt-sc-circle' 			=> esc_html__('Circle', 'jannal'),
			  'dt-sc-hm-elastic'		=> esc_html__('Horizontal Elastic', 'jannal'),
			  'dt-sc-vm-elastic'		=> esc_html__('Vertical Elastic', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'dt-sc-default',
			'info'         => esc_html__('Choose image overlay style to display archives pages.', 'jannal'),
			'dependency' => array( 'blog-post-layout', 'any', 'entry-grid,entry-list' ),
		  ),

		  array(
			'id'           => 'blog-pagination',
			'type'         => 'select',
			'title'        => esc_html__('Pagination Style', 'jannal'),
			'options'      => array(
			  'older_newer' 	=> esc_html__('Older & Newer', 'jannal'),
			  'numbered'      	=> esc_html__('Numbered', 'jannal'),
			  'load_more'      	=> esc_html__('Load More', 'jannal'),
			  'infinite_scroll'	=> esc_html__('Infinite Scroll', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'numbered',
			'info'         => esc_html__('Choose pagination style to display archives pages.', 'jannal'),
		  ),

		),
	),

	// -----------------------------------------
	// Blog Single Options
	// -----------------------------------------
	array(
	  'name'      => 'blog_single_options',
	  'title'     => esc_html__('Blog Single Options', 'jannal'),
	  'icon'      => 'fa fa-thumb-tack',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Blog Single Post Options", 'jannal' ),
		  ),

		  array(
			'id'             => 'post-elements-position',
			'type'           => 'sorter',
			'title'          => esc_html__('Post Elements Positioning', 'jannal'),
			'default'        => array(
			  'enabled'      => array(
					'content'    	=> esc_html__('Content', 'jannal'),
					'meta_group' 	=> esc_html__('Meta Group', 'jannal'),
					'navigation'    => esc_html__('Navigation', 'jannal'),
					'comment_box' 	=> esc_html__('Comment Box', 'jannal'),
			  ),
			  'disabled'     => array(
					'author_bio' 	=> esc_html__('Author Bio', 'jannal'),
					'social_share'  => esc_html__('Social Share', 'jannal'),
					'author'		=> esc_html__('Author', 'jannal'),
					'date'     		=> esc_html__('Date', 'jannal'),
					'comments' 		=> esc_html__('Comments', 'jannal'),
					'categories'    => esc_html__('Categories', 'jannal'),
					'tags'  		=> esc_html__('Tags', 'jannal'),
					'feature_image'	=> esc_html__('Feature Image', 'jannal'),
					'title'      	=> esc_html__('Title', 'jannal'),					
					'related_posts' => esc_html__('Related Posts', 'jannal'),					
					'likes_views'   => esc_html__('Likes & Views', 'jannal'),
					'related_article' 	=> esc_html__('Related Article( Only Fixed )', 'jannal'),
			  ),
			),
			'enabled_title'  => esc_html__('Active Elements', 'jannal'),
			'disabled_title' => esc_html__('Deactive Elements', 'jannal'),
		  ),

		  array(
			'id'             => 'post-meta-position',
			'type'           => 'sorter',
			'title'          => esc_html__('Meta Group Positioning', 'jannal'),
			'default'        => array(
			  'enabled'      => array(
					'tags'  		=> esc_html__('Tags', 'jannal'),
			  ),
			  'disabled'     => array(
					'author'		=> esc_html__('Author', 'jannal'),
					'date'     		=> esc_html__('Date', 'jannal'),
					'comments' 		=> esc_html__('Comments', 'jannal'),
					'categories'    => esc_html__('Categories', 'jannal'),
					'social_share'  => esc_html__('Social Share', 'jannal'),
					'likes_views'   => esc_html__('Likes & Views', 'jannal'),
			  ),
			),
			'enabled_title'  => esc_html__('Active Items', 'jannal'),
			'disabled_title' => esc_html__('Deactive Items', 'jannal'),
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Related Post Options", 'jannal' ),
		  ),

		  array(
			'id'  		 => 'post-related-title',
			'type'  	 => 'text',
			'title' 	 => esc_html__('Related Posts Section Title', 'jannal'),
			'info'		 => esc_html__('Put the related posts section title here', 'jannal'),
			'default'	 => esc_html__('Related Posts', 'jannal')
		  ),

		  array(
			'id'      	   => 'post-related-columns',
			'type'         => 'image_select',
			'title'        => esc_html__('Columns', 'jannal'),
			'options'      => array(
			  'one-column' 		  => JANNAL_THEME_URI . '/cs-framework-override/images/one-column.png',
			  'one-half-column'   => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
			  'one-third-column'  => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
			),
			'default'      => 'one-third-column',
			'attributes'   => array(
			  'data-depend-id' => 'post-related-columns',
			),
		  ),

		  array(
			'id'  		 => 'post-related-count',
			'type'  	 => 'number',
			'title' 	 => esc_html__('No.of Posts to Show', 'jannal'),
			'info'		 => esc_html__('Put the no.of related posts to show', 'jannal'),
			'default'	 => 3
		  ),

		  array(
			'id'  		 => 'enable-related-excerpt',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Enable Excerpt Text', 'jannal'),
			'info'		 => esc_html__('YES! to display excerpt content', 'jannal'),
		  ),

		  array(
			'id'  		 => 'post-related-excerpt',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Excerpt Length', 'jannal'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Put Excerpt Length', 'jannal').'</span>',
			'default' 	 => 25,
			'dependency' => array( 'enable-related-excerpt', '==', 'true' ),
		  ),

		  array(
			'id'  		 => 'enable-related-carousel',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Enable Carousel', 'jannal'),
			'info'		 => esc_html__('YES! to enable carousel related posts', 'jannal'),
		  ),

		  array(
			'id'           => 'related-carousel-nav',
			'type'         => 'select',
			'title'        => esc_html__('Navigation Style', 'jannal'),
			'options'      => array(
			  '' 			=> esc_html__('None', 'jannal'),
			  'navigation'  => esc_html__('Navigations', 'jannal'),
			  'pager'   	=> esc_html__('Pager', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'text',
			'info'         => esc_html__('Choose navigation style to display related post carousel.', 'jannal'),
			'dependency' => array( 'enable-related-carousel', '==', 'true' ),
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Miscellaneous Post Options", 'jannal' ),
		  ),

		  array(
			'id'  		 => 'enable-image-lightbox',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Feature Image Lightbox', 'jannal'),
			'info'		 => esc_html__('YES! to enable lightbox for feature image.', 'jannal'),
		  ),

		  array(
			'id'           => 'post-comments-list-style',
			'type'         => 'select',
			'title'        => esc_html__('Comments List Style', 'jannal'),
			'options'      => array(
			  'rounded' 	=> esc_html__('Rounded', 'jannal'),
			  'square'   	=> esc_html__('Square', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'rounded',
			'info'         => esc_html__('Choose comments list style to display single post.', 'jannal'),
		  ),
		),
	),

	// -----------------------------------------
	// 404 Options
	// -----------------------------------------
	array(
	  'name'      => '404_options',
	  'title'     => esc_html__('404 Options', 'jannal'),
	  'icon'      => 'fa fa-warning',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "404 Message", 'jannal' ),
		  ),
		  
		  array(
			'id'      => 'enable-404message',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Message', 'jannal' ),
			'info'	  => esc_html__('YES! to enable not-found page message.', 'jannal'),
			'default' => true
		  ),

		  array(
			'id'           => 'notfound-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'jannal'),
			'options'      => array(
			  'type1' 	   => esc_html__('Modern', 'jannal'),
			  'type2'      => esc_html__('Classic', 'jannal'),
			  'type4'  	   => esc_html__('Diamond', 'jannal'),
			  'type5'      => esc_html__('Shadow', 'jannal'),
			  'type6'      => esc_html__('Diamond Alt', 'jannal'),
			  'type7'  	   => esc_html__('Stack', 'jannal'),
			  'type8'  	   => esc_html__('Minimal', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of not-found template page.', 'jannal')
		  ),

		  array(
			'id'      => 'notfound-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('404 Dark BG', 'jannal' ),
			'info'	  => esc_html__('YES! to use dark bg notfound page for this site.', 'jannal')
		  ),

		  array(
			'id'           => 'notfound-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'jannal'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'jannal'),
			'info'       	 => esc_html__('Choose the page for not-found content.', 'jannal')
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Background Options", 'jannal' ),
		  ),

		  array(
			'id'    => 'notfound_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'jannal')
		  ),

		  array(
			'id'  		 => 'notfound-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'jannal'),
			'info'		 => esc_html__('Paste custom CSS styles for not found page.', 'jannal')
		  ),

		),
	),

	// -----------------------------------------
	// Underconstruction Options
	// -----------------------------------------
	array(
	  'name'      => 'comingsoon_options',
	  'title'     => esc_html__('Under Construction Options', 'jannal'),
	  'icon'      => 'fa fa-thumbs-down',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Under Construction", 'jannal' ),
		  ),
	
		  array(
			'id'      => 'enable-comingsoon',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Coming Soon', 'jannal' ),
			'info'	  => esc_html__('YES! to check under construction page of your website.', 'jannal')
		  ),
	
		  array(
			'id'           => 'comingsoon-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'jannal'),
			'options'      => array(
			  'type1' 	   => esc_html__('Diamond', 'jannal'),
			  'type2'      => esc_html__('Teaser', 'jannal'),
			  'type3'  	   => esc_html__('Minimal', 'jannal'),
			  'type4'      => esc_html__('Counter Only', 'jannal'),
			  'type5'      => esc_html__('Belt', 'jannal'),
			  'type6'  	   => esc_html__('Classic', 'jannal'),
			  'type7'  	   => esc_html__('Boxed', 'jannal')
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of coming soon template.', 'jannal'),
		  ),

		  array(
			'id'      => 'uc-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('Coming Soon Dark BG', 'jannal' ),
			'info'	  => esc_html__('YES! to use dark bg coming soon page for this site.', 'jannal')
		  ),

		  array(
			'id'           => 'comingsoon-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'jannal'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'jannal'),
			'info'       	 => esc_html__('Choose the page for comingsoon content.', 'jannal')
		  ),

		  array(
			'id'      => 'show-launchdate',
			'type'    => 'switcher',
			'title'   => esc_html__('Show Launch Date', 'jannal' ),
			'info'	  => esc_html__('YES! to show launch date text.', 'jannal'),
		  ),

		  array(
			'id'      => 'comingsoon-launchdate',
			'type'    => 'text',
			'title'   => esc_html__('Launch Date', 'jannal'),
			'attributes' => array( 
			  'placeholder' => '10/30/2016 12:00:00'
			),
			'after' 	=> '<p class="cs-text-info">'.esc_html__('Put Format: 12/30/2016 12:00:00 month/day/year hour:minute:second', 'jannal').'</p>',
		  ),

		  array(
			'id'           => 'comingsoon-timezone',
			'type'         => 'select',
			'title'        => esc_html__('UTC Timezone', 'jannal'),
			'options'      => array(
			  '-12' => '-12', '-11' => '-11', '-10' => '-10', '-9' => '-9', '-8' => '-8', '-7' => '-7', '-6' => '-6', '-5' => '-5', 
			  '-4' => '-4', '-3' => '-3', '-2' => '-2', '-1' => '-1', '0' => '0', '+1' => '+1', '+2' => '+2', '+3' => '+3', '+4' => '+4',
			  '+5' => '+5', '+6' => '+6', '+7' => '+7', '+8' => '+8', '+9' => '+9', '+10' => '+10', '+11' => '+11', '+12' => '+12'
			),
			'class'        => 'chosen',
			'default'      => '0',
			'info'         => esc_html__('Choose utc timezone, by default UTC:00:00', 'jannal'),
		  ),

		  array(
			'id'    => 'comingsoon_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'jannal')
		  ),

		  array(
			'id'  		 => 'comingsoon-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'jannal'),
			'info'		 => esc_html__('Paste custom CSS styles for under construction page.', 'jannal'),
		  ),

		),
	),

  ),
);

// -----------------------------------------
// Widget area Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'widgetarea_options',
  'title'       => esc_html__('Widget Area', 'jannal'),
  'icon'        => 'fa fa-trello',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Widget Area for Sidebar", 'jannal' ),
	  ),

	  array(
		'id'           => 'wtitle-style',
		'type'         => 'select',
		'title'        => esc_html__('Sidebar widget Title Style', 'jannal'),
		'options'      => array(
			'default' => esc_html__('Choose any type', 'jannal'),
			'type1'   => esc_html__('Double Border', 'jannal'),
			'type2'   => esc_html__('Tooltip', 'jannal'),
			'type3'   => esc_html__('Title Top Border', 'jannal'),
			'type4'   => esc_html__('Left Border & Pattren', 'jannal'),
			'type5'   => esc_html__('Bottom Border', 'jannal'),
			'type6'   => esc_html__('Tooltip Border', 'jannal'),
			'type7'   => esc_html__('Boxed Modern', 'jannal'),
			'type8'   => esc_html__('Elegant Border', 'jannal'),
			'type9'   => esc_html__('Needle', 'jannal'),
			'type10'  => esc_html__('Ribbon', 'jannal'),
			'type11'  => esc_html__('Content Background', 'jannal'),
			'type12'  => esc_html__('Classic BG', 'jannal'),
			'type13'  => esc_html__('Tiny Boders', 'jannal'),
			'type14'  => esc_html__('BG & Border', 'jannal'),
			'type15'  => esc_html__('Classic BG Alt', 'jannal'),
			'type16'  => esc_html__('Left Border & BG', 'jannal'),
			'type17'  => esc_html__('Basic', 'jannal'),
			'type18'  => esc_html__('BG & Pattern', 'jannal'),
		),
		'class'   => 'chosen',
		'default' => 'type17',
		'info'    => esc_html__('Choose the style of sidebar widget title.', 'jannal')
	  ),

	  array(
		'id'              => 'widgetarea-custom',
		'type'            => 'group',
		'title'           => esc_html__('Custom Widget Area', 'jannal'),
		'button_title'    => esc_html__('Add New', 'jannal'),
		'accordion_title' => esc_html__('Add New Widget Area', 'jannal'),
		'fields'          => array(

		  array(
			'id'          => 'widgetarea-custom-name',
			'type'        => 'text',
			'title'       => esc_html__('Name', 'jannal'),
		  ),

		)
	  ),

	),
);

// -----------------------------------------
// Sociable Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'sociable_options',
  'title'       => esc_html__('Sociable', 'jannal'),
  'icon'        => 'fa fa-share-square',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Sociable", 'jannal' ),
	  ),

	  array(
		'id'              => 'sociable_fields',
		'type'            => 'group',
		'title'           => esc_html__('Sociable', 'jannal'),
		'info'            => esc_html__('Click button to add type of social & url.', 'jannal'),
		'button_title'    => esc_html__('Add New Social', 'jannal'),
		'accordion_title' => esc_html__('Adding New Social Field', 'jannal'),
		'fields'          => array(
		  array(
			'id'          => 'sociable_fields_type',
			'type'        => 'select',
			'title'       => esc_html__('Select Social', 'jannal'),
			'options'      => array(
			  'delicious' 	 => esc_html__('Delicious', 'jannal'),
			  'deviantart' 	 => esc_html__('Deviantart', 'jannal'),
			  'digg' 	  	 => esc_html__('Digg', 'jannal'),
			  'dribbble' 	 => esc_html__('Dribbble', 'jannal'),
			  'envelope' 	 => esc_html__('Envelope', 'jannal'),
			  'facebook' 	 => esc_html__('Facebook', 'jannal'),
			  'flickr' 		 => esc_html__('Flickr', 'jannal'),
			  'google-plus'  => esc_html__('Google Plus', 'jannal'),
			  'gtalk'  		 => esc_html__('GTalk', 'jannal'),
			  'instagram'	 => esc_html__('Instagram', 'jannal'),
			  'lastfm'	 	 => esc_html__('Lastfm', 'jannal'),
			  'linkedin'	 => esc_html__('Linkedin', 'jannal'),
			  'pinterest'	 => esc_html__('Pinterest', 'jannal'),
			  'reddit'		 => esc_html__('Reddit', 'jannal'),
			  'rss'		 	 => esc_html__('RSS', 'jannal'),
			  'skype'		 => esc_html__('Skype', 'jannal'),
			  'stumbleupon'	 => esc_html__('Stumbleupon', 'jannal'),
			  'tumblr'		 => esc_html__('Tumblr', 'jannal'),
			  'twitter'		 => esc_html__('Twitter', 'jannal'),
			  'viadeo'		 => esc_html__('Viadeo', 'jannal'),
			  'vimeo'		 => esc_html__('Vimeo', 'jannal'),
			  'yahoo'		 => esc_html__('Yahoo', 'jannal'),
			  'youtube'		 => esc_html__('Youtube', 'jannal'),
			),
			'class'        => 'chosen',
			'default'      => 'delicious',
		  ),

		  array(
			'id'          => 'sociable_fields_url',
			'type'        => 'text',
			'title'       => esc_html__('Enter URL', 'jannal')
		  ),
		)
	  ),

   ),
);

// -----------------------------------------
// Hook Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'hook_options',
  'title'       => esc_html__('Hooks', 'jannal'),
  'icon'        => 'fa fa-paperclip',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Top Hook", 'jannal' ),
	  ),

	  array(
		'id'  	=> 'enable-top-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Top Hook', 'jannal'),
		'info'	=> esc_html__("YES! to enable top hook.", 'jannal')
	  ),

	  array(
		'id'  		 => 'top-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Top Hook', 'jannal'),
		'info'		 => esc_html__('Paste your top hook, Executes after the opening &lt;body&gt; tag.', 'jannal')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content Before Hook", 'jannal' ),
	  ),

	  array(
		'id'  	=> 'enable-content-before-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Content Before Hook', 'jannal'),
		'info'	=> esc_html__("YES! to enable content before hook.", 'jannal')
	  ),

	  array(
		'id'  		 => 'content-before-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content Before Hook', 'jannal'),
		'info'		 => esc_html__('Paste your content before hook, Executes before the opening &lt;#primary&gt; tag.', 'jannal')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content After Hook", 'jannal' ),
	  ),

	  array(
		'id'  	=> 'enable-content-after-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Content After Hook', 'jannal'),
		'info'	=> esc_html__("YES! to enable content after hook.", 'jannal')
	  ),

	  array(
		'id'  		 => 'content-after-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content After Hook', 'jannal'),
		'info'		 => esc_html__('Paste your content after hook, Executes after the closing &lt;/#main&gt; tag.', 'jannal')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Bottom Hook", 'jannal' ),
	  ),

	  array(
		'id'  	=> 'enable-bottom-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Bottom Hook', 'jannal'),
		'info'	=> esc_html__("YES! to enable bottom hook.", 'jannal')
	  ),

	  array(
		'id'  		 => 'bottom-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Bottom Hook', 'jannal'),
		'info'		 => esc_html__('Paste your bottom hook, Executes after the closing &lt;/body&gt; tag.', 'jannal')
	  ),

  array(
		'id'  	=> 'enable-analytics-code',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Tracking Code', 'jannal'),
		'info'	=> esc_html__("YES! to enable site tracking code.", 'jannal')
	  ),

	  array(
		'id'  		 => 'analytics-code',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Google Analytics Tracking Code', 'jannal'),
		'info'		 => esc_html__('Either enter your Google tracking id (UA-XXXXX-X) or your full Google Analytics tracking Code here. If you want to offer your visitors the option to stop being tracked you can place the shortcode [dt_sc_privacy_google_tracking] somewhere on your site', 'jannal')
	  ),

   ),
);

// -----------------------------------------
// Custom Font Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'font_options',
  'title'       => esc_html__('Custom Fonts', 'jannal'),
  'icon'        => 'fa fa-font',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Fonts", 'jannal' ),
	  ),

	  array(
		'id'              => 'custom_font_fields',
		'type'            => 'group',
		'title'           => esc_html__('Custom Font', 'jannal'),
		'info'            => esc_html__('Click button to add font name & urls.', 'jannal'),
		'button_title'    => esc_html__('Add New Font', 'jannal'),
		'accordion_title' => esc_html__('Adding New Font Field', 'jannal'),
		'fields'          => array(
		  array(
			'id'          => 'custom_font_name',
			'type'        => 'text',
			'title'       => esc_html__('Font Name', 'jannal')
		  ),

		  array(
			'id'      => 'custom_font_woof',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff)', 'jannal'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff) file here.', 'jannal').'</p>',
		  ),

		  array(
			'id'      => 'custom_font_woof2',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff2)', 'jannal'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff2) file here.', 'jannal').'</p>',
		  )
		),
		'default' => array (
			array (
				'custom_font_name' => esc_html__('FuturaStd Heavy', 'jannal'),
				'custom_font_woof' 		  => JANNAL_THEME_URI . '/fonts/FuturaStd-Heavy.woff',
				'custom_font_woof2' 		  => JANNAL_THEME_URI . '/fonts/FuturaStd-Heavy.woff2',
			),
			array (
				'custom_font_name' => esc_html__('FuturaStd Medium', 'jannal'),
				'custom_font_woof' 		  => JANNAL_THEME_URI . '/fonts/Futura-Std-Medium.woff'
			)
		),	

	  ),

   ),
);

// ------------------------------
// backup                       
// ------------------------------
$options[]   = array(
  'name'     => 'backup_section',
  'title'    => esc_html__('Backup', 'jannal'),
  'icon'     => 'fa fa-shield',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'warning',
      'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'jannal')
    ),

    array(
      'type'    => 'backup',
    ),

  )
);

// ------------------------------
// license
// ------------------------------
$options[]   = array(
  'name'     => 'theme_version',
  'title'    => constant('JANNAL_THEME_NAME').esc_html__(' Log', 'jannal'),
  'icon'     => 'fa fa-info-circle',
  'fields'   => array(

    array(
      'type'    => 'heading',
      'content' => constant('JANNAL_THEME_NAME').esc_html__(' Theme Change Log', 'jannal')
    ),
    array(
      'type'    => 'content',
	  'content' => '<pre>
	  2021.01.23 - version 2.1
	  ========================
	  * Compatible with wordpress 5.6
	  * Some design issues updated
	  * Updated: All premium plugins

	  2020.12.09 - version 2.0
	  ========================
	  * Portfolio animate issue

	  2020.12.01 - version 1.9
	  ========================
	  * Latest jQuery fixes updated
	  * Updated: All premium plugins

	  2020.08.13 - version 1.8
	  ========================
	  * Compatible with wordpress 5.5	  

	  2020.08.05 - version 1.7
	 ========================
	* Updated: Envato Theme check
	* Updated: sanitize_text_field added
	* Updated: All wordpress theme standards
	* Updated: All premium plugins

	  
	  Version 1.6 - 06/07/2020
	  ========================
	  * Compatible with wordpress 5.4.2
	  * Updated: All premium plugins
	  * Updated: Some design tweaks
	  * Updated: Sub menu mouse hover issue
	  * Updated: Activating another theme causes error

      Version 1.5 - 01/02/2020
	  ==========================
      * Compatible with wordpress 5.3.2
      * Updated: All premium plugins
	  * Updated: All wordpress theme standards
	  * Updated: Privacy and Cookies concept
	  * Updated: Gutenberg editor support for custom post types

	  * Fixed: Google Analytics issue
	  * Fixed: Mailchimp email client issue
	  * Fixed: Privacy Button Issue
	  * Fixed: Gutenberg check for old wordpress version

	  * Improved: Tags taxonomy added for portfolio
	  * Improved: Single product breadcrumb section
	  * Improved: Revisions options added for all custom posts

      Version 1.4 - 08/11/2019
	  ==========================
	  * Compatible with wordpress 5.2.4
	  * Updated: All wordpress theme standards
	  * Updated: All premium plugins      

      Version 1.3 - 31/07/2019
	  ==========================

	  * Fixed: Tags taxonomy display for portfolio

	  Version 1.2 - 30/07/2019
	  ==========================
	  
	  * Compatible with wordpress 5.2.2
	  * Updated: All premium plugins
	  * Updated: Revisions added to all custom post types
	  * Updated: Gutenberg editor support for custom post types
	  * Updated: Link for phone number module
	  * Updated: Online documentation link, check readme file
	  
	  * Fixed: Customizer logo option
	  * Fixed: Google Analytics issue
	  * Fixed: Mailchimp email client issue
	  * Fixed: Gutenberg check for old wordpress version
	  * Fixed: Edit with Visual Composer for portfolio
	  * Fixed: Header & Footer wpml option
	  * Fixed: Site title color
	  * Fixed: Privacy popup bg color
	  * Fixed: 404 page scrolling issue
	  
	  * Improved: Single product breadcrumb section
	  * Improved: Tags taxonomy added for portfolio
	  * Improved: Woocommerce cart module added with custom class option
	  
	  * New: Whatsapp Shortcode
	  
	  Version 1.1 - 06/06/2019
	  ==========================
	  
	  * Enhanced Dummy Data
	  
	  
	  Version 1.0 - 05/06/2019
	  ==========================
	  
	  * First Release!  </pre>',
    ),

  )
);

// ------------------------------
// Seperator
// ------------------------------
$options[] = array(
  'name'   => 'seperator_1',
  'title'  => esc_html__('Plugin Options', 'jannal'),
  'icon'   => 'fa fa-plug'
);

// -----------------------------------------
// Woocommerce Options
// -----------------------------------------

	$product_style_templates = cs_get_option( 'dt-woo-product-style-templates' );
	$product_style_templates = (is_array($product_style_templates) && !empty($product_style_templates)) ? $product_style_templates : false;

	$product_style_templates_arr = array ();
	if($product_style_templates) {
		foreach($product_style_templates as $product_style_template_key => $product_style_template) {
			$product_style_templates_arr[$product_style_template_key] = $product_style_template['template-title'];
		}
	}

	$woo_page_layouts = array(
		'content-full-width'   => JANNAL_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
		'with-left-sidebar'    => JANNAL_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
		'with-right-sidebar'   => JANNAL_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
	);

	$social_follow = array (
			  'delicious' 	 => esc_html__('Delicious', 'jannal'),
			  'deviantart' 	 => esc_html__('Deviantart', 'jannal'),
			  'digg' 	  	 => esc_html__('Digg', 'jannal'),
			  'dribbble' 	 => esc_html__('Dribbble', 'jannal'),
			  'envelope' 	 => esc_html__('Envelope', 'jannal'),
			  'facebook' 	 => esc_html__('Facebook', 'jannal'),
			  'flickr' 		 => esc_html__('Flickr', 'jannal'),
			  'google-plus'  => esc_html__('Google Plus', 'jannal'),
			  'gtalk'  		 => esc_html__('GTalk', 'jannal'),
			  'instagram'	 => esc_html__('Instagram', 'jannal'),
			  'lastfm'	 	 => esc_html__('Lastfm', 'jannal'),
			  'linkedin'	 => esc_html__('Linkedin', 'jannal'),
			  'pinterest'	 => esc_html__('Pinterest', 'jannal'),
			  'reddit'		 => esc_html__('Reddit', 'jannal'),
			  'rss'		 	 => esc_html__('RSS', 'jannal'),
			  'skype'		 => esc_html__('Skype', 'jannal'),
			  'stumbleupon'	 => esc_html__('Stumbleupon', 'jannal'),
			  'tumblr'		 => esc_html__('Tumblr', 'jannal'),
			  'twitter'		 => esc_html__('Twitter', 'jannal'),
			  'viadeo'		 => esc_html__('Viadeo', 'jannal'),
			  'vimeo'		 => esc_html__('Vimeo', 'jannal'),
			  'yahoo'		 => esc_html__('Yahoo', 'jannal'),
			  'youtube'		 => esc_html__('Youtube', 'jannal')
			);

	$social_follow_options = array ();
	foreach($social_follow as $socialfollow_key => $socialfollow) {

		$social_follow_option = array(
							'id'    => 'dt-single-product-show-follow-'.$socialfollow_key,
							'type'  => 'switcher',
							'title' => sprintf(esc_html__('Show %1$s Follow', 'jannal'), $socialfollow),
							'default' => true,
						);
		array_push($social_follow_options, $social_follow_option);

	}

	array_push($social_follow_options, array(
						  'type'    => 'notice',
						  'class'   => 'info',
						  'content' => esc_html__('For Sociables Follow - links must be defined under "Sociables" tab. Sociables Share & Sociables Follow option is used for "Custom Template" single product settings.', 'jannal' )
						));


	$options[] = array(
		'name'     => 'dtwoo',
		'title'    => esc_html__( 'WooCommerce', 'jannal' ),
		'icon'     => 'fa fa-shopping-cart',
		'sections' => array(

			// Shop
				array(
					'name'	=> 'dt-woo-shop',
					'title'	=> esc_html__('Shop', 'jannal'),
					'icon'  => 'fa fa-angle-double-right',
					'fields'=> array(
						array(	
							'type'    => 'subheading',
							'content' => esc_html__( 'Shop Page Settings', 'jannal' ),
						),

						array(
							'id'         => 'shop-page-layout',
							'type'       => 'image_select',
							'title'      => esc_html__('Page Layout', 'jannal'),
							'options'    => $woo_page_layouts,
							'default'    => 'content-full-width',
							'attributes' => array( 'data-depend-id' => 'dt-woo-shop-page-layout' )
						),

						array(
							'id'         => 'shop-page-show-standard-sidebar',
							'type'       => 'switcher',
							'title'      => esc_html__('Show Standard Sidebar', 'jannal'),
							'dependency' => array( 'dt-woo-shop-page-layout', 'any', 'with-left-sidebar,with-right-sidebar' )
						),

						array(
							'id'         => 'shop-page-widgetareas',
							'type'       => 'select',
							'title'      => esc_html__('Choose Custom Widget Area', 'jannal'),
							'class'      => 'chosen',
							'options'    => jannal_custom_widgets(),
							'dependency' => array( 'dt-woo-shop-page-layout', 'any', 'with-left-sidebar,with-right-sidebar' ),
							'attributes' => array(
								'multiple'         => 'multiple',
								'data-placeholder' => esc_attr__('Select Widget Areas', 'jannal'),
								'style'            => 'width: 400px;'
							),
						),

						array(
							'id'      => 'shop-product-per-page',
							'type'    => 'number',
							'title'   => esc_html__('Products Per Page', 'jannal'),
							'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Number of products to show in catalog / shop page', 'jannal').'</span>',
							'default' => 8,
						),

						array(
							'id'         => 'shop-page-product-layout',
							'type'       => 'image_select',
							'title'      => esc_html__('Product Layout', 'jannal'),
							'options'    => array(
								1 => JANNAL_THEME_URI . '/cs-framework-override/images/one-column.png',
								2 => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
								3 => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
								4 => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png'
							),
							'default'    => 4,							
						),

				        array(
				          'id'         => 'shop-page-product-style-template',
				          'type'       => 'select',
				          'title'      => esc_html__('Product Style Template', 'jannal'),
									'options'    => $product_style_templates_arr,
									'default'    => 0
				        ), 											

								array(
									'id'         => 'shop-page-enable-breadcrumb',
									'type'       => 'switcher',
									'title'      => esc_html__('Enable Breadcrumb', 'jannal'),
									'info'       => esc_html__('YES! to show breadcrumb on shop page.', 'jannal'),
									'default'    => true
								),

								array(
									'id'  		 => 'shop-page-bottom-hook',
									'type'  	 => 'textarea',
									'title' 	 => esc_html__('Bottom Hook', 'jannal'),
									'info'		 => esc_html__('Content added here will be shown below shop listings.', 'jannal')
								),

						array(
							'type'    => 'subheading',
							'content' => esc_html__( "Shop Page Sorter Settings", 'jannal' ),
						),

						array(
							'id'         => 'product-show-sorter-on-header',
							'type'       => 'switcher',
							'title'      => esc_html__('Show Sorter On Header', 'jannal'),
							'attributes' => array( 'data-depend-id' => 'dt-woo-shop-product-sorter-on-header' ),
							'info'       => esc_html__('YES! to show sorter bar on header.', 'jannal'),
							'default'    => true
						),

						array(
							'id'             => 'product-sorter-header-elements',
							'type'           => 'sorter',
							'title'          => esc_html__('Sorter Header Elements', 'jannal'),
							'default'        => array(
								'enabled'      => array(
									'filter'       => esc_html__('Filter', 'jannal'),
									'result_count' => esc_html__('Result Count', 'jannal'),
									'pagination'   => esc_html__('Pagination', 'jannal'),
								),
								'disabled'     => array(
									'display_mode'         => esc_html__('Display Mode', 'jannal'),
									'display_mode_options' => esc_html__('Display Mode Options', 'jannal'),
								),
							),
							'enabled_title'  => esc_html__('Active Elements', 'jannal'),
							'disabled_title' => esc_html__('Deatcive Elements', 'jannal'),
							'dependency' => array( 'dt-woo-shop-product-sorter-on-header', '==', 'true' )
						),

						array(
							'id'         => 'product-show-sorter-on-footer',
							'type'       => 'switcher',
							'title'      => esc_html__('Show Sorter On Footer', 'jannal'),
							'attributes' => array( 'data-depend-id' => 'dt-woo-shop-product-sorter-on-footer' ),
							'info'       => esc_html__('YES! to show sorter bar on footer.', 'jannal'),
							'default'    => true
						),

						array(
							'id'             => 'product-sorter-footer-elements',
							'type'           => 'sorter',
							'title'          => esc_html__('Sorter Footer Elements', 'jannal'),
							'default'        => array(
								'enabled'      => array(
									'filter'       => esc_html__('Filter', 'jannal'),
									'result_count' => esc_html__('Result Count', 'jannal'),
									'pagination'   => esc_html__('Pagination', 'jannal'),
								),
								'disabled'     => array(
									'display_mode'         => esc_html__('Display Mode', 'jannal'),
									'display_mode_options' => esc_html__('Display Mode Options', 'jannal'),
								),
							),
							'enabled_title'  => esc_html__('Active Elements', 'jannal'),
							'disabled_title' => esc_html__('Deatcive Elements', 'jannal'),
							'dependency' => array( 'dt-woo-shop-product-sorter-on-footer', '==', 'true' )
						)

					)
				),

			// Product Category
				array(
					'name'	=> 'dt-woo-cat-archive',
					'title'	=> esc_html__('Category Archive', 'jannal'),
					'icon'  => 'fa fa-angle-double-right',
					'fields'=> array(

						array(
							'type'    => 'subheading',
							'content' => esc_html__( 'Category Archive Settings', 'jannal' ),
						),

						array(
							'id'         => 'dt-woo-category-archive-layout',
							'type'       => 'image_select',
							'title'      => esc_html__('Page Layout', 'jannal'),
							'options'    => $woo_page_layouts,
							'default'    => 'content-full-width',
							'attributes' => array( 'data-depend-id' => 'dt-woo-category-archive-layout' )
						),

						array(
							'id'         => 'dt-woo-category-archive-show-standard-sidebar',
							'type'       => 'switcher',
							'title'      => esc_html__('Show Standard Sidebar', 'jannal'),
							'dependency' => array( 'dt-woo-category-archive-layout', 'any', 'with-left-sidebar,with-right-sidebar' )
						),

						array(
							'id'         => 'dt-woo-category-archive-widgetareas',
							'type'       => 'select',
							'title'      => esc_html__('Choose Custom Widget Area', 'jannal'),
							'class'      => 'chosen',
							'options'    => jannal_custom_widgets(),
							'dependency' => array( 'dt-woo-category-archive-layout', 'any', 'with-left-sidebar,with-right-sidebar' ),
							'attributes' => array(
								'multiple'         => 'multiple',
								'data-placeholder' => esc_attr__('Select Widget Areas', 'jannal'),
								'style'            => 'width: 400px;'
							),
						),

						array(
							'id'      => 'dt-woo-category-archive-product-per-page',
							'type'    => 'number',
							'title'   => esc_html__('Products Per Page', 'jannal'),
							'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Number of products to show in product category archive page', 'jannal').'</span>',
							'default' => get_option( 'posts_per_page' ),
						),

						array(
							'id'      => 'dt-woo-category-archive-product-column',
							'type'    => 'image_select',
							'title'   => esc_html__('Product Layout', 'jannal'),
							'options' => array(
								1 => JANNAL_THEME_URI . '/cs-framework-override/images/one-column.png',
								2 => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
								3 => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
								4 => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png'
							),
							'default' => 4,
						),

				        array(
				          'id'         => 'dt-woo-category-product-style-template',
				          'type'       => 'select',
				          'title'      => esc_html__('Product Style Template', 'jannal'),
									'options'    => $product_style_templates_arr,
									'default'    => 0
								),

								array(
									'id'         => 'dt-woo-category-archive-enable-breadcrumb',
									'type'       => 'switcher',
									'title'      => esc_html__('Enable Breadcrumb', 'jannal'),
									'info'       => esc_html__('YES! to show breadcrumb on category archive page.', 'jannal'),
									'default'    => true
								)

					)
				),

			// Product Tag
				array(
					'name'	=> 'dt-woo-tag-archive',
					'title'	=> esc_html__('Tag Archive', 'jannal'),
					'icon'  => 'fa fa-angle-double-right',
					'fields'=> array(

						array(
							'type'    => 'subheading',
							'content' => esc_html__( 'Tag Archive Settings', 'jannal' ),
						),

						array(
							'id'         => 'dt-woo-tag-archive-layout',
							'type'       => 'image_select',
							'title'      => esc_html__('Page Layout', 'jannal'),
							'options'    => $woo_page_layouts,
							'default'    => 'content-full-width',
							'attributes' => array( 'data-depend-id' => 'dt-woo-tag-archive-layout' )
						),

						array(
							'id'         => 'dt-woo-tag-archive-show-standard-sidebar',
							'type'       => 'switcher',
							'title'      => esc_html__('Show Standard Sidebar', 'jannal'),
							'dependency' => array( 'dt-woo-tag-archive-layout', 'any', 'with-left-sidebar,with-right-sidebar' )
						),

						array(
							'id'         => 'dt-woo-tag-archive-widgetareas',
							'type'       => 'select',
							'title'      => esc_html__('Choose Custom Widget Area', 'jannal'),
							'class'      => 'chosen',
							'options'    => jannal_custom_widgets(),
							'dependency' => array( 'dt-woo-tag-archive-layout', 'any', 'with-left-sidebar,with-right-sidebar' ),
							'attributes' => array(
								'multiple'         => 'multiple',
								'data-placeholder' => esc_attr__('Select Widget Areas', 'jannal'),
								'style'            => 'width: 400px;'
							),
						),

						array(
							'id'      => 'dt-woo-tag-archive-product-per-page',
							'type'    => 'number',
							'title'   => esc_html__('Products Per Page', 'jannal'),
							'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Number of products to show in product tag archive page', 'jannal').'</span>',
							'default' => get_option( 'posts_per_page' ),
						),

						array(
							'id'      => 'dt-woo-tag-archive-product-column',
							'type'    => 'image_select',
							'title'   => esc_html__('Product Layout', 'jannal'),
							'options' => array(
								2 => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
								3 => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
								4 => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png'							
							),
							'default' => 4,
						),	

				        array(
				          'id'         => 'dt-woo-tag-product-style-template',
				          'type'       => 'select',
				          'title'      => esc_html__('Product Style Template', 'jannal'),
									'options'    => $product_style_templates_arr,
									'default'    => 0
								),

								array(
									'id'         => 'dt-woo-tag-archive-enable-breadcrumb',
									'type'       => 'switcher',
									'title'      => esc_html__('Enable Breadcrumb', 'jannal'),
									'info'       => esc_html__('YES! to show breadcrumb on tag archive page.', 'jannal'),
									'default'    => true
								)								

					)
				),

			// Product
				array(
					'name'   => 'dt-woo-single-product',
					'title'  => esc_html__('Product', 'jannal'),
					'icon'   => 'fa fa-angle-double-right',
					'fields' => array_merge ( 
						array(

							array(	
								'type'    => 'subheading',
								'content' => esc_html__( 'Single Product Page Default Settings', 'jannal' ),
							),

							array(
								'id'      => 'dt-single-product-default-template',
								'type'    => 'select',
								'title'   => esc_html__('Product Template', 'jannal'),
								'class'   => 'chosen',
								'options' => array(
									'woo-default'     => esc_html__( 'WooCommerce Default', 'jannal' ),
									'custom-template' => esc_html__( 'Custom Template', 'jannal' )
								),
								'default'    => 'woo-default',
								'info'       => esc_html__('Don\'t use product shortcodes in content area when "WooCommerce Default" template is chosen.', 'jannal')
							),

							array(
								'id'         => 'dt-single-product-default-layout',
								'type'       => 'image_select',
								'title'      => esc_html__('Page Layout', 'jannal'),
								'options'    => $woo_page_layouts,			
								'default'    => 'content-full-width',
								'attributes' => array( 'data-depend-id' => 'dt-single-product-default-layout' )
							),

							array(
								'id'         => 'dt-single-product-show-default-sidebar',
								'type'       => 'switcher',
								'title'      => esc_html__('Show Standard Sidebar', 'jannal'),
								'dependency' => array( 'dt-single-product-default-layout', 'any', 'with-left-sidebar,with-right-sidebar' )
							),

							array(
								'id'         => 'dt-single-product-widgetareas',
								'type'       => 'select',
								'title'      => esc_html__('Choose Custom Widget Area', 'jannal'),
								'class'      => 'chosen',
								'options'    => jannal_custom_widgets(),
								'dependency' => array( 'dt-single-product-default-layout', 'any', 'with-left-sidebar,with-right-sidebar' ),
								'attributes' => array(
									'multiple'         => 'multiple',
									'data-placeholder' => esc_attr__('Select Widget Areas', 'jannal'),
									'style'            => 'width: 400px;'
								),
							),

							array(
								'id'		 => 'dt-single-product-sale-countdown-timer',
								'type'		 => 'switcher',
								'title'		 => esc_html__('Enable Sale Countdown Timer', 'jannal'),
								'info'       => esc_html__('This option is applicable for "WooCommerce Default" template page only.', 'jannal')
							),

							array(
								'id'		 => 'dt-single-product-enable-size-guide',
								'type'		 => 'switcher',
								'title'		 => esc_html__('Enable Size Guide Button', 'jannal'),
								'info'       => esc_html__('This option is applicable for "WooCommerce Default" template page only.', 'jannal')
							),

							array(
								'id'		 => 'dt-single-product-enable-ajax-addtocart',
								'type'		 => 'switcher',
								'title'		 => esc_html__('Enable Ajax Add To Cart', 'jannal'),
								'info'       => esc_html__('If you wish, you can have ajax functionality in single page add to cart button.', 'jannal')
							),

							array(
								'id'         => 'dt-single-product-enable-breadcrumb',
								'type'       => 'switcher',
								'title'      => esc_html__('Enable Breadcrumb', 'jannal'),
								'info'       => esc_html__('YES! to show breadcrumb on single product page.', 'jannal'),
								'default' 	 => true
							),

							array(	
								'type'    => 'subheading',
								'content' => esc_html__( 'Single Page Upsell Products Settings', 'jannal' ),
							),
							
							array(
								'id'		 => 'dt-single-product-default-show-upsell',
								'type'		 => 'switcher',
								'title'		 => esc_html__('Show Upsell Products', 'jannal'),
								'default' 	 => true
							),

							array(
								'id'  		=> 'dt-single-product-upsell-title',
								'type'  	=> 'wysiwyg',
								'title' 	=> esc_html__('Upsell Title', 'jannal'),
								'default'	=> '<h2>'.esc_html__('You may also like&hellip;', 'jannal').'</h2>'
							),

							array(
								'id'      => 'dt-single-product-upsell-column',
								'type'    => 'image_select',
								'title'   => esc_html__('Upsell Column', 'jannal'),
								'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Select upsell products column layout', 'jannal').'</span>',
								'default' => 4,
								'options' => array(
									1 => JANNAL_THEME_URI . '/cs-framework-override/images/one-column.png',
									2 => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
									3 => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
									4 => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
								)
							),

							array(
								'id'      => 'dt-single-product-upsell-limit',
								'type'    => 'select',
								'title'   => esc_html__('Upsell Limit', 'jannal'),
								'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Select upsell products limit', 'jannal').'</span>',
								'default' => 4,
								'options' => array(
									1 => esc_html__( '1', 'jannal' ),
									2 => esc_html__( '2', 'jannal' ),
									3 => esc_html__( '3', 'jannal' ),
									4 => esc_html__( '4', 'jannal' ),
									5 => esc_html__( '5', 'jannal' ),
									6 => esc_html__( '6', 'jannal' ),
									7 => esc_html__( '7', 'jannal' ),
									8 => esc_html__( '8', 'jannal' ),	
									9 => esc_html__( '9', 'jannal' ),
									10 => esc_html__( '10', 'jannal' ),									
								)
							),

					        array(
					          'id'         => 'dt-woo-single-product-upsell-style-template',
					          'type'       => 'select',
					          'title'      => esc_html__('Product Style Template', 'jannal'),
										'options'    => $product_style_templates_arr,
										'default' 	 => 0,
					        ),

							array(	
								'type'    => 'subheading',
								'content' => esc_html__( 'Single Page Related Products Settings', 'jannal' ),
							),

							array(
								'id'    => 'dt-single-product-default-show-related',
								'type'  => 'switcher',
								'title' => esc_html__('Show Related Products', 'jannal'),
								'default' 	 => true
							),

							array(
								'id'      => 'dt-single-product-related-title',
								'type'    => 'wysiwyg',
								'title'   => esc_html__('Related Product Title', 'jannal'),
								'default' => '<h2>'.esc_html__('Related products', 'jannal').'</h2>'
							),

							array(
								'id'      => 'dt-single-product-related-column',
								'type'    => 'image_select',
								'title'   => esc_html__('Related Column', 'jannal'),
								'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Select related products column layout', 'jannal').'</span>',
								'default' => 4,
								'options' => array(
									2 => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
									3 => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
									4 => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
								)							
							),

							array(
								'id'      => 'dt-single-product-related-limit',
								'type'    => 'select',
								'title'   => esc_html__('Related Limit', 'jannal'),
								'after'   => '<span class="cs-text-desc">&nbsp;'.esc_html__('Select related products limit', 'jannal').'</span>',
								'default' => 4,
								'options' => array(
									1 => esc_html__( '1', 'jannal' ),
									2 => esc_html__( '2', 'jannal' ),
									3 => esc_html__( '3', 'jannal' ),
									4 => esc_html__( '4', 'jannal' ),
									5 => esc_html__( '5', 'jannal' ),
									6 => esc_html__( '6', 'jannal' ),
									7 => esc_html__( '7', 'jannal' ),
									8 => esc_html__( '8', 'jannal' ),	
									9 => esc_html__( '9', 'jannal' ),
									10 => esc_html__( '10', 'jannal' ),									
								)
							),

					        array(
					          'id'         => 'dt-woo-single-product-related-style-template',
					          'type'       => 'select',
					          'title'      => esc_html__('Product Style Template', 'jannal'),
										'options'    => $product_style_templates_arr,
										'default' 	 => 0,
					        ),

							array(	
								'type'    => 'subheading',
								'content' => esc_html__( 'Single Product Page Settings', 'jannal' ),
							),

							array(
								'id'    => 'dt-single-product-addtocart-sticky',
								'type'  => 'switcher',
								'title' => esc_html__('Sticky Add to Cart', 'jannal'),
							),

							array(
								'id'    => 'dt-single-product-show-360-viewer',
								'type'  => 'switcher',
								'title' => esc_html__('Show Product 360 Viewer', 'jannal'),
							),

							array(	
								'type'    => 'subheading',
								'content' => esc_html__( 'Sociables Share', 'jannal' ),
							),

							array(
								'id'    => 'dt-single-product-show-sharer-facebook',
								'type'  => 'switcher',
								'title' => esc_html__('Show Facebook Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-delicious',
								'type'  => 'switcher',
								'title' => esc_html__('Show Delicious Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-digg',
								'type'  => 'switcher',
								'title' => esc_html__('Show Digg Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-stumbleupon',
								'type'  => 'switcher',
								'title' => esc_html__('Show Stumble Upon Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-twitter',
								'type'  => 'switcher',
								'title' => esc_html__('Show Twitter Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-googleplus',
								'type'  => 'switcher',
								'title' => esc_html__('Show Google Plus Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-linkedin',
								'type'  => 'switcher',
								'title' => esc_html__('Show Linkedin Sharer', 'jannal'),
								'default' => true,
							),

							array(
								'id'    => 'dt-single-product-show-sharer-pinterest',
								'type'  => 'switcher',
								'title' => esc_html__('Show Pinterest Sharer', 'jannal'),
								'default' => true,
							),	

							array(	
								'type'    => 'subheading',
								'content' => esc_html__( 'Sociables Follow', 'jannal' ),
							),							

						),

						$social_follow_options

					)
				),
			
			// Size Guide
				array(
					'name'   => 'dt-woo-size-guides',
					'title'  => esc_html__( 'Size Guides', 'jannal' ),
					'icon'   => 'fa fa-angle-double-right',
					'fields' => array(
						array(
							'id'              => 'dt-woo-size-guides',
							'type'            => 'group',
							'title'           => esc_html__( 'Size Guides List', 'jannal' ),
							'button_title'    => esc_html__('Add New', 'jannal'),
							'accordion_title' => esc_html__('Add New Size Guide', 'jannal'),
							'fields'          => array(
								array(
									'id'    => 'title',
									'type'  => 'text',
									'title' => esc_html__('Title', 'jannal'),
								),
								array(
									'id'    => 'size-guide',
									'type'  => 'upload',
									'title' => esc_html__('Size Guide', 'jannal'),
								)
							)
						)
					)
				),
			
			// Product Style Templates
				array(
					'name'   => 'dt-woo-product-style-templates-holder',
					'title'  => esc_html__( 'Product Style Templates', 'jannal' ),
					'icon'   => 'fa fa-angle-double-right',
					'fields' => array(
						array(
							'id'              => 'dt-woo-product-style-templates',
							'type'            => 'group',
							'title'           => esc_html__( 'Product Style Templates', 'jannal' ),
							'button_title'    => esc_html__('Add New', 'jannal'),
							'accordion_title' => esc_html__('Add New Template', 'jannal'),
							'fields'          => array(

								array(
									'id'    => 'template-title',
									'type'  => 'text',
									'title' => esc_html__('Template Title', 'jannal'),
								),
								array(
									'id'         => 'product-style',
									'type'       => 'select',
									'title'      => esc_html__('Product Style', 'jannal'),
									'options'    => array(
														'product-style-default'              => esc_html__('Default', 'jannal'),
														'product-style-cornered'             => esc_html__('Cornered', 'jannal'),
														'product-style-title-eg-highlighter' => esc_html__('Title & Element Group Highlighter', 'jannal'),
														'product-style-content-highlighter'  => esc_html__('Content Highlighter', 'jannal'),
														'product-style-egrp-overlap-pc'      => esc_html__('Element Group Overlap Product Content', 'jannal'),
														'product-style-egrp-reveal-pc'       => esc_html__('Element Group Reveal Product Content', 'jannal'),
														'product-style-igrp-over-pc'         => esc_html__('Icon Group over Product Content', 'jannal'),
														'product-style-egrp-over-pc'         => esc_html__('Element Group over Product Content', 'jannal')
													),
									'default'    => 'product-style-default'
								),								

							// "Product Style" Hover Options

								array(
									'type'    => 'notice',
									'class'   => 'info',
									'content' => esc_html__('"Product Style" Hover Options.', 'jannal')
								),

								array(
									'id'         => 'product-hover-styles',
									'type'       => 'select',
									'title'      => esc_html__('Hover Styles', 'jannal'),
									'options'    => array(
														''                                        => esc_html__('None', 'jannal'),
														'product-hover-fade-border'               => esc_html__('Fade - Border', 'jannal'),
														'product-hover-fade-skinborder'           => esc_html__('Fade - Skin Border', 'jannal'),
														'product-hover-fade-gradientborder'       => esc_html__('Fade - Gradient Border', 'jannal'),
														'product-hover-fade-shadow'               => esc_html__('Fade - Shadow', 'jannal'),
														'product-hover-fade-inshadow'             => esc_html__('Fade - InShadow', 'jannal'),
														'product-hover-thumb-fade-border'         => esc_html__('Fade Thumb Border', 'jannal'),
														'product-hover-thumb-fade-skinborder'     => esc_html__('Fade Thumb SkinBorder', 'jannal'),
														'product-hover-thumb-fade-gradientborder' => esc_html__('Fade Thumb Gradient Border', 'jannal'),
														'product-hover-thumb-fade-shadow'         => esc_html__('Fade Thumb Shadow', 'jannal'),
														'product-hover-thumb-fade-inshadow'       => esc_html__('Fade Thumb InShadow', 'jannal')
													),
									'default'    => 'product-hover-fade-border'
								),

								array(
									'id'         => 'product-overlay-bgcolor',
									'type'       => 'color_picker',
									'title'      => esc_html__('Overlay Background Color', 'jannal')
								),

								array(
									'id'         => 'product-overlay-dark-bgcolor',
									'type'       => 'switcher',
									'title'      => esc_html__('Overlay Dark Background', 'jannal'),
								),

								array(
									'id'         => 'product-overlay-effects',
									'type'       => 'select',
									'title'      => esc_html__('Overlay Effects', 'jannal'),
									'options'    => array(
														''                                    => esc_html__('None', 'jannal'),
														'product-overlay-fixed'               => esc_html__('Fixed', 'jannal'),
														'product-overlay-toptobottom'         => esc_html__('Top to Bottom', 'jannal'),
														'product-overlay-bottomtotop'         => esc_html__('Bottom to Top', 'jannal'),
														'product-overlay-righttoleft'         => esc_html__('Right to Left', 'jannal'),
														'product-overlay-lefttoright'         => esc_html__('Left to Right', 'jannal'),
														'product-overlay-middle'              => esc_html__('Middle', 'jannal'),
														'product-overlay-middleradial'        => esc_html__('Middle Radial', 'jannal'),
														'product-overlay-gradienttoptobottom' => esc_html__('Gradient - Top to Bottom', 'jannal'),
														'product-overlay-gradientbottomtotop' => esc_html__('Gradient - Bottom to Top', 'jannal'),
														'product-overlay-gradientrighttoleft' => esc_html__('Gradient - Right to Left', 'jannal'),
														'product-overlay-gradientlefttoright' => esc_html__('Gradient - Left to Right', 'jannal'),
														'product-overlay-gradientradial'      => esc_html__('Gradient - Radial', 'jannal'),
														'product-overlay-flash'               => esc_html__('Flash', 'jannal'),
														'product-overlay-scale'               => esc_html__('Scale', 'jannal'),
														'product-overlay-horizontalelastic'   => esc_html__('Horizontal - Elastic', 'jannal'),
														'product-overlay-verticalelastic'     => esc_html__('Vertical - Elastic', 'jannal')
													),
									'default'    => ''
								),

								array(
									'id'         => 'product-hover-image-effects',
									'type'       => 'select',
									'title'      => esc_html__('Hover Image Effects', 'jannal'),
									'options'    => array(
														''                                => esc_html__('None', 'jannal'),
														'product-hover-image-blur'        => esc_html__('Blur', 'jannal'),
														'product-hover-image-blackwhite'  => esc_html__('Black & White', 'jannal'),
														'product-hover-image-fadeinleft'  => esc_html__('Fade In Left', 'jannal'),
														'product-hover-image-fadeinright' => esc_html__('Fade In Right', 'jannal'),
														'product-hover-image-rotate'      => esc_html__('Rotate', 'jannal'),
														'product-hover-image-rotatealt'   => esc_html__('Rotate - Alt', 'jannal'),
														'product-hover-image-scalein'     => esc_html__('Scale In', 'jannal'),
														'product-hover-image-scaleout'    => esc_html__('Scale Out', 'jannal'),
														'product-hover-image-floatout'    => esc_html__('Float Up', 'jannal')
													),
									'default'    => ''
								),

								array(
									'id'         => 'product-hover-secondary-image-effects',
									'type'       => 'select',
									'title'      => esc_html__('Hover Secondary Image Effects', 'jannal'),
									'options'    => array(
														'product-hover-secimage-fade'              => esc_html__('Fade', 'jannal'),
														'product-hover-secimage-zoomin'            => esc_html__('Zoom In', 'jannal'),
														'product-hover-secimage-zoomout'           => esc_html__('Zoom Out', 'jannal'),
														'product-hover-secimage-zoomoutup'         => esc_html__('Zoom Out Up', 'jannal'),
														'product-hover-secimage-zoomoutdown'       => esc_html__('Zoom Out Down', 'jannal'),
														'product-hover-secimage-zoomoutleft'       => esc_html__('Zoom Out Left', 'jannal'),
														'product-hover-secimage-zoomoutright'      => esc_html__('Zoom Out Right', 'jannal'),
														'product-hover-secimage-pushup'            => esc_html__('Push Up', 'jannal'),
														'product-hover-secimage-pushdown'          => esc_html__('Push Down', 'jannal'),
														'product-hover-secimage-pushleft'          => esc_html__('Push Left', 'jannal'),
														'product-hover-secimage-pushright'         => esc_html__('Push Right', 'jannal'),
														'product-hover-secimage-slideup'           => esc_html__('Slide Up', 'jannal'),
														'product-hover-secimage-slidedown'         => esc_html__('Slide Down', 'jannal'),
														'product-hover-secimage-slideleft'         => esc_html__('Slide Left', 'jannal'),
														'product-hover-secimage-slideright'        => esc_html__('Slide Right', 'jannal'),		
														'product-hover-secimage-hingeup'           => esc_html__('Hinge Up', 'jannal'),
														'product-hover-secimage-hingedown'         => esc_html__('Hinge Down', 'jannal'),
														'product-hover-secimage-hingeleft'         => esc_html__('Hinge Left', 'jannal'),
														'product-hover-secimage-hingeright'        => esc_html__('Hinge Right', 'jannal'),		
														'product-hover-secimage-foldup'            => esc_html__('Fold Up', 'jannal'),
														'product-hover-secimage-folddown'          => esc_html__('Fold Down', 'jannal'),
														'product-hover-secimage-foldleft'          => esc_html__('Fold Left', 'jannal'),
														'product-hover-secimage-foldright'         => esc_html__('Fold Right', 'jannal'),
														'product-hover-secimage-fliphoriz'         => esc_html__('Flip Horizontal', 'jannal'),
														'product-hover-secimage-flipvert'          => esc_html__('Flip Vertical', 'jannal')
													),
									'default'    => 'product-hover-secimage-fade'
								),

								array(
									'id'         => 'product-content-hover-effects',
									'type'       => 'select',
									'title'      => esc_html__('Content Hover Effects', 'jannal'),
									'options'    => array(
														''                                   => esc_html__('None', 'jannal'),
														'product-content-hover-fade'         => esc_html__('Fade', 'jannal'),
														'product-content-hover-zoom'         => esc_html__('Zoom', 'jannal'),
														'product-content-hover-slidedefault' => esc_html__('Slide Default', 'jannal'),
														'product-content-hover-slideleft'    => esc_html__('Slide From Left', 'jannal'),
														'product-content-hover-slideright'   => esc_html__('Slide From Right', 'jannal'),
														'product-content-hover-slidetop'     => esc_html__('Slide From Top', 'jannal'),
														'product-content-hover-slidebottom'  => esc_html__('Slide From Bottom', 'jannal')
													),
									'default'    => ''
								),

								array(
									'id'         => 'product-icongroup-hover-effects',
									'type'       => 'select',
									'title'      => esc_html__('Icon Group Hover Effects', 'jannal'),
									'options'    => array(
														''                               => esc_html__('None', 'jannal'),
														'product-icongroup-hover-flipx'  => esc_html__('Flip X', 'jannal'),
														'product-icongroup-hover-flipy'  => esc_html__('Flip Y', 'jannal'),
														'product-icongroup-hover-bounce' => esc_html__('Bounce', 'jannal')
													),
									'default'    => ''
								),

							// "Product Style" Common Options

								array(
									'type'    => 'notice',
									'class'   => 'info',
									'content' => esc_html__('"Product Style" Common Options.', 'jannal')
								),	
								array(
									'id'         => 'product-borderorshadow',
									'type'       => 'select',
									'title'      => esc_html__('Border or Shadow', 'jannal'),
									'options'    => array(
														''                              => esc_html__('None', 'jannal'),
														'product-borderorshadow-border' => esc_html__('Border', 'jannal'),
														'product-borderorshadow-shadow' => esc_html__('Shadow', 'jannal')
													),
									'default'    => '',
									'desc'      => esc_html__('Choose either Border or Shadow for your product listing.', 'jannal')
								),										
								array(
									'id'         => 'product-border-type',
									'type'       => 'select',
									'title'      => esc_html__('Border - Type', 'jannal'),
									'options'    => array(
														'product-border-type-default' => esc_html__('Default', 'jannal'),
														'product-border-type-thumb'   => esc_html__('Thumb', 'jannal')
													),
									'default'    => 'product-border-type-default',
								),													
								array(
									'id'         => 'product-border-position',
									'type'       => 'select',
									'title'      => esc_html__('Border - Position', 'jannal'),
									'options'    => array(
														'product-border-position-default'      => esc_html__('Default', 'jannal'),
														'product-border-position-left'         => esc_html__('Left', 'jannal'),
														'product-border-position-right'        => esc_html__('Right', 'jannal'),
														'product-border-position-top'          => esc_html__('Top', 'jannal'),
														'product-border-position-bottom'       => esc_html__('Bottom', 'jannal'),
														'product-border-position-top-left'     => esc_html__('Top Left', 'jannal'),
														'product-border-position-top-right'    => esc_html__('Top Right', 'jannal'),
														'product-border-position-bottom-left'  => esc_html__('Bottom Left', 'jannal'),
														'product-border-position-bottom-right' => esc_html__('Bottom Right', 'jannal')														
													),
									'default'    => 'product-border-position-default',
								),	
								array(
									'id'         => 'product-shadow-type',
									'type'       => 'select',
									'title'      => esc_html__('Shadow - Type', 'jannal'),
									'options'    => array(
														'product-shadow-type-default' => esc_html__('Default', 'jannal'),
														'product-shadow-type-thumb'   => esc_html__('Thumb', 'jannal')
													),
									'default'    => 'product-shadow-type-default',
								),
								array(
									'id'         => 'product-shadow-position',
									'type'       => 'select',
									'title'      => esc_html__('Shadow - Position', 'jannal'),
									'options'    => array(
														'product-shadow-position-default'      => esc_html__('Default', 'jannal'),
														'product-shadow-position-top-left'     => esc_html__('Top Left', 'jannal'),
														'product-shadow-position-top-right'    => esc_html__('Top Right', 'jannal'),
														'product-shadow-position-bottom-left'  => esc_html__('Bottom Left', 'jannal'),
														'product-shadow-position-bottom-right' => esc_html__('Bottom Right', 'jannal')
													),
									'default'    => 'product-shadow-position-default',
								),

								array(
									'id'         => 'product-bordershadow-highlight',
									'type'       => 'select',
									'title'      => esc_html__('Border / Shadow - Highlight', 'jannal'),
									'options'    => array(
														''                                       => esc_html__('None', 'jannal'),
														'product-bordershadow-highlight-default' => esc_html__('Default', 'jannal'),
														'product-bordershadow-highlight-onhover' => esc_html__('On Hover', 'jannal')
													),
									'default'    => '',
								),

								array(
									'id'         => 'product-background-bgcolor',
									'type'       => 'color_picker',
									'title'      => esc_html__('Background - Background Color', 'jannal')
								),

								array(
									'id'         => 'product-background-dark-bgcolor',
									'type'       => 'switcher',
									'title'      => esc_html__('Background - Dark Background', 'jannal')
								),
							
								array(
									'id'         => 'product-padding',
									'type'       => 'select',
									'title'      => esc_html__('Padding', 'jannal'),
									'options'    => array(
														'product-padding-default' => esc_html__('Default', 'jannal'),
														'product-padding-overall' => esc_html__('Product', 'jannal'),
														'product-padding-thumb'   => esc_html__('Thumb', 'jannal'),
														'product-padding-content' => esc_html__('Content', 'jannal'),
													),
									'default'    => 'product-padding-default'
								),
								array(
									'id'         => 'product-space',
									'type'       => 'select',
									'title'      => esc_html__('Space', 'jannal'),
									'options'    => array(
														'product-without-space' => esc_html__('False', 'jannal'),
														'product-with-space'  => esc_html__('True', 'jannal')
													),
									'default'    => 'product-with-space'
								),
								array(
									'id'         => 'product-display-type',
									'type'       => 'select',
									'title'      => esc_html__('Display Type', 'jannal'),
									'options'    => array(
														'grid' => esc_html__('Grid', 'jannal'),
														'list'  => esc_html__('List', 'jannal')
													),
									'default'    => 'grid'
								),
								array(
									'id'         => 'product-display-type-list-options',
									'type'       => 'select',
									'title'      => esc_html__('List Options', 'jannal'),
									'options'    => array(
														'left-thumb'  => esc_html__('Left Thumb', 'jannal'),
														'right-thumb' => esc_html__('Right Thumb', 'jannal')
													),
									'default'    => 'left-thumb'
								),	
								array(
									'id'         => 'product-show-labels',
									'type'       => 'select',
									'title'      => esc_html__('Show Product Labels', 'jannal'),
									'options'    => array(
														'true'  => esc_html__('True', 'jannal'),
														'false' => esc_html__('False', 'jannal')
													),
									'default'    => 'true'
								),															
								array(
									'id'         => 'product-label-design',
									'type'       => 'select',
									'title'      => esc_html__('Product Label Design', 'jannal'),
									'options'    => array(
														'product-label-boxed'      => esc_html__('Boxed', 'jannal'),
														'product-label-circle'  => esc_html__('Circle', 'jannal'),
														'product-label-rounded'   => esc_html__('Rounded', 'jannal'),
														'product-label-angular'   => esc_html__('Angular', 'jannal'),
														'product-label-ribbon'   => esc_html__('Ribbon', 'jannal'),
													),
									'default'    => 'product-label-boxed',
								),

								array(
									'id'         => 'product-custom-class',
									'type'       => 'text',
									'title'      => esc_html__('Custom Class', 'jannal')
								),	

							// "Product Style - Thumb" Options

								array(
									'type'    => 'notice',
									'class'   => 'info',
									'content' => esc_html__('"Product Style - Thumb" Options.', 'jannal')
								),

								array(
									'id'         => 'product-thumb-secondary-image-onhover',
									'type'       => 'switcher',
									'title'      => esc_html__('Show Secondary Image On Hover', 'jannal'),
									'desc'	 => esc_html__('YES! to show secondary image on product hover. First image in the gallery will be used as secondary image.', 'jannal')
								),

								array(
									'id'             => 'product-thumb-content',
									'type'           => 'sorter',
									'title'          => esc_html__('Content', 'jannal'),
									'default'        => array(
										'enabled'      => array(
											'title'          => esc_html__('Title', 'jannal'),
											'category'       => esc_html__('Category', 'jannal'),
											'price'          => esc_html__('Price', 'jannal'),
											'button_element' => esc_html__('Button Element', 'jannal'),
											'icons_group'    => esc_html__('Icons Group', 'jannal'),
										),
										'disabled'     => array(
											'excerpt'       => esc_html__('Excerpt', 'jannal'),
											'rating'        => esc_html__('Rating', 'jannal'),
											'countdown'     => esc_html__('Count Down', 'jannal'),
											'separator'     => esc_html__('Separator', 'jannal'),
											'element_group' => esc_html__('Element Group', 'jannal'),
											'swatches'      => esc_html__('Swatches', 'jannal'),
										),
									),
									'enabled_title'  => esc_html__('Active Elements', 'jannal'),
									'disabled_title' => esc_html__('Deatcive Elements', 'jannal'),
								),

								array(
									'id'         => 'product-thumb-alignment',
									'type'       => 'select',
									'title'      => esc_html__('Alignment', 'jannal'),
									'options'    => array(
														'product-thumb-alignment-top'          => esc_html__('Top', 'jannal'),
														'product-thumb-alignment-top-left'     => esc_html__('Top Left', 'jannal'),
														'product-thumb-alignment-top-right'    => esc_html__('Top Right', 'jannal'),
														'product-thumb-alignment-middle'       => esc_html__('Middle', 'jannal'),
														'product-thumb-alignment-bottom'       => esc_html__('Bottom', 'jannal'),
														'product-thumb-alignment-bottom-left'  => esc_html__('Bottom Left', 'jannal'),
														'product-thumb-alignment-bottom-right' => esc_html__('Bottom Right', 'jannal')
													),
									'default'    => 'product-thumb-alignment-top'
								),

								array(
									'id'         => 'product-thumb-iconsgroup-icons',
									'type'       => 'select',
									'title'      => esc_html__('Icons Group - Icons', 'jannal'),
									'options'    => array(
														'cart'      => esc_html__('Cart', 'jannal'),
														'wishlist'  => esc_html__('Wishlist', 'jannal'),
														'compare'   => esc_html__('Compare', 'jannal'),
														'quickview' => esc_html__('Quick View', 'jannal')
													),
									'class'         => 'chosen',
									'attributes'    => array(
										'multiple'    => 'multiple',
									),							
								),

								array(
									'id'         => 'product-thumb-iconsgroup-style',
									'type'       => 'select',
									'title'      => esc_html__('Icons Group - Style', 'jannal'),
									'options'    => array(
														'product-thumb-iconsgroup-style-simple'  => esc_html__('Simple', 'jannal'),
														'product-thumb-iconsgroup-style-bgfill-square'  => esc_html__('Background Fill Square', 'jannal'),
														'product-thumb-iconsgroup-style-bgfill-rounded-square' => esc_html__('Background Fill Rounded Square', 'jannal'),
														'product-thumb-iconsgroup-style-bgfill-rounded'  => esc_html__('Background Fill Rounded', 'jannal'),
														'product-thumb-iconsgroup-style-brdrfill-square'  => esc_html__('Border Fill Square', 'jannal'),
														'product-thumb-iconsgroup-style-brdrfill-rounded-square' => esc_html__('Border Fill Rounded Square', 'jannal'),
														'product-thumb-iconsgroup-style-brdrfill-rounded'  => esc_html__('Border Fill Rounded', 'jannal'),
														'product-thumb-iconsgroup-style-skinbgfill-square'  => esc_html__('Skin Background Fill Square', 'jannal'),
														'product-thumb-iconsgroup-style-skinbgfill-rounded-square' => esc_html__('Skin Background Fill Rounded Square', 'jannal'),
														'product-thumb-iconsgroup-style-skinbgfill-rounded'  => esc_html__('Skin Background Fill Rounded', 'jannal'),
														'product-thumb-iconsgroup-style-skinbrdrfill-square'  => esc_html__('Skin Border Fill Square', 'jannal'),
														'product-thumb-iconsgroup-style-skinbrdrfill-rounded-square' => esc_html__('Skin Border Fill Rounded Square', 'jannal'),
														'product-thumb-iconsgroup-style-skinbrdrfill-rounded'  => esc_html__('Skin Border Fill Rounded', 'jannal')																											
													),
									'default'    => 'product-thumb-iconsgroup-style-simple'
								),

								array(
									'id'         => 'product-thumb-iconsgroup-position',
									'type'       => 'select',
									'title'      => esc_html__('Icons Group - Position', 'jannal'),
									'options'    => array(

													''                                                                              => esc_html__('Default', 'jannal'),

													'product-thumb-iconsgroup-position-horizontal horizontal-position-top'          => esc_html__('Horizontal Top', 'jannal'),
													'product-thumb-iconsgroup-position-horizontal horizontal-position-top-left'     => esc_html__('Horizontal Top Left', 'jannal'),
													'product-thumb-iconsgroup-position-horizontal horizontal-position-top-right'    => esc_html__('Horizontal Top Right', 'jannal'),
													'product-thumb-iconsgroup-position-horizontal horizontal-position-middle'       => esc_html__('Horizontal Middle', 'jannal'),
													'product-thumb-iconsgroup-position-horizontal horizontal-position-bottom'       => esc_html__('Horizontal Bottom', 'jannal'),
													'product-thumb-iconsgroup-position-horizontal horizontal-position-bottom-left'  => esc_html__('Horizontal Bottom Left', 'jannal'),
													'product-thumb-iconsgroup-position-horizontal horizontal-position-bottom-right' => esc_html__('Horizontal Bottom Right', 'jannal'),

													'product-thumb-iconsgroup-position-vertical vertical-position-top-left'         => esc_html__('Vertical Top Left', 'jannal'),
													'product-thumb-iconsgroup-position-vertical vertical-position-top-right'        => esc_html__('Vertical Top Right', 'jannal'),
													'product-thumb-iconsgroup-position-vertical vertical-position-middle-left'      => esc_html__('Vertical Middle Left', 'jannal'),
													'product-thumb-iconsgroup-position-vertical vertical-position-middle-right'     => esc_html__('Vertical Middle Right', 'jannal'),
													'product-thumb-iconsgroup-position-vertical vertical-position-bottom-left'      => esc_html__('Vertical Bottom Left', 'jannal'),
													'product-thumb-iconsgroup-position-vertical vertical-position-bottom-right'     => esc_html__('Vertical Bottom Right', 'jannal')

												),
									'default'    => ''
								),

								array(
									'id'         => 'product-thumb-buttonelement-button',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Button', 'jannal'),
									'options'    => array(
														''          => esc_html__('None', 'jannal'),
														'cart'      => esc_html__('Cart', 'jannal'),
														'wishlist'  => esc_html__('Wishlist', 'jannal'),
														'compare'   => esc_html__('Compare', 'jannal'),
														'quickview' => esc_html__('Quick View', 'jannal')
													)
								),	

								array(
									'id'         => 'product-thumb-buttonelement-secondary-button',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Secondary Button', 'jannal'),
									'options'    => array(
														''          => esc_html__('None', 'jannal'),
														'cart'      => esc_html__('Cart', 'jannal'),
														'wishlist'  => esc_html__('Wishlist', 'jannal'),
														'compare'   => esc_html__('Compare', 'jannal'),
														'quickview' => esc_html__('Quick View', 'jannal')
													)
								),

								array(
									'id'         => 'product-thumb-buttonelement-style',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Style', 'jannal'),
									'options'    => array(
														'product-thumb-buttonelement-style-simple'  => esc_html__('Simple', 'jannal'),
														'product-thumb-buttonelement-style-bgfill-square'  => esc_html__('Background Fill Square', 'jannal'),
														'product-thumb-buttonelement-style-bgfill-rounded-square' => esc_html__('Background Fill Rounded Square', 'jannal'),
														'product-thumb-buttonelement-style-bgfill-rounded'  => esc_html__('Background Fill Rounded', 'jannal'),
														'product-thumb-buttonelement-style-brdrfill-square'  => esc_html__('Border Fill Square', 'jannal'),
														'product-thumb-buttonelement-style-brdrfill-rounded-square' => esc_html__('Border Fill Rounded Square', 'jannal'),
														'product-thumb-buttonelement-style-brdrfill-rounded'  => esc_html__('Border Fill Rounded', 'jannal'),
														'product-thumb-buttonelement-style-skinbgfill-square'  => esc_html__('Skin Background Fill Square', 'jannal'),
														'product-thumb-buttonelement-style-skinbgfill-rounded-square' => esc_html__('Skin Background Fill Rounded Square', 'jannal'),
														'product-thumb-buttonelement-style-skinbgfill-rounded'  => esc_html__('Skin Background Fill Rounded', 'jannal'),
														'product-thumb-buttonelement-style-skinbrdrfill-square'  => esc_html__('Skin Border Fill Square', 'jannal'),
														'product-thumb-buttonelement-style-skinbrdrfill-rounded-square' => esc_html__('Skin Border Fill Rounded Square', 'jannal'),
														'product-thumb-buttonelement-style-skinbrdrfill-rounded'  => esc_html__('Skin Border Fill Rounded', 'jannal')																
													),
									'default'    => 'product-thumb-buttonelement-style-simple'
								),

								array(
									'id'         => 'product-thumb-buttonelement-stretch',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Stretch', 'jannal'),
									'options'    => array(
														''                                    => esc_html__('False', 'jannal'),
														'product-thumb-buttonelement-stretch' => esc_html__('True', 'jannal')
													)
								),

								array(
									'id'             => 'product-thumb-element-group',
									'type'           => 'sorter',
									'title'          => esc_html__('Element Group Content', 'jannal'),
									'default'        => array(
										'enabled'      => array(
											'title' => esc_html__('Title', 'jannal'),
											'price' => esc_html__('Price', 'jannal')
										),
										'disabled'     => array(
											'cart'           => esc_html__('Cart', 'jannal'),
											'wishlist'       => esc_html__('Wishlist', 'jannal'),
											'compare'        => esc_html__('Compare', 'jannal'),
											'quickview'      => esc_html__('Quick View', 'jannal'),
											'category'       => esc_html__('Category', 'jannal'),
											'button_element' => esc_html__('Button Element', 'jannal'),
											'icons_group'    => esc_html__('Icons Group', 'jannal'),
											'excerpt'        => esc_html__('Excerpt', 'jannal'),
											'rating'         => esc_html__('Rating', 'jannal'),
											'separator'      => esc_html__('Separator', 'jannal'),
											'swatches'       => esc_html__('Swatches', 'jannal')
										),
									),
									'enabled_title'  => esc_html__('Active Elements', 'jannal'),
									'disabled_title' => esc_html__('Deatcive Elements', 'jannal'),
								),


							// "Product Style - Content" Options
								
								array(
									'type'    => 'notice',
									'class'   => 'info',
									'content' => esc_html__('"Product Style - Content" Options.', 'jannal')
								),

								array(
									'id'         => 'product-content-enable',
									'type'       => 'switcher',
									'title'      => esc_html__('Enable Content Section', 'jannal'),
									'desc'	 => esc_html__('YES! to enable content section.', 'jannal')
								),

								array(
									'id'             => 'product-content-content',
									'type'           => 'sorter',
									'title'          => esc_html__('Content', 'jannal'),
									'default'        => array(
										'enabled'      => array(
											'title'          => esc_html__('Title', 'jannal'),
											'category'       => esc_html__('Category', 'jannal'),
											'price'          => esc_html__('Price', 'jannal'),
											'button_element' => esc_html__('Button Element', 'jannal'),
											'icons_group'    => esc_html__('Icons Group', 'jannal'),
										),
										'disabled'     => array(
											'excerpt'       => esc_html__('Excerpt', 'jannal'),
											'rating'        => esc_html__('Rating', 'jannal'),
											'countdown'     => esc_html__('Count Down', 'jannal'),
											'separator'     => esc_html__('Separator', 'jannal'),
											'element_group' => esc_html__('Element Group', 'jannal'),
											'swatches'      => esc_html__('Swatches', 'jannal'),
										),
									),
									'enabled_title'  => esc_html__('Active Elements', 'jannal'),
									'disabled_title' => esc_html__('Deatcive Elements', 'jannal'),
								),

								array(
									'id'         => 'product-content-alignment',
									'type'       => 'select',
									'title'      => esc_html__('Alignment', 'jannal'),
									'options'    => array(
														'product-content-alignment-left'   => esc_html__('Left', 'jannal'),
														'product-content-alignment-right'  => esc_html__('Right', 'jannal'),
														'product-content-alignment-center' => esc_html__('Center', 'jannal')
													),
									'default'    => 'product-content-alignment-left'
								),

								array(
									'id'         => 'product-content-iconsgroup-icons',
									'type'       => 'select',
									'title'      => esc_html__('Icons Group - Icons', 'jannal'),
									'options'    => array(
														'cart'      => esc_html__('Cart', 'jannal'),
														'wishlist'  => esc_html__('Wishlist', 'jannal'),
														'compare'   => esc_html__('Compare', 'jannal'),
														'quickview' => esc_html__('Quick View', 'jannal')
													),
									'class'         => 'chosen',
									'attributes'    => array(
										'multiple'    => 'multiple',
									),							
								),

								array(
									'id'         => 'product-content-iconsgroup-style',
									'type'       => 'select',
									'title'      => esc_html__('Icons Group - Style', 'jannal'),
									'options'    => array(
														'product-content-iconsgroup-style-simple'  => esc_html__('Simple', 'jannal'),
														'product-content-iconsgroup-style-bgfill-square'  => esc_html__('Background Fill Square', 'jannal'),
														'product-content-iconsgroup-style-bgfill-rounded-square' => esc_html__('Background Fill Rounded Square', 'jannal'),
														'product-content-iconsgroup-style-bgfill-rounded'  => esc_html__('Background Fill Rounded', 'jannal'),
														'product-content-iconsgroup-style-brdrfill-square'  => esc_html__('Border Fill Square', 'jannal'),
														'product-content-iconsgroup-style-brdrfill-rounded-square' => esc_html__('Border Fill Rounded Square', 'jannal'),
														'product-content-iconsgroup-style-brdrfill-rounded'  => esc_html__('Border Fill Rounded', 'jannal'),
														'product-content-iconsgroup-style-skinbgfill-square'  => esc_html__('Skin Background Fill Square', 'jannal'),
														'product-content-iconsgroup-style-skinbgfill-rounded-square' => esc_html__('Skin Background Fill Rounded Square', 'jannal'),
														'product-content-iconsgroup-style-skinbgfill-rounded'  => esc_html__('Skin Background Fill Rounded', 'jannal'),
														'product-content-iconsgroup-style-skinbrdrfill-square'  => esc_html__('Skin Border Fill Square', 'jannal'),
														'product-content-iconsgroup-style-skinbrdrfill-rounded-square' => esc_html__('Skin Border Fill Rounded Square', 'jannal'),
														'product-content-iconsgroup-style-skinbrdrfill-rounded'  => esc_html__('Skin Border Fill Rounded', 'jannal')																													
													),
									'default'    => 'product-content-iconsgroup-style-simple'
								),

								array(
									'id'         => 'product-content-buttonelement-button',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Button', 'jannal'),
									'options'    => array(
														''          => esc_html__('None', 'jannal'),
														'cart'      => esc_html__('Cart', 'jannal'),
														'wishlist'  => esc_html__('Wishlist', 'jannal'),
														'compare'   => esc_html__('Compare', 'jannal'),
														'quickview' => esc_html__('Quick View', 'jannal')
													)
								),	

								array(
									'id'         => 'product-content-buttonelement-secondary-button',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Secondary Button', 'jannal'),
									'options'    => array(
														''          => esc_html__('None', 'jannal'),
														'cart'      => esc_html__('Cart', 'jannal'),
														'wishlist'  => esc_html__('Wishlist', 'jannal'),
														'compare'   => esc_html__('Compare', 'jannal'),
														'quickview' => esc_html__('Quick View', 'jannal')
													)
								),

								array(
									'id'         => 'product-content-buttonelement-style',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Style', 'jannal'),
									'options'    => array(
														'product-content-buttonelement-style-simple'  => esc_html__('Simple', 'jannal'),
														'product-content-buttonelement-style-bgfill-square'  => esc_html__('Background Fill Square', 'jannal'),
														'product-content-buttonelement-style-bgfill-rounded-square' => esc_html__('Background Fill Rounded Square', 'jannal'),
														'product-content-buttonelement-style-bgfill-rounded'  => esc_html__('Background Fill Rounded', 'jannal'),
														'product-content-buttonelement-style-brdrfill-square'  => esc_html__('Border Fill Square', 'jannal'),
														'product-content-buttonelement-style-brdrfill-rounded-square' => esc_html__('Border Fill Rounded Square', 'jannal'),
														'product-content-buttonelement-style-brdrfill-rounded'  => esc_html__('Border Fill Rounded', 'jannal'),
														'product-content-buttonelement-style-skinbgfill-square'  => esc_html__('Skin Background Fill Square', 'jannal'),
														'product-content-buttonelement-style-skinbgfill-rounded-square' => esc_html__('Skin Background Fill Rounded Square', 'jannal'),
														'product-content-buttonelement-style-skinbgfill-rounded'  => esc_html__('Skin Background Fill Rounded', 'jannal'),
														'product-content-buttonelement-style-skinbrdrfill-square'  => esc_html__('Skin Border Fill Square', 'jannal'),
														'product-content-buttonelement-style-skinbrdrfill-rounded-square' => esc_html__('Skin Border Fill Rounded Square', 'jannal'),
														'product-content-buttonelement-style-skinbrdrfill-rounded'  => esc_html__('Skin Border Fill Rounded', 'jannal')																													
													),
									'default'    => 'product-content-buttonelement-style-simple'
								),

								array(
									'id'         => 'product-content-buttonelement-stretch',
									'type'       => 'select',
									'title'      => esc_html__('Button Element - Stretch', 'jannal'),
									'options'    => array(
														''                                    => esc_html__('False', 'jannal'),
														'product-content-buttonelement-stretch' => esc_html__('True', 'jannal')
													)
								),

								array(
									'id'             => 'product-content-element-group',
									'type'           => 'sorter',
									'title'          => esc_html__('Element Group Content', 'jannal'),
									'default'        => array(
										'enabled'      => array(
											'title'          => esc_html__('Title', 'jannal'),
											'price'          => esc_html__('Price', 'jannal')
										),
										'disabled'     => array(
											'cart'           => esc_html__('Cart', 'jannal'),
											'wishlist'       => esc_html__('Wishlist', 'jannal'),
											'compare'        => esc_html__('Compare', 'jannal'),
											'quickview'      => esc_html__('Quick View', 'jannal'),
											'category'       => esc_html__('Category', 'jannal'),
											'button_element' => esc_html__('Button Element', 'jannal'),
											'icons_group'    => esc_html__('Icons Group', 'jannal'),
											'excerpt'        => esc_html__('Excerpt', 'jannal'),
											'rating'         => esc_html__('Rating', 'jannal'),
											'separator'      => esc_html__('Separator', 'jannal'),
											'swatches'       => esc_html__('Swatches', 'jannal')
										),
									),
									'enabled_title'  => esc_html__('Active Elements', 'jannal'),
									'disabled_title' => esc_html__('Deactive Elements', 'jannal')
								),

							
							),

							'default' => array (
														dt_sc_woo_default_product_settings()
												),							

						)					
					)
				),

			// Others
				array(
					'name'   => 'dt-woo-other-settings',
					'title'  => esc_html__('Others', 'jannal'),
					'icon'   => 'fa fa-angle-double-right',
					'fields' => array(

						array(	
							'type'    => 'subheading',
							'content' => esc_html__( 'Other Settings', 'jannal' ),
						),

						array(
							'id'    => 'dt-woo-quantity-plusnminus',
							'type'  => 'switcher',
							'title' => esc_html__('Enable Plus / Minus Button - Quantity', 'jannal'),
						),

						array(	
							'type'    => 'subheading',
							'content' => esc_html__( 'Cart Settings', 'jannal' ),
						),

						array(
							'id'         => 'dt-woo-addtocart-custom-action',
							'type'       => 'select',
							'title'      => esc_html__('Add To Cart Custom Action', 'jannal'),
							'options'    => array(
												''                    => esc_html__('None', 'jannal'),
												'sidebar_widget'      => esc_html__('Sidebar Widget', 'jannal'),
												'notification_widget' => esc_html__('Notification Widget', 'jannal'),
											),
							'default'    => '',
						),

						array(
							'id'      => 'dt-woo-cross-sell-column',
							'type'    => 'image_select',
							'title'   => esc_html__('Cross Sell Prodcut Column', 'jannal'),
							'options' => array(
								2 => JANNAL_THEME_URI . '/cs-framework-override/images/one-half-column.png',
								3 => JANNAL_THEME_URI . '/cs-framework-override/images/one-third-column.png',
								4 => JANNAL_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
							),
							'default' => 2,
						),

						array(
							'id'  		=> 'dt-cross-sell-title',
							'type'  	=> 'wysiwyg',
							'title' 	=> esc_html__('Cross Sell Title', 'jannal'),
							'default'	=> '<h2>You may be interested in&hellip;</h2>'
						),	
						
						array(
							'id'         => 'dt-woo-cross-sell-style-template',
							'type'       => 'select',
							'title'      => esc_html__('Product Style Template', 'jannal'),
							'options'    => $product_style_templates_arr
						),

					)
				),
		)
	);


CSFramework::instance( $settings, $options );