<?php
/*
 * Generates inline CSS from Customizer settings.
 */
if (!function_exists('hanio_get_customizer_css')) {
    function hanio_get_customizer_css()
    {
        ob_start();

        get_template_part('template-parts/header-variables');

        echo '#main-header {position: relative;}';
        echo '@media (min-width: 1200px) {#main-header {margin-bottom: -32px;} #site-footer {margin-top: 90px;}}';
        echo '@media (min-width: 576px) and (max-width: 1199px) {#site-footer {margin-top: 70px;}}';
        echo '@media (max-width: 575px) {#site-footer {margin-top: 50px;}}';
        echo '@media (min-width: 1200px) and (max-width: 1460px) {:root {zoom: 0.85;}}'; // Fix MacBook 13-inch viewport size.
        echo '#bg-header, #bg-footer {position: absolute; width: 100%; height: 100%; z-index: 1; top: 0;}';
        echo '#bg-footer {opacity: 0.6;}';
        echo '#header-wave {margin-bottom: -1px;}';
        echo '#magic-search .search-submit {display: none;}';
        echo '#footer-wave {margin-top: -1px; margin-bottom: -2px;}';
        echo '.onsale .onsale-svg {height: 100%;}';

        if (get_theme_mod('meta_cat_switcher', false)) {
            echo '.entry-categories {display: none;}';
        }

        if (get_theme_mod('meta_author_switcher', false)) {
            echo '.post-author {display: none;}';
        }

        if (get_theme_mod('meta_date_switcher', false)) {
            echo '.post-date {display: none;}';
        }

        if (get_theme_mod('meta_comm_switcher', false)) {
            echo '.post-comment-link {display: none;}';
        }

        if (get_theme_mod('meta_pr_cat_switcher', false)) {
            echo '.product_meta .posted_in {display: none;}';
        }

        return ob_get_clean();
    }
}