<?php
/**
 * Customizer settings for this theme.
 * @since Hanio 1.0
 */
if (!class_exists('hanio_Customize')) {
    /**
     * CUSTOMIZER SETTINGS
     */
    class hanio_Customize
    {

        /**
         * Register customizer options.
         *
         * @param WP_Customize_Manager $wp_customize Theme Customizer object.
         */
        public static function register($wp_customize)
        {
            /* ========================================================================= */
            /*
             * COLORS
             */

            // Primary color
            $wp_customize->add_setting('pr_color', array(
                'default' => '#f8ae4b',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary color', 'hanio'),
                'description' => esc_html__('Sets main accent color.', 'hanio'),
            )));


            // Primary hover color
            $wp_customize->add_setting('pr_h_color', array(
                'default' => '#000000',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary hover color', 'hanio'),
                'description' => esc_html__('Sets link hover color.', 'hanio'),
            )));


            // Primary background color
            $wp_customize->add_setting('pr_bg_color', array(
                'default' => '#fcf6f0',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary background color', 'hanio'),
                'description' => esc_html__("Changes header background and second accent colors. If there is no changing of the header color that means the current page uses Elementor builder’s header instead of the site's global, so you need to change the color on the page.", 'hanio'),
            )));


            // Header background color
            $wp_customize->add_setting('h_bg_color', array(
                'default' => '#FFF4E6',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'h_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Header background color', 'hanio'),
                'description' => esc_html__("Changes header background color.", 'hanio'),
            )));


            // Footer background color
            $wp_customize->add_setting('f_bg_color', array(
                'default' => '#FFF4E6',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'f_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Footer background color', 'hanio'),
                'description' => esc_html__("Changes footer background color.", 'hanio'),
            )));


            // Primary dark color
            $wp_customize->add_setting('pr_d_color', array(
                'default' => '#000000',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_d_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary dark color', 'hanio'),
                'description' => esc_html__('Sets text color in paragraphs.', 'hanio'),
            )));


            // h1 title color
            $wp_customize->add_setting('title_color', array(
                'default' => '#000000',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'title_color', array(
                'section' => 'colors',
                'label' => esc_html__('Title color', 'hanio'),
                'description' => esc_html__('Sets color for titles.', 'hanio'),
            )));


            // Footer widget title color
            $wp_customize->add_setting('fw_title_color', array(
                'default' => '#ffffff',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fw_title_color', array(
                'section' => 'colors',
                'label' => esc_html__('Footer widget title color', 'hanio'),
            )));


            // Header links hover color
            $wp_customize->add_setting('header_h_color', array(
                'default' => '#FFF4E6',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Header links hover color', 'hanio'),
            )));


            // Button background color 1
            $wp_customize->add_setting('btn_bg_color_1', array(
                'default' => '#FC6274',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_bg_color_1', array(
                'section' => 'colors',
                'label' => esc_html__('Button background first color', 'hanio'),
            )));


            // Button background color 2
            $wp_customize->add_setting('btn_bg_color_2', array(
                'default' => '#EC720F',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_bg_color_2', array(
                'section' => 'colors',
                'label' => esc_html__('Button background second color', 'hanio'),
            )));


            // Button hover color
            $wp_customize->add_setting('btn_h_color', array(
                'default' => '#f8ae4b',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Button hover color', 'hanio'),
            )));


            // Social icon text color
            $wp_customize->add_setting('social_icon_txt_color', array(
                'default' => '#ffffff',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_icon_txt_color', array(
                'section' => 'colors',
                'label' => esc_html__('Social icon color', 'hanio'),
            )));


            // Social icon background color
            $wp_customize->add_setting('social_icon_color', array(
                'default' => '#f8ae4b',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_icon_color', array(
                'section' => 'colors',
                'label' => esc_html__('Social icon circle background color', 'hanio'),
            )));


            // Social icon background hover color
            $wp_customize->add_setting('social_icon_h_color', array(
                'default' => '#EC720F',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_icon_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Social icon circle background hover color', 'hanio'),
            )));


            // Woocommerce price filter widget color
            $wp_customize->add_setting('woo_pr_fil_bg_color', array(
                'default' => '#f8ae4b',
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'woo_pr_fil_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Woocommerce price filter widget color', 'hanio'),
            )));


            // Text selection background color
            $wp_customize->add_setting('txt_select_bg_color', array(
                'default' => '#feebd4',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'txt_select_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Text selection background color', 'hanio'),
                'description' => esc_html__('Changes text selection background color. Try to select text on a page.', 'hanio'),
            )));


            // Price color
            $wp_customize->add_setting('price_color', array(
                'default' => '#000000',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'price_color', array(
                'section' => 'colors',
                'label' => esc_html__('Price color', 'hanio'),
                'description' => esc_html__('Sets color for price text on product tiles.', 'hanio'),
            )));


            // Color for title on product tile
            $wp_customize->add_setting('price_tile_color', array(
                'default' => '#000000',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'price_tile_color', array(
                'section' => 'colors',
                'label' => esc_html__('Product title color', 'hanio'),
                'description' => esc_html__('Sets color for title on product tile.', 'hanio'),
            )));


            // Color of sale badge
            $wp_customize->add_setting('sale_badge_bg_color', array(
                'default' => '#f8ae4b',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'sale_badge_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Color of sale badge', 'hanio'),
                'description' => esc_html__('Sets color of sale badge on product tile.', 'hanio'),
            )));


            // Cart count color
            $wp_customize->add_setting('cart_count_color', array(
                'default' => '#f8ae4b',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'cart_count_color', array(
                'section' => 'colors',
                'label' => esc_html__('Cart count color', 'hanio'),
                'description' => esc_html__('Sets background color for count badge on cart icon on the header. Add product to cart to see the badge.', 'hanio'),
            )));


            // Success icon color
            $wp_customize->add_setting('success_icon_color', array(
                'default' => '#f8ae4b',
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'success_icon_color', array(
                'section' => 'colors',
                'label' => esc_html__('Success icon color', 'hanio'),
                'description' => esc_html__('Sets icon color on success notice ✔', 'hanio'),
            )));


            /* end COLORS */
            /* ========================================================================= */
            /*
             * HEADER
             */

            $wp_customize->add_section('header', array(
                'title' => esc_html__('Header', 'hanio')
            ));


            // Switcher for enable address on the header
            $wp_customize->add_setting('h_address_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_address_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Enable address on the header?', 'hanio'),
                'type' => 'checkbox'
            ));


            // Address text
            $wp_customize->add_setting('h_address_text', array(
                'default' => esc_html__('25 W 51st St, New York, NY 10019', 'hanio'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_address_text', array(
                'section' => 'header',
                'label' => esc_html__('Address text.', 'hanio'),
                'description' => esc_html__('Field for business address.', 'hanio'),
                'type' => 'text'
            ));


            // Address link
            $wp_customize->add_setting('h_address_link', array(
                'default' => esc_html__('https://goo.gl/maps/XyANinc4EoxHZguc9', 'hanio'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_address_link', array(
                'section' => 'header',
                'label' => esc_html__('Address link.', 'hanio'),
                'description' => wp_kses((__('You can use any map service here, for example <a href="https://www.google.com/maps" target="_blank">Google Maps</a>, just find your place in Google Maps, copy link and put it to this field to set.', 'hanio')), 'link'),
                'type' => 'text'
            ));


            // Switcher for enable Call Us on the header
            $wp_customize->add_setting('h_call_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_call_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Enable Call Us on the header?', 'hanio'),
                'type' => 'checkbox'
            ));


            // Call phone number
            $wp_customize->add_setting('h_call_number', array(
                'default' => esc_html__('800.275.8777', 'hanio'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_call_number', array(
                'section' => 'header',
                'label' => esc_html__('Phone number.', 'hanio'),
                'description' => esc_html__('You can use any phone number format here e.g. 123-AWESOME-BUSINESS or +1 234 56 78.', 'hanio'),
                'type' => 'text'
            ));


            // Call text
            $wp_customize->add_setting('h_call_txt', array(
                'default' => esc_html__('Call Us', 'hanio'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_call_txt', array(
                'section' => 'header',
                'label' => esc_html__('Call Us text.', 'hanio'),
                'description' => esc_html__('Use any or default Call Us text (it also uses Call Us text if this field is blank).', 'hanio'),
                'type' => 'text'
            ));


            /* end HEADER */
            /* ========================================================================= */
            /*
             * FOOTER
             */

            $wp_customize->add_section('footer', array(
                'title' => esc_html__('Footer', 'hanio')
            ));

            // Switcher for Copyright text
            $wp_customize->add_setting('copyright_text_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('copyright_text_switcher', array(
                'section' => 'footer',
                'label' => esc_html__('Disable "Copyright" text before the year', 'hanio'),
                'type' => 'checkbox'
            ));

            // Custom copyright
            $wp_customize->add_setting('copyright_text', array(
                'default' => '',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('copyright_text', array(
                'section' => 'footer',
                'label' => esc_html__('Custom copyright text.', 'hanio'),
                'description' => esc_html__('Leave blank to use default copyright.', 'hanio'),
                'type' => 'text'
            ));

            /* end FOOTER */
            /* ========================================================================= */
            /*
             * TWEAKS
             */

            $wp_customize->add_section('tweaks', array(
                'title' => esc_html__('Tweaks', 'hanio')
            ));


            // Show/hide
            $wp_customize->add_setting('add_to_cart_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('add_to_cart_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable "Add to cart" button on product tiles', 'hanio'),
                'type' => 'checkbox'
            ));


            // Disable post category meta text
            $wp_customize->add_setting('meta_cat_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_cat_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post category meta text', 'hanio'),
                'type' => 'checkbox'
            ));


            // Disable post author meta text
            $wp_customize->add_setting('meta_author_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_author_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post author meta text', 'hanio'),
                'type' => 'checkbox'
            ));


            // Disable post date meta text
            $wp_customize->add_setting('meta_date_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_date_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post date meta text', 'hanio'),
                'type' => 'checkbox'
            ));

            // Disable post comments meta text
            $wp_customize->add_setting('meta_comm_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_comm_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post comments meta text', 'hanio'),
                'type' => 'checkbox'
            ));


            // Disable product category meta text
            $wp_customize->add_setting('meta_pr_cat_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));


            // Enable search an entire website, not just products
            $wp_customize->add_setting('search_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('search_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Enable search an entire website, not just products', 'hanio'),
                'type' => 'checkbox'
            ));


            /* end TWEAKS */
            /* ========================================================================= */


            /* -----------------------------*/
            /* end Customize Settings */
            /* -----------------------------*/
        }
    }


    // Setup the Theme Customizer settings and controls.
    add_action('customize_register', array('hanio_Customize', 'register'));

}