<?php

if (!class_exists('MAD_AJAX_SEARCH_MOD')) {

	class MAD_AJAX_SEARCH_MOD extends MAD_PLUGINS_CONFIG {

		function __construct() {

			if ( !defined( 'YITH_WCAS' ) ) { return; }

			if ( ! defined( 'MAD_ASSETS_IMAGES_URL' ) ) {
				define( 'MAD_ASSETS_IMAGES_URL', MAD_BASE_URI. 'images/' );
			}

			add_filter('yith_wcas_suggestion', array($this, 'wcas_suggestion'), 10, 2);
			add_action('wp_enqueue_scripts', array(&$this, 'ajax_search_enqueue_styles_scripts'), 1);
		}

		public function wcas_suggestion($values, $product) {
			$values['thumbnail'] = $product->get_image(array(60, 60));
			$values['sku'] = $product->get_sku();
			return $values;
		}

		public function ajax_search_enqueue_styles_scripts() {

			$basedir = basename(dirname(__FILE__));

			$frontend_js = self::assetExtendUrl('js/frontend.js', $basedir);
			$frontend_css = self::assetExtendUrl('css/yith_wcas_ajax_search.css', $basedir);
			$autocomplete_js = self::assetExtendUrl('js/devbridge-jquery-autocomplete.js', $basedir);

			wp_deregister_script('yith_wcas_jquery-autocomplete');
			wp_register_script('yith_wcas_jquery-autocomplete', $autocomplete_js, array('jquery'), '', true);

			wp_deregister_style('yith_wcas_frontend');
			wp_deregister_script('yith_wcas_frontend');
			wp_register_script('yith_wcas_frontend', $frontend_js, array('jquery'), '1.0', true);
			wp_enqueue_style( 'yith_wcas_frontend', $frontend_css );

		}

	}

}