<?php
/**
 * $Desc
 *
 * @version    $Id$
 * @package    wpbase
 * @author     WpOpal Team <opalwordpress@gmail.com>
 * @copyright  Copyright (C) 2016 http://www.wpopal.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * @website  http://www.wpopal.com
 * @support  http://www.wpopal.com/questions/
 */


extract( $atts );
$col = floor(12/$columns);
if( isset($woocategory) && !empty($woocategory) ){
    $categories = array_keys( wpopal_themer_autocomplete_options_helper($woocategory) );
}
if($categories && is_array($categories)): ?>
    <div class="opal-list-categories woocommerce <?php echo (($el_class!='')?' '.esc_attr( $el_class ):''); ?>">
        <div class="row">
            <?php foreach ($categories as $slug) : 
                $term = get_term_by( 'slug', $slug, 'product_cat' ); 
                if( empty($term) ){ return ; }
                $term_id = $term->term_id;
                $thumbnail_id = get_woocommerce_term_meta( $term_id, 'thumbnail_id', true );
                $image = wp_get_attachment_image_src( $thumbnail_id, 'full');
                $category_link = get_term_link( $term->term_id, 'product_cat' );?>
            
                <div class="col-md-<?php echo esc_attr($col); ?>">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="category-caption">
                                <h4>
                                    <span><?php echo trim($term->name); ?></span>
                                </h4>
                                <small><?php echo trim($term->count); ?> <?php esc_html_e( 'Products', 'flashshop' );?></small>
                            </div> 
                        </div>
                        <div class="col-md-6">
                            <?php if( $image ) : ?>
                            <div class="category-image">
                                <a href="<?php echo esc_url( $category_link ); ?>">
                                    <img class="hidden-sm" src="<?php echo esc_url_raw( $image[0] ); ?>" title="<?php echo esc_attr($term->name); ?>" style="max-width: 100%" alt="">
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div> <!-- /.col -->
        <?php endforeach; ?>
        </div> <!-- /.row -->
    </div> <!-- /.opal-list-categories -->
<?php endif; //check $categories?>
