<?php

$icon = $style = $class = $align = $css = $title_style = '';
$atts  = array_merge( array(
        'title'          => '',
        'subtitle'       => '',
        'style'          => '',
        'info'           => '',
        'box_wrap_class' => '',
        'show_image'     => '',
        'featured_image' => '',
    ), $atts); 
extract( $atts );

// size
if( isset( $atts['icon_size'] ) && !empty( $atts['icon_size'] ) ){
    $style .= 'font-size: '.$atts['icon_size'];
    if( is_numeric( $atts['icon_size'] ) )
        $style .= 'px;';
    else $style .= ';';
}

if( !empty( $atts['icon'] ) )
    $icon = '<i class="'.esc_attr($atts['icon']).'" style="'.trim($style).'"></i>';

$image_full_width = wp_get_attachment_image_src( $featured_image, 'full' );
$image_full = $image_full_width[0];
?>

<div class="feature-box feature-box-<?php echo esc_attr($style); ?> feature-box-<?php echo esc_attr($box_style); ?> <?php echo esc_attr($box_wrap_class) ?>">

    <?php if($show_image === 'yes'){ ?>
        <div class="fbox-img"><img src="<?php echo esc_url( $image_full ); ?>" alt="<?php echo trim($title); ?>"/></div>
    <?php } else { ?>
        <?php if(!empty($icon) || $icon){ ?>
            <div class="fbox-icon"><?php echo trim( $icon ); ?></div>
        <?php } ?>
    <?php } ?>

      <div class="fbox-content">  
         <div class="fbox-body"> 
            <h4 <?php echo trim( $title_style); ?>><?php echo trim($title); ?></h4> 
            <?php if( $subtitle ) { ?>
                <small><?php echo esc_html($subtitle); ?></small>  
            <?php } ?>                             
            
                                 
         </div>
         <?php if(trim($info)!=''){ ?>
           <div class="description"><?php echo trim( $info );?></div>  
         <?php } ?>
      </div>      
</div>
