<?php
	add_action('init', 'flashshop_element_kingcomposer_map', 99 );

	function flashshop_element_kingcomposer_map(){
		global $kc;

		$maps = array();
		
		
		// Featured Box
		$maps['element_featured_box'] =  array(
			'name' => esc_html__( 'Featured Box', 'flashshop' ),
			'title' => 'Featured Box',
			'icon' => 'kc-icon-icon',
			'category' => 'Elements',
			'wrapper_class' => 'clearfix',
			'description' => esc_html__( 'Featured box.', 'flashshop' ),
			'params' => array(
				array(
					'name' => 'show_image',
					'label' => 'Show Image ?',
					'type' => 'checkbox',
					'value' => 'no',
					'options' => array(
						'yes' => esc_html__('Yes, Please!', 'flashshop')
					),
					'description' => esc_html__('If you want more flexible options to display Image instead of icon', 'flashshop')
				),
				array(
					'name' => 'featured_image',
					'label' => 'Image',
					'type' => 'attach_image',
					'value' => '',
					'relation' => array(
						'parent' => 'show_image',
						'show_when' => 'yes'
					),
				),

			    array(
					'name'	      => 'icon',
					'label'	      => 'Select Icon',
					'type'	      => 'icon_picker',
					'admin_label' => true,
				),

				array(
					'name'	      => 'icon_size',
					'label'	      => 'Icon Size',
					'type'	      => 'text',
					'admin_label' => true,
					'description' => esc_html__('Enter the font-size of the icon such as: 15px, 1em, etc.', 'flashshop')
				),
				
				array(
					'name'	      => 'title',
					'label'	      => esc_html__('Title', 'flashshop'),
					'type'	      => 'text',
					'admin_label' => true,
					'description' => esc_html__('', 'flashshop')
				),
				

				array(
					'name'	      => 'subtitle',
					'label'	      => esc_html__('Sub Title', 'flashshop'),
					'type'	      => 'text',
					'admin_label' => true,
					'description' => esc_html__('', 'flashshop')
				),
				

				array(
					'name'	  => 'style',
					'label'   => esc_html__('Version', 'flashshop'), 
					'type'	  => 'select',
					'options' => array(
						'left' => esc_html__('Version left', 'flashshop'),
						'right' => esc_html__('Version right', 'flashshop'),
						'center' => esc_html__('Version center', 'flashshop')
					)
				),

				array(
					'name'	  => 'box_style',
					'label'   => esc_html__('Style', 'flashshop'), 
					'type'	  => 'select',
					'options' => array(
						'noborder' => esc_html__('Style noborder', 'flashshop'),
						'border' => esc_html__('Style border', 'flashshop')
					)
				),
				array(
					'name'	      => 'info',
					'label'	      => esc_html__('Information', 'flashshop'),
					'type'	      => 'textarea',
					'admin_label' => true,
					'description' => esc_html__('', 'flashshop')
				),
				
				array(
					'name'	        => 'box_wrap_class',
					'label'	        => 'Wrapper class name',
					'type'	        => 'text',
					'description'   => esc_html__('Enter class name for wrapper', 'flashshop'),
				),
             // end params
			)
		);

		$maps['element_block_heading'] =  array(

			"name"        => esc_html__("Block Heading", 'flashshop'),
			"class"       => "",
			"description" => esc_html__( 'Display Block Heading', 'flashshop' ),
			"category"    => esc_html__('Elements', 'flashshop'),
			"icon"        => 'kc-icon-title',
			"params"      => array(

	    	array(
				"type"        => "textfield",
				"label"       => esc_html__("Heading", 'flashshop'),
				"name"        => "heading",
				"value"       => '',
				"admin_label" => true
			),
			array(
				"type"        => "textfield",
				"label"       => esc_html__("Sub Heading", 'flashshop'),
				"name"        => "subheading",
				"value"       => '',
				"admin_label" => true
			),
			array(
				"type" => "select",
				"label" => esc_html__("Style", 'flashshop'),
				"name" => "style",
				'options' 	=> array( 
					'style-v1' => esc_html__('No style', 'flashshop'), 
					'style-v2' => esc_html__('Style left', 'flashshop'),
					'style-v3' => esc_html__('Style center', 'flashshop'),
					'style-v4' => esc_html__('Style Light center', 'flashshop'),
					'style-v5' => esc_html__('Style Light left', 'flashshop')
				),
			),
		  )
		);

		$kc->add_map_param(
			'element_blog_posts',				
				array(
					'name'	      => 'title',
					'label'	      => esc_html__('Title', 'flashshop'),
					'type'	      => 'text',
					'admin_label' => true,
					'description' => esc_html__('', 'flashshop')
				),
			1);
		
		$maps = apply_filters( 'flashshop_element_kingcomposer_map', $maps );
	    $kc->add_map( $maps );
	} // end class

function flashshop_fnc_woocommerce_element_kingcomposer_map(){

	global $kc;
	$maps = array();

	$product_categories_select = array( 'none'=> esc_html__('None', 'flashshop') );
		
	if( is_admin() ){
		$args = array(
			'type' => 'post',
			'child_of' => 0,
			'parent' => '',
			'orderby' => 'name',
			'order' => 'ASC',
			'hide_empty' => false,
			'hierarchical' => 1,
			'exclude' => '',
			'include' => '',
			'number' => '',
			'taxonomy' => 'product_cat',
			'pad_counts' => false,

		);

		$categories = get_categories( $args );
		wpopal_themer_woocommerce_getcategorychilds( 0, 0, $categories, 0, $product_categories_select );
	}
	//Grid product
		$maps['woo_grid_products'] =
			array(
                'name' => 'Grid Products',
                'description' => esc_html__('Display Bestseller, Latest, Most Review ... in grid', 'flashshop'),
                'icon' => 'sl-paper-plane',
                'category' => 'Woocommerce',

                'params' => array(
                	
                    array(
                        'name' => 'type',
                        'label' => 'Product Type',
                        'type' => 'select',
                        'admin_label' => true,
                        'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
					        'recent_products'   	=> esc_html__( 'Recent', 'flashshop' ),
					        'sale_products' 		=> esc_html__( 'On Sale', 'flashshop' ),
					        'featured_products' 	=> esc_html__( 'Featured', 'flashshop' ),
					        'best_selling_products'	=> esc_html__( 'Best Sellers', 'flashshop' ),
					        'products'				=> esc_html__( 'Products', 'flashshop' ),
					    )
                    ),
                    array(
						'type'           => 'autocomplete',
						'label'          => esc_html__( 'Select Category', 'flashshop' ),
						'name'           => 'woocategory',
						'description'    => esc_html__( 'Select Category to display', 'flashshop' ),
						'admin_label'    => true,
						'options' => array( 'category_name' => 'product_cat' )

                    ),
                    array(
                        'name' => 'layout',
                        'label' => 'Product layout',
                        'type' => 'select',
                        'admin_label' => true,
                        'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
					        'list_grid'   	=> esc_html__( 'Products List', 'flashshop' ),
					        'inner' 		=> esc_html__( 'Products Grid', 'flashshop' ),
					    )
                    ),

                    array(
                        'name' => 'per_page',
                        'label' => 'Number post show',
                        'type' => 'number_slider',
                        'options' => array(
                            'min' => 1,
                            'max' => 24,
                            'unit' => '',
                            'show_input' => true
                        ),
                        'description' => 'Display number of post'
                    ),
                    array(
                        'name' => 'columns',
                        'label' => esc_html__( 'Grid Column' , 'flashshop' ),
                        'type' => 'number_slider',
                        'options' => array(
                            'min' => 1,
                            'max' => 6,
                            'unit' => '',
                            'show_input' => true
                        ),
                        'description' => 'Display number of post'
                    ),
                )
	    );


		// List Categories
		$maps['woo_categories_list'] = 
				array(
	                'name' => 'Categories List',
	                'description' => esc_html__('Display List Categories and Couting Products', 'flashshop'),
	                'icon' => 'sl-paper-plane',
	                'category' => 'Woocommerce',

	                "params" => array(
			    
				    	 		array(
									'type'           => 'autocomplete',
									'label'          => esc_html__( 'Select Category', 'flashshop' ),
									'name'           => 'woocategory',
									'description'    => esc_html__( 'Select Category to display', 'flashshop' ),
									'admin_label'    => true,
									'options' => array( 'category_name' => 'product_cat' )

			                    ),
				    	 		array(
									'name' => 'show_image',
									'label' => 'Show Image ?',
									'type' => 'checkbox',
									'value' => 'no',
									'options' => array(
										'yes' => esc_html__('Yes, Please!', 'flashshop')
									),
								),
								array(
					                'name' => 'columns',
					                'label' => 'Columns',
					                'type' => 'number_slider',
					                'value' => '4',
				                        'options' => array(
				                            'min' => 1,
				                            'max' => 6,
				                            'unit' => '',
				                            'show_input' => true
				                        ),
				                    'description' => 'Display number column'
					            ),

								array(
									"type"        => "textfield",
									"label"     => esc_html__("Extra class name",'flashshop'),
									"name"  => "el_class",
									"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.",'flashshop')
								)
			   		) 
	              		 
	    );

		//products category tabs
		$maps['woo_products_category_tabs'] =
			array(
                'name' => 'Products Category Tabs',
                'description' => esc_html__('Display list product category tabs', 'flashshop'),
                'icon' => 'sl-paper-plane',
                'category' => 'Woocommerce',

                'params' => array(

                	array(
                        'name' => 'type',
                        'label' => 'Product Type',
                        'type' => 'select',
                        'admin_label' => true,
                        'value' => 'recent_products',
                        'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
					        'recent_products'   	=> esc_html__( 'Recent products', 'flashshop' ),
					        'sale_products' 		=> esc_html__( 'On Sale', 'flashshop' ),
					        'featured_products' 	=> esc_html__( 'Featured products', 'flashshop' ),
					        'best_selling_products'	=> esc_html__( 'Best Sellers', 'flashshop' ),
					        'products'				=> esc_html__( 'Products', 'flashshop' ),
					    )
                    ),
                	
                    array(
						'type'           => 'autocomplete',
						'label'          => esc_html__( 'Select Category', 'flashshop' ),
						'name'           => 'woocategory',
						'description'    => esc_html__( 'Select Category to display', 'flashshop' ),
						'admin_label'    => true,
						'options' => array( 'category_name' => 'product_cat' )

                    ),

                    array(
		                'name' => 'layout',
		                'label' => 'Product layout',
		                'type' => 'select',
		                'value' => 'carousel',
		                'admin_label' => true,
		                'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
					        'carousel'   	=> esc_html__( 'Products Carousel', 'flashshop' ),
					        'grid_list' 		=> esc_html__( 'Products Grid list', 'flashshop' ),
					    )
		            ),

		            array(
		                'name' => 'number',
		                'label' => 'Number products',
		                'type' => 'number_slider',
		                'value' => '8',
	                        'options' => array(
	                            'min' => 4,
	                            'max' => 20,
	                            'unit' => '',
	                            'show_input' => true
	                        ),
	                    'description' => 'Select number product to show (use for Product carousel)'
		            ),

		            array(
		                'name' => 'columns',
		                'label' => 'Columns',
		                'type' => 'number_slider',
		                'value' => '4',
	                        'options' => array(
	                            'min' => 1,
	                            'max' => 6,
	                            'unit' => '',
	                            'show_input' => true
	                        ),
	                    'description' => 'Display number column of post (use for Product carousel)'
		            ),
                )
	    );

			//add element

		$kc->add_map_param(
			'woo_carousel_products',				
				array(
	                'name' => 'layout',
	                'label' => 'Product layout',
	                'type' => 'select',
	                'admin_label' => true,
	                'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
				        'list_grid'   	=> esc_html__( 'Products List', 'flashshop' ),
				        'inner' 		=> esc_html__( 'Products Grid', 'flashshop' ),
				    )
	            ),
			3);

		$kc->add_map_param(
			'woo_carousel_products',				
				array(
	                'name' => '_rows',
	                'label' => 'Rows number',
	                'type' => 'number_slider',
	                'value' => '1',
                        'options' => array(
                            'min' => 1,
                            'max' => 4,
                            'unit' => '',
                            'show_input' => true
                        ),
                    'description' => 'Display number of post'
	            ),
			6);

		$kc->add_map_param(
			'woo_deal_products',				
				array(
                    'name' => 'layout',
                    'label' => 'Product layout',
                    'type' => 'select',
                    'admin_label' => true,
                    'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
				        'carousel'   	=> esc_html__( 'Products Carousel', 'flashshop' ),
				        'grid' 		=> esc_html__( 'Products Grid', 'flashshop' ),
				    )
                ),
			4);


		$maps = apply_filters( 'flashshop_fnc_woocommerce_element_kingcomposer_map', $maps );
	    $kc->add_map( $maps );
}

if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
	add_action('init', 'flashshop_fnc_woocommerce_element_kingcomposer_map', 99 );
}
function flashshop_kc_woo_carousel_products_add_map_param(){
	global $kc;	
	$kc->add_map(
         array(
            'woo_carousel_products_v2' => array(
                'name' => 'Carousel Products 2',
                'description' => esc_html__('Display Bestseller, Latest, Most Review ... in grid', 'flashshop'),
                'icon' => 'sl-paper-plane',
                'category' => 'Woocommerce',

                'params' => array(
                    	array(
                        'name' => 'type',
                        'label' => 'Product Type',
                        'type' => 'select',
                        'admin_label' => true,
                         'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
					        'recent_products'   	=> esc_html__( 'Recent Products', 'flashshop' ),
					        'sale_products' 		=> esc_html__( 'Sale Products', 'flashshop' ),
					        'featured_products' 	=> esc_html__( 'Featured Products', 'flashshop' ),
					        'best_selling_products'	=> esc_html__( 'Best Selling Products', 'flashshop' ),
					        'products'				=> esc_html__( 'Products', 'flashshop' ),
					    	)
                   	),
                     array(
						'type'           => 'autocomplete',
						'label'          => esc_html__( 'Select Category', 'flashshop' ),
						'name'           => 'woocategory',
						'description'    => esc_html__( 'Select Category to display', 'flashshop' ),
						'admin_label'    => true,
						'options' => array( 'taxonomy' => 'product_cat' )

                    ),

                    array(
                        'name' => 'number_post',
                        'label' => 'Number post show',
                        'type' => 'number_slider',
                        'options' => array(
                            'min' => 1,
                            'max' => 24,
                            'unit' => '',
                            'show_input' => true
                        ),
                        'description' => 'Display number of post'
                    ),

                    array(
                        'name' => 'number_per_post',
                        'label' => 'Number Per page  ',
                        'type' => 'number_slider',
                        'value' => 5,
                        'options' => array(
                            'min' => 1,
                            'max' => 11,
                            'unit' => '',
                            'show_input' => true
                        ),
                        'description' => 'Display the number product show on per page'
                    ),
                    array(
                        'name' => 'style',
                        'label' => 'Style Product',
                        'type' => 'select',
                        'value' => 'style-1',
                       	'options' => array(
					        		'style-1'   	=> esc_html__( '1 column product', 'flashshop' ),
					         	'style-2'   	=> esc_html__( '2 column product', 'flashshop' ),
					        	),
                        'description' => 'Select style for product'
                     ),
                )
            )
        )
    );	
}
if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
	add_action('init', 'flashshop_kc_woo_carousel_products_add_map_param', 99 );
}