<?php
/**
 * Remove javascript and css files not use
 */
if( is_admin() ){
	function flashshop_setup_admin_setting(){

		global $pagenow;
		if ( is_admin() && isset($_GET['activated'] ) && $pagenow == 'themes.php' ) {
			/**
			 *
			 */
			$pts = array( 'brands', 'footer', 'megamenu', 'testimonials', 'portfolio');

			$options = array();

			foreach( $pts as $key ){
				$options['enable_'.$key] = 'on';
			}

			update_option( 'wpopal_themer_posttype', $options );

			do_action( 'flashshop_setup_theme_actived' );
		}
	}
	add_action( 'init', 'flashshop_setup_admin_setting'  );
}


/**
 * Hoo to top bar layout
 */
function flashshop_fnc_topbar_layout(){
	$layout = flashshop_fnc_get_header_layout();
	get_template_part( 'page-templates/parts/topbar', $layout );
	get_template_part( 'page-templates/parts/topbar', 'mobile' );
}

add_action( 'flashshop_template_header_before', 'flashshop_fnc_topbar_layout' );

/**
 * Hook to select header layout for archive layout
 */
function flashshop_fnc_get_header_layout( $layout='' ){
	global $post;

	$layout = $post && get_post_meta( $post->ID, 'flashshop_header_layout', 1 ) ? get_post_meta( $post->ID, 'flashshop_header_layout', 1 ) : flashshop_fnc_theme_options( 'headerlayout' );

 	if( $layout == 'default' ){
 		return '';
 	}elseif( $layout){
 		return trim( $layout );
 	}elseif ( $layout = flashshop_fnc_theme_options('header_skin','') ){
 		return trim( $layout );
 	}

	return $layout;
}

add_filter( 'flashshop_fnc_get_header_layout', 'flashshop_fnc_get_header_layout' );

/**
 * Hook to select header layout for archive layout
 */
function flashshop_fnc_get_footer_profile( $profile='default' ){

	global $post;

	$profile =  $post? get_post_meta( $post->ID, 'flashshop_footer_profile', 1 ):null ;

 	if ( $profile && $profile != 'global' ) {
 		return trim( $profile );
 	} elseif ( $profile = flashshop_fnc_theme_options('footer-style', $profile ) ) {
 		return trim( $profile );
 	}

	return $profile;
}

add_filter( 'flashshop_fnc_get_footer_profile', 'flashshop_fnc_get_footer_profile' );


/**
 * Hook to show breadscrumbs
 */
function flashshop_fnc_render_breadcrumbs(){

	global $post;

	if( is_object($post) ){
		$disable = get_post_meta( $post->ID, 'flashshop_disable_breadscrumb', 1 );
		if(  $disable || is_front_page() ){
			return true;
		}
		$bgimage = get_post_meta( $post->ID, 'flashshop_image_breadscrumb', 1 );
		$color 	 = get_post_meta( $post->ID, 'flashshop_color_breadscrumb', 1 );
		$bgcolor = get_post_meta( $post->ID, 'flashshop_bgcolor_breadscrumb', 1 );
		$style = array();

		if( $bgcolor  ){
			$style[] = 'background-color:'.$bgcolor;
		}

		if( $bgimage  ){
			$style[] = 'background-image:url(\''.wp_get_attachment_url($bgimage).'\')';
		}else{
			$bgimage = flashshop_fnc_theme_options( 'breadcrumb-bg' );
			$style[] =  $bgimage  ? 'background-image:url(\''.$bgimage.'\')' : "";
		}

		if( $color  ){
			$style[] = 'color:'.$color;
		}

		$estyle = !empty($style)? 'style="'.implode(";", $style).'"':"";
	} else {

		$bgimage = flashshop_fnc_theme_options( 'breadcrumb-bg' );
		if( !empty($bgimage)  ){
			$style[] = 'background-image:url(\''.$bgimage.'\')';
		}
		$estyle = !empty($style)? 'style="'.implode(";", $style).'"':"";
	}

	echo '<section id="opal-breadscrumb" class="opal-breadscrumb" '.$estyle.'><div class="container">';
			flashshop_fnc_breadcrumbs();
	echo '</div></section>';

}

add_action( 'flashshop_template_main_before', 'flashshop_fnc_render_breadcrumbs' );


/**
 * Main Container
 */

function flashshop_template_main_container_class( $class ){
	global $post;
	global $flashshop_wpopconfig;

	$layoutcls = get_post_meta( $post->ID, 'flashshop_enable_fullwidth_layout', 1 );

	if( $layoutcls ) {
		$flashshop_wpopconfig['layout'] = 'fullwidth';
		return 'container-fluid';
	}
	return $class;
}
add_filter( 'flashshop_template_main_container_class', 'flashshop_template_main_container_class', 1 , 1  );
add_filter( 'flashshop_template_main_content_class', 'flashshop_template_main_container_class', 1 , 1  );



/**
 * Get Configuration for Page Layout
 *
 */
function flashshop_fnc_get_page_sidebar_configs( $configs='' ){

	global $post;

	$left  =  get_post_meta( $post->ID, 'flashshop_leftsidebar', 1 );
	$right =  get_post_meta( $post->ID, 'flashshop_rightsidebar', 1 );

	return flashshop_fnc_get_layout_configs( $left, $right );
}

add_filter( 'flashshop_fnc_get_page_sidebar_configs', 'flashshop_fnc_get_page_sidebar_configs', 1, 1 );

function flashshop_fnc_get_single_sidebar_configs($configs = '') {

    $layout = flashshop_fnc_theme_options( 'blog-single-layout' );
    $left = flashshop_fnc_theme_options( 'blog-single-left-sidebar' );
    $right = flashshop_fnc_theme_options( 'blog-single-right-sidebar' );

    return flashshop_fnc_get_layout_configs( $left, $right, $layout );
}

add_filter( 'flashshop_fnc_get_single_sidebar_configs', 'flashshop_fnc_get_single_sidebar_configs', 1, 1 );

function flashshop_fnc_get_archive_sidebar_configs( $configs='' ){

	global $post;

	$layout = flashshop_fnc_theme_options( 'blog-archive-layout' );
	$left  =  flashshop_fnc_theme_options( 'blog-archive-left-sidebar' );
	$right =  flashshop_fnc_theme_options( 'blog-archive-right-sidebar' );

	return flashshop_fnc_get_layout_configs( $left, $right,$layout );
}

add_filter( 'flashshop_fnc_get_archive_sidebar_configs', 'flashshop_fnc_get_archive_sidebar_configs', 1, 1 );
add_filter( 'flashshop_fnc_get_category_sidebar_configs', 'flashshop_fnc_get_archive_sidebar_configs', 1, 1 );

/**
 *
 */
function flashshop_fnc_get_layout_configs( $left, $right, $layout = null ){
	$configs = array();
	$configs['main'] = array( 'class' => 'col-lg-9 col-md-9' );
	
	$left =  isset($_GET['sidebar_left']) ? $_GET['sidebar_left'] : $left;
	$left = is_active_sidebar( $left ) ? $left : "";
	$right =  isset($_GET['sidebar_right']) ? $_GET['sidebar_right'] : $right;
	$right = is_active_sidebar( $right ) ? $right : "";
	$layout = isset($_GET['sidebar_main']) ? $_GET['sidebar_main'] : $layout;

	if($layout && $layout == 'leftmain'){
		$configs['sidebars'] = array( 
			'left'  => array( 'sidebar' => $left, 'active' => 1, 'class' => 'col-lg-3 col-md-3 col-sm-12'  ),
			'right' => array( 'sidebar' => $right, 'active' => 0, 'class' => '' ) 
		); 
	}elseif($layout && $layout == 'mainright'){
		$configs['sidebars'] = array( 
			'left'  => array( 'sidebar' => $left, 'active' => 0, 'class' => ''  ),
			'right' => array( 'sidebar' => $right, 'active' => 1, 'class' => 'col-lg-3 col-md-3 col-sm-12' ) 
		); 
	}elseif($layout && $layout == 'leftmainright'){
		$configs['sidebars'] = array( 
			'left'  => array( 'sidebar' => $left, 'active' => 1, 'class' => 'col-lg-3 col-md-3 col-sm-12'  ),
			'right' => array( 'sidebar' => $right, 'active' => 1, 'class' => 'col-lg-3 col-md-3 col-sm-12' ) 
		);
		$configs['main'] = array( 'class' => 'col-lg-6 col-md-6' ); 

	}else{
		$configs['sidebars'] = array( 
			'left'  => array( 'sidebar' => $left, 'active' => 0, 'class' => ''  ),
			'right' => array( 'sidebar' => $right, 'active' => 0, 'class' => '' ) 
		);
		$configs['main'] = array( 'class' => 'col-lg-12 col-md-12' ); 
	}
	return $configs;  
}


function flashshop_fnc_sidebars_others_configs(){

	global $flashshop_page_layouts;

	return $flashshop_page_layouts;
}

add_filter("flashshop_fnc_sidebars_others_configs", "flashshop_fnc_sidebars_others_configs");