<?php

function flashshop_fnc_import_remote_demos() {
   $sample_packages = wp_remote_get( 'http://wpsampledemo.com/flashshop/package.json');
   if ( is_wp_error( $sample_packages ) ) {
      if ( $return ) {
         return false;
      }

      wp_send_json_error( esc_html__('Failed to retrieve available sample data packages.', 'flashshop' ) );
   }
   $sample_packages = $sample_packages['body'];
   $obj = json_decode($sample_packages);
   $packages = $obj->package;
   $package_r = array();
   for ($i = 0 ;$i < count($packages);$i++) {
      $package_r[$packages[$i]->name] = array(
            'name'      => $packages[$i]->name,
            'source' => $packages[$i]->source,
            'preview'   => $packages[$i]->preview
      );
   }
   return $package_r;
}

add_filter( 'wpopal_themer_import_remote_demos', 'flashshop_fnc_import_remote_demos' );



function flashshop_fnc_import_theme() {
	return  'flashshop';
}
add_filter( 'wpopal_themer_import_theme', 'flashshop_fnc_import_theme' );

function flashshop_fnc_import_demos() {
	$folderes = glob( get_template_directory() .'/inc/import/*', GLOB_ONLYDIR );

	$output = array();

	foreach( $folderes as $folder ){
		$output[basename( $folder )] = basename( $folder );
	}

 	return $output;
}
add_filter( 'wpopal_themer_import_demos', 'flashshop_fnc_import_demos' );

function flashshop_fnc_import_types() {
	return array(
			'all' => 'All',
			'content' => 'Content',
			'widgets' => 'Widgets',
			'page_options' => 'Theme + Page Options',
			'menus' => 'Menus',
			'rev_slider' => 'Revolution Slider',
			'vc_templates' => 'VC Templates'
		);
}
add_filter( 'wpopal_themer_import_types', 'flashshop_fnc_import_types' );


/**
 * Matching and resizing images with url.
 *
 *  $ouput = array(
 *        'allowed' => 1, // allow resize images via using GD Lib php to generate image
 *        'height'  => 900,
 *        'width'   => 800,
 *        'file_name' => 'blog_demo.jpg'
 *   );
 */
function flashshop_import_attachment_image_size( $url ){

   $name = basename( $url );

   $ouput = array(
         'allowed' => 0
   );

   if( preg_match("#product#", $name) ) {
      $ouput = array(
         'allowed' => 1,
         'height'  => 542,
         'width'   => 610,
         'file_name' => 'product_demo.jpg'
      );
   }
   elseif( preg_match("#blog#", $name) || preg_match("#news-#", $name) || preg_match("#612YntpjodL#", $name) ){
      $ouput = array(
         'allowed' => 1,
         'height'  => 608,
         'width'   => 940,
         'file_name' => 'blog_demo.jpg'
      );
   }
   elseif( preg_match("#portfolio#", $name) ){
      $ouput = array(
         'allowed' => 1,
         'height'  => 750,
         'width'   => 1125,
         'file_name' => 'portfolio_demo.png'
      );
   }
   

   return $ouput;
}

add_filter( 'pbrthemer_import_attachment_image_size', 'flashshop_import_attachment_image_size' , 1 , 999 );
