<?php
/**
 * mode Customizer support
 *
 * @package WpOpal
 * @subpackage flashshop
 * @since flashshop 1.0
 */
//Update logo wordpress 4.5
if (version_compare($GLOBALS['wp_version'], '4.5', '>=')) {
    function flashshop_fnc_setup_logo()
    {
        add_theme_support('custom-logo');
    }

    add_action('after_setup_theme', 'flashshop_fnc_setup_logo');
}
if ( ! function_exists( 'flashshop_fnc_customize_register' ) ) :
function flashshop_fnc_customize_register($wp_customize){
    $wp_customize->remove_section('colors');

    // Add Panel Colors
    $wp_customize->add_panel('colors', array(
        'priority' => 15,
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => esc_html__('Colors', 'flashshop'),
    ));
    /* OpalTool: inject code */
    
    // Primary Color
    $wp_customize->add_section('flashshop_main_color', array(
        'title'      => esc_html__('Main Color', 'flashshop'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));
    $wp_customize->add_setting('flashshop_maincolor_primary_color', array(
        'default'    => get_option('flashshop_maincolor_primary_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control header_bg
    $wp_customize->add_control('flashshop_maincolor_primary_color', array(
        'label'    => esc_html__('Primary Color', 'flashshop'),
        'section'  => 'flashshop_main_color',
        'type'      => 'color',
    ) );/* OpalTool: end inject code */
        // Add Section header
    $wp_customize->add_section('flashshop_color_header', array(
        'title'      => esc_html__('Header', 'flashshop'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting topbar_bg
    $wp_customize->add_setting('flashshop_color_topbar_bg', array(
        'default'    => get_option('flashshop_color_topbar_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control topbar_bg
    $wp_customize->add_control('flashshop_color_topbar_bg', array(
        'label'    => esc_html__('Topbar Background', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add setting topbar_color
    $wp_customize->add_setting('flashshop_color_topbar_color', array(
        'default'    => get_option('flashshop_color_topbar_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control topbar_color
    $wp_customize->add_control('flashshop_color_topbar_color', array(
        'label'    => esc_html__('Topbar color', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add setting header_bg
    $wp_customize->add_setting('flashshop_color_header_bg', array(
        'default'    => get_option('flashshop_color_header_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control header_bg
    $wp_customize->add_control('flashshop_color_header_bg', array(
        'label'    => esc_html__('Header Background', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add setting cart_bg
    $wp_customize->add_setting('flashshop_color_cart_bg', array(
        'default'    => get_option('flashshop_color_cart_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control cart_bg
    $wp_customize->add_control('flashshop_color_cart_bg', array(
        'label'    => esc_html__('Cart Background', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add setting cart_color
    $wp_customize->add_setting('flashshop_color_cart_color', array(
        'default'    => get_option('flashshop_color_cart_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control cart_color
    $wp_customize->add_control('flashshop_color_cart_color', array(
        'label'    => esc_html__('Cart color', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add setting menu_background
    $wp_customize->add_setting('flashshop_color_menu_background', array(
        'default'    => get_option('flashshop_color_menu_background'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control menu_background
    $wp_customize->add_control('flashshop_color_menu_background', array(
        'label'    => esc_html__('Megamenu Background', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add setting menu_color
    $wp_customize->add_setting('flashshop_color_menu_color', array(
        'default'    => get_option('flashshop_color_menu_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control menu_color
    $wp_customize->add_control('flashshop_color_menu_color', array(
        'label'    => esc_html__('Megamenu color', 'flashshop'),
        'section'  => 'flashshop_color_header',
        'type'      => 'color',
    ) );
    // Add Section single_product
    $wp_customize->add_section('flashshop_color_single_product', array(
        'title'      => esc_html__('Single Product', 'flashshop'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting breadcrumb_color
    $wp_customize->add_setting('flashshop_color_breadcrumb_color', array(
        'default'    => get_option('flashshop_color_breadcrumb_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control breadcrumb_color
    $wp_customize->add_control('flashshop_color_breadcrumb_color', array(
        'label'    => esc_html__('Breadcrumb Color', 'flashshop'),
        'section'  => 'flashshop_color_single_product',
        'type'      => 'color',
    ) );
    // Add setting breadcrumb_active_color
    $wp_customize->add_setting('flashshop_color_breadcrumb_active_color', array(
        'default'    => get_option('flashshop_color_breadcrumb_active_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control breadcrumb_active_color
    $wp_customize->add_control('flashshop_color_breadcrumb_active_color', array(
        'label'    => esc_html__('Breadcrumb Active Color', 'flashshop'),
        'section'  => 'flashshop_color_single_product',
        'type'      => 'color',
    ) );
    // Add setting product_name_color
    $wp_customize->add_setting('flashshop_color_product_name_color', array(
        'default'    => get_option('flashshop_color_product_name_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control product_name_color
    $wp_customize->add_control('flashshop_color_product_name_color', array(
        'label'    => esc_html__('Product Name Color', 'flashshop'),
        'section'  => 'flashshop_color_single_product',
        'type'      => 'color',
    ) );
    // Add setting product_price_color
    $wp_customize->add_setting('flashshop_color_product_price_color', array(
        'default'    => get_option('flashshop_color_product_price_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control product_price_color
    $wp_customize->add_control('flashshop_color_product_price_color', array(
        'label'    => esc_html__('Product Price Color', 'flashshop'),
        'section'  => 'flashshop_color_single_product',
        'type'      => 'color',
    ) );
    // Add setting product_pricesale_color
    $wp_customize->add_setting('flashshop_color_product_pricesale_color', array(
        'default'    => get_option('flashshop_color_product_pricesale_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control product_pricesale_color
    $wp_customize->add_control('flashshop_color_product_pricesale_color', array(
        'label'    => esc_html__('Product Price Sale Color', 'flashshop'),
        'section'  => 'flashshop_color_single_product',
        'type'      => 'color',
    ) );
    // Add Section footer
    $wp_customize->add_section('flashshop_color_footer', array(
        'title'      => esc_html__('Footer', 'flashshop'),
        'transport'  => 'postMessage',
        'priority'   => 10,
        'panel'      => 'colors'
    ));    // Add setting footer_bg
    $wp_customize->add_setting('flashshop_color_footer_bg', array(
        'default'    => get_option('flashshop_color_footer_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control footer_bg
    $wp_customize->add_control('flashshop_color_footer_bg', array(
        'label'    => esc_html__('Footer BG', 'flashshop'),
        'section'  => 'flashshop_color_footer',
        'type'      => 'color',
    ) );
    // Add setting footer_color
    $wp_customize->add_setting('flashshop_color_footer_color', array(
        'default'    => get_option('flashshop_color_footer_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control footer_color
    $wp_customize->add_control('flashshop_color_footer_color', array(
        'label'    => esc_html__('Footer Color', 'flashshop'),
        'section'  => 'flashshop_color_footer',
        'type'      => 'color',
    ) );
    // Add setting link_color
    $wp_customize->add_setting('flashshop_color_link_color', array(
        'default'    => get_option('flashshop_color_link_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control link_color
    $wp_customize->add_control('flashshop_color_link_color', array(
        'label'    => esc_html__('Link Color', 'flashshop'),
        'section'  => 'flashshop_color_footer',
        'type'      => 'color',
    ) );
    // Add setting heading_color
    $wp_customize->add_setting('flashshop_color_heading_color', array(
        'default'    => get_option('flashshop_color_heading_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control heading_color
    $wp_customize->add_control('flashshop_color_heading_color', array(
        'label'    => esc_html__('Heading Color', 'flashshop'),
        'section'  => 'flashshop_color_footer',
        'type'      => 'color',
    ) );
    // Add setting copyright_bg
    $wp_customize->add_setting('flashshop_color_copyright_bg', array(
        'default'    => get_option('flashshop_color_copyright_bg'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control copyright_bg
    $wp_customize->add_control('flashshop_color_copyright_bg', array(
        'label'    => esc_html__('Footer Copyright Background', 'flashshop'),
        'section'  => 'flashshop_color_footer',
        'type'      => 'color',
    ) );
    // Add setting copyright_color
    $wp_customize->add_setting('flashshop_color_copyright_color', array(
        'default'    => get_option('flashshop_color_copyright_color'),
        'type'       => 'option',
        'capability' => 'manage_options',
        'transport'  => 'postMessage',
        'sanitize_callback' => 'sanitize_hex_color'
    ) );

    // Add Control copyright_color
    $wp_customize->add_control('flashshop_color_copyright_color', array(
        'label'    => esc_html__('Copyright Color', 'flashshop'),
        'section'  => 'flashshop_color_footer',
        'type'      => 'color',
    ) );

}
endif;
add_action('customize_register', 'flashshop_fnc_customize_register', 99);