<?php
/**
 * Implement Custom Header functionality for Flashshop
 *
 * @package WpOpal
 * @subpackage Flashshop
 * @since Flashshop 1.0
 */

/**
 * Set up the WordPress core custom header settings.
 *
 * @since Flashshop 1.0
 *
 * @uses flashshop_fnc_header_style()
 * @uses flashshop_fnc_admin_header_style()
 * @uses flashshop_fnc_admin_header_image()
 */
function flashshop_fnc_custom_header_setup() {
	/**
	 * Filter Flashshop custom-header support arguments.
	 *
	 * @since Flashshop 1.0
	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type bool   $header_text            Whether to display custom header text. Default false.
	 *     @type int    $width                  Width in pixels of the custom header image. Default 1260.
	 *     @type int    $height                 Height in pixels of the custom header image. Default 240.
	 *     @type bool   $flex_height            Whether to allow flexible-height header images. Default true.
	 *     @type string $admin_head_callback    Callback function used to style the image displayed in
	 *                                          the Appearance > Header screen.
	 *     @type string $admin_preview_callback Callback function used to create the custom header markup in
	 *                                          the Appearance > Header screen.
	 * }
	 */
	add_theme_support( 'custom-header', apply_filters( 'flashshop_fnc_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 1260,
		'height'                 => 240,
		'flex-height'            => true,
		'wp-head-callback'       => 'flashshop_fnc_header_style',
		'admin-head-callback'    => 'flashshop_fnc_admin_header_style',
		'admin-preview-callback' => 'flashshop_fnc_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'flashshop_fnc_custom_header_setup' );

if ( ! function_exists( 'flashshop_fnc_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see flashshop_fnc_custom_header_setup().
 *
 */
function flashshop_fnc_header_style() {
    ?>
    <style type="text/css" id="flashshop-header-css">
        
        <?php
        $topbar_bg = get_option('flashshop_color_topbar_bg');
        if( !empty($topbar_bg) && preg_match("#\##", $topbar_bg) ) : ?>
            .opal-topbar{
                background-color:<?php echo esc_attr($topbar_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $topbar_color = get_option('flashshop_color_topbar_color');
        if( !empty($topbar_color) && preg_match("#\##", $topbar_color) ) : ?>
            .opal-topbar{
                color:<?php echo esc_attr($topbar_color); ?>;
            }
        <?php endif; ?>

        <?php
        $header_bg = get_option('flashshop_color_header_bg');
        if( !empty($header_bg) && preg_match("#\##", $header_bg) ) : ?>
            #opal-masthead{
                background-color:<?php echo esc_attr($header_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $cart_bg = get_option('flashshop_color_cart_bg');
        if( !empty($cart_bg) && preg_match("#\##", $cart_bg) ) : ?>
            .opal-topcart .mini-cart-items{
                background:<?php echo esc_attr($cart_bg); ?>;
            }
            .opal-topcart .mini-cart-items:before{
                border-right-color:<?php echo esc_attr($cart_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $cart_color = get_option('flashshop_color_cart_color');
        if( !empty($cart_color) && preg_match("#\##", $cart_color) ) : ?>
            .opal-topcart .mini-cart-items{
                color:<?php echo esc_attr($cart_color); ?>;
            }
        <?php endif; ?>

        <?php
        $menu_background = get_option('flashshop_color_menu_background');
        if( !empty($menu_background) && preg_match("#\##", $menu_background) ) : ?>
            .header-bottom .inner{
                background-color:<?php echo esc_attr($menu_background); ?>;
            }
        <?php endif; ?>

        <?php
        $menu_color = get_option('flashshop_color_menu_color');
        if( !empty($menu_color) && preg_match("#\##", $menu_color) ) : ?>
            .navbar-mega-light .navbar-mega .navbar-nav li a{
                color:<?php echo esc_attr($menu_color); ?>;
            }
        <?php endif; ?>

        <?php
        $breadcrumb_color = get_option('flashshop_color_breadcrumb_color');
        if( !empty($breadcrumb_color) && preg_match("#\##", $breadcrumb_color) ) : ?>
            .opal-breadscrumb .breadcrumb a,.opal-breadscrumb .breadcrumb li:after{
                color:<?php echo esc_attr($breadcrumb_color); ?>;
            }
        <?php endif; ?>

        <?php
        $breadcrumb_active_color = get_option('flashshop_color_breadcrumb_active_color');
        if( !empty($breadcrumb_active_color) && preg_match("#\##", $breadcrumb_active_color) ) : ?>
            .opal-breadscrumb .breadcrumb li:last-child{
                color:<?php echo esc_attr($breadcrumb_active_color); ?>;
            }
        <?php endif; ?>

        <?php
        $product_name_color = get_option('flashshop_color_product_name_color');
        if( !empty($product_name_color) && preg_match("#\##", $product_name_color) ) : ?>
            .product-block .name a{
                color:<?php echo esc_attr($product_name_color); ?>;
            }
        <?php endif; ?>

        <?php
        $product_price_color = get_option('flashshop_color_product_price_color');
        if( !empty($product_price_color) && preg_match("#\##", $product_price_color) ) : ?>
            .product-block .price *{
                color:<?php echo esc_attr($product_price_color); ?>;
            }
        <?php endif; ?>

        <?php
        $product_pricesale_color = get_option('flashshop_color_product_pricesale_color');
        if( !empty($product_pricesale_color) && preg_match("#\##", $product_pricesale_color) ) : ?>
            .product-block .price del span,.product-block .price del{
                color:<?php echo esc_attr($product_pricesale_color); ?>;
            }
        <?php endif; ?>

        <?php
        $footer_bg = get_option('flashshop_color_footer_bg');
        if( !empty($footer_bg) && preg_match("#\##", $footer_bg) ) : ?>
            .opal-footer{
                background-color:<?php echo esc_attr($footer_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $footer_color = get_option('flashshop_color_footer_color');
        if( !empty($footer_color) && preg_match("#\##", $footer_color) ) : ?>
            .opal-footer{
                color:<?php echo esc_attr($footer_color); ?>;
            }
        <?php endif; ?>

        <?php
        $link_color = get_option('flashshop_color_link_color');
        if( !empty($link_color) && preg_match("#\##", $link_color) ) : ?>
            .opal-footer ul.menu li a{
                color:<?php echo esc_attr($link_color); ?>;
            }
        <?php endif; ?>

        <?php
        $heading_color = get_option('flashshop_color_heading_color');
        if( !empty($heading_color) && preg_match("#\##", $heading_color) ) : ?>
            .opal-footer .widget .widget-title, .opal-footer .widget .widgettitle{
                color:<?php echo esc_attr($heading_color); ?>;
            }
        <?php endif; ?>

        <?php
        $copyright_bg = get_option('flashshop_color_copyright_bg');
        if( !empty($copyright_bg) && preg_match("#\##", $copyright_bg) ) : ?>
            .opal-copyright{
                background-color:<?php echo esc_attr($copyright_bg); ?>;
            }
        <?php endif; ?>

        <?php
        $copyright_color = get_option('flashshop_color_copyright_color');
        if( !empty($copyright_color) && preg_match("#\##", $copyright_color) ) : ?>
            .opal-copyright{
                color:<?php echo esc_attr($copyright_color); ?>;
            }
        <?php endif; ?>

    </style>
    <?php
    /* OpalTool: inject code */
    
    $flashshop_maincolor_primary_color = get_option('flashshop_maincolor_primary_color');
    if( (!empty($flashshop_maincolor_primary_color) && preg_match("#\##", $flashshop_maincolor_primary_color)) || is_customize_preview() ) : ?>
        <?php if(is_customize_preview()) $flashshop_maincolor_primary_color = $flashshop_maincolor_primary_color?$flashshop_maincolor_primary_color:'__none_color__'; ?>
        <style type="text/css" id="flashshop_maincolor_primary_color-header-css"<?php if(is_customize_preview()){ ?> data-color="<?php echo esc_attr($flashshop_maincolor_primary_color); ?>"<?php } ?>>
            
  a:hover,a:focus ,.text-primary ,blockquote ,.btn-primary .badge ,.btn-link:hover,.btn-link:focus ,.dropdown-menu > li > a:hover,.dropdown-menu > li > a:focus ,.nav-tabs > li.active > a,.nav-tabs > li.active > a:hover,.nav-tabs > li.active > a:focus ,.navbar-default .navbar-nav > li > a:hover,.navbar-default .navbar-nav > li > a:focus ,.navbar-default .navbar-nav .open .dropdown-menu > li > a:hover,.navbar-default .navbar-nav .open .dropdown-menu > li > a:focus ,.navbar-default .navbar-link:hover ,.navbar-default .btn-link:hover,.navbar-default .btn-link:focus ,a.label:hover,a.label:focus ,.panel-primary > .panel-heading ,.opal-topbar .list-inline a:hover ,.box-group span:hover ,.box-user span:hover ,.box-user .dropdown-menu li a:hover ,.search-box-wrapper .search-focus:hover ,.opal-breadscrumb .breadcrumb > li:last-child ,.opal-breadscrumb .breadcrumb > a:last-child ,.opal-footer ul.menu li a:hover ,.opal-copyright a ,.opal-copyright a:hover,.opal-copyright a:focus,.opal-copyright a:active ,.widget_archive a:before,.widget_recent_entries a:before,.widget_recent_comments a:first-child:before,.widget_layered_nav a:before,.widget_categories a:before ,.widget_recent_comments .comment-author-link,.widget_recent_entries .comment-author-link ,.widget.widget_layered_nav ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget_nav_menu ul li a:hover,.widget.widget_pages ul li a:hover ,.widget_categories > ul > li:before ,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date ,.widget_calendar tbody a ,.widget_calendar #today ,.navbar-mega .navbar-nav > .open > a ,.navbar-mega .navbar-nav li.active > a ,.navbar-mega .navbar-nav li.active > a .caret ,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus ,.navbar-mega .navbar-nav li.open > a ,.navbar-mega .navbar-nav > li > a:hover,.navbar-mega .navbar-nav > li > a:focus ,.navbar-mega .navbar-nav > li > a:hover .caret,.navbar-mega .navbar-nav > li > a:focus .caret ,.navbar-mega .navbar-nav > li .dropdown-menu li a:hover ,.navbar-mega .navbar-nav > li .dropdown-menu li.active > a ,.navbar-mega .navbar-nav > .active > a ,.widget_wpopal_menu_vertical .navbar-nav > li:focus > a,.widget_wpopal_menu_vertical .navbar-nav > li:hover > a ,.widget_wpopal_menu_vertical .navbar-nav > li:focus > a .caret:before,.widget_wpopal_menu_vertical .navbar-nav > li:hover > a .caret:before ,.widget_wpopal_menu_vertical .navbar-nav > li:focus > a:before,.widget_wpopal_menu_vertical .navbar-nav > li:hover > a:before ,.widget_wpopal_menu_vertical .navbar-nav li a:hover,.widget_wpopal_menu_vertical .navbar-nav li a:focus ,.widget_wpopal_menu_vertical .navbar-nav li .dropdown-menu > li > a:hover ,.widget_wpopal_menu_vertical .navbar-nav li:focus > a,.widget_wpopal_menu_vertical .navbar-nav li:hover > a ,.widget_wpopal_menu_vertical .navbar-nav li:focus > a .caret::before,.widget_wpopal_menu_vertical .navbar-nav li:hover > a .caret::before ,.widget_wpopal_menu_vertical .widget_nav_menu ul li a:hover ,.sidebar .opal-search .btn-search:hover ,.sidebar .opal-search .btn-search input:hover ,.entry-category ul li a ,.entry-content .edit-link a ,article .entry-title a:hover ,article .readmore:hover ,article.type-post .post-content span a,article.post .post-content span a ,article.type-post .post-content a,article.post .post-content a ,.comments .comment-author ,.comments a ,.list-post-type .list-item .post-content > a .badge ,.single-portfolio .format-infomation .single-body .portfolio-info a:hover ,.ih-item .info h3:hover ,.btn-inverse-light ,.btn-outline.btn-primary ,.btn-inverse.btn-primary:hover ,.btn-custom:hover ,.text-primary ,.heading-v5:before ,.heading-v6:after,.heading-v6:before ,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:active ,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:active ,.blogv1 a:hover ,.scrollup:hover ,.kc-pie-chart-wrapper .pie_chart_text h3 ,.kc-call-to-action .kc-cta-button a:hover ,.kc_button.btn-primary .badge ,.kc_button.btn-outline.btn-primary ,.kc_button.btn-inverse.btn-primary:hover ,.btn-offcanvas:hover ,.offcanvas-showright .showright .fa ,.navbar-offcanvas ul#main-menu-offcanvas li.active > a ,.navbar-default .navbar-nav > li > a:hover,.navbar-default .navbar-nav > li > a:focus ,.navbar-default .navbar-nav .open .dropdown-menu > li > a:hover,.navbar-default .navbar-nav .open .dropdown-menu > li > a:focus ,.navbar-default .navbar-link:hover ,.navbar-default .btn-link:hover,.navbar-default .btn-link:focus ,a:hover,a:focus ,.text-primary ,blockquote ,.btn-primary .badge ,.btn-link:hover,.btn-link:focus ,.dropdown-menu > li > a:hover,.dropdown-menu > li > a:focus ,.nav-tabs > li.active > a,.nav-tabs > li.active > a:hover,.nav-tabs > li.active > a:focus ,.navbar-default .navbar-nav > li > a:hover,.navbar-default .navbar-nav > li > a:focus ,.navbar-default .navbar-nav .open .dropdown-menu > li > a:hover,.navbar-default .navbar-nav .open .dropdown-menu > li > a:focus ,.navbar-default .navbar-link:hover ,.navbar-default .btn-link:hover,.navbar-default .btn-link:focus ,a.label:hover,a.label:focus ,.panel-primary > .panel-heading ,.opal-topbar .list-inline a:hover ,.box-group span:hover ,.box-user span:hover ,.box-user .dropdown-menu li a:hover ,.search-box-wrapper .search-focus:hover ,.opal-breadscrumb .breadcrumb > li:last-child ,.opal-breadscrumb .breadcrumb > a:last-child ,.opal-footer ul.menu li a:hover ,.opal-copyright a ,.opal-copyright a:hover,.opal-copyright a:focus,.opal-copyright a:active ,.widget_archive a:before,.widget_recent_entries a:before,.widget_recent_comments a:first-child:before,.widget_layered_nav a:before,.widget_categories a:before ,.widget_recent_comments .comment-author-link,.widget_recent_entries .comment-author-link ,.widget.widget_layered_nav ul li a:hover,.widget.widget_layered_nav_filters ul li a:hover,.widget_nav_menu ul li a:hover,.widget.widget_pages ul li a:hover ,.widget_categories > ul > li:before ,.widget_wpopal_recent_post .post-stick-layout .item-post.media .post-date ,.widget_calendar tbody a ,.widget_calendar #today ,.navbar-mega .navbar-nav > .open > a ,.navbar-mega .navbar-nav li.active > a ,.navbar-mega .navbar-nav li.active > a .caret ,.navbar-mega .navbar-nav li a:hover,.navbar-mega .navbar-nav li a:active,.navbar-mega .navbar-nav li a:focus ,.navbar-mega .navbar-nav li.open > a ,.navbar-mega .navbar-nav > li > a:hover,.navbar-mega .navbar-nav > li > a:focus ,.navbar-mega .navbar-nav > li > a:hover .caret,.navbar-mega .navbar-nav > li > a:focus .caret ,.navbar-mega .navbar-nav > li .dropdown-menu li a:hover ,.navbar-mega .navbar-nav > li .dropdown-menu li.active > a ,.navbar-mega .navbar-nav > .active > a ,.widget_wpopal_menu_vertical .navbar-nav > li:focus > a,.widget_wpopal_menu_vertical .navbar-nav > li:hover > a ,.widget_wpopal_menu_vertical .navbar-nav > li:focus > a .caret:before,.widget_wpopal_menu_vertical .navbar-nav > li:hover > a .caret:before ,.widget_wpopal_menu_vertical .navbar-nav > li:focus > a:before,.widget_wpopal_menu_vertical .navbar-nav > li:hover > a:before ,.widget_wpopal_menu_vertical .navbar-nav li a:hover,.widget_wpopal_menu_vertical .navbar-nav li a:focus ,.widget_wpopal_menu_vertical .navbar-nav li .dropdown-menu > li > a:hover ,.widget_wpopal_menu_vertical .navbar-nav li:focus > a,.widget_wpopal_menu_vertical .navbar-nav li:hover > a ,.widget_wpopal_menu_vertical .navbar-nav li:focus > a .caret::before,.widget_wpopal_menu_vertical .navbar-nav li:hover > a .caret::before ,.widget_wpopal_menu_vertical .widget_nav_menu ul li a:hover ,.sidebar .opal-search .btn-search:hover ,.sidebar .opal-search .btn-search input:hover ,.entry-category ul li a ,.entry-content .edit-link a ,article .entry-title a:hover ,article .readmore:hover ,article.type-post .post-content span a,article.post .post-content span a ,article.type-post .post-content a,article.post .post-content a ,.comments .comment-author ,.comments a ,.list-post-type .list-item .post-content > a .badge ,.single-portfolio .format-infomation .single-body .portfolio-info a:hover ,.ih-item .info h3:hover ,.btn-inverse-light ,.btn-outline.btn-primary ,.btn-inverse.btn-primary:hover ,.btn-custom:hover ,.text-primary ,.heading-v5:before ,.heading-v6:after,.heading-v6:before ,.pricing.pricing-v2.pricing-highlight .btn-block:hover,.pricing.pricing-v2.pricing-highlight .btn-block:focus,.pricing.pricing-v2.pricing-highlight .btn-block:active ,.pricing.pricing-v3.pricing-highlight .btn-block:hover,.pricing.pricing-v3.pricing-highlight .btn-block:focus,.pricing.pricing-v3.pricing-highlight .btn-block:active ,.blogv1 a:hover ,.scrollup:hover ,.kc-pie-chart-wrapper .pie_chart_text h3 ,.kc-call-to-action .kc-cta-button a:hover ,.kc_button.btn-primary .badge ,.kc_button.btn-outline.btn-primary ,.kc_button.btn-inverse.btn-primary:hover ,.btn-offcanvas:hover ,.offcanvas-showright .showright .fa ,.navbar-offcanvas ul#main-menu-offcanvas li.active > a ,.woocommerce ul.product_list_widget li ins ,ul.product-categories > li:before ,.opal-category-list #opal-accordion-categories .category-title a:hover ,.cart_list .cart-main-content .remove:hover ,.widget-categoriestabs .tablist > li.active > a ,.category-filter-default h5:before ,.category-filter-v1 .category-filter-title a:before ,.woof_list_label li .woof_label_term:hover,.woof_list_label li .woof_label_term.checked ,.widget-woof .woof_container_product_cat .woof_list_label .woof_label_term.checked:hover ,.widget-woof .woof_container_product_cat .woof_list_label .woof_label_term:hover ,.widget-woof .woof_list_label .woof_label_count ,.opal-topcart .name a:hover ,.product-info a.button.compare:hover:before ,.product-info .price > * ,.product-info .yith-wcwl-wishlistaddedbrowse a:hover,.product-info .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.product-info .yith-wcwl-add-button a:hover,.product-info .yith-wcwl-add-button a.add_to_wishlist:hover,.product-info .yith-wcwl-wishlistexistsbrowse a:hover,.product-info .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover ,.single-product-summary .yith-wcwl-add-to-wishlist a:hover ,.single-product-summary .yith-wcwl-wishlistaddedbrowse a:hover,.single-product-summary .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.single-product-summary .yith-wcwl-add-button a:hover,.single-product-summary .yith-wcwl-add-button a.add_to_wishlist:hover,.single-product-summary .yith-wcwl-wishlistexistsbrowse a:hover,.single-product-summary .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover ,.single-product-summary .yith-wcwl-wishlistaddedbrowse .feedback,.single-product-summary .yith-wcwl-wishlistexistsbrowse .feedback ,.product-block .price > * ,.product-block .name a:hover ,.product-block .category a:hover ,.products-list .product-block .yith-wcwl-wishlistaddedbrowse a:hover,.products-list .product-block .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.products-list .product-block .yith-wcwl-add-button a:hover,.products-list .product-block .yith-wcwl-add-button a.add_to_wishlist:hover,.products-list .product-block .yith-wcwl-wishlistexistsbrowse a:hover,.products-list .product-block .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover,.list .product-block .yith-wcwl-wishlistaddedbrowse a:hover,.list .product-block .yith-wcwl-wishlistaddedbrowse a.add_to_wishlist:hover,.list .product-block .yith-wcwl-add-button a:hover,.list .product-block .yith-wcwl-add-button a.add_to_wishlist:hover,.list .product-block .yith-wcwl-wishlistexistsbrowse a:hover,.list .product-block .yith-wcwl-wishlistexistsbrowse a.add_to_wishlist:hover ,.products-list .product-block a.compare:hover,.products-list .product-block a.quickview:hover,.list .product-block a.compare:hover,.list .product-block a.quickview:hover ,.products-list .product-block a.compare.added,.products-list .product-block a.quickview.added,.list .product-block a.compare.added,.list .product-block a.quickview.added ,.product_meta a:hover ,.product-single-nav .single_nav .price * ,.products-top-wrap .childrens .product-category h3:hover ,.products-bottom-wrap nav.woocommerce-pagination ul span.current,.products-bottom-wrap nav.woocommerce-pagination ul li span.current ,.products-bottom-wrap nav.woocommerce-pagination ul a:hover,.products-bottom-wrap nav.woocommerce-pagination ul span:hover,.products-bottom-wrap nav.woocommerce-pagination ul li a:hover,.products-bottom-wrap nav.woocommerce-pagination ul li span:hover ,#opal-quickview-modal .product-info .price ,#opal-quickview-modal .product-info .add-cart > a ,.woocommerce div.product .woocommerce-tabs.horizontal-tabs ul.tabs li > a:hover ,.woocommerce div.product .woocommerce-tabs.horizontal-tabs ul.tabs li.active > a ,.woocommerce div.product .woocommerce-tabs.horizontal-tabs ul.tabs li.active ,.woocommerce div.product .vertical-tabs ul.tabs li.active ,.woocommerce #respond input#submit .badge,.woocommerce button.button .badge,.woocommerce input.button .badge ,.woocommerce #respond input#submit.alt .badge,.woocommerce a.button.alt .badge,.woocommerce button.button.alt .badge,.woocommerce input.button.alt .badge ,.woocommerce .wishlist_table td.product-add-to-cart a .badge ,.woocommerce .cart-collaterals .order-total .amount ,.woocommerce-error a,.woocommerce-info a,.woocommerce-message a ,.woocommerce-checkout-review-order-table .order-total .woocommerce-Price-amount {
                color:<?php echo esc_attr($flashshop_maincolor_primary_color); ?>;
            }
            

.modal-content ,.carousel-indicators li ,.active-mobile .active-content ,.heading-v2:before ,.modal-content ,.carousel-indicators li ,.active-mobile .active-content ,.heading-v2:before ,#opal-quickview-modal .product-info .add-cart > a {
                border-color:<?php echo esc_attr($flashshop_maincolor_primary_color); ?>;
            }
            
      .navbar-mega .dropdown-menu .text-label.text-featured:after ,.navbar-mega .dropdown-menu .text-label:after ,.navbar-mega .dropdown-menu .text-label.text-featured:after ,.navbar-mega .dropdown-menu .text-label:after ,.woocommerce div.product .vertical-tabs ul.tabs li.active > a {
                border-right-color:<?php echo esc_attr($flashshop_maincolor_primary_color); ?>;
            }
            
    .product-info .stock:before {
                border-top-color:<?php echo esc_attr($flashshop_maincolor_primary_color); ?>;
            }
            

.bg-primary ,.btn-primary ,.btn-primary.disabled,.btn-primary.disabled:hover,.btn-primary.disabled:focus,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled.active,.btn-primary[disabled],.btn-primary[disabled]:hover,.btn-primary[disabled]:focus,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled].active,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary:hover,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary.active ,.label-primary ,.progress-bar ,.panel-primary > .panel-heading .badge ,.carousel-indicators .active ,button:hover,button:focus,html input[type="button"]:hover,html input[type="button"]:focus,input[type="reset"]:hover,input[type="reset"]:focus,input[type="submit"]:hover,input[type="submit"]:focus ,#opal-masthead.header-v2 .mini-cart-items ,.btn-search ,.widget .widget-title:before,.widget .widgettitle:before ,.widget_categories > ul > li:hover ,.widget_categories > ul > li.current-cat,.widget_categories > ul > li.current-cat-parent ,.widget_mc4wp_form_widget input[type="submit"] ,.navbar-mega .navbar-toggle .icon-bar ,.navbar-mega-theme ,.notfound-page .btn-search ,.navigation .pagination > *:hover ,.navigation .pagination span.current ,.tagcloud a:hover ,.list-post-type .list-item .post-content > a ,.list-post-type .list-item .post-content > a.disabled,.list-post-type .list-item .post-content > a.disabled:hover,.list-post-type .list-item .post-content > a.disabled:focus,.list-post-type .list-item .post-content > a.disabled.focus,.list-post-type .list-item .post-content > a.disabled:active,.list-post-type .list-item .post-content > a.disabled.active,.list-post-type .list-item .post-content > a[disabled],.list-post-type .list-item .post-content > a[disabled]:hover,.list-post-type .list-item .post-content > a[disabled]:focus,.list-post-type .list-item .post-content > a[disabled].focus,.list-post-type .list-item .post-content > a[disabled]:active,.list-post-type .list-item .post-content > a[disabled].active,fieldset[disabled] .list-post-type .list-item .post-content > a,fieldset[disabled] .list-post-type .list-item .post-content > a:hover,fieldset[disabled] .list-post-type .list-item .post-content > a:focus,fieldset[disabled] .list-post-type .list-item .post-content > a.focus,fieldset[disabled] .list-post-type .list-item .post-content > a:active,fieldset[disabled] .list-post-type .list-item .post-content > a.active ,.ih-item.square.effect16 .info ,.ih-item.square.effect16 .info ,.bg-primary ,.btn-outline-light:hover,.btn-outline-light:focus,.btn-outline-light:active,.btn-outline-light.active ,.open .btn-outline-light.dropdown-toggle ,.btn-outline-dark:hover,.btn-outline-dark:focus,.btn-outline-dark:active,.btn-outline-dark.active ,.open .btn-outline-dark.dropdown-toggle ,.btn-inverse-light .badge ,.owl-controls .owl-page.active span ,ul.social a ,ul.social a:hover ,.panel-primary:before ,.panel-primary:before ,.panel-primary:before ,.panel-primary:before ,.bo-social-icons [class^="bo-social-"]:hover ,.dropcap.dropcap-v2 ,.heading-v1:before ,.heading-v2:after ,.element-block-heading.style-v3:after ,.pricing.pricing-v2 .plan-price ,.pricing.pricing-v2 .plan-price .plan-price-body ,.pricing.pricing-v2.pricing-highlight .plan-price-body ,.pricing.pricing-v2.pricing-highlight .btn-block ,.pricing.pricing-v3.pricing-highlight .plan-title ,.pricing.pricing-v3.pricing-highlight .plan-price ,.pricing.pricing-v3.pricing-highlight .btn-block ,.pricing.pricing-highlight .plan-title ,.pbr-team.other-team ,.text-top ,.kc_button.btn-primary ,.kc_button.btn-primary.disabled,.kc_button.btn-primary.disabled:hover,.kc_button.btn-primary.disabled:focus,.kc_button.btn-primary.disabled.focus,.kc_button.btn-primary.disabled:active,.kc_button.btn-primary.disabled.active,.kc_button.btn-primary[disabled],.kc_button.btn-primary[disabled]:hover,.kc_button.btn-primary[disabled]:focus,.kc_button.btn-primary[disabled].focus,.kc_button.btn-primary[disabled]:active,.kc_button.btn-primary[disabled].active,fieldset[disabled] .kc_button.btn-primary,fieldset[disabled] .kc_button.btn-primary:hover,fieldset[disabled] .kc_button.btn-primary:focus,fieldset[disabled] .kc_button.btn-primary.focus,fieldset[disabled] .kc_button.btn-primary:active,fieldset[disabled] .kc_button.btn-primary.active ,.opal-topcart .mini-cart-items ,.opal-topcart .mini-cart-items ,.opal-topcart .mini-cart-items ,.bg-primary ,.btn-primary ,.btn-primary.disabled,.btn-primary.disabled:hover,.btn-primary.disabled:focus,.btn-primary.disabled.focus,.btn-primary.disabled:active,.btn-primary.disabled.active,.btn-primary[disabled],.btn-primary[disabled]:hover,.btn-primary[disabled]:focus,.btn-primary[disabled].focus,.btn-primary[disabled]:active,.btn-primary[disabled].active,fieldset[disabled] .btn-primary,fieldset[disabled] .btn-primary:hover,fieldset[disabled] .btn-primary:focus,fieldset[disabled] .btn-primary.focus,fieldset[disabled] .btn-primary:active,fieldset[disabled] .btn-primary.active ,.label-primary ,.progress-bar ,.panel-primary > .panel-heading .badge ,.carousel-indicators .active ,button:hover,button:focus,html input[type="button"]:hover,html input[type="button"]:focus,input[type="reset"]:hover,input[type="reset"]:focus,input[type="submit"]:hover,input[type="submit"]:focus ,#opal-masthead.header-v2 .mini-cart-items ,.btn-search ,.widget .widget-title:before,.widget .widgettitle:before ,.widget_categories > ul > li:hover ,.widget_categories > ul > li.current-cat,.widget_categories > ul > li.current-cat-parent ,.widget_mc4wp_form_widget input[type="submit"] ,.navbar-mega .navbar-toggle .icon-bar ,.navbar-mega-theme ,.notfound-page .btn-search ,.navigation .pagination > *:hover ,.navigation .pagination span.current ,.tagcloud a:hover ,.list-post-type .list-item .post-content > a ,.list-post-type .list-item .post-content > a.disabled,.list-post-type .list-item .post-content > a.disabled:hover,.list-post-type .list-item .post-content > a.disabled:focus,.list-post-type .list-item .post-content > a.disabled.focus,.list-post-type .list-item .post-content > a.disabled:active,.list-post-type .list-item .post-content > a.disabled.active,.list-post-type .list-item .post-content > a[disabled],.list-post-type .list-item .post-content > a[disabled]:hover,.list-post-type .list-item .post-content > a[disabled]:focus,.list-post-type .list-item .post-content > a[disabled].focus,.list-post-type .list-item .post-content > a[disabled]:active,.list-post-type .list-item .post-content > a[disabled].active,fieldset[disabled] .list-post-type .list-item .post-content > a,fieldset[disabled] .list-post-type .list-item .post-content > a:hover,fieldset[disabled] .list-post-type .list-item .post-content > a:focus,fieldset[disabled] .list-post-type .list-item .post-content > a.focus,fieldset[disabled] .list-post-type .list-item .post-content > a:active,fieldset[disabled] .list-post-type .list-item .post-content > a.active ,.ih-item.square.effect16 .info ,.ih-item.square.effect16 .info ,.bg-primary ,.btn-outline-light:hover,.btn-outline-light:focus,.btn-outline-light:active,.btn-outline-light.active ,.open .btn-outline-light.dropdown-toggle ,.btn-outline-dark:hover,.btn-outline-dark:focus,.btn-outline-dark:active,.btn-outline-dark.active ,.open .btn-outline-dark.dropdown-toggle ,.btn-inverse-light .badge ,.owl-controls .owl-page.active span ,ul.social a ,ul.social a:hover ,.panel-primary:before ,.panel-primary:before ,.panel-primary:before ,.panel-primary:before ,.bo-social-icons [class^="bo-social-"]:hover ,.dropcap.dropcap-v2 ,.heading-v1:before ,.heading-v2:after ,.element-block-heading.style-v3:after ,.pricing.pricing-v2 .plan-price ,.pricing.pricing-v2 .plan-price .plan-price-body ,.pricing.pricing-v2.pricing-highlight .plan-price-body ,.pricing.pricing-v2.pricing-highlight .btn-block ,.pricing.pricing-v3.pricing-highlight .plan-title ,.pricing.pricing-v3.pricing-highlight .plan-price ,.pricing.pricing-v3.pricing-highlight .btn-block ,.pricing.pricing-highlight .plan-title ,.pbr-team.other-team ,.text-top ,.kc_button.btn-primary ,.kc_button.btn-primary.disabled,.kc_button.btn-primary.disabled:hover,.kc_button.btn-primary.disabled:focus,.kc_button.btn-primary.disabled.focus,.kc_button.btn-primary.disabled:active,.kc_button.btn-primary.disabled.active,.kc_button.btn-primary[disabled],.kc_button.btn-primary[disabled]:hover,.kc_button.btn-primary[disabled]:focus,.kc_button.btn-primary[disabled].focus,.kc_button.btn-primary[disabled]:active,.kc_button.btn-primary[disabled].active,fieldset[disabled] .kc_button.btn-primary,fieldset[disabled] .kc_button.btn-primary:hover,fieldset[disabled] .kc_button.btn-primary:focus,fieldset[disabled] .kc_button.btn-primary.focus,fieldset[disabled] .kc_button.btn-primary:active,fieldset[disabled] .kc_button.btn-primary.active ,/*------------------------------------*    Widget Price Filter
\*------------------------------------*/
.widget_price_filter .ui-slider .ui-slider-handle ,ul.product-categories > li:hover ,ul.product-categories > li.current-cat,ul.product-categories > li.current-cat-parent ,.widget_shopping_cart_content .button ,.widget_shopping_cart_content a.button ,.widget-woof .woof_container h4:before ,.widget-woof .woof_container_product_cat .woof_list_label .woof_label_count ,.widget-woof .woof_list_label .woof_label_term.checked ,.widget-woof .woof_list_label .woof_label_term:hover ,.opal-topcart .mini-cart-items ,.product-info form.cart .button.button.alt:hover ,.product-info .stock ,.product-block .add-cart > a.button:hover ,.products-list .add-cart > a.button,.list .add-cart > a.button ,#opal-quickview-modal .product-info .add-cart > a:hover ,#opal-quickview-modal .carousel-indicators .active ,/**
 * Checkout Page
 */
/**
 * Thanks you page
 */
/************************
 * Form Styles
 ************************/
.woocommerce #respond input#submit,.woocommerce button.button,.woocommerce input.button ,.woocommerce #respond input#submit.disabled,.woocommerce #respond input#submit.disabled:hover,.woocommerce #respond input#submit.disabled:focus,.woocommerce #respond input#submit.disabled.focus,.woocommerce #respond input#submit.disabled:active,.woocommerce #respond input#submit.disabled.active,.woocommerce #respond input#submit[disabled],.woocommerce #respond input#submit[disabled]:hover,.woocommerce #respond input#submit[disabled]:focus,.woocommerce #respond input#submit[disabled].focus,.woocommerce #respond input#submit[disabled]:active,.woocommerce #respond input#submit[disabled].active,fieldset[disabled] .woocommerce #respond input#submit,fieldset[disabled] .woocommerce #respond input#submit:hover,fieldset[disabled] .woocommerce #respond input#submit:focus,fieldset[disabled] .woocommerce #respond input#submit.focus,fieldset[disabled] .woocommerce #respond input#submit:active,fieldset[disabled] .woocommerce #respond input#submit.active,.woocommerce button.button.disabled,.woocommerce button.button.disabled:hover,.woocommerce button.button.disabled:focus,.woocommerce button.button.disabled.focus,.woocommerce button.button.disabled:active,.woocommerce button.button.disabled.active,.woocommerce button.button[disabled],.woocommerce button.button[disabled]:hover,.woocommerce button.button[disabled]:focus,.woocommerce button.button[disabled].focus,.woocommerce button.button[disabled]:active,.woocommerce button.button[disabled].active,fieldset[disabled] .woocommerce button.button,fieldset[disabled] .woocommerce button.button:hover,fieldset[disabled] .woocommerce button.button:focus,fieldset[disabled] .woocommerce button.button.focus,fieldset[disabled] .woocommerce button.button:active,fieldset[disabled] .woocommerce button.button.active,.woocommerce input.button.disabled,.woocommerce input.button.disabled:hover,.woocommerce input.button.disabled:focus,.woocommerce input.button.disabled.focus,.woocommerce input.button.disabled:active,.woocommerce input.button.disabled.active,.woocommerce input.button[disabled],.woocommerce input.button[disabled]:hover,.woocommerce input.button[disabled]:focus,.woocommerce input.button[disabled].focus,.woocommerce input.button[disabled]:active,.woocommerce input.button[disabled].active,fieldset[disabled] .woocommerce input.button,fieldset[disabled] .woocommerce input.button:hover,fieldset[disabled] .woocommerce input.button:focus,fieldset[disabled] .woocommerce input.button.focus,fieldset[disabled] .woocommerce input.button:active,fieldset[disabled] .woocommerce input.button.active ,.woocommerce #respond input#submit.alt,.woocommerce a.button.alt,.woocommerce button.button.alt,.woocommerce input.button.alt ,.woocommerce #respond input#submit.alt.disabled,.woocommerce #respond input#submit.alt.disabled:hover,.woocommerce #respond input#submit.alt.disabled:focus,.woocommerce #respond input#submit.alt.disabled.focus,.woocommerce #respond input#submit.alt.disabled:active,.woocommerce #respond input#submit.alt.disabled.active,.woocommerce #respond input#submit.alt[disabled],.woocommerce #respond input#submit.alt[disabled]:hover,.woocommerce #respond input#submit.alt[disabled]:focus,.woocommerce #respond input#submit.alt[disabled].focus,.woocommerce #respond input#submit.alt[disabled]:active,.woocommerce #respond input#submit.alt[disabled].active,fieldset[disabled] .woocommerce #respond input#submit.alt,fieldset[disabled] .woocommerce #respond input#submit.alt:hover,fieldset[disabled] .woocommerce #respond input#submit.alt:focus,fieldset[disabled] .woocommerce #respond input#submit.alt.focus,fieldset[disabled] .woocommerce #respond input#submit.alt:active,fieldset[disabled] .woocommerce #respond input#submit.alt.active,.woocommerce a.button.alt.disabled,.woocommerce a.button.alt.disabled:hover,.woocommerce a.button.alt.disabled:focus,.woocommerce a.button.alt.disabled.focus,.woocommerce a.button.alt.disabled:active,.woocommerce a.button.alt.disabled.active,.woocommerce a.button.alt[disabled],.woocommerce a.button.alt[disabled]:hover,.woocommerce a.button.alt[disabled]:focus,.woocommerce a.button.alt[disabled].focus,.woocommerce a.button.alt[disabled]:active,.woocommerce a.button.alt[disabled].active,fieldset[disabled] .woocommerce a.button.alt,fieldset[disabled] .woocommerce a.button.alt:hover,fieldset[disabled] .woocommerce a.button.alt:focus,fieldset[disabled] .woocommerce a.button.alt.focus,fieldset[disabled] .woocommerce a.button.alt:active,fieldset[disabled] .woocommerce a.button.alt.active,.woocommerce button.button.alt.disabled,.woocommerce button.button.alt.disabled:hover,.woocommerce button.button.alt.disabled:focus,.woocommerce button.button.alt.disabled.focus,.woocommerce button.button.alt.disabled:active,.woocommerce button.button.alt.disabled.active,.woocommerce button.button.alt[disabled],.woocommerce button.button.alt[disabled]:hover,.woocommerce button.button.alt[disabled]:focus,.woocommerce button.button.alt[disabled].focus,.woocommerce button.button.alt[disabled]:active,.woocommerce button.button.alt[disabled].active,fieldset[disabled] .woocommerce button.button.alt,fieldset[disabled] .woocommerce button.button.alt:hover,fieldset[disabled] .woocommerce button.button.alt:focus,fieldset[disabled] .woocommerce button.button.alt.focus,fieldset[disabled] .woocommerce button.button.alt:active,fieldset[disabled] .woocommerce button.button.alt.active,.woocommerce input.button.alt.disabled,.woocommerce input.button.alt.disabled:hover,.woocommerce input.button.alt.disabled:focus,.woocommerce input.button.alt.disabled.focus,.woocommerce input.button.alt.disabled:active,.woocommerce input.button.alt.disabled.active,.woocommerce input.button.alt[disabled],.woocommerce input.button.alt[disabled]:hover,.woocommerce input.button.alt[disabled]:focus,.woocommerce input.button.alt[disabled].focus,.woocommerce input.button.alt[disabled]:active,.woocommerce input.button.alt[disabled].active,fieldset[disabled] .woocommerce input.button.alt,fieldset[disabled] .woocommerce input.button.alt:hover,fieldset[disabled] .woocommerce input.button.alt:focus,fieldset[disabled] .woocommerce input.button.alt.focus,fieldset[disabled] .woocommerce input.button.alt:active,fieldset[disabled] .woocommerce input.button.alt.active ,.woocommerce .wishlist_table td.product-add-to-cart a ,.woocommerce .wishlist_table td.product-add-to-cart a.disabled,.woocommerce .wishlist_table td.product-add-to-cart a.disabled:hover,.woocommerce .wishlist_table td.product-add-to-cart a.disabled:focus,.woocommerce .wishlist_table td.product-add-to-cart a.disabled.focus,.woocommerce .wishlist_table td.product-add-to-cart a.disabled:active,.woocommerce .wishlist_table td.product-add-to-cart a.disabled.active,.woocommerce .wishlist_table td.product-add-to-cart a[disabled],.woocommerce .wishlist_table td.product-add-to-cart a[disabled]:hover,.woocommerce .wishlist_table td.product-add-to-cart a[disabled]:focus,.woocommerce .wishlist_table td.product-add-to-cart a[disabled].focus,.woocommerce .wishlist_table td.product-add-to-cart a[disabled]:active,.woocommerce .wishlist_table td.product-add-to-cart a[disabled].active,fieldset[disabled] .woocommerce .wishlist_table td.product-add-to-cart a,fieldset[disabled] .woocommerce .wishlist_table td.product-add-to-cart a:hover,fieldset[disabled] .woocommerce .wishlist_table td.product-add-to-cart a:focus,fieldset[disabled] .woocommerce .wishlist_table td.product-add-to-cart a.focus,fieldset[disabled] .woocommerce .wishlist_table td.product-add-to-cart a:active,fieldset[disabled] .woocommerce .wishlist_table td.product-add-to-cart a.active ,.woocommerce-error a.button,.woocommerce-info a.button,.woocommerce-message a.button ,.woocommerce .return-to-shop .button {
                background-color:<?php echo esc_attr($flashshop_maincolor_primary_color); ?>;
            }

    </style>
    <?php
    endif;/* OpalTool: end inject code */
}
endif; // flashshop_fnc_header_style


if ( ! function_exists( 'flashshop_fnc_admin_header_style' ) ) :
/**
 * Style the header image displayed on the Appearance > Header screen.
 *
 * @see flashshop_fnc_custom_header_setup()
 *
 * @since Flashshop 1.0
 */
function flashshop_fnc_admin_header_style() {
?>
	<style type="text/css" id="flashshop-admin-header-css">
	.appearance_page_custom-header #headimg {
		background-color: #000;
		border: none;
		max-width: 1260px;
		min-height: 48px;
	}
	#headimg h1 {
		font-family: Lato, sans-serif;
		font-size: 18px;
		line-height: 48px;
		margin: 0 0 0 30px;
	}
	.rtl #headimg h1  {
		margin: 0 30px 0 0;
	}
	#headimg h1 a {
		color: #fff;
		text-decoration: none;
	}
	#headimg img {
		vertical-align: middle;
	}

<?php
}
endif; // flashshop_fnc_admin_header_style

if ( ! function_exists( 'flashshop_fnc_admin_header_image' ) ) :
/**
 * Create the custom header image markup displayed on the Appearance > Header screen.
 *
 * @see flashshop_fnc_custom_header_setup()
 *
 * @since Flashshop 1.0
 */
function flashshop_fnc_admin_header_image() {
?>
	<div id="headimg">
		<?php if ( get_header_image() ) : ?>
		<img src="<?php header_image(); ?>" alt="">
		<?php endif; ?>
		<h1 class="displaying-header-text"><a id="name" style="<?php echo esc_attr( sprintf( 'color: #%s;', get_header_textcolor() ) ); ?>" onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>" tabindex="-1"><?php bloginfo( 'name' ); ?></a></h1>
	</div>
<?php
}
endif; // flashshop_fnc_admin_header_image