<?php
/**
 * The Header for our theme: Main Darker Background. Logo left + Main menu and Right sidebar. Below Category Search + Mini Shopping basket.
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WpOpal
 * @subpackage Flashshop
 * @since Flashshop 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site"><div class="opal-page-inner row-offcanvas row-offcanvas-left">
    <?php if ( get_header_image() ) : ?>
    <div id="site-header" class="hidden-xs hidden-sm">
        <a href="<?php echo esc_url( get_option('header_image_link','#') ); ?>" rel="home">
            <img src="<?php header_image(); ?>" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
        </a>
    </div>
    <?php endif; ?>
    <?php get_template_part( 'page-templates/parts/topbar', 'mobile' ); ?> 
    <?php get_template_part( 'page-templates/parts/topbar'); ?>              
    <header id="opal-masthead" class="site-header header-default" role="banner">
        <div class="header-main">
            <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3 inner">
                    <?php get_template_part( 'page-templates/parts/logo'); ?>
                </div>
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <?php get_template_part( 'page-templates/parts/search-overlay' ); ?>   
                </div>
                <div class="hidden-xs hidden-sm col-sm-4 col-md-3 col-lg-3">
                    <?php if ( is_active_sidebar( 'support' ) ) : ?>
                        <?php dynamic_sidebar('support'); ?>
                    <?php endif; ?>
                </div>
            </div>                      
            </div>   
        </div>
        <div class="header-bottom hidden-sm hidden-xs <?php echo flashshop_fnc_theme_options('keepheader') ? 'has-sticky' : ''; ?>">
            <div class="container"> <div class="inner">
                <div class="row">                
                    <div class="col-xs-12 col-sm-12 col-md-10">
                        <div id="opal-mainmenu" class="opal-mainmenu navbar-mega-light">
                            <?php get_template_part( 'page-templates/parts/nav' ); ?>
                        </div>                     
                    </div>
                    <div class="header-right col-xs-6 col-sm-4 col-md-2 col-lg-2">
                        <?php do_action( "flashshop_template_header_right" ); ?>                   
                    </div>
                </div>
            </div></div>
        </div>  
    </header><!-- #masthead -->

    <?php do_action( 'flashshop_template_header_after' ); ?>

    <section id="main" class="site-main">
