<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WpOpal
 * @subpackage Liftsupply
 * @since Liftsupply 1.0
 */

?>
		</section><!-- #main -->
		<?php do_action( 'flashshop_template_main_after' ); ?>
		<?php do_action( 'flashshop_template_footer_before' ); ?>
		<footer id="opal-footer" class="opal-footer">
			<?php flashshop_display_footer_content(); ?>				
		</footer><!-- #colophon -->
		<div class="opal-copyright clearfix">
			<div class="container"><div class="inner">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
						<a href="#" class="scrollup"><i class="fa fa-hand-o-down"></i><?php esc_html_e('To top', 'flashshop');?></a>
                    </div>
                    <div class="col-md-6 col-sm-8 col-xs-12 text-left">
                        <?php do_action( 'flashshop_fnc_credits' ); ?>
                    </div>
                    <div class="col-md-6 col-sm-4 col-xs-12 text-right">
                    	<?php $img_link = flashshop_fnc_theme_options('image-payment', ''); ?>
                    	<?php if(!empty( $img_link)): ?>
                        	<img src="<?php echo esc_url_raw($img_link); ?>" alt ="<?php esc_html_e('Payment logo', 'flashshop');?>">
                    	<?php endif; ?>
                    </div>
                </div>
			</div></div>
		</div>

		<?php do_action( 'flashshop_template_footer_after' ); ?>
		<?php get_sidebar( 'offcanvas' );  ?>
	<!-- #page -->
	</div>
</div>
<?php wp_footer(); ?>
</body>
</html>
