<?php
    $link = get_post_meta( get_the_ID(), 'testimonials_link', true );
    $job = get_post_meta( get_the_ID(), 'testimonials_job', true );
    $excerpt = explode(' ', strip_tags(get_the_content( )), 15);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
    $excerpt = preg_replace('`[[^]]*]`','',$excerpt);

?>
<div class="testimonials testimonials-v2 text-center">
    <div class="testimonials-body">
        
        <div class="image radius-x"><?php the_post_thumbnail('shop_thumbnail');?></div>
        <div class="testimonials-position">                                           
            <h5 class="testimonials-name">
                <?php the_title(); ?>
            </h5>  
            <p class="job">
                <a href="<?php echo empty($link) ? '#' : esc_url( $link ); ?>">
                    <?php echo empty($job) ? '' : trim( $job ); ?>
                </a>
            </p>  
        </div>
        <p class="testimonials-description"><?php echo trim( $excerpt ); ?></p>   
    </div>                      
</div>