<?php
/**
 * The template for displaying posts in the Image post format
 *
 * @package WpOpal
 * @subpackage Flashshop
 * @since Flashshop 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
 	    
    <div class="blog-detail">
        <div class="post-preview">
            <?php flashshop_fnc_post_thumbnail(); ?>        
        </div>
    	<header class="entry-header">
    		<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && flashshop_fnc_categorized_blog() ) : ?>

    		<?php
    			endif;

    			if ( is_single() ) :
    				the_title( '<h1 class="entry-title">', '</h1>' );
    			else :
    				the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
    			endif;
    		?>
            <div class="entry-meta"> 
                <div class="entry-category pull-left">
                    <?php esc_html_e('in', 'flashshop'); the_category(); ?>
                </div>
                <span class="author"><?php esc_html_e('by', 'flashshop'); the_author_posts_link(); ?></span>                     
                <span class="date">
                    <?php
                        if ( 'post' == get_post_type() )
                            flashshop_fnc_posted_on();
                        if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) :
                            endif;
                    ?>
                </span>                  

                <?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
                <span class="comments-link"><span class="fa fa-comment-o"></span> <?php comments_popup_link( esc_html__( 'Leave a comment', 'flashshop' ), esc_html__( '1 Comment', 'flashshop' ), esc_html__( '% Comments', 'flashshop' ) ); ?></span>
                <?php endif; ?>

                <?php edit_post_link( esc_html__( 'Edit', 'flashshop' ), '<span class="edit-link">', '</span>' ); ?>
            </div><!-- .entry-meta -->
        </header><!-- .entry-header -->
        	   	

    	<div class="entry-content">
    		<?php
    			/* translators: %s: Name of current post */
    			if(is_single()){
    				the_content( sprintf(
    					esc_html__( 'Continue reading %s', 'flashshop').'<span class="meta-nav">&rarr;</span>',
    					the_title( '<span class="screen-reader-text">', '</span>', false )
    				) );
    			}else{
    				the_excerpt();
    			}

    			wp_link_pages( array(
    				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'flashshop' ) . '</span>',
    				'after'       => '</div>',
    				'link_before' => '<span>',
    				'link_after'  => '</span>',
    			) );
    		?>
    	</div><!-- .entry-content -->

    	<?php the_tags( '<footer class="entry-meta"><span class="tag-links">', '', '</span></footer>' ); ?>
    </div>
</article><!-- #post-## -->
