<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 * @package WpOpal
 * @subpackage Flashshop
 * @since Flashshop 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('content-style'); ?>>
                
        <div class="blog-content clearfix">
			<?php
					the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			?>       		
            <div class="entry-meta">    
                <?php
                    if ( 'post' == get_post_type() )
                        flashshop_fnc_posted_on();
                    if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) :
                        endif;
                ?> 
            </div><!-- .entry-meta -->
            <div class="post-preview clearfix">        
                <?php the_post_thumbnail('thumbnail'); ?>
            </div>
    		<div class="excerpt">
                <?php
                    /* translators: %s: Name of current post */
                    
                     echo flashshop_fnc_excerpt( 20, '...' );
                     
                    wp_link_pages( array(
                        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'flashshop' ) . '</span>',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    ) );
                ?>
            </div><!-- .entry-content -->
            <a class="readmore" href="<?php the_permalink(); ?>" title="<?php esc_html_e( 'Read More', 'flashshop' ); ?>"><?php esc_html_e( 'Read More', 'flashshop' ); ?><span class="icon-readmore"><i class="fa fa-long-arrow-right"></i></span></a>
        </div>
	<!-- .entry-content -->
</article><!-- #post-## -->
