<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other 'pages' on your WordPress site will use a different template.
 *
 * @package WpOpal
 * @subpackage Flashshop
 * @since Flashshop 1.0
 */
/*
*Template Name: 404 Page
*/

get_header( apply_filters( 'flashshop_fnc_get_header_layout', null ) ); ?>
<?php do_action( 'flashshop_template_main_before' ); ?>
<section id="main-container" class=" inner clearfix notfound-page">
    <div class="<?php echo apply_filters('flashshop_template_main_container_class','container');?>">         
        <div id="main-content" class="main-content">
            <div id="primary" class="content-area">
                 <div id="content" class="site-content" role="main">
                    <div class="page-404">
                        <span class="sub"><?php esc_html_e( 'Oops, that page can not be found.', 'flashshop' ); ?></span>
                        <div class="error-description">
                            <p><?php esc_html_e( 'Can not find what you need, Take a moment and do a search below', 'flashshop' ); ?></p>
                            
                        </div><!-- .page-content -->
                        <div class="title">
                            <span class="text-primary">404</span>                         
                        </div>                  
                        <?php get_search_form(); ?>
                    </div>
                </div><!-- #content -->
            </div><!-- #primary -->
        </div><!-- #main-content -->
    </div>
</section>
<?php

get_footer();

