<?php 

/**
 * Template Name: Video:: Single Vendor Profile
 *
 * @package eidmart
 **/

get_header(); 

global $post;

if ( isset( $_GET['user'] ) ) {

$user_name = $_GET['user'];

$username = $user_name;
$user = get_user_by( 'login', $username);

?>


<div class="author-profile-banner margin-bottom-large">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-md-7">
				<div class="author-profile-left">
					<div class="media">
						<?php echo get_avatar( $user->ID, '60', '' , '' , array( 'class' => array( '' ) ) ); ?>
						<div class="media-body">
							<span class="author"><?php echo esc_html( $user->display_name ); ?></span>
							<p>
								<b><?php esc_html_e( 'Joined: ', 'eidmart' ); ?></b>
								<?php
								$udata = get_userdata( $user->ID );
								$registered = $udata->user_registered;
								printf( '%s', date( "F j, Y", strtotime( $registered ) ) );
							
								?>
							</p>
							<ul class="vendor-social">

								<?php

								$facebook = get_the_author_meta( 'facebook', $user->ID );
								if ( $facebook && $facebook != '' ) {
								echo '<li><a href="' . esc_url($facebook) . '"><i class="fa fa-facebook"></i>&nbsp; </a></li>';
								}

								$twitter = get_the_author_meta( 'twitter', $user->ID );
								if ( $twitter && $twitter != '' ) {
								echo '<li><a href="' . esc_url($twitter) . '"><i class="fa fa-twitter"></i>&nbsp; </a></li>';
								}

								$linkedin = get_the_author_meta( 'linkedin', $user->ID );
								if ( $linkedin && $linkedin != '' ) {
								echo '<li><a href="' . esc_url($linkedin) . '"><i class="fa fa-linkedin"></i>&nbsp; </a></li>';
								}

								$dribbble = get_the_author_meta( 'dribbble', $user->ID );
								if ( $dribbble && $dribbble != '' ) {
								echo '<li><a href="' . esc_url($dribbble) . '"><i class="fa fa-dribbble"></i>&nbsp; </a></li>';
								}

								$github = get_the_author_meta( 'github', $user->ID );
								if ( $github && $github != '' ) {
								echo '<li><a href="' . esc_url($github) . '"><i class="fa fa-github"></i>&nbsp; </a></li>';
								}

								$behance = get_the_author_meta( 'behance', $user->ID );
								if ( $behance && $behance != '' ) {
								echo '<li><a href="' . esc_url($behance) . '"><i class="fa fa-behance"></i>&nbsp; </a></li>';
								}

								$instagram = get_the_author_meta( 'instagram', $user->ID );
								if ( $instagram && $instagram != '' ) {
								echo '<li><a href="' . esc_url($instagram) . '"><i class="fa fa-instagram"></i>&nbsp; </a></li>';
								}

								?>

							</ul>

						</div>
					</div>
				</div>
			</div>
			<div class="col-md-5">                  
				<div class="author-profile-right">
					<div class="row">
					
						<div class="col-md-6 offset-md-6">
							<div class="sales-info red">
								<h3><?php echo count_user_posts( $user->ID, 'download', 'false' ); ?></h3>
								<p><?php esc_html_e( 'Total Items', 'eidmart' ); ?></p>
							</div>
						</div>
					
					</div>
				</div>                      
			</div>
		</div>

		<?php if( get_user_meta( $user->ID, 'intro', true ) || get_user_meta( $user->ID, 'description', true ) ): ?>
		<div class="row">
			<div class="col-md-12">
				<div class="vendor-intro">
					<h1><?php esc_html_e( 'Introduction', 'eidmart' ); ?></h1> 
					<p>

					<?php 
					if( get_user_meta( $user->ID, 'intro', true ) ):
					echo wp_kses( get_user_meta( $user->ID, 'intro', true ), 'allowed_html' ); 
					else:
					echo wp_kses( get_user_meta( $user->ID, 'description', true ), 'allowed_html' );
					endif;
					?>
					
					</p>
				</div>
			</div>
		</div>
		<?php endif; ?>

	</div>
</div> 

<div class="container video-filter margin-bottom-large">
	<div class="row photography-filter">

		<?php

		$paged = ( get_query_var( 'paged')) ? get_query_var( 'paged') : 1;

		$args = array(
			'post_type' => 'download', 
			'author' => $user->ID,                               
			'posts_per_page' => 6,
			'paged' => $paged
		);

		$wp_query = new WP_Query( $args );

		if( $wp_query->have_posts() ) : 

			while( $wp_query -> have_posts() ) : $wp_query -> the_post(); 

			$id = get_the_ID();
            $meta = get_post_meta(get_the_ID());
            $variable_pricing = isset($meta['_variable_pricing'][0]) ? $meta['_variable_pricing'][0] : '';
            $edd_price = isset($meta['edd_price'][0]) ? $meta['edd_price'][0] : '';

            $sales = edd_get_download_sales_stats(get_the_ID());
            $sales = $sales > 1 ? $sales . __(' sales', 'eidmart') : $sales . __(' sale', 'eidmart');

            $internal_url = isset($meta['mp4_url'][0]) ? $meta['mp4_url'][0] : '';
            $external_url = isset($meta['external_url'][0]) ? $meta['external_url'][0] : '';

            $video_url = !empty( $external_url ) ? $external_url : $internal_url;
			$video_type = isset($meta['video_type'][0]) ? $meta['video_type'][0] : 1;

            // Collect downloads tearms
            $terms = get_the_terms($post->ID, 'download_category'); 
			
			/**
				* Get all variable pricing
				*/
			$prices = apply_filters( 'edd_purchase_variable_prices', edd_get_variable_prices( $id ), $id );
			
			/**
			* Get checked item
			*/
			$checked_key = isset( $_GET['price_option'] ) ? absint( $_GET['price_option'] ) : edd_get_default_variable_price( $id );
			$price_checked = apply_filters( 'edd_price_option_checked', $checked_key, $id );                            
			$price_checked = isset( $price_checked ) ? $price_checked: 0;

			// Variables pricing price
			$regular_amount = isset( $prices[$price_checked]['regular_amount'] ) ? $prices[$price_checked]['regular_amount']: 1;
			$sale_price = isset( $prices[$price_checked]['sale_price'] ) ? $prices[$price_checked]['sale_price']: 1;

			// Pricing options price
			$single_regular_price = get_post_meta( $id, 'edd_price', true );
			$single_sale_price = get_post_meta( $id, 'edd_sale_price', true );

			/**
				* Get the selected price of variable item
				*/
			if( 1 != $checked_key ): 
				$item_price = edd_price( $id, false, $price_checked ); 
			else: 
				$item_price = edd_price( $id, false, '' ); 
			endif;
			
			?>                    

			<div class="<?php echo esc_attr( get_theme_mod( 'course_grid', 'col-md-4' ) ); ?> photography-filter-item">
				<div class="load-more">
				
					<a class="photography-item_url" href="<?php the_permalink();?>">
					<?php if( $video_url ): 
						
						// Check video type
						if( $video_type == 1 ){ ?>

							<video <?php if( get_theme_mod( 'video_sound' ) == 1 ): echo "muted"; endif; ?> class="hvrbox-layer_bottom video-control" style="height: <?php echo esc_attr( get_theme_mod( 'video_height', 210 ) );?>px">
								<source src="<?php echo esc_url( $video_url ); ?>" type="video/mp4">
								<?php esc_html_e( 'Your browser does not support HTML5 video.', 'eidmart' ); ?>
							</video>

						<?php } else { ?>

							<!-- 16:9 aspect ratio -->
							<div class="embed-responsive embed-responsive-16by9" style="height: <?php echo esc_attr( get_theme_mod( 'video_height', 210 ) );?>px">
								<iframe class="embed-responsive-item" src="https://www.youtube.com/embed/<?php echo esc_attr( $video_url ); ?>?rel=0&controls=0&modestbranding=1&showinfo=0" allowfullscreen frameborder="0""></iframe>
							</div>

						<?php } endif; ?>
					</a>

					<?php
					/**
					 * Discount percentage calculation
					 */
					if( $sale_price && edd_has_variable_prices( $id ) ):
						$discount_percent = intval( 100 * ( $regular_amount - $sale_price ) / $regular_amount );
					elseif( $single_sale_price ):
						$discount_percent = intval( 100 * ( $single_regular_price - $single_sale_price ) / $single_regular_price );
					else:
						$discount_percent = 0;
					endif;

					/**
					 * Discount Percentage
					 */
					if( $discount_percent > 0 ):
					?>
					<p class="discount-percentage">
						<span><?php echo esc_html( $discount_percent ); ?>%</span>
						<?php esc_html_e( 'Off', 'eidmart' ); ?>
					</p>
					<?php endif; 
					
					if ( get_theme_mod( 'eid_love' ) == 'on' ): ?>
						<div class="image-rating">
							<span><i><?php echo eidmart_get_likes_button(get_the_ID()); ?></i></span>
						</div>
					<?php endif; if ( get_theme_mod( 'eid_price_con' ) == 'on' ): ?>
						<span class="sale"><?php if ($edd_price): echo wp_kses_post( $item_price ); else: echo __('Free', 'eidmart'); endif; ?></span>
					<?php endif;

					echo "<div class='auth-info'>"; 
						if( get_theme_mod( 'author' ) =='on' || get_theme_mod( 'category' ) =='on' ):                                            
							echo "<span>";
								if( get_theme_mod( 'author' ) =='on' ):
								
								// Author picture show
								echo get_avatar(get_the_author_meta('ID'), '40', '', '', array('class' => array('vendor-pic')));
								esc_html_e('by', 'eidmart');?> <a href="<?php if (!class_exists('EDD_Front_End_Submissions')) {echo esc_url(home_url('profile/'));?>?user=<?php echo esc_attr($user_name);} else {echo esc_url(eidmart_edd_fes_author_url());} ?>"> <?php the_author();?></a>

								<?php 
								endif;

								if ( get_theme_mod( 'category' ) == 'on' ):                                    
									esc_html_e('in', 'eidmart');                                                
									$terms = get_the_terms($id, 'download_category');
									if (!empty($terms) && !is_wp_error($terms)) {
										//foreach ( $terms as $term ) {
										?>
											<a href="<?php echo esc_url(get_term_link($terms[0])); ?>"><?php echo esc_html($terms[0]->name); ?></a>
											<?php if( $video_type == 2 && get_theme_mod( 'youtube_btn' ) ): ?>
											<a class="btn-hover color-11" href="<?php the_permalink(); ?>"><?php echo esc_html( get_theme_mod( 'youtube_btn', 'Read more' ) ); ?></a>
										<?php
									endif; // End video type checking
									//}
									}
								endif;                                    
							echo "</span>";
						endif; // End author and category

						if (class_exists('EDD_Reviews') && get_theme_mod( 'eid_ratings' ) == 'on') {
							echo "<span class='bt-review'>";

								$mreview = new \EDD_Reviews;
								$rating = $mreview->average_rating(false);
								echo wp_kses_post( $mreview->render_star_rating( $rating ));
								echo '('. esc_html( $mreview->count_reviews()) .')';

							echo "</span>";
						} // End ratings check 
						if ( get_theme_mod( 'eid_sales' ) == 'on'): 
							echo "<span>".esc_html( $sales )."</span>";
						endif;
						?>
					</div>
				</div>
			</div>

			<?php endwhile; wp_reset_postdata(); ?> 


			<?php if( paginate_links() ): ?>               

				<div class="col-md-12">
					<div class="course-pagination">
						<ul class="pagination">
							<li>
								<?php

								global $wp_query;
						
								$big = 999999999; // need an unlikely integer

								echo paginate_links( array(                         
									
									'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
									'total'        => $wp_query->max_num_pages,
									'current'      => max( 1, get_query_var( 'paged' ) ),
									'format'       => '?paged=%#%',
									'show_all'     => false,
									'type'         => 'plain',
									'end_size'     => 2,
									'mid_size'     => 1,
									'prev_next'    => true,
									'prev_text' => '<i class="fa fa-angle-left"></i>',
									'next_text' => '<i class="fa fa-angle-right"></i>',
									'add_args'     => false,
									'add_fragment' => ''

								) );

								?>
							</li>
						</ul>
					</div>
				</div>

			<?php

			endif;                           

		else: ?>                            
		
			<h4><?php esc_html_e( 'No item available right now.','eidmart' ); ?></h4>
		
		<?php endif; ?>

	</div>
</div>


<?php } get_footer(); ?>