<?php 

/**
 * Template Name: Graphicland:: Multi Vendor Graphicland Profile Template (1)
 *
 * @package eidmart
 **/

get_header();

global $post;

$user_name = get_query_var('vendor');
$username = $user_name;
$user = get_user_by( 'login', $username);

$products = EDD_FES()->vendors->get_all_products( $user->ID );

$sales = 0;
$earnings = 0;
if (!empty($products)) {
	foreach ($products as $product) {
		$sales += $product['sales'];
		$earnings += $product['earnings'];
	}
} 

// Vendor information
$db_user = new FES_DB_Vendors();
$vendor = $db_user->get_vendor_by( 'user_id', $user->ID );


// check if vendor
if ( $db_user->exists( 'user_id', $user->ID ) ) {
?>

	<div class="author-profile-banner margin-bottom-large">
		<div class="container graphicland-one graphicland-style">
			<div class="row  align-items-center">
				<div class="col-md-6">
					<div class="author-profile-left">
						<div class="media">
							<?php echo get_avatar( $user->ID, '60', '' , '' , array( 'class' => array( '' ) ) ); ?>
							<div class="media-body">
								<span class="author">
								<?php 

								if( get_user_meta( $user->ID, 'name_of_store', true ) ):                                  
									echo get_user_meta( $user->ID, 'name_of_store', true ); 
								else :
									echo esc_html( $user->display_name ); 
								endif;

								?>
								</span>
								
								<p>
								<b><?php esc_html_e( 'Joined: ', 'eidmart' ); ?></b>
								<?php
									$udata = get_userdata( $user->ID );
									$registered = $udata->user_registered;
									printf( '%s', date( "F j, Y", strtotime( $registered ) ) );
								
								?>
								</p>
								<ul class="vendor-social">
									<?php if( get_user_meta( $user->ID, 'facebook', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( $user->ID, 'facebook', true )); ?>"><i class="fa fa-facebook"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( $user->ID, 'twitter', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( $user->ID, 'twitter', true )); ?>"><i class="fa fa-twitter"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( $user->ID, 'linkedin', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( $user->ID, 'linkedin', true )); ?>"><i class="fa fa-linkedin"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( $user->ID, 'dribbble', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( $user->ID, 'dribbble', true )); ?>"><i class="fa fa-dribbble"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( $user->ID, 'github', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( $user->ID, 'github', true )); ?>"><i class="fa fa-github"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( $user->ID, 'behance', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( $user->ID, 'behance', true )); ?>"><i class="fa fa-behance"></i></a></li><?php endif; ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-6">                  
					<div class="author-profile-right">
						<div class="row">                      

							<?php if( get_current_user_id() == $user->ID ): ?>
							
							<div class="col-md-4">
								<div class="sales-info orange">
									<h3><?php echo edd_currency_symbol(); echo esc_html( intval( $vendor->sales_value ) ); ?></h3>
									<p><?php esc_html_e( 'Total Earnings', 'eidmart' ); ?></p>
								</div>
							</div>

							<div class="col-md-4">
								<div class="sales-info blue">
									<h3><?php echo esc_html( $vendor->sales_count ); ?></h3>
									<p><?php esc_html_e( 'Lifetime Sales', 'eidmart' ); ?></p>
								</div>
							</div>

							<?php else : ?>

							<div class="col-md-4 offset-md-4">
								<div class="sales-info blue">
									<h3><?php echo esc_html( $vendor->sales_count ); ?></h3>
									<p><?php esc_html_e( 'Lifetime Sales', 'eidmart' ); ?></p>
								</div>
							</div>

							<?php endif; ?>

							<div class="col-md-4">
								<div class="sales-info red">
									<h3><?php echo esc_html( $vendor->product_count ); ?></h3>
									<p><?php esc_html_e( 'Total Items', 'eidmart' ); ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<?php if( get_user_meta( $user->ID, 'intro', true ) ): ?>
			<div class="row">
				<div class="col-md-12">
					<div class="vendor-intro">
						<h1><?php esc_html_e( 'Introduction', 'eidmart' ); ?></h1> 
						<p><?php echo wp_kses( get_user_meta( $user->ID, 'intro', true ), 'allowed_html' ); ?></p>
					</div>
				</div>
			</div>
			<?php endif; ?>
			
		</div>
	</div>  

	<div class="latest-product-1x graphicland-profile-product graphicland-style graphicland-one">
		<div class="container">
			<div class="row">          

				<div class="col-md-12">
					<div class="row">

						<?php
						// Author item display
						$paged = ( get_query_var( 'paged')) ? get_query_var( 'paged') : 1;

						$args = array(
							'post_type' => 'download', 
							'author' => $user->ID,  
							'product_para' => '',
							'paged' => $paged,
							'posts_per_page' => get_option( 'posts_per_page' )
						);


						$temp = $wp_query; 
						$wp_query = null; 

						$wp_query = new WP_Query(); 

						$wp_query -> query( $args ); 

						if( $wp_query->have_posts() ):
							while ( $wp_query->have_posts() ) : 
								$wp_query -> the_post();

						
								$id = get_the_ID();
								$meta = get_post_meta( get_the_ID() );
								$variable_pricing = isset( $meta['_variable_pricing'][0] ) ? $meta['_variable_pricing'][0] : '';
								$edd_price = isset( $meta['edd_price'][0] ) ? $meta['edd_price'][0] : '';

								$sales = edd_get_download_sales_stats( get_the_ID() );
								$sales = $sales > 1 ? esc_html__('Sales ', 'eidmart') . $sales : esc_html__('Sale ', 'eidmart') .$sales;

								/**
								 * Get all variable pricing
								 */
								$prices = apply_filters( 'edd_purchase_variable_prices', edd_get_variable_prices( $id ), $id );
								
								/**
								 * Get checked item
								 */
								$checked_key = isset( $_GET['price_option'] ) ? absint( $_GET['price_option'] ) : edd_get_default_variable_price( $id );
								$price_checked = apply_filters( 'edd_price_option_checked', $checked_key, $id );                            
								$price_checked = isset( $price_checked ) ? $price_checked: 0;

								// Variables pricing price
								$regular_amount = isset( $prices[$price_checked]['regular_amount'] ) ? $prices[$price_checked]['regular_amount']: 1;
								$sale_price = isset( $prices[$price_checked]['sale_price'] ) ? $prices[$price_checked]['sale_price']: 1;

								// Pricing options price
								$single_regular_price = get_post_meta( $id, 'edd_price', true );
								$single_sale_price = get_post_meta( $id, 'edd_sale_price', true );

								/**
								 * Get the selected price of variable item
								 */
								if( 1 != $checked_key ): 
									$item_price = edd_price( $id, false, $price_checked ); 
								else: 
									$item_price = edd_price( $id, false, '' ); 
								endif;
								
								?>

								<div class="<?php echo esc_attr( get_theme_mod( 'course_grid', 'col-md-3' ) ); ?>">
									<div class="single-product">                  
										<div class="graphicland-product-container">                               
											<div class="product-content">
												<a href="<?php the_permalink(); ?>" target="_blank">
													<div class="content-overlay"></div>

													<?php the_post_thumbnail( '', [ 'class' => 'graphicland-image' ] ); ?>
												
													<div class="overlay-center">
														<?php if( get_post_meta( $post->ID, 'preview_url',true ) ): ?>
														<div class="graphicland-live-preview">
															<?php if( get_post_meta( $post->ID, 'preview_url',true) ): ?><a  target="_blank" href="<?php echo esc_url( get_post_meta( $post->ID, 'preview_url',true) ); ?>"> <i class="las la-eye"></i> </a><?php endif; ?>
														</div>
														<?php endif; if ( get_theme_mod( 'eid_love' ) == 'on'): ?>
														<div class="graphicland-favourite-icon">
															<?php echo eidmart_get_likes_button( get_the_ID() ); ?>
														</div>
														<?php endif; ?>
													</div>                                
												</a>
											</div>
										</div>
									
										<?php if( !empty( get_post_meta( $post->ID, 'edd_feature_download' ) ) ): ?>
											<span class="sticker-feature"><i class="fa fa-gitlab"></i></span>
										<?php endif; 

										/**
										* Discount percentage calculation
										*/
										if( $sale_price && edd_has_variable_prices( $id ) ):
											$discount_percent = intval( 100 * ( $regular_amount - $sale_price ) / $regular_amount );
										elseif( $single_sale_price ):
											$discount_percent = intval( 100 * ( $single_regular_price - $single_sale_price ) / $single_regular_price );
										else:
											$discount_percent = 0;
										endif;

										/**
										* Discount Percentage
										*/
										if( $discount_percent > 0 ):
										?>
										<p class="discount-percentage">
											<span><?php echo esc_html( $discount_percent ); ?>%</span>
											<?php esc_html_e( 'Off', 'eidmart' ); ?>
										</p>
										<?php endif; ?>

										<div class="product-details graphicland-product-details">
											<div class="product-content">

												<div class="product-details graphicland-product-details">                                       
													<h3 class="content-title" ><a href="<?php the_permalink(); ?>"><?php echo eidmart_excerpt_char_course_title( get_theme_mod( 'max_char', '30' ) ); ?></a> <?php if( get_theme_mod( 'eid_price_con' ) == 'on' ): ?><strong><?php if( $edd_price ): echo wp_kses_post( $item_price ); else: echo __( 'Free','eidmart' ); endif; ?></strong><?php endif; ?></h3>
												</div>
												
												<?php

												// Collect user ID
												$user_id = get_the_author_meta( 'ID' ); 
												// Collect user name
												$user_name = get_the_author_meta( 'user_login' , $user_id );

												echo "<p>"; 
													if( get_theme_mod( 'author' ) =='on' || get_theme_mod( 'category' ) =='on' ):                                            
														echo "<span>";
															if( get_theme_mod( 'author' ) =='on' ):
															echo get_avatar( $user_id, 20, '' , '' , array( 'class' => array( 'vendor-avatar' ) ) ); ?> <a href="<?php if( !class_exists( 'EDD_Front_End_Submissions' ) ){ echo esc_url( home_url( 'profile/' ) ); ?>?user=<?php echo esc_attr( $user_name ); } else { echo esc_url( eidmart_edd_fes_author_url() ); } ?>"> <?php the_author(); ?></a> 
															
															<?php 
															endif;
															if( get_theme_mod( 'category' ) =='on' ):
															esc_html_e( 'in', 'eidmart' ); ?>
															<?php
																$terms = get_the_terms( $id , 'download_category' );
																if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
																	//foreach ( $terms as $term ) {
																		?>
															
																		<a href="<?php echo esc_url( get_term_link( $terms[0] ) ); ?>"><?php echo esc_html( $terms[0]->name ); ?></a> 

																		<?php                             
																// }
																}
															endif;
														echo "</span>";
													endif; // End author and category

													if (class_exists('EDD_Reviews') && get_theme_mod( 'eid_ratings' ) == 'on') {
														echo "<span class='bt-review'>";

															$mreview = new \EDD_Reviews;
															$rating = $mreview->average_rating(false);
															echo wp_kses_post( $mreview->render_star_rating( $rating ));
															echo '('. esc_html( $mreview->count_reviews()) .')';

														echo "</span>";
													} // End ratings check 
													if ( get_theme_mod( 'eid_sales' ) == 'on'): 
														echo "<span>".esc_html( $sales )."</span>";
													endif;
													?>
												</p>                                  

											</div>
										</div>
									</div>
								</div>                     

								<?php endwhile; wp_reset_postdata();  if( paginate_links() ): ?>  

								<div class="col-md-12">
									<div class="course-pagination">
										<ul class="pagination">
											<li>
											<?php

											global $wp_query;
										
											$big = 999999999; // need an unlikely integer

											echo paginate_links( array(             
												
												'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
												'total'        => $wp_query->max_num_pages,
												'current'      => max( 1, get_query_var( 'paged' ) ),
												'format'       => '?paged=%#%',
												'show_all'     => false,
												'type'         => 'plain',
												'end_size'     => 2,
												'mid_size'     => 1,
												'prev_next'    => true,
												'prev_text' => '<i class="fa fa-angle-left"></i>',
												'next_text' => '<i class="fa fa-angle-right"></i>',
												'add_args'     => false,
												'add_fragment' => ''

											) );

											?>
											</li>
										</ul>
									</div>
								</div>                           

						<?php endif; else: ?>                            
						
							<h4><?php esc_html_e( 'No item available right now.','eidmart' ); ?></h4>
						
						<?php endif; ?>

					</div>
				</div>

			</div>
		</div>     
	</div> 
	
<?php } else { ?>


<div class="page-banner">                 
	<div class="hvrbox">       
		<?php echo the_post_thumbnail( '', array( 'class' => 'hvrbox-layer_bottom' ) ); ?>
		<div class="hvrbox-layer_top">
			<div class="container">
				<div class="overlay-text text-center">
					<h1><?php esc_html_e( 'Become a Vendor', 'eidmart' ); ?></h1>
				</div>
			</div>
		</div>
	</div>                       
</div>

<div class="simple-page-content">
	<div class="container">
		<div class="row">

			<div class="col-md-6 offset-md-3">
				<?php echo do_shortcode( '[fes_registration_form]' ); ?>                
			</div>

		</div>
	</div>
</div>

<?php } get_footer(); ?>