<?php
/*
* Template Name: General:: Vendor Dashboard
*
* @package Vendd
*/
get_header(); 

global $current_user;

$products = EDD_FES()->vendors->get_all_products( get_current_user_id() );

// Vendor information
$db_user = new FES_DB_Vendors();
$vendor = $db_user->get_vendor_by( 'user_id', get_current_user_id() );


// check if vendor
if ( $db_user->exists( 'user_id', get_current_user_id() ) ) {

	if( is_user_logged_in() ): ?>

	<div class="author-profile-banner">
		<div class="container">
			<div class="row align-items-center">

				<div class="col-md-6">
					<div class="author-profile-left">
						<div class="media">
							<?php echo get_avatar( get_current_user_id(), '60', '' , '' , array( 'class' => array( '' ) ) ); ?>
							<div class="media-body">
								<span class="author">
									<?php 

									if( get_user_meta( get_current_user_id(), 'name_of_store', true ) ):                                  
									echo get_user_meta( get_current_user_id(), 'name_of_store', true ); 
									else :
									echo esc_html( $current_user->display_name ); 
									endif;

									?>
									</span>
								<p>
									<b><?php esc_html_e( 'Joined: ', 'eidmart' ); ?></b>
									<?php
									$udata = get_userdata( get_current_user_id() );
									$registered = $udata->user_registered;
									printf( '%s', date( "F j, Y", strtotime( $registered ) ) );
								
									?>
								</p>
								<ul class="vendor-social">
									<?php if( get_user_meta( get_current_user_id(), 'facebook', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( get_current_user_id(), 'facebook', true )); ?>"><i class="fa fa-facebook"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( get_current_user_id(), 'twitter', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( get_current_user_id(), 'twitter', true )); ?>"><i class="fa fa-twitter"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( get_current_user_id(), 'linkedin', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( get_current_user_id(), 'linkedin', true )); ?>"><i class="fa fa-linkedin"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( get_current_user_id(), 'dribbble', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( get_current_user_id(), 'dribbble', true )); ?>"><i class="fa fa-dribbble"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( get_current_user_id(), 'github', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( get_current_user_id(), 'github', true )); ?>"><i class="fa fa-github"></i></a></li><?php endif; ?>
									<?php if( get_user_meta( get_current_user_id(), 'behance', true ) ): ?><li><a href="<?php echo esc_url( get_user_meta( get_current_user_id(), 'behance', true )); ?>"><i class="fa fa-behance"></i></a></li><?php endif; ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-6">                  
					<div class="author-profile-right">
						<div class="row">                      

							<div class="col-md-4">
								<div class="sales-info orange">
									<h3><?php echo edd_currency_symbol(); echo esc_html( intval( $vendor->sales_value ) ); ?></h3>
									<p><?php esc_html_e( 'Total Earnings', 'eidmart' ); ?></p>
								</div>
							</div>

							<div class="col-md-4">
								<div class="sales-info blue">
									<h3><?php echo esc_html( $vendor->sales_count ); ?></h3>
									<p><?php esc_html_e( 'Lifetime Sales', 'eidmart' ); ?></p>
								</div>
							</div>                        

							<div class="col-md-4">
								<div class="sales-info red">
									<h3><?php echo esc_html( $vendor->product_count ); ?></h3>
									<p><?php esc_html_e( 'Total Items', 'eidmart' ); ?></p>
								</div>
							</div>						
						
						</div>                      
					</div>
				</div>

			</div>
		</div>
	</div>

	<?php else: ?>

	<div class="margin-bottom-middle"></div>

	<?php endif; ?>

	<div class="vendor-dashboard-main">
		<div class="container">
			<div class="row">
				
				<div class="col-md-3">

					<a target="_blank" href="<?php echo esc_url( home_url( '/vendor/'. $current_user->user_login ) ); ?>" class="btn-hover color-11"> <?php esc_html_e( 'Your Public Store', 'eidmart' ); ?> </a>
					
					<?php

					$featured_item = get_user_meta( get_current_user_id(), 'featured_item', true );
					
					if ( $featured_item ) {
						
						$args = array(
							'post_type' => 'download', 
							'author' => get_current_user_id(),                              
							'post__in' => array( $featured_item ),
							'posts_per_page' => 1
						);


						$featured_item = new WP_Query( $args ); 

							if( $featured_item->have_posts() ):
								while ( $featured_item->have_posts() ) : 

								$featured_item -> the_post();

						
								$id = get_the_ID();
								$meta = get_post_meta( get_the_ID() );
								$variable_pricing = isset( $meta['_variable_pricing'][0] ) ? $meta['_variable_pricing'][0] : '';
								$edd_price = isset( $meta['edd_price'][0] ) ? $meta['edd_price'][0] : '';

								$sales = edd_get_download_sales_stats( get_the_ID() );
								$sales = $sales > 1 ? $sales . esc_html__(' sales','eidmart') : $sales . esc_html__(' sale','eidmart');

								?>
								
							
								<div class="vendor-feature-product">
									<h2><?php esc_html_e( 'Featured Item', 'eidmart' ); ?></h2>
									<?php the_post_thumbnail(); ?>

									<a href="<?php the_permalink(); ?>"><?php echo eidmart_excerpt_char_course_title( '30' ); ?></a>
									<h3> <strong><?php if( $edd_price ): echo edd_price(); else: echo esc_html__( 'Free','eidmart' ); endif; ?></strong></h3>
									
								</div>
								

								<?php endwhile; wp_reset_postdata();                     

						else: ?>                            
						
							<div class="vendor-feature-product">
								<h3><?php esc_html_e( 'No item available right now.','eidmart' ); ?></h3>
							</div>

					<?php endif; } ?>

					<?php if( get_user_meta( get_current_user_id(), 'work_ad', true ) ): ?>
					<div class="freelance-available">
						<i class="fa fa-check-circle"></i> <?php echo get_user_meta( get_current_user_id(), 'work_ad', true ); ?>
					</div>
					<?php endif; ?>

				</div>

				<div class="col-md-9">
					<?php while ( have_posts() ) : the_post(); ?>
			
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<?php the_content(); ?>
						</article>

					<?php endwhile; // end of the loop. ?>
				</div>			

			</div>
		</div>
	</div>

<?php } else { ?>

<div class="page-banner">                 
	<div class="hvrbox">       
		<?php echo the_post_thumbnail( '', array( 'class' => 'hvrbox-layer_bottom' ) ); ?>
		<div class="hvrbox-layer_top">
			<div class="container">
				<div class="overlay-text text-left">
					<nav aria-label="breadcrumb">
						<?php eidmart_breadcrumbs(); ?>
					</nav>
					<h1><?php the_title(); ?></h1>
				</div>
			</div>
		</div>
	</div>                       
</div>

<div class="simple-page-content">
	<div class="container">
		<div class="row">

			<div class="col-md-6 offset-md-3">
				<?php echo do_shortcode( '[fes_registration_form]' ); ?>                
			</div>

		</div>
	</div>
</div>

<?php } get_footer(); ?>