<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eidmart
 */

get_header(); 

$author = get_user_by( 'slug', get_query_var( 'author_name' ) );

?>

<div class="author-profile-banner">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-md-9">
				<div class="author-profile-left">
					<div class="media">
						<?php echo get_avatar( get_the_author_meta( 'user_email' )); ?>
						<div class="media-body">
							<span class="author">
								<?php the_author(); ?>
							</span>
							<p>
								<b><?php esc_html_e( 'Joined: ', 'eidmart' ); ?></b>
								<?php
								$udata = get_userdata( get_the_author_meta( 'ID' ) );
								$registered = $udata->user_registered;
								printf( '%s', date( "F j, Y", strtotime( $registered ) ) );
							
								?>
							</p>
							<ul class="vendor-social">

								<?php

								$facebook = get_the_author_meta( 'facebook' );
								if ( $facebook && $facebook != '' ) {
									echo '<li><a href="' . esc_url($facebook) . '"><i class="fa fa-facebook"></i>&nbsp; </a></li>';
								}

								$twitter = get_the_author_meta( 'twitter' );
								if ( $twitter && $twitter != '' ) {
									echo '<li><a href="' . esc_url($twitter) . '"><i class="fa fa-twitter"></i>&nbsp; </a></li>';
								}

								$linkedin = get_the_author_meta( 'linkedin' );
								if ( $linkedin && $linkedin != '' ) {
									echo '<li><a href="' . esc_url($linkedin) . '"><i class="fa fa-linkedin"></i>&nbsp; </a></li>';
								}

								$dribbble = get_the_author_meta( 'dribbble' );
								if ( $dribbble && $dribbble != '' ) {
									echo '<li><a href="' . esc_url($dribbble) . '"><i class="fa fa-dribbble"></i>&nbsp; </a></li>';
								}

								$github = get_the_author_meta( 'github' );
								if ( $github && $github != '' ) {
									echo '<li><a href="' . esc_url($github) . '"><i class="fa fa-github"></i>&nbsp; </a></li>';
								}

								$behance = get_the_author_meta( 'behance' );
								if ( $behance && $behance != '' ) {
									echo '<li><a href="' . esc_url($behance) . '"><i class="fa fa-behance"></i>&nbsp; </a></li>';
								}

								$instagram = get_the_author_meta( 'instagram' );
								if ( $instagram && $instagram != '' ) {
									echo '<li><a href="' . esc_url($instagram) . '"><i class="fa fa-instagram"></i>&nbsp; </a></li>';
								}

								?>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-3">                  
				<div class="author-profile-right">
					<div class="row">                      

						<div class="col-md-12">
							<div class="sales-info red">
								<h3><?php echo count_user_posts( get_the_author_meta( 'ID' ) ); ?></h3>
								<p><?php esc_html_e( 'Total Articles', 'eidmart' ); ?></p>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>

		<?php 
		if( function_exists( 'EDD' ) ) {
			if( get_user_meta( $author->ID, 'intro', true ) || get_user_meta( $author->ID, 'description', true ) ): ?>
			<div class="row">
				<div class="col-md-12">
					<div class="vendor-intro">
						<h1><?php esc_html_e( 'Introduction', 'eidmart' ); ?></h1> 
						<p>

						<?php 
						if( get_user_meta( $author->ID, 'intro', true ) ):
							echo wp_kses( get_user_meta( $author->ID, 'intro', true ), 'allowed_html' ); 
						else:
							echo wp_kses( get_user_meta( $author->ID, 'description', true ), 'allowed_html' );
						endif;
						?>
							
						</p>
					</div>
				</div>
			</div>
			<?php endif; 
		} ?>
		
	</div>
</div> 

<div class="container blog-1x author-post">     

	<div class="col-md-12">
		<div class="row">
					
			<div class="col-md-12">
				<div class="row">  

					<?php 
			
					if( have_posts() ):
						while (have_posts() ) : 
							the_post(); ?>

							<div class="col-lg-4">
								<div class="single-blog hover01">
									<figure>
										<a href="<?php the_permalink();?>">
											<?php the_post_thumbnail();?>
										</a>
									</figure>
									<div class="blog-content">

										<span><i class="fa fa-bookmark-o"></i>
											<?php $categories = get_the_category();
											if (!empty($categories)) {
												echo esc_html($categories[0]->name);
											} ?>
										</span>

										<a href="<?php the_permalink();?>" title="<?php the_title();?>"><?php echo eidmart_excerpt_char_course_title( 45 ); ?></a>

										<div class="pub-meta">
											<span class="pub-author">
												<i class="fa fa-clock-o"></i><?php the_time('d M, Y');?>
											</span>
										</div>

									</div>
								</div>
							</div>

						<?php 
						
						endwhile; wp_reset_postdata();

						if( paginate_links() ):
						?>          

						<div class="col-md-12">
							<div class="course-pagination">
								<ul class="pagination">
								<li>
								<?php
							
								$big = 999999999; // need an unlikely integer

								echo paginate_links(array(
									'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
									'format'    => '?paged=%#%',
									'current'   => max(1, get_query_var('paged')),
									'total'     => $wp_query->max_num_pages,
									'type'      => '',
									'prev_text' => '<i class="fa fa-angle-left"></i>',
									'next_text' => '<i class="fa fa-angle-right"></i>',
								));

								?>
								</li>
								</ul>
							</div>
						</div>

						<?php
						endif;

					else:
				
					?>                
					
					<h3><?php echo esc_html__( 'There are no related blog post.','eidmart' ); ?></h3>
					
					<?php endif; ?>

				</div>
			</div>   

		</div>
	</div>
	
</div>

<?php 
get_footer();
