<?php
/**
 * The template for displaying posts with no or standard format
 */
if (!defined('ABSPATH')) {
    exit();
}
?>
<div <?php post_class('blog-article'); ?>>
     <?php
    $embeds = null;
    if (has_post_format('video') || has_post_format('audio')) {
        $content = do_shortcode(apply_filters('the_content', get_the_content()));
        $embeds = get_media_embedded_in_content($content);
    }

    if (has_post_thumbnail() || $embeds != null) {
        ?>
    <div class='blog-article-thumbnail'>
            <?php if ($embeds != null) { ?>
                <div <?php
                if (has_post_format('video')) {
                    echo 'class="embed-responsive embed-responsive-16by9"';
                }
                ?>>
                        <?php print $embeds[0]; ?>
                </div>
                <?php
            } else { the_post_thumbnail(); } ?>
        </div>
    <?php } ?>	

    <div class="blog-article-date"><?php echo get_the_date('d M, Y'); ?></div>

    <div class="blog-article-details">

        <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

        <p>

            <?php
            esc_html_e('By ', 'dakota-theme');
            the_author();
            ?> | <?php the_category(', '); ?> | 
            <a href="<?php comments_link(); ?>"><?php
                echo get_comments_number();
                esc_html_e(' Comments', 'dakota-theme');
                ?></a>

        </p>

        <?php the_excerpt(); ?>

    <a class="btn btn-white" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'dakota-theme'); ?></a>

    </div><!-- blog-article-details -->	


</div><!-- blog-article -->