<?php
/*
 * Template used for displaying the single posts content
 */
if (!defined('ABSPATH')) {
    exit();
}
?>

<div <?php post_class('blog-article'); ?>>
    <?php if (has_post_thumbnail()) { ?>
        <div class='blog-article-thumbnail'>
            <?php the_post_thumbnail(); ?>							
        </div>
    <?php } ?>	

    <div class="blog-article-date"><?php echo get_the_date('d M, Y'); ?></div>

    <div class="blog-article-details">

        <h5><?php the_title(); ?></h5>

        <p>

            <?php
            esc_html_e('By ', 'dakota-theme');
            the_author();
            ?> | <?php the_category(', '); ?> | 
            <a href="<?php comments_link(); ?>"><?php
                echo get_comments_number();
                esc_html_e(' Comments', 'dakota-theme');
                ?></a>

        </p>

        <?php the_content(''); ?>

    </div><!-- blog-article-details -->	

    <?php
    the_tags();
    echo '<br>';
    wp_link_pages();
    posts_nav_link();
    ?>

</div><!-- blog-article -->

<div class="blog-article-author">

    <?php echo get_avatar(get_the_author_meta('ID'), 110); ?>

    <div class="blog-article-author-details">

        <h6>
            <?php the_author_meta('display_name'); ?>, 
            <span> <?php esc_html_e('author', 'dakota-theme'); ?></span>
        </h6>

        <p><em><?php the_author_meta('description'); ?></em></p>

    </div><!-- blog-article-author-details -->

</div><!-- blog-article-author -->

<?php comments_template(); ?> 