<?php
/**
 * The template for displaying portfolio posts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
get_header();
if ( have_posts() ) {
    // Current portfolio post sidebar related meta
    $sidebar_position = get_post_meta( get_the_ID(), 'milo_sidebar_position', true );

    // Start the Loop.
    while ( have_posts() ) {
        the_post();
        
        $content = $post->post_content;

        if ( !empty( $sidebar_position ) && $sidebar_position != 'none' || strpos( $content, '[/vc_row]' ) === false ) {
            echo '<div class="container"><div class="row">';
        }

        if ( !empty( $sidebar_position ) ) {
            if ( $sidebar_position == 'left' ) {
                get_sidebar();
            }
        }

        if ( !empty( $sidebar_position ) && $sidebar_position != 'none' ) {
           global $milo_theme_options;
            if ( isset( $milo_theme_options['milo-sidebars-size'] ) ) {
                $span_size = 12 - $milo_theme_options['milo-sidebars-size'];
                echo '<div class="col-sm-' . absint($span_size) . '">';
            } else {
                echo '<div class="col-sm-8">';
            }
        } else if ( strpos( $content, '[/vc_row]' ) === false ) {
            echo '<div class="col-sm-12">';
        }

        the_content();

        if ( !empty( $sidebar_position ) && $sidebar_position != 'none' || strpos( $content, '[/vc_row]' ) === false ) {
            echo '</div>';
        }

        if ( !empty( $sidebar_position ) ) {
            if ( $sidebar_position == 'right' ) {
                get_sidebar();
            }
        }

        if ( !empty( $sidebar_position ) && $sidebar_position != 'none' || strpos( $content, '[/vc_row]' ) === false ) {
            echo '</div></div>';
        }
    }
} else {
    get_template_part( 'content', 'none' );
}
get_footer();