<?php
/**
 * The template for displaying a "No posts found" message
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
?>
<div class="col-sm-6">
    <header>
        <h3><?php esc_html_e( 'Nothing Found', 'dakota-theme' ); ?></h3>
    </header>

    <div>
        <?php if( is_home() && current_user_can( 'publish_posts' ) ) : ?>

            <p><?php
                echo esc_html__( 'Ready to publish your first post?', 'dakota-theme' )
                . '<a href="' . esc_url( admin_url( 'post-new.php' ) ) . '">'
                . esc_html__( 'Get started here', 'dakota-theme' ) . '</a>.';
                ?></p>

        <?php elseif( is_search() ) : ?>

            <p><?php echo esc_html__( 'There are no search results for ', 'dakota-theme' ) . get_search_query(); ?></p>
            <div class="widget widget_search">
            <?php get_search_form(); ?>
                </div>

        <?php else : ?>

            <p><?php esc_html_e( 'It seems we cannot find what you are looking for. Perhaps searching can help.', 'dakota-theme' ); ?></p>
            <div class="widget widget_search">
            <?php get_search_form(); ?>
                </div>

        <?php endif; ?>
    </div>
</div>