<?php
/**
 * Template Name: Posts 2 columns masonry
 * The template for displaying blog posts in 2 columns masonry
 */
if (!defined('ABSPATH')) {
    exit();
}
get_header();
// Get Blog related header meta
$post_id = get_the_id();
?> 
<div class="container">	
    <div class="row">
        <?php
        $sidebar_position = get_post_meta($post_id, 'milo_sidebar_position', true);
        if ($post_id == 0) {
            $sidebar_position = 'right';
        }

        if (!empty($sidebar_position)) {
            if ($sidebar_position == 'left') {
                get_sidebar();
            }
        }
        if (!empty($sidebar_position) && $sidebar_position != 'none') {
            global $milo_theme_options;
            if (isset($milo_theme_options['milo-sidebars-size'])) {
                $span_size = 12 - $milo_theme_options['milo-sidebars-size'];
            } else {
                $span_size = 8;
            }
            ?>
            <div class="col-sm-<?php echo absint($span_size); ?>"> 
                <div class="row">
                    <?php the_post();
                    the_content();
                    ?>
                </div>
                <?php
                // There is a sidebar
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array(
                    'post_type' => 'post',
                    'paged' => $paged,
                    'post_status' => 'publish');

                $loop = new WP_Query($args);
                if ($loop->have_posts()) {
                    ?>
                    <div class="isotope col-2 gutter">
                        <?php
                        while ($loop->have_posts()) : $loop->the_post();
                            get_template_part('templates/post', 'masonry');
                        endwhile;
                        ?>
                    </div>
                        <?php
                        if ($loop->max_num_pages > 1) {
                            ?>
                        <ul class="pagination">
                        <?php for ($i = 1; $i <= $loop->max_num_pages; $i++) { ?>
                                <li <?php echo ($paged == $i) ? 'class="active"' : ''; ?>><a href="<?php echo get_permalink($post_id) . 'page/' . esc_attr($i); ?>" ><?php echo esc_html($i); ?></a></li>
                        <?php }
                        ?>
                        </ul>
                    <?php } ?>

                    <?php
                } else {
                    // If no content, include the "No posts found" template.
                    get_template_part('templates/content', 'none');
                }
                ?>
            </div>   
                <?php } else {
                    ?>
            <div class="col-sm-12"> 
                <div class="row">
                <?php the_post();
                the_content();
                ?>
                </div>
                <?php
                // There is no sidebar
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array(
                    'post_type' => 'post',
                    'paged' => $paged,
                    'post_status' => 'publish');

                $loop = new WP_Query($args);
                if ($loop->have_posts()) {
                    ?>
                    <div class="isotope col-2 gutter">
                    <?php
                    while ($loop->have_posts()) : $loop->the_post();
                        get_template_part('templates/post', 'masonry');
                    endwhile;
                    ?>
                    </div>

                    <?php if ($loop->max_num_pages > 1) {
                        ?>
                        <ul class="pagination text-center">
                        <?php for ($i = 1; $i <= $loop->max_num_pages; $i++) { ?>
                                <li <?php echo ($paged == $i) ? 'class="active"' : ''; ?>><a href="<?php echo get_permalink($post_id) . 'page/' . esc_attr($i); ?>" ><?php echo esc_html($i); ?></a></li>
                        <?php }
                        ?>
                        </ul>
                    <?php
                }
            } else {
                // If no content, include the "No posts found" template.
                get_template_part('templates/content', 'none');
            }
            ?>
            </div>
            <?php
        }

        if (!empty($sidebar_position)) {
            if ($sidebar_position == 'right') {
                get_sidebar();
            }
        }
        ?>
    </div> 
</div> 
<?php
get_footer();
