<?php
/**
 * The Template for displaying all single posts
 */
if ( !defined( 'ABSPATH' ) ) {
    exit();
}
if ( defined( 'MILO_PORTFOLIO' ) ) {
    $portfolio_slug = 'milo-portfolio';
} else {
    $portfolio_slug = false;
}
if ( get_post_type() == $portfolio_slug ):
    get_template_part( 'templates/content', 'portfolio' );
else :
    get_header();
// Get Blog related header meta
    $post_id = get_the_id();
   
    ?> 
    <div class="container">	
        <div class="row">
            <?php
            // Gets blog page related meta for sidebar
            $sidebar_position = get_post_meta( $post_id, 'milo_sidebar_position', true );
            if ( $post_id == 0 ) {
                $sidebar_position = 'right';
            }

            if ( !empty( $sidebar_position ) ) {
                if ( $sidebar_position == 'left' ) {
                    get_sidebar();
                }
            }
            if ( !empty( $sidebar_position ) && $sidebar_position != 'none' ) {
                global $milo_theme_options;
                if ( isset( $milo_theme_options['milo-sidebars-size'] ) ) {
                    $span_size = 12 - $milo_theme_options['milo-sidebars-size'];
                } else {
                    $span_size = 8;
                }
                // There is a sidebar, 
                if ( have_posts() ) :
                    ?>
                    <div class="col-sm-<?php echo absint($span_size); ?>">   
                        <?php
                        while ( have_posts() ) : the_post();
                            get_template_part( 'templates/content', 'post' );
                        endwhile;
                        ?>
                    </div>
                <?php else :
                    ?>
                    <div class="col-sm-<?php echo absint($span_size); ?>">
                        <?php
                        // If no content, include the "No posts found" template.
                        get_template_part( 'templates/content', 'none' );
                        ?>
                    </div>
                <?php
                endif;
            } else {
                // There is no sidebar
                if ( have_posts() ) :
                    ?> 
                    <div class="col-sm-12">   
                        <?php
                        while ( have_posts() ) : the_post();
                            get_template_part( 'templates/content', 'post' );
                        endwhile;
                        ?>
                    </div>
                    <?php
                else :
                    ?>
                    <div class="col-sm-12">
                        <?php
                        // If no content, include the "No posts found" template.
                        get_template_part( 'templates/content', 'none' );
                        ?>
                    </div>
                <?php
                endif;
            }

            if ( !empty( $sidebar_position ) ) {
                if ( $sidebar_position == 'right' ) {
                    get_sidebar();
                }
            }
            ?>
        </div> 
    </div> 
    <?php
    get_footer();
endif;