<?php

if (is_page() || get_post_type() == 'milo-portfolio') {
    // Sidebar data for each page
    $current_page_id = get_queried_object_id();
    $sidebar_id = get_post_meta($current_page_id, 'milo_sidebar_source', true);
} else if (is_singular('post')) {
    $sidebar_id = get_post_meta(get_the_id(), 'milo_sidebar_source', true);
} else {
    // Sidebar data for the rest of the post types (blog sidebar)
    $page_for_posts = get_option('page_for_posts');
    $sidebar_id = get_post_meta($page_for_posts, 'milo_sidebar_source', true);
    if ($page_for_posts == 0) {
        $sidebar_id = 'milo-default-sidebar';
    }
}

if (!empty($sidebar_id)) {
    if (function_exists('dynamic_sidebar')) {
        global $milo_theme_options;
        if (isset($milo_theme_options['milo-sidebars-size'])) {
            echo '<div id="milo-sidebar" class="col-sm-' . absint($milo_theme_options['milo-sidebars-size']) . '">';
        } else {
            echo '<div id="milo-sidebar" class="col-sm-4">';
        }
        dynamic_sidebar($sidebar_id);
        echo '</div>';
    }
}