<?php
/*
 * The main template file
 */
if (!defined('ABSPATH')) {
    exit();
}
get_header();
// Get Blog related header meta
$post_id = get_option('page_for_posts');
$blog_layout = get_post_meta($post_id, 'milo_blog_layout', true);
if($blog_layout==null){
    $blog_layout='1';
}
?> 
<div class="container">	
    <div class="row">
        <?php
        // Gets blog page related meta for sidebar
        $sidebar_position = get_post_meta($post_id, 'milo_sidebar_position', true);
        if ($post_id == 0) {
            $sidebar_position = 'right';
        }

        if (!empty($sidebar_position)) {
            if ($sidebar_position == 'left') {
                get_sidebar();
            }
        }
        if (!empty($sidebar_position) && $sidebar_position != 'none') {
            global $milo_theme_options;
            if (isset($milo_theme_options['milo-sidebars-size'])) {
                $span_size = 12 - $milo_theme_options['milo-sidebars-size'];
            } else {
                $span_size = 8;
            }
            // There is a sidebar
            if (have_posts()) :
                ?>
                <div class="col-sm-<?php echo absint($span_size); ?>">   
                    <?php
                    $i = 0;
                    while (have_posts()) : the_post();
                        if ($blog_layout == '1') {
                            get_template_part('templates/post', '1-col-sidebar');
                        } else if ($blog_layout == '2') {
                            if ($i == 0) {
                                echo'<div class="row">';
                            }
                            get_template_part('templates/post', '2-cols-sidebar');
                            $i++;
                            if ($i == 2) {
                                echo'</div>';
                                $i = 0;
                            }
                        } else if ($blog_layout == '3') {
                            if ($i == 0) {
                                echo'<div class="row">';
                            }
                            get_template_part('templates/post', '3-cols');
                            $i++;
                            if ($i == 3) {
                                echo'</div>';
                                $i = 0;
                            }
                        } else if ($blog_layout == '4') {
                            echo '<div class="isotope col-2 gutter">';
                            get_template_part('templates/post', 'masonry');
                            echo'</div>';
                        } else if ($blog_layout == '5') {
                            echo '<div class="isotope col-3 gutter">';
                            get_template_part('templates/post', 'masonry');
                            echo'</div>';
                        }
                    endwhile;
                    if ($blog_layout == '2' || $blog_layout == '3') {
                        if ($i != 0) {
                            echo'</div>';
                        }
                    }
                    if (function_exists("milo_pagination")) {
                        echo '<br class="clear_milo"/>';
                        milo_pagination();
                    }
                    ?>
                </div>

            <?php else :
                ?>
                <div class="col-sm-<?php echo absint($span_size); ?>">
                    <?php
                    // If no content, include the "No posts found" template.
                    get_template_part('content', 'none');
                    ?>
                </div>
            <?php
            endif;
        } else {
            // There is no sidebar
            if (have_posts()) {
                ?> 
                <div class="col-sm-12">  

                    <?php
                    $i = 0;
                    while (have_posts()) : the_post();
                        if ($blog_layout == '1') {
                            get_template_part('templates/content', get_post_format());
                        } else if ($blog_layout == '2') {
                            if ($i == 0) {
                                echo'<div class="row">';
                            }
                            get_template_part('templates/post', '2-cols');
                            $i++;
                            if ($i == 2) {
                                echo'</div>';
                                $i = 0;
                            }
                        } else if ($blog_layout == '3') {
                            if ($i == 0) {
                                echo'<div class="row">';
                            }
                            get_template_part('templates/post', '3-cols');
                            $i++;
                            if ($i == 3) {
                                echo'</div>';
                                $i = 0;
                            }
                        } else if ($blog_layout == '4') {
                            echo '<div class="isotope col-2 gutter">';
                            get_template_part('templates/post', 'masonry');
                            echo'</div>';
                        } else if ($blog_layout == '5') {
                            echo '<div class="isotope col-3 gutter">';
                            get_template_part('templates/post', 'masonry');
                            echo'</div>';
                        }
                    endwhile;
                    if ($blog_layout == '2' || $blog_layout == '3') {
                        if ($i != 0) {
                            echo'</div>';
                        }
                    }

                    if (function_exists("milo_pagination")) {
                        echo '<br class="clear_milo"/>';
                        echo '<div class="text-center">';
                        milo_pagination();
                        echo '</div>';
                    }
                    ?>
                </div>

                <?php
            } else {
                ?>
                <div class="col-sm-12">
                    <?php
                    // If no content, include the "No posts found" template.
                    get_template_part('templates/content', 'none');
                    ?>
                </div>
                <?php
            }
        }

        if (!empty($sidebar_position)) {
            if ($sidebar_position == 'right') {
                get_sidebar();
            }
        }
        ?>
    </div> 
</div> 
<?php
get_footer();
